/**
 *
 * Copyright (C) 2005 linxs<linxsy@gmail.com>
 *
 * Atli is controlled and maintained by the original author. Atli 
 * is a program originally targeting at providing a quick way to 
 * develop application script language, which is extensible and 
 * flexible.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *
**/

 

#ifdef WIN32
//#include "stdafx.h"
#include <windows.h>
#endif
#ifdef LINUX
#include <stdarg.h>
#endif
#include <vector>
#include <string>
#include <map>
#include <algorithm>
#include "utility.h"
#include "mathparse.h"

#define OPERATORS "+-*/%)"
#define OPERANDS  "-.0123456789("
#define OPERANDS_END "0123456789."

//#define _debug_arithm_

using namespace std;

typedef struct _tag_op_ {
    int     type;  // 0 is operand, 1 is operator
    union {
        float  op_operand;
        int    op_operator;
    };
}AOPER;

struct _tag_arithm { 
    string          arithm_string;
    string          error_string;
    float           result;
    int             knum;
    int             pop;
    vector<AOPER>   oper_list;
    map<int,int>    operator_priority;
    vector<float>   arithm_operand;
    vector<int>     arithm_operator;
} g_arithm;

#define OPNDLIST g_arithm.arithm_operand
#define OPRTLIST g_arithm.arithm_operator
#define OPLIST   g_arithm.oper_list
#define OPPRTY   g_arithm.operator_priority
#define POP      g_arithm.pop

static int proc_error (char *str, int st, int ed)
{
    g_arithm.error_string = str;
    g_arithm.error_string += g_arithm.arithm_string.substr (st, ed -st);
    return 0;
}

static int initialize ()
{
    g_arithm.arithm_string  = "";
    g_arithm.error_string   = "";
    g_arithm.result         = 0.0f;
    g_arithm.knum           = 0;

    g_arithm.oper_list.clear ();
    g_arithm.arithm_operand.clear ();
    g_arithm.arithm_operator.clear ();
    g_arithm.operator_priority.clear ();

    g_arithm.operator_priority['+'] = 1;
    g_arithm.operator_priority['-'] = 1;
    g_arithm.operator_priority['*'] = 2;
    g_arithm.operator_priority['/'] = 2;
    g_arithm.operator_priority['%'] = 2;
    g_arithm.operator_priority['('] = 3;
    g_arithm.operator_priority[')'] = 0;
    return 0;
}

static int uninitialize ()
{
    g_arithm.oper_list.clear ();
    g_arithm.arithm_operand.clear ();
    g_arithm.arithm_operator.clear ();
    g_arithm.operator_priority.clear ();

    return 0;
}


static int operand_push (size_t st, size_t ed)
{
    float op;
    string sop;
    char *stop;
    AOPER aop;

    sop = g_arithm.arithm_string.substr (st, ed - st);
    op = (float)strtod (sop.c_str (), &stop);
    if (stop[0] != 0) return -1;
#ifdef _debug_arithm_
    dbgprint ("get one operand:%f\n", op);
#endif
    aop.type = 0;
    aop.op_operand = op;
    g_arithm.oper_list.push_back (aop);

    return 0;
}

static int operator_push (size_t st, size_t ed)
{
    string sop;
    AOPER aop;

    sop = g_arithm.arithm_string.substr (st, ed - st);
    aop.type = 1;
    aop.op_operator = sop[0];
    g_arithm.oper_list.push_back (aop);
#ifdef _debug_arithm_
    dbgprint ("get one operator:%s, op size:%d\n", sop.c_str(), OPLIST.size());
#endif

    return 0;
}

static int get_one_operand (int &st)
{
    int ed, rst;

    st = (int)g_arithm.arithm_string.find_first_not_of (" \t", st);
    rst = (int)g_arithm.arithm_string.find_first_of (OPERANDS, st);
    if (st != rst) return -1;

    do {
        st = (int)g_arithm.arithm_string.find_first_of (OPERANDS, st);
        if (st < 0) return -1;

        if (g_arithm.arithm_string[st] == '(') {
            operator_push (st, st+1);
            st ++;
            g_arithm.knum ++;
            continue;
        }
        else break;
    }while (1);

    ed = (int)g_arithm.arithm_string.find_first_not_of (OPERANDS_END, st);
    if (ed < 0) ed = (int)g_arithm.arithm_string.length ();

    return ed;
}

static int get_one_operator (int &st)
{
    int ed;
    int rst;

    st = (int)g_arithm.arithm_string.find_first_not_of (" \t", st);
    if (st < 0) return -1;
    rst = (int)g_arithm.arithm_string.find_first_of (OPERATORS, st);
    if (rst < 0) return -2;
    if (st != rst) return -2;

    do {
        st = (int)g_arithm.arithm_string.find_first_of (OPERATORS, st);
        if (st < 0) return 1;
        if (g_arithm.arithm_string[st] == ')') {
            operator_push (st, st + 1);
            st ++;
            g_arithm.knum --;
            continue;
        }
        else break;
    }while (1);
    ed = (int)g_arithm.arithm_string.find_first_not_of (OPERATORS, st);
    if (ed == -1) ed =(int) g_arithm.arithm_string.length ();

    return ed;
}

static int parse_arithm_string ()
{
    int st, ed;
    int ret;

    st = 0; ed = 0;

    ed = get_one_operand (st);
    if (ed < 0) {
        g_arithm.error_string = "Can not get any operand";
        return -1;
    }
    ret = operand_push (st, ed);
    if (ret < 0) {
        proc_error ("Can not get operand correct: ", st, ed);
        return -2;
    }

    while (ed < (int)g_arithm.arithm_string.length ()) {
        st = ed;
        ed = get_one_operator (st);
        if (ed == -2) {
            proc_error ("Can not get operator correct:", st, ed);
            return -1;
        }
        else if (st == -1 || ed == -1) break;
        ret = operator_push (st, ed);
        if (ret < 0) {
            proc_error( "Can not get correct operator:", st, ed);
            return -3;
        }

        st = ed;
        ed = get_one_operand (st);
        if (ed < 0) {
            proc_error ("Can not get correct operand:", st, ed);
            return -4;
        }
        ret = operand_push (st, ed);
        if (ret < 0) {
            proc_error ("Can not get correct operand:", st, ed);
            return -5;
        }
    }

    if (g_arithm.knum) {
        g_arithm.error_string = "( and ) are not corresponding to each other";
        return -1;
    }


    return 0;
}


static int calc_back ()
{
    float opnd1, opnd2;
    float result;
    int oper = 0;

    if (OPLIST[POP].op_operator != '(') 
    while (OPRTLIST.size() >0 && OPPRTY [OPLIST[POP].op_operator] <= OPPRTY[OPRTLIST.back ()]) {
#ifdef _debug_arithm_
    dbgprint ("process operator:%c\n", OPRTLIST.back());
#endif
        if (OPLIST[POP].op_operator == ')' && OPRTLIST.back() == '(') {
            POP++;
            OPRTLIST.pop_back ();
            return 0;
        }
        if (OPRTLIST.back() != '(' && OPRTLIST.back() != ')') {
            opnd2 = OPNDLIST.back ();
            OPNDLIST.pop_back ();
            opnd1 = OPNDLIST.back ();
            OPNDLIST.pop_back ();
            oper = OPRTLIST.back ();
            OPRTLIST.pop_back ();
        }
        else break;

        switch (oper) {
            case '+':
                result = opnd1 + opnd2;
                break;
            case '-':
                result = opnd1 - opnd2;
                break;
            case '*':
                result = opnd1 * opnd2;
                break;
            case '/':
                result = opnd1 / opnd2;
                break;
            case '%':
                result = (float)((int)opnd1 % (int)opnd2);
                break;
        }
        OPNDLIST.push_back (result);
#ifdef _debug_arithm_
        dbgprint ("next step, operator:%c, %c, size:%d\n", OPLIST[POP].op_operator, OPRTLIST.back (), OPRTLIST.size());
#endif
    }
    OPRTLIST.push_back (OPLIST[POP++].op_operator);

    return 0;
}


static int calc_end ()
{
    float opnd1, opnd2;
    float result;
    int oper = 0;

    while (OPRTLIST.size() >0) {
#ifdef _debug_arithm_
    dbgprint ("process operator:%c\n", OPRTLIST.back());
#endif
    if (OPRTLIST.back() != '(' && OPRTLIST.back() != ')') {
            opnd2 = OPNDLIST.back ();
            OPNDLIST.pop_back ();
            opnd1 = OPNDLIST.back ();
            OPNDLIST.pop_back ();
            oper = OPRTLIST.back ();
            OPRTLIST.pop_back ();
        }
        switch (oper) {
            case '+':
                result = opnd1 + opnd2;
                break;
            case '-':
                result = opnd1 - opnd2;
                break;
            case '*':
                result = opnd1 * opnd2;
                break;
            case '/':
                result = opnd1 / opnd2;
                break;
            case '%':
                result = (float)(((int)opnd1) % ((int)opnd2));
                break;
        }
        OPNDLIST.push_back (result);
    }

    return 0;
}

static int calc_arithm ()
{
    POP = 0;
#ifdef _debug_arithm_
    dbgprint ("begin to calc\n");
#endif

    while (POP < (int)OPLIST.size ()) {
#ifdef _debug_arithm_
        if (OPLIST[POP].type == 0) {
            dbgprint ("Operand: %f\n", OPLIST[POP].op_operand);
        }
        else {
            dbgprint ("Operator: %c\n", OPLIST[POP].op_operator);
        }
#endif
        switch (OPLIST[POP].type) {
            case 0:
                OPNDLIST.push_back (OPLIST[POP++].op_operand);
                break;
            case 1:
                if (OPLIST[POP].op_operator == '(' || OPRTLIST.size() == 0) {
                    OPRTLIST.push_back (OPLIST[POP++].op_operator);
                } else {
                    calc_back ();// go on here next time.
                }
                break;
        }
    }
    calc_end ();
    g_arithm.result = OPNDLIST.back ();
#ifdef _debug_arithm_
    dbgprint ("Result:%f\n", g_arithm.result);
#endif

    return 0;
}

float get_value_arithmetic (const char *arithm)
{
    int ret;

    initialize ();
    g_arithm.arithm_string  = arithm;
#ifdef _debug_arithm_
    dbgprint ("arithm: %s\n", arithm);
#endif        

    ret = parse_arithm_string ();
    if (ret) goto error;

    ret = calc_arithm ();
    if (ret) goto error;

    uninitialize ();
    return g_arithm.result;
error:
#ifdef _debug_arithm_
    dbgprint ("error: %s\n", g_arithm.error_string.c_str());
#endif 
    uninitialize ();
    return 0.0f;
}

const char   *get_error_airthm ()
{
    return g_arithm.error_string.c_str ();
}

#if 0
int main (int argc, char*argv[])
{
    if (argc < 2) return -1;

    get_value_arithmetic (argv[1]);
    return 0;
}
#endif
