/**
 *
 * Copyright (C) 2005 linxs<linxsy@gmail.com>
 *
 * Atli is controlled and maintained by the original author. Atli 
 * is a program originally targeting at providing a quick way to 
 * develop application script language, which is extensible and 
 * flexible.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *
**/



#ifdef WIN32
#define _WIN32_WINNT 0x0501
//#include "stdafx.h"
#include <windows.h>
#endif
#ifdef LINUX
#include <stdarg.h>
#include <fnmatch.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#endif
#include <stdio.h>
#include <list>
#include <string>
#include <vector>
#include <fstream>
#include <iterator>
#include <sstream>
#include <algorithm>
#include <map>
#include <time.h>
#include "Atli.h"
#include "utility.h"
#include "mathparse.h"
#include "logiparse.h"
#include "atlidef.h"
#include "Atliparse.h"
#include "utility.h"

using namespace std;
extern Scriptor g_script;

#define HEX_CHAR "0123456789ABCDEFabcdef"

int copy_escape_string (string &to, string &from)
{
    const char * p;
    char *buf = (char*)malloc(from.length() + 4);
    int posto;

    to = "";
    buf [0] = 0;
    posto = 0;

    p = from.c_str();

    while (*p) {
        if (*p == '\\') {
            p ++;
            switch (*p) {
                case 'n': buf[posto] = '\n'; break;
                case 't': buf[posto] = '\t'; break;
                case '\\': buf[posto] = '\\'; break;
                case '"': buf[posto] = '"'; break;
                case 'b': posto--; break;
                case 'r': buf[posto] = 'r'; break;
                case 'x': 
                    {
                        char v;
                        p ++;
                        v = (*p >= 'a') ? (*p - 'a' + 10):
                            (*p >= 'A') ? (*p - 'A' + 10) : (*p - '0');

                        if (strchr(HEX_CHAR, *(p+1))) {
                            p ++;
                            v = v * 16;
                            v += (*p >= 'a') ? (*p - 'a' + 10):
                                 (*p >= 'A') ? (*p - 'A' + 10) : (*p - '0');
                        }
                        buf[posto] = v; 
                        break;                   
                    } //endof case'x'
            }
        } else {
            buf[posto] = *p;
        }
        posto ++; p++;
    }
    buf[posto] = 0;
    to = buf;
    free(buf);

    return 0;
}

int find_correspond_quotation (string& str, size_t st)
{
    const char* p = str.c_str() + st;

    p ++;
    while (*p) {
        switch (*p) {
        case '"':
            return (int)(p - str.c_str());
        case '\\':
            p++; 
        default:
            p++;
        }
    }
    
    return (int) st;
}

int find_correspond_blacket (string &str, size_t st)
{
    size_t ed;
    int blkno = 0;

    st ++;
    do {
        ed = str.find_first_of ("\"()", st);
        if (ed == -1) return -1;

        switch (str[ed]) {
        case '"': 
            ed = find_correspond_quotation (str, ed);
            if (ed == -1) return -1;
            break;
        case '(':
            blkno --;
            break;
        case ')':
            blkno ++;
        }
        st = ed + 1;
    } while (blkno != 1);
    
    return (int)st - 1;
}

const char* random_variable_name (const char*key)
{
    static unsigned int rndname = 0;
    static char varname[128];

    rndname ++;
    sprintf (varname, "$__%s%d_%d_", key, rndname, (unsigned int)rand());
    return varname;
}


static void dmapprint (std::pair<const std::string,std::string> pp)
{
    dbgprint ("%s = %s\n", pp.first.c_str(), pp.second.c_str());
}

int dbgprint_variable (map<string, string> *pmap)
{
    for_each (pmap->begin(), pmap->end(), dmapprint);
    return 0;
}



void dbgprint(const char *msg, ...)
{
    char dbgmsg[8192];
    va_list args;

    va_start(args, msg);

#ifdef WIN32
    _vsnprintf(dbgmsg, 8192, msg, args);
    OutputDebugString(dbgmsg);
#endif 
#ifdef LINUX
    vsnprintf(dbgmsg, 8192, msg, args);

#endif

    if (g_script.debug_level == 1) {
#ifdef LINUX
        dprintf (fileno(stderr), dbgmsg);
#endif
#ifdef WIN32
        printf (dbgmsg);
#endif
    }

    va_end(args);
}
