/* fuji_mb86606.h -- Fujitsu MB86606 external definition file
 * Marc SCHAEFER <schaefer@dilog.ch>
 * Creation: 28/09/97
 * Update:   15/10/97
 * V1.0 PV004
 * DESCRIPTION
 *    This include file contains public definitions for the
 *    Fujitsu MB86606 Linux kernel SCSI module.
 * NOTES
 *    - Current version is just a very simple demo version.
 * BUGS
 * TODO
 * BASED-ON
 *    Took some structuration ideas from
 *       qlogicisp.h of Linux 2.0.27
 * MODIFICATION-HISTORY
 *    15/10/97  schaefer  Adding support for command() function.
 * $Id: fuji_mb86606.h,v 1.11 1997/10/15 11:13:29 schaefer Exp $
 */

#ifndef _FUJI_MB86606_H
#define _FUJI_MB86606_H

#ifndef PCI_VENDOR_ID_FUJITSU
#define PCI_VENDOR_ID_FUJITSU 0x2002
#define PCI_DEVICE_ID_FUJI_MB86606 0x10CF
#endif

#define FUJI_MB86606_REQ_QUEUE_LEN 1
#define FUJI_MB86606_SG_TABLE_SIZE 127 /* total 128 */
#define FUJI_MB86606_CMD_PER_LUN 1
#define FUJI_MB86606_SG_MAX_CDB_SIZE 12
#define FUJI_MB86606_SG_MAX_SENSE_DATA 32

int fuji_mb86606_detect(Scsi_Host_Template *);
int fuji_mb86606_release(struct Scsi_Host *);
const char *fuji_mb86606_info(struct Scsi_Host *);
int fuji_mb86606_command(Scsi_Cmnd *);
int fuji_mb86606_queuecommand(Scsi_Cmnd *, void (* done)(Scsi_Cmnd *));
int fuji_mb86606_abort(Scsi_Cmnd *);
int fuji_mb86606_reset(Scsi_Cmnd *, unsigned int);
int fuji_mb86606_biosparam(Disk *, kdev_t, int[]);

#ifndef NULL
#define NULL (0)
#endif

#ifdef FUJI_ENABLE_PROC_SUPPORT
#define PROC_ENTRY &proc_scsi_fuji_mb86606
#else
#define PROC_ENTRY NULL
#endif

#define FUJI_MB86606 { \
        /* next */         NULL, \
        /* usage_count */  NULL, \
        /* proc dir */     PROC_ENTRY, \
        /* procfs info */  NULL, \
        /* name */         NULL, \
        /* detect */       fuji_mb86606_detect, \
        /* release */      fuji_mb86606_release, \
        /* info */         fuji_mb86606_info, \
        /* command */      fuji_mb86606_command, \
        /* queuecommand */ fuji_mb86606_queuecommand, \
        /* abort */        fuji_mb86606_abort, \
        /* reset */        fuji_mb86606_reset, \
        /* slave_attach */ NULL, \
        /* bios_param */   fuji_mb86606_biosparam, \
        /* can_queue */    FUJI_MB86606_REQ_QUEUE_LEN, \
        /* this_id */      -1, \
        /* sg_tablesize */ FUJI_MB86606_SG_TABLE_SIZE, \
        /* cmd_per_lun */  FUJI_MB86606_CMD_PER_LUN, \
        /* present */      0, \
   /* unchecked_isa_dma */ 0, \
      /* use_clustering */ DISABLE_CLUSTERING \
}

#endif /* _FUJI_MB86606_H */
