/* fuji_mb86606_private.h -- Fujitsu MB86606 private definitions
 * Marc SCHAEFER <schaefer@dilog.ch>
 * Creation: 29/09/97
 * Update:   11/12/97
 * V1.0 PV003
 * DESCRIPTION
 *    This include file contains private definitions for the
 *    Fujitsu MB86606 Linux kernel SCSI module.
 * NOTES
 * BUGS
 * TODO
 * BASED-ON
 * MODIFICATION-HISTORY
 *    11/12/97  schaefer PCI Control register define.
 * $Id: fuji_mb86606_private.h,v 1.19 1997/12/11 15:33:02 schaefer Exp $
 */

#ifndef _FUJI_MB86606_PRIVATE_H
#define _FUJI_MB86606_PRIVATE_H

/* Chip identification */

#define FUJI_MB86606_REV_ID    98
#define SPC_REVISION_ID_CODE   (0x40|0x20)

/* Default values */

/* When a selection/reselection timeout occurs, we will
 * retry upto 2 times with an interval of 35 ms.
 *    0 1 0 1 1 1 1
 */
#define SPC_SEL_RESEL_RETRIES  (0x40|0x10|8|4|2|1)
/* Selection/reselection timeout (>= 250 ms)
 *    33.33 ns x 2 (CLK) x value  == 250 ms
 *    value == (125/33.33) x 1e6 == 4'000'000
 */
#define SPC_SELECTION_TIMEOUT  (0x40)

#define SPC_REQ_ACK_TIMEOUT    0 /* Not detected */

#define SPC_ASYNC_SETUP        0 /* BUG @@@ */

#define SPC_SPECIAL_CMD_LEN    0 /* Group 6 and 7 unsupported */

/* 40 MHz external, 20 MHz internal */
#define SPC_CLOCK_CONVERSION   (0x40|0x10|2|1)

#define SPC_OWN_ID              (7 & SPC_REG_OWN_ID_MASK)
/* Multi-node support */
#define SPC_RESPONSE_MAP_H      0
#define SPC_RESPONSE_MAP_L      0x80 /* Only responds to ID 7 */

#define SPC_SPC_TIMEOUT         0 /* General timeout -- not used */

/* SPC registers (as seen through PCI)
 * NOTES
 *    - Most of those can't be read back.
 */

#define SPC_REG_DMA_XFER_VL     0x04 /* read/write */
#define SPC_REG_DMA_XFER_L      0x05 /* read/write */
#define SPC_REG_DMA_XFER_M      0x06 /* read/write */
#define SPC_REG_DMA_XFER_H      0x07 /* read/write */
#define SPC_REG_PCI_CONTROL     0x10 /* write */
#define SPC_REG_PCI_STATUS      0x11 /* read */
#define SPC_REG_PCI_INT_ENABLE  0x11 /* write */
#define SPC_REG_STATUS          0x12 /* read */
#define SPC_REG_CONTROL         0x12 /* write */
#define SPC_REG_NEXUS           0x13 /* read */
#define SPC_REG_IO_CONTROL      0x13 /* write */
#define SPC_REG_INTERRUPT       0x14 /* read */
#define SPC_REG_SEL_RESEL_ID    0x14 /* write */
#define SPC_REG_COMMAND_STEP    0x15 /* read */
#define SPC_REG_COMMAND         0x15 /* write */
#define SPC_REG_DATA_BLOCK_L    0x16 /* read/write */
#define SPC_REG_DATA_BLOCK_H    0x17 /* read/write */
#define SPC_REG_MC_BYTE_L       0x18 /* read/write */
#define SPC_REG_MC_BYTE_M       0x19 /* read/write */
#define SPC_REG_MC_BYTE_H       0x1A /* read/write */
#define SPC_REG_SCSI_CONTROL    0x1B /* read */
#define SPC_REG_DIAGNOSTIC_CTL  0x1B /* write */
#define SPC_REG_SYNC_PERIOD     0x1C /* read/write */
#define SPC_REG_SYNC_OFFSET     0x1D /* read/write */
#define SPC_REG_MODIFIED_BYTE_H 0x1E /* read */
#define SPC_REG_MODIFIED_BYTE_L 0x1F /* read */
#define SPC_REG_WINDOW_ACCESS   0x1F /* write */
#define SPC_REG_CLOCK_CONV      0x20 /* read/write */
#define SPC_REG_OWN_ID          0x21 /* read/write */
#define SPC_REG_RESPONSE_MODE   0x22 /* read/write */
#define SPC_REG_SEL_RESEL_MODE  0x23 /* read/write */
#define SPC_REG_SEL_RESEL_RETRY 0x24 /* read/write */
#define SPC_REG_SEL_RESEL_TIMEO 0x25 /* read/write */
#define SPC_REG_REQ_ACK_TIMEOUT 0x26 /* read/write */
#define SPC_REG_ASYNC_SETUP     0x27 /* read/write */
#define SPC_REG_PARITY_DETECT   0x28 /* read/write */
#define SPC_REG_INT_ENABLE      0x29 /* read/write */
#define SPC_REG_SPECIAL_CMD_LEN 0x2A /* read/write */
#define SPC_REG_RESPONSE_OWN_ID 0x2B /* read */
#define SPC_REG_RESPONSE_MAP_H  0x2C /* read/write */
#define SPC_REG_RESPONSE_MAP_L  0x2D /* read/write */
#define SPC_REG_AUTO_OP_MODE    0x2E /* read/write */
#define SPC_REG_REVISION_ID     0x2F /* read */
#define SPC_REG_SPC_TIMEOUT     0x2F /* write */
#define SPC_REG_UP_CONTROL      0x30 /* read/write */
#define SPC_REG_UP_CURR_ADDR_L  0x32 /* read */
#define SPC_REG_UP_SET_ADDR_L   0x32 /* write */
#define SPC_REG_UP_CURR_ADDR_H  0x33 /* read */
#define SPC_REG_UP_SET_ADDR_H   0x33 /* write */
#define SPC_REG_UP_DATA_PORT_0  0x34 /* read/write */
#define SPC_REG_UP_DATA_PORT_1  0x35 /* read/write */
#define SPC_REG_UP_DATA_PORT_2  0x36 /* read/write */
#define SPC_REG_UP_DATA_PORT_3  0x37 /* read/write */
#define SPC_REG_UP_START_L      0x38 /* read/write */
#define SPC_REG_UP_START_H      0x39 /* read/write */
#define SPC_REG_UP_AUTO_SEL_R_L 0x3A /* read/write */
#define SPC_REG_UP_AUTO_SEL_R_H 0x3B /* read/write */

#define SPC_REG_MCS_BUFFER      0x40 /* read/write, but separate direction */

/* Register bits */

#define SPC_REG_PCI_INT_ENABLE_DTTPE 0x80
#define SPC_REG_PCI_INT_ENABLE_SSE   0x40
#define SPC_REG_PCI_INT_ENABLE_RMA   0x20
#define SPC_REG_PCI_INT_ENABLE_RTA   0x10
#define SPC_REG_PCI_INT_ENABLE_STA      8
#define SPC_REG_PCI_INT_ENABLE_DAP      4
#define SPC_REG_PCI_INT_ENABLE_PO1      2 /* Terminator, 0 for on */
#define SPC_REG_PCI_INT_ENABLE_PO0      1 /* LED, 0 for on */

#define SPC_REG_STATUS_INTERRUPT     0x80
#define SPC_REG_STATUS_BUSY          0x40
#define SPC_REG_STATUS_XFER_READY    0x20
#define SPC_REG_STATUS_TIMEOUT       0x10
#define SPC_REG_STATUS_IGNORE_RESID     8
#define SPC_REG_STATUS_DATA_REQ         4
#define SPC_REG_STATUS_DATA_REG_FULL    2
#define SPC_REG_STATUS_DATA_REG_EMPTY   1

#define SPC_REG_IO_CONTROL_MANUAL_M  0x10
#define SPC_REG_IO_CONTROL_AUTO_M       8
#define SPC_REG_IO_CONTROL_INT_CNTL     4
#define SPC_REG_IO_CONTROL_DC1          2
#define SPC_REG_IO_CONTROL_DC0          1

#define SPC_REG_SEL_RESEL_ID_MASK       (1|2|4|8)

#define SPC_REG_SYNC_PERIOD_SYNC_EN  0x80
#define SPC_REG_SYNC_PERIOD_WIDE_EN  0x40
/* The following value is
 *    (40 MByte/s) x value == clock frequency
 */
#define SPC_REG_SYNC_PERIOD_P_MASK   (1|2|4|8|16)

#define SPC_REG_OWN_ID_MASK          (1|2|4|8)

#define SPC_REG_RESPONSE_MODE_RESEL_ENABLE 0x80
#define SPC_REG_RESPONSE_MODE_SEL_ENABLE   0x40
#define SPC_REG_RESPONSE_MODE_AUTO_RCV     0x20
#define SPC_REG_RESPONSE_MODE_PRTY_DATA_ST 0x10
#define SPC_REG_RESPONSE_MODE_SCSI_1          2
#define SPC_REG_RESPONSE_MODE_ARBITRATION     1

#define SPC_REG_SEL_RESEL_MODE_USER_PROGR  0x80
#define SPC_REG_SEL_RESEL_MODE_RESEL_MSG   0x40
#define SPC_REG_SEL_RESEL_MODE_TARGET_AUTO 0x20
#define SPC_REG_SEL_RESEL_MODE_TARGET_PHSE 0x10

#define SPC_REG_PARITY_DETECT_SCSI_CHECK   0x80
#define SPC_REG_PARITY_DETECT_SCSI_GEN     0x40
#define SPC_REG_PARITY_DETECT_PARITY_ODD   0x20 /* For system, not SCSI */
#define SPC_REG_PARITY_DETECT_MPU_CHECK    0x10
#define SPC_REG_PARITY_DETECT_MPU_GEN         8
#define SPC_REG_PARITY_DETECT_DMA_CHECK       2
#define SPC_REG_PARITY_DETECT_DMA_GEN         1

#define SPC_REG_INT_ENABLE_ENABLE_INT      0x80 /* Master override */
#define SPC_REG_INT_ENABLE_AUTO_SEL_RESEL  0x20
#define SPC_REG_INT_ENABLE_SEL_RESEL       0x10
#define SPC_REG_INT_ENABLE_REPORT             8
#define SPC_REG_INT_ENABLE_PHASE_ERROR        4
#define SPC_REG_INT_ENABLE_TRANSFER_ERROR     2
#define SPC_REG_INT_ENABLE_SCSI_RESET         1

#define SPC_REG_AUTO_OP_MODE_INT_CMD_HAND  0x80
#define SPC_REG_AUTO_OP_MODE_INT_HOLD      0x40
#define SPC_REG_AUTO_OP_MODE_NO_REJ_BUSY   0x20
#define SPC_REG_AUTO_OP_MODE_NO_REJ_SEL    0x10
#define SPC_REG_AUTO_OP_MODE_NO_REQ           8
#define SPC_REG_AUTO_OP_MODE_NO_COMPL_REPORT  4
#define SPC_REG_AUTO_OP_MODE_NO_LEVEL_2       2
#define SPC_REG_AUTO_OP_MODE_AUTO_ACK_RESET   1

#define SPC_REG_REVISION_ID_MASK_CODE         (0x80|0x40|0x20|0x10)
#define SPC_REG_REVISION_ID_MASK_REVISION     (1|2|4|8)

#define SPC_REG_INTERRUPT_XFER_PHASE_ERROR    0x32
#define SPC_REG_INTERRUPT_XFER_GOT_MSG        0x55 
#define SPC_REG_INTERRUPT_TERMINATED_NORMALLY 0x60
#define SPC_REG_INTERRUPT_DISCONNECT          0x70
#define SPC_REG_INTERRUPT_REQ_ASSERTED        0x71
#define SPC_REG_INTERRUPT_TIMEOUT             0x82

#define SPC_REG_SCSI_CONTROL_REQ              0x80
#define SPC_REG_SCSI_CONTROL_ACK              0x40
#define SPC_REG_SCSI_CONTROL_ATN              0x20
#define SPC_REG_SCSI_CONTROL_SEL              0x10
#define SPC_REG_SCSI_CONTROL_BSY                 8
#define SPC_REG_SCSI_CONTROL_MSG                 4
#define SPC_REG_SCSI_CONTROL_CD                  2
#define SPC_REG_SCSI_CONTROL_IO                  1

#define SPC_REG_CONTROL_ATN_ON                0x80

/* SPC commands */

/* Sequential commands */

#define SPC_CMD_SELECT_AND_CMD                0x00
#define SPC_CMD_SELECT_AND_N_BYTE_MSG_AND_CMD 0x02
#define SPC_CMD_SEND_N_BYTE_MSG               0x05

/* Discrete commands */

#define SPC_CMD_SELECT_WITH_ATN     0x09
#define SPC_CMD_SET_ATN             0x0A
#define SPC_CMD_RESET_ACK           0x0D
#define SPC_CMD_SEND_DATA_FROM_DMA  0x11
#define SPC_CMD_RECEIVE_DATA_TO_DMA 0x13
#define SPC_CMD_RECEIVE_MSG         0x1A
#define SPC_CMD_SEND_CMD            0x1B
#define SPC_CMD_RECEIVE_STATUS      0x1C

/* Common commands */

#define SPC_CMD_SOFTWARE_RESET  0x40
#define SPC_CMD_TRANSFER_RESET  0x41
#define SPC_CMD_SCSI_RESET      0x42
#define SPC_CMD_INIT_DIAG_START 0x44
#define SPC_CMD_TARG_DIAG_START 0x45
#define SPC_CMD_DIAG_END        0x46
#define SPC_CMD_PAUSE           0x47
#define SPC_CMD_SET_RST         0x48
#define SPC_CMD_RESET_RST       0x49

/* Special commands */

#define SPC_REG_CMD_LAUNCH_USER_PROGRAM 0x80


/* Macros */

#define SEND_COMMAND(chip, cmd) WRITE_TO_REGISTER((chip), \
                                                  SPC_REG_COMMAND, \
                                                  (cmd));
#define WRITE_TO_REGISTER(chip, reg, value) outb((value), \
                                            (u_long) (((void *) (chip)->io_port) \
                                            + (reg)));
#define READ_REGISTER(chip, reg) inb(((u_long) ((void *) (chip)->io_port) + (reg)))

#endif /* FUJI_MB86606_PRIVATE_H */
