/* 
 * Runset Init: Command dispatch table
 *
 * Copyright 1998, 1999, 2000, 2001, 2003, 2004, 2006,
 *           2007, 2009 Michael Deutschmann
 *
 * This software package is subject to the GNU General Public License
 * version 3 or later (your choice) as published by the Free Software 
 * Foundation.
 *
 * THERE ARE NO WARRANTIES WHATSOEVER. 
 *
 */

#define _GNU_SOURCE

#include "common.h"
#include "dispatch.h"

/* This is the list of commands that we understand in the configuration 
 * file. 
 */
const struct dtable dispatch_table[] = {
  {"once", &act_once},
  {"watch", &act_watch},
  {"wait", &act_wait},
  {"together", &act_together},
  {"respawn", &act_respawn},
  {"leave", &act_leave},
  {"filesystem", &act_filesystem},
  {"swap", &act_swap},
  {"openutmp", &act_openutmp},
  {"service", &act_service},
  {"pass_socket", &act_pass_socket},
  {"clock", &act_clock},
  {"done", &act_done},
  {"tidy", &act_tidy},
  {"mrespawn", &act_mrespawn},
  {0, 0}
};
