/* 
 * Runset Init: Prototypes for all action functions
 *
 * Copyright 1998, 1999, 2000, 2001, 2003, 2004, 2006,
 *           2007, 2009 Michael Deutschmann
 *
 * This software package is subject to the GNU General Public License
 * version 3 or later (your choice) as published by the Free Software 
 * Foundation.
 *
 * THERE ARE NO WARRANTIES WHATSOEVER. 
 *
 */

/* simple.c - the simple init options */
void act_once (hchain top, cvec vector, cenv env);
void act_watch (hchain top, cvec vector, cenv env);
void act_wait (hchain top, cvec vector, cenv env);
void act_together (hchain top, cvec vector, cenv env);
void act_leave (hchain top, cvec vector, cenv env);
void act_tidy (hchain top, cvec vector, cenv env);
void act_respawn (hchain top, cvec vector, cenv env);
void act_mrespawn (hchain top, cvec vector, cenv env);
void act_done (hchain top, cvec vector, cenv env);

/* mount.c - mounting filesystems */
void act_filesystem (hchain top, cvec vector, cenv env);
void act_swap (hchain top, cvec vector, cenv env);

/* utmp.c - an option to start/stop UTMP */
void act_openutmp (hchain top, cvec vector, cenv env);

/* service.c - socket services */
void act_service (hchain top, cvec vector, cenv env);
void act_pass_socket (hchain top, cvec vector, cenv env);

/* clock.c - calendar-based execution */
void act_clock (hchain top, cvec vector, cenv env);
