/* 
 * Runset Init: Switch daemon common header
 *
 * Copyright 1998, 1999, 2000, 2001, 2003, 2004, 2006,
 *           2007, 2009 Michael Deutschmann
 *
 * This software package is subject to the GNU General Public License
 * version 3 or later (your choice) as published by the Free Software 
 * Foundation.
 *
 * THERE ARE NO WARRANTIES WHATSOEVER. 
 *
 */

#include <sys/types.h>
#include <stdio.h>
#include <signal.h>

/* switcher.c - switcher core */
void add_request (const char *runset_name, uid_t user);
void remove_request (const char *runset, uid_t user);
void cancel_requests (const char *name);
void cancel_all (void);
int update (void);
void reap (pid_t process);
void dump_requests (FILE * stream, const char *name);
void dump_all (FILE * stream);

/* control.c - setup and handle commands 
 *
 * Both these exports are only used to clean up the process state before 
 * executing a child process.
 */
extern sigset_t nonblocking;
extern int listening_socket;
