/*  Gringotts - a small utility to safe-keep sensitive data
 *  (c) 2002, Germano Rizzo <mano@pluto.linux.it>
 *
 *  grg_defs.h - various declarations
 *  Author: Germano Rizzo
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef GRG_DEFS_H
#define GRG_DEFS_H

#include <glib.h>

#ifdef HAVE_CONFIG_H

#include "config.h"

#endif

#include <libintl.h>
#define _(String) gettext (String)

//general
#define GRG_FALSE		FALSE
#define GRG_TRUE		!GRG_FALSE

//returned OK
#define GRG_OK			0

//interface-specific constants

#define GRG_CUT			100
#define GRG_COPY		101
#define GRG_PASTE		102

#define GRG_PAD			4

//saveable
#define GRG_SAVE_INACTIVE	0
#define GRG_SAVE_ACTIVE		1
#define GRG_SAVE_QUERY		2

#endif
