/*  Gringotts - a small utility to safe-keep sensitive data
 *  (c) 2002, Germano Rizzo <mano@pluto.linux.it>
 *
 *  grg_entries.h - header file for grg_entries.c
 *  Author: Germano Rizzo
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef GRG_ENTRIES_H
#define GRG_ENTRIES_H

//Appends a new entry to the list
void grg_entries_append(gchar * ID);

//Removes the current entry and frees it
void grg_entries_remove();


//Tells if the current entry is the first one
gboolean grg_entries_is_first();

//Tells if the current entry is the last one
gboolean grg_entries_is_last();

//Tells if the current list is empty
gboolean grg_entries_is_empty();


//Goes to the first entry
void grg_entries_first();

//Goes to the previous entry
void grg_entries_prev();

//Goes to the next entry
void grg_entries_next();

//Goes to the last entry
void grg_entries_last();

//Goes to the specified entry, if possible
void grg_entries_nth(gint pos);


//Tells the position of the current entry in the list
gint grg_entries_position();

//Shifts one position up
void grg_entries_raise();

//Shifts one position down
void grg_entries_sink();

//Tells how many elements does the list contain
guint grg_entries_n_el();


//Returns the title of the current entry.
gchar *grg_entries_get_ID();

//Returns the body of the current entry.
GtkTextBuffer *grg_entries_get_Body();

//Returns the text contained in the body of the current entry.
gchar *grg_entries_get_Body_text();

//Stores the given title in the current entry.
void grg_entries_set_ID(gchar * ID);

//Stores the given body in the current entry.
void grg_entries_set_Body(GtkTextBuffer * Body);

//Stores the given text in the body of the current entry.
void grg_entries_set_Body_text(gchar * Body);


//Deletes and frees all the list
void grg_entries_free();


//Saves the list into an encrypted file
gint grg_entries_save(gchar * file, gchar * pwd);

//Reads a file into an entry list
gint grg_entries_load(gchar * file, gchar * pwd);

//"de-serializes" a string into an entry list
void grg_entries_load_from_string(gchar * str);

//Wrapper to grg_load_crypted, to add UTF-8 validation
gint grg_load_wrapper(guchar **txt, gchar *pwd, gchar *file, guint just_validate);

#endif
