/*  Gringotts - a small utility to safe-keep sensitive data
 *  (c) 2002, Germano Rizzo <mano@pluto.linux.it>
 *
 *  grg_menus.c - builds the menu widget(s)
 *  Author: Nicolas Pouillon
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>

#include "gringotts.h"
#include "grg_menus.h"
#include "grg_defs.h"

#include <gdk/gdkkeysyms.h>

#define NEW_MENU_ITEM(var, text, cb, data, parent, img, key, mod) \
	var = gtk_image_menu_item_new_with_mnemonic(text); \
	gtk_menu_shell_append (GTK_MENU_SHELL (parent), var); \
	image = gtk_image_new_from_stock( img, GTK_ICON_SIZE_MENU ); \
	gtk_image_menu_item_set_image( GTK_IMAGE_MENU_ITEM(var), image ); \
	gtk_widget_add_accelerator (var, "activate", accel_group, key, mod, GTK_ACCEL_VISIBLE); \
	g_signal_connect (var, "activate", G_CALLBACK(cb), data)

#define NEW_MENU_SEPARATOR(var, parent) \
	var = gtk_separator_menu_item_new(); \
	gtk_menu_shell_append (GTK_MENU_SHELL (parent), var)

/**
 * grg_menu_create:
 * @window: the window to add the menu to
 *
 * Makes a menubar, within a handlebox, and returns the GtkWidget
 *
 * Returns: the menubar widget
 */
GtkWidget *
grg_menu_create (GtkWidget * window)
{
	// menu File: GtkWidget *bnew, *bopen, *bsave, *bsas, *brev, *bclose, *bquit;
	// menu Edit: GtkWidget *badd, *bcut, *bcop, *bpaste, *brem, *bpwd, *bpref;
	// menu Navigation: GtkWidget *bmfirst, *bmback, *bmfor, *bmlast, *bmind;
	// menu Help: GtkWidget *babo;

	GtkWidget *menubar, *mhandle, *wid;
	GtkWidget *file, *edit, *nav, *help;
	GtkWidget *image;
	GtkAccelGroup *accel_group;

	accel_group = gtk_accel_group_new ();
	gtk_window_add_accel_group (GTK_WINDOW (window), accel_group);

	menubar = gtk_menu_bar_new ();
	mhandle = gtk_handle_box_new ();

	gtk_container_add (GTK_CONTAINER (mhandle), menubar);
	gtk_widget_show (menubar);

	/*
	 * File menu
	 */

	file = gtk_menu_new ();

	wid = gtk_tearoff_menu_item_new ();
	gtk_menu_shell_append (GTK_MENU_SHELL (file), wid);

	NEW_MENU_ITEM (bnew, _("New"), do_new, NULL, file, GTK_STOCK_NEW,
		       GDK_N, GDK_CONTROL_MASK);
	NEW_MENU_SEPARATOR (wid, file);
	NEW_MENU_ITEM (bopen, _("Open"), meta_load, NULL, file,
		       GTK_STOCK_OPEN, GDK_O, GDK_CONTROL_MASK);
	NEW_MENU_ITEM (bsave, _("Save"), save, NULL, file, GTK_STOCK_SAVE,
		       GDK_S, GDK_CONTROL_MASK);
	NEW_MENU_ITEM (bsas, _("Save As"), meta_save_as, NULL, file,
		       GTK_STOCK_SAVE_AS, GDK_A, GDK_CONTROL_MASK);
	NEW_MENU_ITEM (brev, _("Revert"), revert, NULL, file,
		       GTK_STOCK_REVERT_TO_SAVED, GDK_R, GDK_CONTROL_MASK);
	NEW_MENU_ITEM (bclose, _("Close"), file_close, NULL, file,
		       GTK_STOCK_CLOSE, GDK_W, GDK_CONTROL_MASK);
	NEW_MENU_SEPARATOR (wid, file);
	NEW_MENU_ITEM (bquit, _("Quit"), meta_quit, NULL, file,
		       GTK_STOCK_QUIT, GDK_Q, GDK_CONTROL_MASK);


	wid = gtk_menu_item_new_with_label (_("File"));
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (wid), file);
	gtk_menu_shell_append (GTK_MENU_SHELL (menubar), wid);

	/*
	 * Edit menu
	 */

	edit = gtk_menu_new ();

	wid = gtk_tearoff_menu_item_new ();
	gtk_menu_shell_append (GTK_MENU_SHELL (edit), wid);

	NEW_MENU_ITEM (badd, _("Add"), insert, NULL, edit, GTK_STOCK_ADD,
		       GDK_D, GDK_CONTROL_MASK);
	NEW_MENU_ITEM (brem, _("Remove"), del, NULL, edit, GTK_STOCK_REMOVE,
		       GDK_E, GDK_CONTROL_MASK);
	NEW_MENU_SEPARATOR (wid, edit);
	NEW_MENU_ITEM (bcut, _("Cut"), cucopa, GINT_TO_POINTER (GRG_CUT),
		       edit, GTK_STOCK_CUT, GDK_X, GDK_CONTROL_MASK);
	NEW_MENU_ITEM (bcop, _("Copy"), cucopa, GINT_TO_POINTER (GRG_COPY),
		       edit, GTK_STOCK_COPY, GDK_C, GDK_CONTROL_MASK);
	NEW_MENU_ITEM (bpaste, _("Paste"), cucopa,
		       GINT_TO_POINTER (GRG_PASTE), edit, GTK_STOCK_PASTE,
		       GDK_V, GDK_CONTROL_MASK);
	NEW_MENU_SEPARATOR (wid, edit);
	NEW_MENU_ITEM (bpwd, _("Change Password"), chpwd, NULL, edit,
		       GTK_STOCK_ADD, GDK_C,
		       GDK_SHIFT_MASK | GDK_CONTROL_MASK);
	NEW_MENU_SEPARATOR (wid, edit);
	NEW_MENU_ITEM (bpref, _("Preferences"), nyi, NULL, edit,
		       GTK_STOCK_PREFERENCES, GDK_P, GDK_CONTROL_MASK);

	wid = gtk_menu_item_new_with_label (_("Edit"));
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (wid), edit);
	gtk_menu_shell_append (GTK_MENU_SHELL (menubar), wid);

	/*
	 * Navigation menu
	 */

	nav = gtk_menu_new ();

	wid = gtk_tearoff_menu_item_new ();
	gtk_menu_shell_append (GTK_MENU_SHELL (nav), wid);

	NEW_MENU_ITEM (bmfirst, _("First"), move_1, NULL, nav,
		       GTK_STOCK_GOTO_FIRST, GDK_I, GDK_CONTROL_MASK);
	NEW_MENU_ITEM (bmback, _("Back"), move_b, NULL, nav,
		       GTK_STOCK_GO_BACK, GDK_K, GDK_CONTROL_MASK);
	NEW_MENU_ITEM (bmfor, _("Forward"), move_f, NULL, nav,
		       GTK_STOCK_GO_FORWARD, GDK_W,
		       GDK_SHIFT_MASK | GDK_CONTROL_MASK);
	NEW_MENU_ITEM (bmlast, _("Last"), move_l, NULL, nav,
		       GTK_STOCK_GOTO_LAST, GDK_T, GDK_CONTROL_MASK);
	NEW_MENU_SEPARATOR (wid, nav);
	NEW_MENU_ITEM (bmind, _("Index"), meta_list, NULL, nav,
		       GTK_STOCK_INDEX, GDK_X,
		       GDK_SHIFT_MASK | GDK_CONTROL_MASK);

	wid = gtk_menu_item_new_with_label (_("Navigation"));
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (wid), nav);
	gtk_menu_shell_append (GTK_MENU_SHELL (menubar), wid);

	/*
	 * Help menu
	 */

	help = gtk_menu_new ();

	wid = gtk_tearoff_menu_item_new ();
	gtk_menu_shell_append (GTK_MENU_SHELL (help), wid);

	NEW_MENU_ITEM (babo, _("About"), about, NULL, help, GTK_STOCK_HELP,
		       GDK_B, GDK_CONTROL_MASK);

	wid = gtk_menu_item_new_with_label (_("Help"));
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (wid), help);
	gtk_menu_item_set_right_justified (GTK_MENU_ITEM (wid), TRUE);
	gtk_menu_shell_append (GTK_MENU_SHELL (menubar), wid);

	return mhandle;
}
