/*  Gringotts - a small utility to safe-keep sensitive data
 *  (c) 2002, Germano Rizzo <mano@pluto.linux.it>
 *
 *  grg_widgets.h - header file for grg_widgets.c
 *  Author: Germano Rizzo
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef GRG_WIDGETS_H
#define GRG_WIDGETS_H

//Shows and manages a dialog that asks for a string.
gchar *grg_input_dialog(gchar * title, gchar * qtext, gchar * preset,
			gboolean is_pass, GtkWidget * parent);

//Displays a dialog that shows a message.
void grg_msg(gchar * text, GtkMessageType msgt, GtkWidget * parent);

//Asks for a new password, validating it (>4 chars).
gchar *grg_new_pwd_dialog(GtkWidget * parent);

//Asks a question for a boolean answer.
gboolean grg_ask_dialog(gchar * title, gchar * question,
			GtkWidget * parent);

//Associates the Gringotts icon with the given window.
void grg_window_set_icon(GtkWindow * w);

#endif
