/*  Gringotts - a small utility to safe-keep sensitive data
 *  (c) 2002, Germano Rizzo <mano@pluto.linux.it>
 *
 *  gringotts.h - header file for gringotts.c
 *  Author: Germano Rizzo
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef GRINGOTTS_H
#define GRINGOTTS_H

void meta_saveable(gpointer data, gpointer user_data);

	/*callbacks for menu items */

//Displays a "not yet implemented" message box
void nyi();

	/*menu File */

//Creates a new document.
void do_new();

//Displays a file loading dialog, then calls load().
void meta_load();

//Saves the current version of the opened document.
void save();

//Displays the Save As dialog, then calls save_as().
void meta_save_as();

//Reverts to last saved version.
void revert();

//Closes the opened document.
void file_close();

//Asks for save if not saved, and then exits.
void meta_quit();

	/*menu Edit */

//basic CUT clipboard operation
void cucopa(gpointer callback_data, guint callback_action);

//basic COPY clipboard operation
void copy();

//basic PASTE clipboard operation
void paste();

//Appends a new entry.
void insert();

//Deletes the current entry.
void del();

//Calls the change password dialog.
void chpwd();

	/*menu Navigation */

//Displays the first entry.
void move_1();

//Displays the previous entry.
void move_b();

//Displays the next entry.
void move_f();

//Displays the last entry.
void move_l();

//Calls the list window.
void meta_list();

	/*menu Help */

//Displays the `About' box.
void about();

//Performs an action about saveability.
gboolean update_saveable(gint mode);

#endif
