#!/bin/sh
# Tools: jwasm, jfc, jwlink, ms link (COFF)

cmpbin() {
../../Tools/jfc $1.BIN $1.EXP
}
cmpmz() {
../../Tools/jfc $1.EXE $1.EXP
}
cmperr() {
../../Tools/jfc -t 0 $1.err $1.EXP
}
cmpomf() {
../../Tools/jfc $1.o $1.EXP
}
lnkomf() {
../../Tools/jwlink op q,nofar format dos file $1.OBJ libpath ../libomf
../../Tools/jfc $1.EXE $1.EXP
}
cmppe() {
../../Tools/jfc -pe $1.EXE $1.EXP
}
cmplst() {
../../Tools/jfc -t 1 $1.LST $1.EXP
}
coff() {
jwasm -q -coff -safeseh SAFESEH.ASM
if [ "$?" -eq "0" ]; then
../../Tools/link /nologo /SAFESEH SAFESEH.OBJ ../libcoff/SAFESEH.LIB
../../Tools/jfc -pe SAFESEH.EXE SAFESEH.EXP
fi

# weak externals [ extern sym (altname) ...]
jwasm -q -coff EXTERN4.ASM
if [ "$?" -eq "0" ]; then
../../Tools/link /nologo /subsystem:console EXTERN4.OBJ
../../Tools/jfc -pe EXTERN4.EXE EXTERN4.EXP
fi

# weak externals [ ALIAS <> = <> ]
jwasm -q -coff EXTERN11.ASM
if [ "$?" -eq "0" ]; then
../../Tools/jfc -co EXTERN11.o EXTERN11.EXP
fi

# ALIAS segment attribute
jwasm -q -coff SEGALIAS.ASM
if [ "$?" -eq "0" ]; then
../../Tools/jfc -co SEGALIAS.o SEGALIAS.EXP
fi

# ALIGN and characteristics segment attributes
jwasm -q -coff -eq SEGALIGN.ASM
../../Tools/jfc -t 0 SEGALIGN.err SEGALIGN.EXP

# 64-bit dll
jwasm -q -coff DLL64.ASM
if [ "$?" -eq "0" ]; then
../../Tools/jfc -co DLL64.o DLL64.EXP
fi
jwasm -q -coff SEH64.ASM
if [ "$?" -eq "0" ]; then
../../Tools/jfc -co SEH64.o SEH64.EXP
fi
jwasm -q -coff SEH642.ASM
if [ "$?" -eq "0" ]; then
../../Tools/jfc -co SEH642.o SEH642.EXP
fi
jwasm -q -win64 MOV643.ASM
if [ "$?" -eq "0" ]; then
../../Tools/jfc -co MOV643.o MOV643.EXP
fi
jwasm -q -win64 PROC641.ASM
if [ "$?" -eq "0" ]; then
../../Tools/jfc -co PROC641.o PROC641.EXP
fi
jwasm -q -coff PROC643.ASM
if [ "$?" -eq "0" ]; then
../../Tools/jfc -co PROC643.o PROC643.EXP
fi

# option dllimport
jwasm -q -coff -Fd DLLIMP.ASM
if [ "$?" -eq "0" ]; then
../../Tools/jwlink2 format win pe f DLLIMP.OBJ op q,noreloc
../../Tools/jfc -pe DLLIMP.EXE DLLIMP.EXP
fi

# unsupported directives in COFF
jwasm -q -coff -eq UNSUPP1.ASM
../../Tools/jfc -t 0 UNSUPP1.err UNSUPP1.EXP

jwasm -q -coff DATA10.ASM
if [ "$?" -eq "0" ]; then
../../Tools/jfc -co DATA10.o DATA10.EXP
fi

jwasm -q -coff COFFOP.ASM
if [ "$?" -eq "0" ]; then
../../Tools/jfc -co COFFOP.o COFFOP.EXP
fi

# invalid operands for COFF operators
jwasm -q -coff -eq COFFOP2.ASM
../../Tools/jfc -t 0 COFFOP2.err COFFOP2.EXP

# invalid segment attribute (ALIAS) changes
jwasm -q -coff -eq ALIAS2.ASM
../../Tools/jfc -t 0 ALIAS2.err ALIAS2.EXP

# COMDAT errors
jwasm -q -coff -eq COMDAT1.ASM
../../Tools/jfc -t 0 COMDAT1.err COMDAT1.EXP

# COMDAT object module
jwasm -q -coff COMDAT2.ASM
../../Tools/jfc -co COMDAT2.o COMDAT2.EXP

# 64-bit SEH unwind errors
jwasm -q -coff -eq PROC644.ASM
../../Tools/jfc -t 0 PROC644.err PROC644.EXP

# CV4 debug info and multiple code sections 
jwasm -q -coff -Zi CVCOFF1.ASM
../../Tools/jfc -co CVCOFF1.o CVCOFF1.EXP

jwasm -q -coff PROC645.ASM
if [ "$?" -eq "0" ]; then
../../Tools/jfc -co PROC645.o PROC645.EXP
fi

jwasm -q -coff COFF1.ASM
if [ "$?" -eq "0" ]; then
../../Tools/jfc -co COFF1.o COFF1.EXP
fi

jwasm -q -Zi -coff DBGCV.ASM
if [ "$?" -eq "0" ]; then
../../Tools/jfc -co DBGCV.o DBGCV.EXP
fi
}

elf() {
jwasm -q -elf ELF1.ASM
if [ "$?" -eq "0" ]; then
../../Tools/jfc ELF1.o ELF1.EXP
fi
}

div() {
jwasm -q -eq -Zne OVERRID3.ASM
../../Tools/jfc -t 0 OVERRID3.err OVERRID3.EXP

jwasm -q -Zg -bin LOCAL3.ASM
../../Tools/jfc LOCAL3.BIN LOCAL3.EXP

jwasm -q -Zg -bin INVOKE21.ASM
../../Tools/jfc INVOKE21.BIN INVOKE21.EXP

jwasm -q -Zg -bin HLL4.ASM
../../Tools/jfc HLL4.BIN HLL4.EXP

jwasm -q -Zg -omf OPATTR10.ASM
../../Tools/jfc OPATTR10.o OPATTR10.EXP

jwasm -q -Zd -omf LINNUM.ASM
../../Tools/jfc LINNUM.o LINNUM.EXP

jwasm -q -eq -bin STARTUP4.ASM
../../Tools/jfc -t 0 STARTUP4.err STARTUP4.EXP

jwasm -q -eq -mz TEXT32.ASM
../../Tools/jfc -t 0 TEXT32.err TEXT32.EXP

jwasm -q -Cu CASEMAP1.ASM
if [ "$?" -eq "0" ]; then
../../Tools/jfc CASEMAP1.o CASEMAP1.EXP
fi

jwasm -q -eq -W3 INVOKE53.ASM
../../Tools/jfc INVOKE53.err INVOKE53.EXP

jwasm -q -eq -W3 OFFSET15.ASM
../../Tools/jfc OFFSET15.err OFFSET15.EXP
jwasm -q -eq -W3 OFFSET16.ASM
../../Tools/jfc OFFSET16.err OFFSET16.EXP
jwasm -q -eq -W3 INVLPG1.ASM
../../Tools/jfc INVLPG1.err INVLPG1.EXP
}

rm16() {
# rm16 calls jwasmr ( won't run in unix )
../../build/owdos16r/jwasmr -q -zlc -zld ISDEF.ASM
if [ "$?" -eq "0" ]; then
../../Tools/jfc ISDEF.OBJ ISDEF.EXP
fi
}

cd bin
jwasm -q -bin *.ASM
for f in *.ASM; do 
    cmpbin ${f%.*}
done
cd ..

cd mz
jwasm -q -mz *.ASM
for f in *.ASM; do
    cmpmz ${f%.*}
done
cd ..

cd errcoff
jwasm -q -coff -eq *.ASM
for f in *.ASM; do
    cmperr ${f%.*}
done
cd ..

cd error
jwasm -q -omf -eq *.ASM
for f in *.ASM; do
    cmperr ${f%.*}
done
cd ..

cd omf
jwasm -q -omf *.ASM
for f in *.ASM; do
    cmpomf ${f%.*} 
done
cd ..

cd omflnk
jwasm -q -omf *.ASM
#for f in *.ASM; do
#    lnkomf ${f%.*}
#done
cd ..

cd pe
jwasm -q -pe *.ASM
for f in *.ASM; do
    cmppe ${f%.*}
done
cd ..

cd peerr
jwasm -q -pe -eq *.ASM
for f in *.ASM; do
    cmperr ${f%.*}
done
cd ..

cd listing
jwasm -q -Fl -Sn -Sz *.ASM
for f in *.ASM; do
    cmplst ${f%.*}
done
cd ..

cd listmz
jwasm -q -Fl -mz -Sn -Sz *.ASM
for f in *.ASM; do
    cmplst ${f%.*}
done
cd ..

exit

cd coff
coff
cd ..

cd elf
elf
cd ..

cd div
div
cd ..

#cant run jwasmr.exe in unix
#cd rm16
#call :rm16
#cd ..

exit

