/****************************************************************************
*
*                            Open Watcom Project
*
*    Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
*
*  ========================================================================
*
*    This file contains Original Code and/or Modifications of Original
*    Code as defined in and that are subject to the Sybase Open Watcom
*    Public License version 1.0 (the 'License'). You may not use this file
*    except in compliance with the License. BY USING THIS FILE YOU AGREE TO
*    ALL TERMS AND CONDITIONS OF THE LICENSE. A copy of the License is
*    provided with the Original Code and Modifications, and is also
*    available at www.sybase.com/developer/opensource.
*
*    The Original Code and all software distributed under the License are
*    distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
*    EXPRESS OR IMPLIED, AND SYBASE AND ALL CONTRIBUTORS HEREBY DISCLAIM
*    ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF
*    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR
*    NON-INFRINGEMENT. Please see the License for the specific language
*    governing rights and limitations under the License.
*
*  ========================================================================
*
* Description:  WHEN YOU FIGURE OUT WHAT THIS FILE DOES, PLEASE
*               DESCRIBE IT HERE!
*
****************************************************************************/


// MKGML - This program takes as input the 'cerrs.h' file and
//         creates the appropriate GML file for the manual and
//         on-line help files.
//  Date:       Who:            Reason:
//  -----       ----            -------
//  01-apr-95   F.W.Crigger     Initial implementation
//
#include <stdio.h>

#define warn
#define E(msg)          msg
#define J(msg)
#define err1(code,msg)  msg
#define err2(code,msg)  msg
#define err3(code,msg)  msg
#define err9(code,msg)  msg
#define inf1(code,msg)  msg
#define ERR1MSG_ARRAY   char *Err1Msgs[]
#define ERR2MSG_ARRAY   char *Err2Msgs[]
#define ERR3MSG_ARRAY   char *Err3Msgs[]
#define ERR9MSG_ARRAY   char *Err9Msgs[]
#define INF1MSG_ARRAY   char *Inf1Msgs[]
#define MKGML
#include "cerrs.h"

void ProcessMsgs( FILE *out, FILE *in, char *msgs[], char chr, int msgnum )
{
    int         i;
    char        buf[128];

    for( i=0; msgs[i]; i++ ) {
        if( *msgs[i] != '\0' ) {
            fprintf( out, ".errnote %c%d %s\n", chr, msgnum, msgs[i] );
        }
        for(;;) {
            fgets( buf, 128, in );
            if( memcmp( buf, "#ifdef GML", 10 ) == 0 ) break;
        }
        for(;;) {
            fgets( buf, 128, in );
            if( memcmp( buf, "#endif", 6 ) == 0 ) break;
            fprintf( out, "%s", buf );
        }
        fprintf( out, "\n" );
        ++msgnum;
    }
}

main()
{
    FILE        *in;
    FILE        *out;

    in = fopen( "cerrs.h", "r" );
    out = fopen( "cerror.gml", "w" );
    fprintf( out, ".* ***********************************************\n" );
    fprintf( out, ".* DO NOT EDIT THIS FILE! THIS FILE IS GENERATED *\n" );
    fprintf( out, ".* FROM CERRS.H IN THE C PROJECT.                *\n" );
    fprintf( out, ".* ***********************************************\n" );
    fprintf( out, ".*\n.errsect Warning Level 1 Messages\n.*\n" );
    fprintf( out, ".ix 'diagnostics' 'warning'\n" );
    fprintf( out, ".ix 'messages' 'warning'\n" );
    fprintf( out, ".ix 'warning messages' 'level 1'\n" );
    ProcessMsgs( out, in, Err1Msgs, 'W', 100 );
    fprintf( out, ".eerrsect\n" );
    fprintf( out, ".*\n.errsect Warning Level 2 Messages\n.*\n" );
    fprintf( out, ".ix 'diagnostics' 'warning'\n" );
    fprintf( out, ".ix 'messages' 'warning'\n" );
    fprintf( out, ".ix 'warning messages' 'level 2'\n" );
    ProcessMsgs( out, in, Err2Msgs, 'W', 200 );
    fprintf( out, ".eerrsect\n" );
    fprintf( out, ".*\n.errsect Warning Level 3 Messages\n.*\n" );
    fprintf( out, ".ix 'diagnostics' 'warning'\n" );
    fprintf( out, ".ix 'messages' 'warning'\n" );
    fprintf( out, ".ix 'warning messages' 'level 3'\n" );
    ProcessMsgs( out, in, Err3Msgs, 'W', 300 );
    fprintf( out, ".eerrsect\n" );
    fprintf( out, ".*\n.errsect Error Messages\n.*\n" );
    fprintf( out, ".ix 'diagnostics' 'error'\n" );
    fprintf( out, ".ix 'messages' 'error'\n" );
    fprintf( out, ".ix 'error messages'\n" );
    ProcessMsgs( out, in, Err9Msgs, 'E', 1000 );
    fprintf( out, ".eerrsect\n" );
    fprintf( out, ".*\n.errsect Informational Messages\n.*\n" );
    fprintf( out, ".ix 'diagnostics' 'informational'\n" );
    fprintf( out, ".ix 'messages' 'informational'\n" );
    ProcessMsgs( out, in, Inf1Msgs, 'I', 2000 );
    fprintf( out, ".eerrsect\n" );
    fclose( in );
    fclose( out );
}
