.chap *refid=wdisasm The Object File Disassembler
.*
.if &e'&dohelp eq 0 .do begin
.section Introduction
.do end
.*
.np
.ix 'disassembler'
This chapter describes the &disname..
It takes as input an object file (a file with extension "&obj") and
produces, as output, the Intel assembly language equivalent.
The &company compilers do not produce an assembly language listing
directly from a source program.
Instead, the &disname can be used to generate an assembly language
listing from the object file generated by the compiler.
.np
The &disname command line syntax is the following.
.ix '&discmdup' 'command line format'
.ix 'command line format' '&discmdup'
.if '&target' eq 'QNX' .do begin
.mbigbox
&discmdup [options] filespec [options]
.embigbox
.np
The square brackets [ ] denote items which are optional.
.begnote
.mnote &discmd
is the name of the &disname..
.mnote filespec
is the filename specification of the object file to be
disassembled.
A default filename extension of ".o" is assumed when no extension is
specified.
A filename extension consists of that portion of a filename containing
the last "." and any characters which follow it.
.exam begin
File Specification              Extension
/home/john.doe/foo              (none)
/home/john.doe/foo.             .
/home/john.doe/foo.bar          .bar
/home/john.doe/foo.goo.bar      .bar
.exam end
.mnote options
is a list of valid &disname options, each preceded by a dash
("&minus.").
Options may be specified in any order.
.endnote
.do end
.el .do begin
.mbigbox
&discmdup [options] [d:][path]filename[.ext] [options]
.embigbox
.np
The square brackets [ ] denote items which are optional.
.begnote
.mnote &discmdup
is the name of the &disname..
.mnote d:
is an optional drive specification such as "A:", "B:", etc.
If not specified, the default drive is assumed.
.mnote path
is an optional path specification such as "\PROGRAMS\OBJ\".
If not specified, the current directory is assumed.
.mnote filename
is the file name of the object file to disassemble.
.mnote ext
is the file extension of the object file to disassemble.
If omitted, a file extension of "&obj" is assumed.
If the period "." is specified but not the extension, the file is
assumed to have no file extension.
.mnote options
is a list of valid options, each preceded by a slash
("/") or a dash ("&minus.").
Options may be specified in any order.
.endnote
.do end
.np
The options supported by the &disname. are:
.begnote $break $compact
.note a
write assembly instructions only to the listing file
:CMT. .note au
:CMT. .ix 'UNIX'
:CMT. write assembly instructions only to the listing file using
:CMT. UNIX-style assembly syntax
.note e
include list of external names
.note fp
do not use instruction name pseudonyms
.note fr
do not use register name pseudonyms [Alpha only]
.note fi
use alternate indexing format [80(x)86 only]
.note fu
instructions/registers in upper case
.note i=<char>
redefine the initial character of internal labels (default: L)
.note l[=<list_file>]
create a listing file
.note m
leave C++ names mangled
.note o
print list of operands beside instructions
.note p
include list of public names
.note s[=<source_file>]
using object file source line information, imbed original source
lines into the output file
:CMT. .note b
:CMT. generate alternate form of based or indexed addressing modes
:CMT. .note c=<code_name>
:CMT. name of additional segments that contain executable code
:CMT. .note r
:CMT. display register names in upper case
:CMT. .note u
:CMT. display instruction opcode mnemonics in upper case
.endnote
.np
.ix '&discmdup options'
The following sections describe the list of options.
:CMT. .*
:CMT. .section Identifying Code Segments Option - "c=<code_name>"
:CMT. .*
:CMT. .np
:CMT. .ix '&discmdup options' 'c'
:CMT. The "c" option permits you to specify one additional segment name
:CMT. or pattern for segments that contain executable code.
:CMT. Valid forms of the "c" option are:
:CMT. .millust begin
:CMT. c=<string>
:CMT. &setdelim.c=*<string>&setdelim.
:CMT. &setdelim.c=<string>*&setdelim.
:CMT. .millust end
:CMT. .pc
:CMT. .id <string>
:CMT. is any sequence of characters with letters treated in a case insensitive
:CMT. manner.
:CMT. The "*" character is a wildcard character.
:CMT. .if '&target' eq 'QNX' .do begin
:CMT. You must protect the "*" with quotation marks to prevent the shell
:CMT. from attempting to expand it.
:CMT. .do end
:CMT. .np
:CMT. By default, the following segments are assumed to contain executable code.
:CMT. .autopoint
:CMT. .point
:CMT. segments with class name "CODE"
:CMT. .point
:CMT. segments whose name ends in "TEXT" or "CODE" (this is equivalent to
:CMT. "c=*text" and "c=*code")
:CMT. .endpoint
:CMT. .np
:CMT. Consider the following example.
:CMT. .millust begin
:CMT. &prompt.&discmd myprog &setdelim.&sw.c=T@*&setdelim.
:CMT. .millust end
:CMT. .pc
:CMT. All segments whose name starts with the characters "T@" (in addition
:CMT. to those ending in "CODE" or "TEXT") are assumed to contain
:CMT. executable code.
:CMT. .remark
:CMT. It is not possible to instruct the &disname to interpret segments
:CMT. whose name ends in "CODE" or "TEXT" as data.
:CMT. .eremark
.*
.section Changing the Internal Label Character - "i=<char>"
.*
.np
.ix '&discmdup options' 'i'
The "i" option permits you to specify the first character to be used
for internal labels.
Internal labels take the form "Ln" where "n" is one or more digits.
The default character "L" can be changed using the "i" option.
The replacement character must be a letter (a-z, A-Z).
A lowercase letter is converted to uppercase.
.exam begin
&prompt.&discmd calendar &sw.i=x
.exam end
.*
:CMT. .section The Assembly Format Option - "a", "au"
.*
.section The Assembly Format Option - "a"
.*
.np
.ix '&discmdup options' 'a'
The "a" option controls the format of the output produced to the
listing file.
When specified, the &disname will produce a listing file that can be
used as input to an assembler.
:CMT. .ix 'UNIX'
:CMT. When "au" is specified, the assembly syntax is that employed by UNIX
:CMT. systems.
.exam begin
&prompt.&discmd calendar &sw.a &sw.l=calendar.asm
.exam end
.pc
In the above example, the &disname is instructed to disassemble the
contents of the file
.fi calendar&obj
and produce the output to the file
.fi calendar.asm
so that it can be assembled by an assembler.
.*
:CMT. .section The Alternate Addressing Form Option - "b"
.*
.section The External Symbols Option - "e"
.*
.np
.ix '&discmdup options' 'e'
The "e" option controls the amount of information produced in the
listing file.
When specified, a list of all externally defined symbols is produced
in the listing file.
.exam begin
&prompt.&discmd calendar &sw.e
.exam end
.pc
In the above example, the &disname is instructed to disassemble the
contents of the file
.fi calendar&obj
and produce the output, with a
list of all external symbols, on the screen.
A sample list of external symbols is shown below.
.if '&lang' eq 'C' or '&lang' eq 'C/C++' .do begin
.if '&arch' eq '16-bit' .do begin
.code begin
List of external symbols

Symbol
----------------
___iob           000002bc 000001c4 000001af 00000128 00000111
__STK            000002fc 000002c9 0000027f 000001e4 000000a9 00000004
Box_             000000d2
Calendar_        0000008e 00000066 0000003e
ClearScreen_     00000012
fflush_          000002bf 000001c7 000001b2 0000012b 00000114
int86_           00000323 000002f1
Line_            00000272 00000252 00000235 0000021c 00000205
localtime_       00000023
memset_          0000029d
PosCursor_       000002af 000001a1 0000011c 00000100 00000097
printf_          000002b6 000001be 000001a9 00000122 0000010b
strlen_          000000e3
time_            00000017
------------------------------------------------------------
.code end
.do end
.if '&arch' eq '32-bit' .do begin
.code begin
List of external symbols

Symbol
----------------
___iob           0000032f 00000210 000001f4 00000158 00000139
__CHK            00000381 00000343 000002eb 00000237 000000cb 00000006
Box_             000000f2
Calendar_        000000a7 00000079 00000049
ClearScreen_     00000016
fflush_          00000334 00000215 000001f9 0000015d 0000013e
int386_          000003af 00000372
Line_            000002db 000002b5 00000293 00000274 0000025a
localtime_       00000028
memset_          00000308
PosCursor_       0000031e 000001e1 00000148 00000123 000000b6
printf_          00000327 00000208 000001ec 00000150 00000131
strlen_          00000108
time_            0000001d
------------------------------------------------------------
.code end
.do end
.do end
.if '&lang' eq 'FORTRAN 77' .do begin
.if '&arch' eq '16-bit' .do begin
.code begin
List of external symbols

Symbol
----------------
CALENDAR         000000f8 000000aa 0000005c
CLEARSCREEN      0000000b
GETDAT           0000001f
POSCURSOR        00000117
------------------------------------------------------------
.code end
.do end
.if '&arch' eq '32-bit' .do begin
.code begin
List of external symbols

Symbol
----------------
CALENDAR         000000cf 0000008b 00000047
CLEARSCREEN      0000000a
GETDAT           00000018
POSCURSOR        000000e8
------------------------------------------------------------
.code end
.do end
.do end
.pc
Each externally defined symbol is followed by a list of location
counter values indicating where the symbol is referenced.
.np
The "e" option is ignored when the "a" option is specified.
.*
.section The No Instruction Name Pseudonyms Option - "fp"
.*
.np
.ix '&discmdup options' 'fp'
By default, AXP instruction name pseudonyms are emitted in place of
actual instruction names.
The &wasname accepts instruction name pseudonyms.
The "fp" option instructs the &disname to emit the actual instruction
names instead.
.*
.section The No Register Name Pseudonyms Option - "fr"
.*
.np
.ix '&discmdup options' 'fr'
By default, AXP register names are emitted in pseudonym form.
The &wasname accepts register pseudonyms.
The "fr" option instructs the &disname to display register names in
their non-pseudonym form.
.*
.section The Alternate Addressing Form Option - "fi"
.*
.np
.ix '&discmdup options' 'fi'
The "fi" option causes an alternate syntactical form of the based or
indexed addressing mode of the 80x86 to be used in an instruction.
For example, the following form is used by default for Intel
instructions.
.millust begin
mov ax,-2[bp]
.millust end
.pc
If the "fi" option is specified, the following form is used.
.millust begin
mov ax,[bp-2]
.millust end
.*
.section The Uppercase Instructions/Registers Option - "fu"
.*
.np
.ix '&discmdup options' 'fu'
The "fu" option instructs the &disname to display instruction and
register names in uppercase characters.
The default is to display them in lowercase characters.
.*
.section The Listing Option - "l[=<list_file>]"
.*
.np
.ix '&discmdup options' 'l (lowercase L)'
By default, the &disname produces its output to the terminal.
The "l" (lowercase L) option instructs the &disname to produce the
output to a listing file.
The default file name of the listing file is the same as the file
name of the object file.
The default file extension of the listing file is
.fi &lst..
.exam begin
&prompt.&discmd calendar &sw.l
.exam end
.pc
In the above example, the &disname is instructed to disassemble the
contents of the file
.fi calendar&obj
and produce the output to a listing file called
.fi calendar&lst..
.np
An alternate form of this option is "l=<list_file>".
With this form, you can specify the name of the listing file.
When specifying a listing file, a file extension of
.fi &lst
is assumed if none is specified.
.exam begin
&prompt.&discmd calendar &sw.l=calendar.lis
.exam end
.pc
In the above example, the &disname is instructed to disassemble the
contents of the file
.fi calendar&obj
and produce the output to a listing file called
.fi calendar.lis.
.*
.section The Public Symbols Option - "p"
.*
.np
.ix '&discmdup options' 'p'
The "p" option controls the amount of information produced in the
listing file.
When specified, a list of all public symbols is produced in the
listing file.
.exam begin
&prompt.&discmd calendar &sw.p
.exam end
.pc
In the above example, the &disname is instructed to disassemble the
contents of the file
.fi calendar&obj
and produce the output, with a list of all exported symbols, to the
screen.
A sample list of public symbols is shown below.
.if '&lang' eq 'C' or '&lang' eq 'C/C++' .do begin
.if '&arch' eq '16-bit' .do begin
.code begin
List of public symbols

SYMBOL                  SECTION                 OFFSET
--------------------------------------------------------
main_                   _TEXT                   0000024A
void near Box( int, int, int, int )
                        _TEXT                   0000007D
void near Calendar( int, int, int, int, int, char near * )
                        _TEXT                   00000118
void near ClearScreen() _TEXT                   00000000
void near Line( int, int, int, char, char, char )
                        _TEXT                   0000002E
void near PosCursor( int, int )
                        _TEXT                   00000015
.code end
.do end
.if '&arch' eq '32-bit' .do begin
.np
The following is a list of public symbols in 80x86 code.
.code begin
List of public symbols

SYMBOL                  SECTION                 OFFSET
--------------------------------------------------------
main_                   _TEXT                   000002C0
void near Box( int, int, int, int )
                        _TEXT                   00000093
void near Calendar( int, int, int, int, int, char near * )
                        _TEXT                   0000014A
void near ClearScreen() _TEXT                   00000000
void near Line( int, int, int, char, char, char )
                        _TEXT                   00000036
void near PosCursor( int, int )
                        _TEXT                   0000001A
.code end
.np
The following is a list of public symbols in Alpha AXP code.
.code begin
List of public symbols

SYMBOL                  SECTION                 OFFSET
--------------------------------------------------------
main                    .text                   000004F0
void near Box( int, int, int, int )
                        .text                   00000148
void near Calendar( int, int, int, int, int, char near * )
                        .text                   00000260
void near ClearScreen() .text                   00000000
void near Line( int, int, int, char, char, char )
                        .text                   00000060
void near PosCursor( int, int )
                        .text                   00000028
.code end
.do end
.do end
.if '&lang' eq 'FORTRAN 77' .do begin
.if '&arch' eq '16-bit' .do begin
.code begin
List of public symbols

SYMBOL          GROUP           SEGMENT          ADDRESS
---------------------------------------------------------
BOX                             BOX_TEXT         00000000
CALENDAR                        CALENDAR_TEXT    00000000
CLEARSCREEN                     CLEARSCREEN_TEXT 00000000
FMAIN                           FMAIN_TEXT       00000000
LINE                            LINE_TEXT        00000000
POSCURSOR                       POSCURSOR_TEXT   00000000

------------------------------------------------------------
.code end
.do end
.if '&arch' eq '32-bit' .do begin
.code begin
List of public symbols

SYMBOL          GROUP           SEGMENT          ADDRESS
---------------------------------------------------------
BOX                             BOX_TEXT         00000000
CALENDAR                        CALENDAR_TEXT    00000000
CLEARSCREEN                     CLEARSCREEN_TEXT 00000000
FMAIN                           FMAIN_TEXT       00000000
LINE                            LINE_TEXT        00000000
POSCURSOR                       POSCURSOR_TEXT   00000000

------------------------------------------------------------
.code end
.do end
.do end
.np
The "p" option is ignored when the "a" option is specified.
.*
.section Retain C++ Mangled Names  - "m"
.*
.np
.ix '&discmdup options' 'm'
The "m" option instructs the &disname to retain C++ mangled names
rather than displaying their demangled form.
The default is to interpret mangled C++ names and display them in
a somewhat more intelligible form.
.*
.section The Source Option - "s[=<source_file>]"
.*
.np
.ix '&discmdup options' 's'
The "s" option causes the source lines corresponding to the assembly
language instructions to be produced in the listing file.
The object file must contain line numbering information.
That is, the "d1" or "d2" option must have been specified when the
source file was compiled.
If no line numbering information is present in the object file, the "s"
option is ignored.
.np
The following defines the order in which the source file name is
determined when the "s" option is specified.
.autopoint
.point
If present,
the source file name specified on the command line.
.point
The name from the module header record.
.point
The object file name.
.endpoint
.np
In the following example, we have compiled the source file
.fi mysrc.&langsuff
with "d1" debugging information.
We then disassemble it as follows:
.exam begin
&prompt.&discmd mysrc &sw.s &sw.l
.exam end
.pc
In the above example, the &disname is instructed to disassemble the
contents of the file
.fi mysrc&obj
and produce the output to the listing file
.fi mysrc&lst..
The source lines are extracted from the file
.fi mysrc.&langsuff..
.np
An alternate form of this option is "s=<source_file>".
With this form, you can specify the name of the source file.
:cmt. When specifying a source file, a file extension of ".&langsuffup" is
:cmt. assumed if none is specified.
.exam begin
&prompt.&discmd mysrc &sw.s=myprog.&langsuff &sw.l
.exam end
.pc
The above example produces the same result as in the previous example
except the source lines are extracted from the file
.fi myprog.&langsuff..
.*
.section An Example
.*
.np
.ix '&discmdup example'
.ix 'disassembly example'
Consider the following program contained in the file
.fi hello.&langsuff..
.if '&lang' eq 'C' or '&lang' eq 'C/C++' .do begin
.mbox begin
#include <stdio.h>

void main()
{
    printf( "Hello world\n" );
}
.mbox end
.do end
.if '&lang' eq 'FORTRAN 77' .do begin
.mbox begin
      program main
      print *, 'Hello world'
      end
.mbox end
.do end
.np
Compile it with the "d1" option.
An object file called
.fi hello&obj
will be produced.
The "d1" option causes line numbering information to be generated in
the object file.
We can use the &disname to disassemble the contents of the object file
by issuing the following command.
.millust begin
&prompt.&discmd hello &sw.l &sw.e &sw.p &sw.s &sw.fu
.millust end
.pc
The output will be written to a listing file called
.fi hello&lst
(the "l" option was specified").
It will contain a list of external symbols
(the "e" option was specified),
a list of public symbols (the "p" option was specified) and
the source lines corresponding to the assembly language instructions
(the "s" option was specified).
The source input file is called
.fi hello.&langsuff..
The register names will be displayed in upper case (the "fu" option was
specified).
The output, shown below, is the result of using the
.if '&lang' eq 'C' or '&lang' eq 'C/C++' .do begin
&cmppname
.do end
.if '&lang' eq 'FORTRAN 77' .do begin
&cmpname
.do end
compiler.
.if '&lang' eq 'C' or '&lang' eq 'C/C++' .do begin
.if '&arch' eq '16-bit' .do begin
.code begin
Module: HELLO.C
GROUP: 'DGROUP' CONST,CONST2,_DATA,_BSS

Segment: _TEXT WORD USE16 00000013 bytes

#include <stdio.h>

void main()
0000                    main_:
0000    B8 04 00            MOV       AX,0x00000004
0003    E8 00 00            CALL      __STK

{
    printf( "Hello world\n" );
0006    B8 00 00            MOV       AX,offset L$1
0009    50                  PUSH      AX
000A    E8 00 00            CALL      printf_
000D    83 C4 02            ADD       SP,0x00000002

}
0010    31 C0               XOR       AX,AX
0012    C3                  RET

Routine Size: 19 bytes,    Routine Base: _TEXT + 0000

No disassembly errors

.code break
List of external references

SYMBOL
-------
__STK                   0004
printf_                 000B

Segment: CONST WORD USE16 0000000D bytes
0000                    L$1:
0000    48 65 6C 6C 6F 20 77 6F 72 6C 64 0A 00          Hello world..




BSS Size: 0 bytes

.code break
List of public symbols

SYMBOL                  SECTION                 OFFSET
--------------------------------------------------------
main_                   _TEXT                   00000000
.code end
.do end
.if '&arch' eq '32-bit' .do begin
.np
The following is a disassembly of 80x86 code.
.code begin
Module: HELLO.C
GROUP: 'DGROUP' CONST,CONST2,_DATA,_BSS

Segment: _TEXT DWORD USE32 0000001A bytes

#include <stdio.h>

void main()
0000                    main_:
0000    68 08 00 00 00      PUSH      0x00000008
0005    E8 00 00 00 00      CALL      __CHK

{
    printf( "Hello world\n" );
000A    68 00 00 00 00      PUSH      offset L$1
000F    E8 00 00 00 00      CALL      printf_
0014    83 C4 04            ADD       ESP,0x00000004

}
0017    31 C0               XOR       EAX,EAX
0019    C3                  RET

Routine Size: 26 bytes,    Routine Base: _TEXT + 0000

No disassembly errors

.code break
List of external references

SYMBOL
-------
__CHK                   0006
printf_                 0010

Segment: CONST DWORD USE32 0000000D bytes
0000                    L$1:
0000    48 65 6C 6C 6F 20 77 6F 72 6C 64 0A 00          Hello world..




BSS Size: 0 bytes

.code break
List of public symbols

SYMBOL                  SECTION                 OFFSET
--------------------------------------------------------
main_                   _TEXT                   00000000
.code end
.np
The following is a disassembly of Alpha AXP code.
.code begin
                                .new_section .text, "crx4"

#include <stdio.h>

void main()
0000                    main:
0000    23DEFFF0            LDA           SP,-0x10(SP)
0004    B75E0000            STQ           RA,(SP)

{
    printf( "Hello world\n" );
0008    261F0000            LDAH          A0,h^L$0(R31)
000C    22100000            LDA           A0,l^L$0(A0)
0010    43F00010            SEXTL         A0,A0
0014    D3400000            BSR           RA,j^printf

}
0018    201F0000            MOV           0x00000000,V0
001C    A75E0000            LDQ           RA,(SP)
0020    23DE0010            LDA           SP,0x10(SP)
0024    6BFA8001            RET           (RA)

Routine Size: 40 bytes,    Routine Base: .text + 0000

No disassembly errors

.code break
List of external references

SYMBOL
-------
printf                  0014

                                .new_section .const, "drw4"
0000                    L$0:
0000    48 65 6C 6C 6F 20 77 6F 72 6C 64 0A 00 00 00 00 Hello world.....

                                .new_section .const2, "drw4"

                                .new_section .data, "drw4"

                                .new_section .bss, "urw4"
0000                    .bss:

BSS Size: 0 bytes


                                .new_section .pdata, "dr2"

0000                    //  Procedure descriptor for main
        main                                    //  BeginAddress      : 0
        main+0x28                               //  EndAddress        : 40
        00000000                                //  ExceptionHandler  : 0
        00000000                                //  HandlerData       : 0
        main+0x8                                //  PrologEnd         : 8

                                .new_section .drectve, "iRr0"
0000    2D 64 65 66 61 75 6C 74 6C 69 62 3A 63 6C 69 62 -defaultlib:clib
0010    20 2D 64 65 66 61 75 6C 74 6C 69 62 3A 70 6C 69  -defaultlib:pli
0020    62 20 2D 64 65 66 61 75 6C 74 6C 69 62 3A 6D 61 b -defaultlib:ma
0030    74 68 20 00                                     th .

.code break
List of public symbols

SYMBOL                  SECTION                 OFFSET
--------------------------------------------------------
main                    .text                   00000000
.code end
.do end
.do end
.if '&lang' eq 'FORTRAN 77' .do begin
.if '&arch' eq '16-bit' .do begin
.code begin
Module: hello.for
GROUP: 'DGROUP' CONST,_DATA,_BSS

Segment: CONST PARA USE16 0000000B bytes
0000                    L$1:
0000    48 65 6C 6C 6F 20 77 6F 72 6C 64                Hello world

Segment: _DATA PARA USE16 00000006 bytes
0000                    L$2:
0000    00 00 00 00                                     DD      L$1
0004    0B 00                                           ..


BSS Size: 0 bytes

Segment: FMAIN_TEXT BYTE USE16 00000017 bytes

      program main
0000                    FMAIN:
0000    52                  PUSH      DX

      print *, 'Hello world'
0001    9A 00 00 00 00      CALL      RT@IOWrite
0006    B8 00 00            MOV       AX,offset L$2
0009    8C D2               MOV       DX,SS
000B    9A 00 00 00 00      CALL      RT@OutCHAR
0010    9A 00 00 00 00      CALL      RT@EndIO

      end
0015    5A                  POP       DX
0016    CB                  RETF

Routine Size: 23 bytes,    Routine Base: FMAIN_TEXT + 0000

No disassembly errors

.code break
List of external references

SYMBOL
-------
RT@EndIO                0011
RT@IOWrite              0002
RT@OutCHAR              000C

List of public symbols

SYMBOL                  SECTION                 OFFSET
--------------------------------------------------------
FMAIN                   FMAIN_TEXT              00000000
.code end
.do end
.if '&arch' eq '32-bit' .do begin
.code begin
Module: hello.for
Group: 'DGROUP' CONST,_DATA,_BSS
Group: 'FLAT'

Segment: 'FMAIN_TEXT' BYTE USE32  00000014 bytes

        program main
        print *, 'Hello world'
 0000  e8 00 00 00 00    FMAIN           call    RT@IOWrite
 0005  b8 00 00 00 00                    mov     EAX,offset L2
 000a  e8 00 00 00 00                    call    RT@OutCHAR
 000f  e9 00 00 00 00                    jmp     RT@EndIO
.code break
No disassembly errors

List of external symbols

Symbol
----------------
RT@EndIO         00000010
RT@IOWrite       00000001
RT@OutCHAR       0000000b
------------------------------------------------------------

Segment: 'CONST' WORD USE32  0000000b bytes
 0000  48 65 6c 6c 6f 20 77 6f L1              - Hello wo
 0008  72 6c 64                                - rld
.code break
No disassembly errors

------------------------------------------------------------

Segment: '_DATA' WORD USE32  00000008 bytes
 0000  00 00 00 00             L2              DD      DGROUP:L1
 0004  0b 00 00 00                             - ....
.code break
No disassembly errors

------------------------------------------------------------
List of public symbols

SYMBOL          GROUP           SEGMENT          ADDRESS
---------------------------------------------------------
FMAIN                           FMAIN_TEXT       00000000

------------------------------------------------------------

.code end
.do end
.do end
.keep
.np
Let us create a form of the listing file that can be used
as input to an assembler.
.millust begin
&prompt.&discmd hello &sw.l=hello.asm &sw.r &sw.a
.millust end
.pc
The output will be produced in the file
.fi hello.asm.
The output, shown below, is the result of using the
.if '&lang' eq 'C' or '&lang' eq 'C/C++' .do begin
&cmppname
.do end
.if '&lang' eq 'FORTRAN 77' .do begin
&cmpname
.do end
compiler.
.if '&lang' eq 'C' or '&lang' eq 'C/C++' .do begin
.if '&arch' eq '16-bit' .do begin
.code begin
.387
                PUBLIC  main_
                EXTRN   __STK:BYTE
                EXTRN   printf_:BYTE
                EXTRN   ___wcpp_3_data_init_fs_root_:BYTE
                EXTRN   _small_code_:BYTE
                EXTRN   _cstart_:BYTE
DGROUP          GROUP   CONST,CONST2,_DATA,_BSS
_TEXT           SEGMENT WORD PUBLIC USE16 'CODE'
                ASSUME CS:_TEXT, DS:DGROUP, SS:DGROUP
main_:
    MOV       AX,0x00000004
    CALL      near ptr __STK
    MOV       AX,offset L$1
    PUSH      AX
    CALL      near ptr printf_
    ADD       SP,0x00000002
    XOR       AX,AX
    RET
_TEXT           ENDS
.code break
CONST           SEGMENT WORD PUBLIC USE16 'DATA'
L$1:
                DB      0x48, 0x65, 0x6c, 0x6c, 0x6f, 0x20, 0x77, 0x6f
                DB      0x72, 0x6c, 0x64, 0x0a, 0x00

CONST           ENDS
CONST2          SEGMENT WORD PUBLIC USE16 'DATA'
CONST2          ENDS
_DATA           SEGMENT WORD PUBLIC USE16 'DATA'
_DATA           ENDS
_BSS            SEGMENT WORD PUBLIC USE16 'BSS'
_BSS            ENDS

                END
.code end
.do end
.if '&arch' eq '32-bit' .do begin
.np
The following is a disassembly of 80x86 code.
.code begin
~.387
~.386p
                PUBLIC  main_
                EXTRN   __CHK:BYTE
                EXTRN   printf_:BYTE
                EXTRN   ___wcpp_3_data_init_fs_root_:BYTE
                EXTRN   _cstart_:BYTE
DGROUP          GROUP   CONST,CONST2,_DATA,_BSS
_TEXT           SEGMENT DWORD PUBLIC USE32 'CODE'
                ASSUME CS:_TEXT, DS:DGROUP, SS:DGROUP
main_:
    PUSH      0x00000008
    CALL      near ptr __CHK
    PUSH      offset L$1
    CALL      near ptr printf_
    ADD       ESP,0x00000004
    XOR       EAX,EAX
    RET
_TEXT           ENDS
.code break
CONST           SEGMENT DWORD PUBLIC USE32 'DATA'
L$1:
                DB      0x48, 0x65, 0x6c, 0x6c, 0x6f, 0x20, 0x77, 0x6f
                DB      0x72, 0x6c, 0x64, 0x0a, 0x00

CONST           ENDS
CONST2          SEGMENT DWORD PUBLIC USE32 'DATA'
CONST2          ENDS
_DATA           SEGMENT DWORD PUBLIC USE32 'DATA'
_DATA           ENDS
_BSS            SEGMENT DWORD PUBLIC USE32 'BSS'
_BSS            ENDS

                END
.code end
.np
The following is a disassembly of Alpha AXP code.
.code begin
~.globl          main
~.extrn          printf
~.extrn          _cstart_
~.new_section .text, "crx4"
main:
    LDA           $SP,-0x10($SP)
    STQ           $RA,($SP)
    LDAH          $A0,h^`L$0`($ZERO)
    LDA           $A0,l^`L$0`($A0)
    SEXTL         $A0,$A0
    BSR           $RA,j^printf
    MOV           0x00000000,$V0
    LDQ           $RA,($SP)
    LDA           $SP,0x10($SP)
    RET           $ZERO,($RA),0x00000001
.code break
~.new_section .const, "drw4"
`L$0`:
                .asciiz "Hello world\n"
                .byte   0x00, 0x00, 0x00



~.new_section .pdata, "dr2"

                //  0000                Procedure descriptor for main
                .long   main                    //  BeginAddress      : 0
                .long   main+0x28               //  EndAddress        : 40
                .long   00000000                //  ExceptionHandler  : 0
                .long   00000000                //  HandlerData       : 0
                .long   main+0x8                //  PrologEnd         : 8

~.new_section .drectve, "iRr0"
                .asciiz "-defaultlib:clib -defaultlib:plib -defaultlib:math "

.code end
.do end
.do end
.if '&lang' eq 'FORTRAN 77' .do begin
.if '&arch' eq '16-bit' .do begin
.code begin
~.387
                PUBLIC  FMAIN
                EXTRN   `RT@IOWrite`:BYTE
                EXTRN   `RT@OutCHAR`:BYTE
                EXTRN   `RT@EndIO`:BYTE
                EXTRN   __init_error:BYTE
                EXTRN   __init_english:BYTE
                EXTRN   _cstart_:BYTE
DGROUP          GROUP   CONST,_DATA,_BSS
CONST           SEGMENT PARA PUBLIC USE16 'DATA'
L$1:
                DB      0x48, 0x65, 0x6c, 0x6c, 0x6f, 0x20, 0x77, 0x6f
                DB      0x72, 0x6c, 0x64

CONST           ENDS
.code break
_DATA           SEGMENT PARA PUBLIC USE16 'DATA'
L$2:
                DD      L$1
                DB      0x0b, 0x00

_DATA           ENDS
_BSS            SEGMENT PARA PUBLIC USE16 'BSS'
_BSS            ENDS

FMAIN_TEXT              SEGMENT BYTE PUBLIC USE16 'CODE'
                ASSUME CS:FMAIN_TEXT, DS:DGROUP, SS:DGROUP
FMAIN:
    PUSH      DX
    CALL      far ptr `RT@IOWrite`
    MOV       AX,offset L$2
    MOV       DX,SS
    CALL      far ptr `RT@OutCHAR`
    CALL      far ptr `RT@EndIO`
    POP       DX
    RETF
FMAIN_TEXT              ENDS
                END
.code end
.do end
.if '&arch' eq '32-bit' .do begin
.code begin
~.387
~.386p
                PUBLIC  FMAIN
                EXTRN   `RT@IOWrite`:BYTE
                EXTRN   `RT@OutCHAR`:BYTE
                EXTRN   `RT@EndIO`:BYTE
                EXTRN   __init_error:BYTE
                EXTRN   __init_english:BYTE
                EXTRN   __init_387_emulator:BYTE
                EXTRN   _cstart_:BYTE
DGROUP          GROUP   CONST,_DATA,_BSS
CONST           SEGMENT PARA PUBLIC USE32 'DATA'
L$1:
                DB      0x48, 0x65, 0x6c, 0x6c, 0x6f, 0x20, 0x77, 0x6f
                DB      0x72, 0x6c, 0x64

CONST           ENDS
.code break
_DATA           SEGMENT PARA PUBLIC USE32 'DATA'
L$2:
                DD      L$1
                DB      0x0b, 0x00, 0x00, 0x00

_DATA           ENDS
_BSS            SEGMENT PARA PUBLIC USE32 'BSS'
_BSS            ENDS

_TEXT           SEGMENT BYTE PUBLIC USE32 'CODE'
                ASSUME CS:_TEXT, DS:DGROUP, SS:DGROUP
FMAIN:
    CALL      near ptr `RT@IOWrite`
    MOV       EAX,offset L$2
    CALL      near ptr `RT@OutCHAR`
    JMP       near ptr `RT@EndIO`
_TEXT           ENDS
                END
.code end
.do end
.do end
