/****************************************************************************
*
*                            Open Watcom Project
*
*    Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
*
*  ========================================================================
*
*    This file contains Original Code and/or Modifications of Original
*    Code as defined in and that are subject to the Sybase Open Watcom
*    Public License version 1.0 (the 'License'). You may not use this file
*    except in compliance with the License. BY USING THIS FILE YOU AGREE TO
*    ALL TERMS AND CONDITIONS OF THE LICENSE. A copy of the License is
*    provided with the Original Code and Modifications, and is also
*    available at www.sybase.com/developer/opensource.
*
*    The Original Code and all software distributed under the License are
*    distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
*    EXPRESS OR IMPLIED, AND SYBASE AND ALL CONTRIBUTORS HEREBY DISCLAIM
*    ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF
*    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR
*    NON-INFRINGEMENT. Please see the License for the specific language
*    governing rights and limitations under the License.
*
*  ========================================================================
*
* Description:  Declares items used to smooth out the differences between
*               Open Watcom on DOS, OS2, and Windows on the one hand and 
*               Linux on the other.
*                   get_file_size()
*
****************************************************************************/

#ifndef DOWLINUX_H_INCLUDED
#define DOWLINUX_H_INCLUDED

#ifdef __LINUX__

#include <dirent.h>
#include <unistd.h>

#else /* DOS, OS/2, Windows */

#include <direct.h>

#endif /* __LINUX__ */

/* Function declarations */

#ifdef  __cplusplus
extern "C" {    /* Use "C" linkage when in C++ mode */
#endif

long get_file_size( struct dirent * );

#ifdef  __cplusplus
}   /* End of "C" linkage for C++ */
#endif

#endif  /* DOWLINUX_H_INCLUDED */
