/***************************************************************************
 * FILE: math.h/cmath (Math functions)
 *
 *                          Open Watcom Project
 *
 *    Copyright (c) 2002-2008 Open Watcom Contributors. All Rights Reserved.
 *    Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 *
 * Description: This header is part of the C/C++ standard library. It
 *              describes the math functions provided by those standards.
 ***************************************************************************/
#ifndef _MATH_H_INCLUDED
#define _MATH_H_INCLUDED

#if !defined(_ENABLE_AUTODEPEND)
  #pragma read_only_file;
#endif

#ifdef __cplusplus
#define _INCLUDED_FROM_MATH_H
#include <cmath>
#undef  _INCLUDED_FROM_MATH_H

// C99 functions in math.h
using std::acos;
using std::asin;
using std::atan;
using std::atan2;
using std::ceil;
using std::cos;
using std::cosh;
using std::exp;
using std::fabs;
using std::floor;
using std::fmod;
using std::frexp;
using std::ldexp;
using std::log;
using std::log10;
using std::modf;
using std::pow;
using std::sin;
using std::sinh;
using std::sqrt;
using std::tan;
using std::tanh;

#if !defined(NO_EXT_KEYS) /* extensions enabled */
// C99 functions in math.h that are currently considered extensions.
using std::acosh;
using std::asinh;
using std::atanh;
using std::hypot;
using std::log2;
#endif

#else /* __cplusplus not defined */


#ifndef _COMDEF_H_INCLUDED
 #include <_comdef.h>
#endif

#ifdef _M_IX86
#pragma pack( __push, 1 )
#else
#pragma pack( __push, 8 )
#endif

_WCRTLINK extern const double   *__get_HugeValue_ptr( void );
#if defined(__FUNCTION_DATA_ACCESS)
 #define _HugeValue             (*__get_HugeValue_ptr())
#elif defined(__SW_BR) || defined(_RTDLL)
  #define _HugeValue            _HugeValue_br
#endif
_WCRTDATA extern const double _WCDATA   _HugeValue;
#define HUGE_VAL                _HugeValue


/* Internal library helper routines */
_WMRTLINK extern int _FSClass( float __x );
_WMRTLINK extern int _FDClass( double __x );
_WMRTLINK extern int _FLClass( long double __x );
_WMRTLINK extern int _FSSign( float __x );
_WMRTLINK extern int _FDSign( double __x );
_WMRTLINK extern int _FLSign( long double __x );

/* Floating-point classification macros */
#define FP_ZERO         0
#define FP_SUBNORMAL    1
#define FP_NORMAL       2
#define FP_NAN          3
#define FP_INFINITE     4

#define fpclassify(x)                               \
    ((sizeof(x) == sizeof(float)) ? _FSClass(x) :   \
    (sizeof(x) == sizeof(double)) ? _FDClass(x) :   \
                                    _FLClass(x))

#define isfinite(x)     (fpclassify(x) <= FP_NORMAL)
#define isinf(x)        (fpclassify(x) == FP_INFINITE)
#define isnan(x)        (fpclassify(x) == FP_NAN)
#define isnormal(x)     (fpclassify(x) == FP_NORMAL)

#define signbit(x)                                  \
    ((sizeof(x) == sizeof(float)) ? _FSSign(x) :    \
    (sizeof(x) == sizeof(double)) ? _FDSign(x) :    \
                                    _FLSign(x))

/* Floating-point Infinity and NaN constants */
_WMRTDATA extern const float    __f_infinity;
_WMRTDATA extern const float    __f_posqnan;

#define INFINITY   __f_infinity
#define NAN        __f_posqnan


_WMRTLINK extern double ceil( double __x );
_WMRTLINK extern double floor( double __x );
#if defined(_M_IX86) && 0
#pragma aux ceil  parm nomemory modify nomemory;
#pragma aux floor parm nomemory modify nomemory;
#endif
_WMRTLINK extern double frexp( double __value, int *__exp );
_WMRTLINK extern double ldexp( double __x, int __exp );
_WMRTLINK extern double modf( double __value, double *__iptr );

_WMIRTLINK extern double acos( double __x );
_WMIRTLINK extern double asin( double __x );
_WMIRTLINK extern double atan( double __x );
_WMIRTLINK extern double atan2( double __y, double __x );
_WMIRTLINK extern double cos( double __x );
_WMIRTLINK extern double cosh( double __x );
_WMIRTLINK extern double exp( double __x );
_WMIRTLINK extern double fabs( double __x );
_WMIRTLINK extern double fmod( double __x, double __y );
_WMIRTLINK extern double log( double __x );
_WMIRTLINK extern double log10( double __x );
_WMIRTLINK extern double pow( double __x, double __y );
_WMIRTLINK extern double sin( double __x );
_WMIRTLINK extern double sinh( double __x );
_WMIRTLINK extern double sqrt( double __x );
_WMIRTLINK extern double tan( double __x );
_WMIRTLINK extern double tanh( double __x );

/* non-ANSI */
#if !defined(NO_EXT_KEYS) /* extensions enabled */

struct _complex {
        double  x;
        double  y;
};

struct complex {
        double  x;
        double  y;
};

_WMRTLINK extern double acosh( double __x );
_WMRTLINK extern double asinh( double __x );
_WMRTLINK extern double atanh( double __x );
_WMRTLINK extern double hypot( double __x, double __y );
_WMRTLINK extern double log2( double __x );

_WMRTLINK extern double cabs( struct _complex );
_WMRTLINK extern double j0( double __x );
_WMRTLINK extern double j1( double __x );
_WMRTLINK extern double jn( int __n, double __x );
_WMRTLINK extern double y0( double __x );
_WMRTLINK extern double y1( double __x );
_WMRTLINK extern double yn( int __n, double __x );

/* The following struct is used to record errors detected in the math library.
 * matherr is called with a pointer to this struct for possible error recovery.
 */

struct _exception {
        int     type;           /* type of error, see below */
        char    *name;          /* name of math function */
        double  arg1;           /* value of first argument to function */
        double  arg2;           /* second argument (if indicated) */
        double  retval;         /* default return value */
};

struct  exception {
        int     type;           /* type of error, see below */
        char    *name;          /* name of math function */
        double  arg1;           /* value of first argument to function */
        double  arg2;           /* second argument (if indicated) */
        double  retval;         /* default return value */
};

#define DOMAIN          1       /* argument domain error */
#define SING            2       /* argument singularity  */
#define OVERFLOW        3       /* overflow range error  */
#define UNDERFLOW       4       /* underflow range error */
#define TLOSS           5       /* total loss of significance */
#define PLOSS           6       /* partial loss of significance */

_WMRTLINK extern int    matherr( struct _exception * );
_WMRTLINK extern double _matherr( struct _exception * );
_WMRTLINK extern void   _set_matherr( int (*rtn)( struct _exception * ) );

_WCRTLINK extern int _dieeetomsbin( double *__x, double *__y );
_WCRTLINK extern int _dmsbintoieee( double *__x, double *__y );
_WCRTLINK extern int _fieeetomsbin( float *__x, float *__y );
_WCRTLINK extern int _fmsbintoieee( float *__x, float *__y );

#endif /* EXTENSIONS */

#if !defined( __NO_MATH_OPS ) && defined(_M_IX86)
/*
    Defining the __NO_MATH_OPS macro will stop the compiler from
    recognizing the following functions as intrinsic operators.
*/
#pragma intrinsic(log,cos,sin,tan,sqrt,fabs,pow,atan2,fmod)
#pragma intrinsic(acos,asin,atan,cosh,exp,log10,sinh,tanh)
#endif

#pragma pack( __pop )

#endif /* __cplusplus not defined */

#endif

