
;--- sample for 16-bit DOS debugging with WD
;--- to get around a few quirks of WD, make sure
;--- to take care of the "DGROUP alignment" (BEGDATA)
;--- and "procedure offset 0000" issues.

;--- Issue 1 ( DGROUP alignment )
;--- The BEGDATA segment makes DGROUP align at a paragraph.
;--- Without this, global variables will only be displayed correctly
;--- if the (last) code segment happens to end at offset 0xF or 0x0.
;--- Also, note that the segment definition must be located BEFORE
;--- the .MODEL directive - this ensures that BEGDATA will be the first
;--- segment in DGROUP

BEGDATA segment para public 'DATA'
BEGDATA ends
DGROUP group BEGDATA

    .model small
    option casemap:none
    .dosseg
    .stack 1024

;--- here are a few (useless) type definitions,
;--- just to demonstrate the debugger's capabilities
;--- when contents of local variables are to be displayed

PSTR typedef ptr BYTE

S1 struct
f1  dw 2 dup (?)
f2  PSTR 2 dup (?)
struct a
sf1 dw ?
sf2 dw ?
ends
S1 ends

    .data

text db "ASM$"

    .code

;--- Issue 2 ( procedure offset 0000 )
;--- make sure no proc starts at offset 0 - else its locals won't be displayed
    nop
    nop

main proc c argc:word, argv:ptr ptr

local pText:PSTR
local szText[32]:BYTE
local s1:S1

    mov si,offset text
    lea di,szText
    push ss
    pop es
    mov cx,sizeof text
    rep movsb
    mov s1.a.sf1,1
    mov s1.a.sf2,2
    lea ax, szText
    mov pText, ax
    mov dx, pText
    mov ah, 09h
    int 21h
    ret
main endp

start:
    mov ax, @data
    mov ds, ax
    mov bx, ss
    sub bx, ax
    mov cl, 4
    shl bx, cl
    mov ss, ax
    add sp, bx
    invoke main, 0, 0
    mov ax, 4c00h
    int 21h

    end start
