/****************************************************************************
*
*                            Open Watcom Project
*
*    Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
*
*  ========================================================================
*
*    This file contains Original Code and/or Modifications of Original
*    Code as defined in and that are subject to the Sybase Open Watcom
*    Public License version 1.0 (the 'License'). You may not use this file
*    except in compliance with the License. BY USING THIS FILE YOU AGREE TO
*    ALL TERMS AND CONDITIONS OF THE LICENSE. A copy of the License is
*    provided with the Original Code and Modifications, and is also
*    available at www.sybase.com/developer/opensource.
*
*    The Original Code and all software distributed under the License are
*    distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
*    EXPRESS OR IMPLIED, AND SYBASE AND ALL CONTRIBUTORS HEREBY DISCLAIM
*    ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF
*    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR
*    NON-INFRINGEMENT. Please see the License for the specific language
*    governing rights and limitations under the License.
*
*  ========================================================================
*
* Description:  Defines the dynamic template library needed for VIW.
*
****************************************************************************/


#ifndef DYNTPL_H
#define DYNTPL_H

#include <wpitypes.h>

/* The dynamic templates must be defined in the dialog, with the visible
   flag off for all controls in the dynamic templates. The data control
   for the dynamic templates is an array of 'dyn_tpl_static' and
   'dyn_tpl_dim' structures. This control structure is generated by
   'PARSEDYN.EXE'. A dynamic template defines a set of controls as
   follows:
        dyn_tpl := <range_ctl>* '0' <ctl>* '0'
        range_ctl := <ctl> <ctl>
        ctl := {an int defining a control id}
*/

typedef enum {
    DYN_TPL_STATIC, // a static template
    DYN_TPL_DIM     // a dim template
} dyn_tpl_type;

/////////////////////////////////////////////////////////////////////////////////
// A static template. What does this do? (MISSING!!!)

typedef struct {
    dyn_tpl_type        type;           // type of dynamic template
    BOOL                use;            // dyn tpls can be turned off
    int                 (*which_tpl)( HWND );// rtn to see which template to use
} dyn_static_def;

typedef struct {
    dyn_static_def      info;
    int                 dyn_tpls[1];    // array of above tpls: ends in '0'
} dyn_tpl_static;

/////////////////////////////////////////////////////////////////////////////////
// A dim template

typedef enum {
    DYN_VISIBLE,    // show the control, make it useable
    DYN_DIM,        // show the control, make it unuseable
    DYN_INVISIBLE   // hide the control          // return on check to permamently disable tpl
} dyn_dim_type;

typedef struct {
    dyn_tpl_type        type;           // type of dynamic template
    BOOL                use;            // dyn tpls can be turned off
    dyn_dim_type        state;          // current state of dyn tpl
    dyn_dim_type        (*tpl_state)( HWND, BOOL );// rtn to see the next state
    BOOL                (*tpl_check)( WPI_PARAM1, WPI_PARAM2, HWND ); // check if tpl changed
} dyn_dim_def;

typedef struct {
    dyn_dim_def         info;
    int                 dyn_tpl[1];     // the dyn tpl to toggle states (ends with -1)
} dyn_tpl_dim;

/////////////////////////////////////////////////////////////////////////////////
// The dynamic template dialog struct

typedef struct {
    int                 num_tpls;       // how many dyn tpls for this dialog
    dyn_tpl_dim         tpls[1];        // array of 'dim' and 'static' tpls.
                                        // The array is stored as a continuous block in
                                        // memory filled with dyn_tpl_dim and dyn_tpl_static
                                        // objects (which have unknown length due to the
                                        // dyn_tpl/dyn_tpls arrays).
} dyn_tpl_dlg;

/////////////////////////////////////////////////////////////////////////////////
// Routines to use a dynamic template with a dialog

// MISSING!!! (???)
BOOL dyn_tpl_button_check( int ctl, WPI_PARAM1 wParam, WPI_PARAM2 lParam );

// process changes
void dyn_tpl_process( void *dyn, HWND dlg_hld, WPI_PARAM1 parm1, WPI_PARAM2 parm2 );

// initialize a dialog with a dynamic template
void dyn_tpl_init( void *dyn, HWND dlg_hld );

// MISSING!!! (???)
void dyn_tpl_change( int *tpl, dyn_dim_type type, HWND dlg_hld );

// MISSING!!! (free the dynamic template?)
void dyn_tpl_free( void *dyn );

// MISSING!!! (create a copy of the dynamic template?)
void *dyn_tpl_copy( void *dyn );

#endif

