
		include objbase.inc

ifndef DIRECTINPUT_VERSION
DIRECTINPUT_VERSION equ 0700h
endif

externdef IID_IDirectInput:byte

LPVOID typedef ptr
LPDIRECTINPUT typedef ptr

protoEnumDevicesCallbackA typedef proto :DWORD, :DWORD
LPDIENUMDEVICESCALLBACKA typedef ptr protoEnumDevicesCallbackA

DINPUTVFT struct
pQueryInterface         dd ?  ; REFIID riid, LPVOID FAR * ppvObj
pAddRef                 dd ?
pRelease                dd ?
pCreateDevice			dd ?
pEnumDevices			dd ?
pGetDeviceStatus		dd ?
pRunControlPanel		dd ?
pInitialize				dd ?
DINPUTVFT ends

DINPDEVVFT struct
pQueryInterface         dd ?  ; REFIID riid, LPVOID FAR * ppvObj
pAddRef                 dd ?
pRelease                dd ?
pGetCapabilities		dd ?  ; :LPDIDEVCAPS
pEnumObjects			dd ?  ; :LPDIENUMDEVICEOBJECTSCALLBACKA, :LPVOID, :DWORD
pGetProperty			dd ?  ; :REFGUID, :LPDIPROPHEADER
pSetProperty			dd ?  ; :REFGUID, :LPCDIPROPHEADER
pAcquire				dd ? 
pUnacquire				dd ? 
pGetDeviceState			dd ?  ; :DWORD, :LPVOID
pGetDeviceData			dd ?  ; :DWORD, :LPDIDEVICEOBJECTDATA, :LPDWORD, :DWORD
pSetDataFormat			dd ?  ; :LPCDIDATAFORMAT
pSetEventNotification	dd ?  ; :HANDLE
pSetCooperativeLevel	dd ?  ; :HWND, :DWORD
pGetObjectInfo			dd ?  ; :LPDIDEVICEOBJECTINSTANCEA, :DWORD, :DWORD
pGetDeviceInfo			dd ?  ; :LPDIDEVICEINSTANCEA
pRunControlPanel		dd ?  ; :HWND, :DWORD
pInitialize				dd ?  ; :HINSTANCE, :DWORD, :REFGUID
DINPDEVVFT ends

LPDIRECTINPUTEFFECT typedef ptr IDirectInputEffect

proto_LPDIENUMCREATEDEFFECTOBJECTSCALLBACK typedef proto stdcall :LPDIRECTINPUTEFFECT,:LPVOID
LPDIENUMCREATEDEFFECTOBJECTSCALLBACK typedef ptr proto_LPDIENUMCREATEDEFFECTOBJECTSCALLBACK

DIEFFESCAPE	struct
dwSize			DWORD	?
dwCommand		DWORD	?
lpvInBuffer		LPVOID	?
cbInBuffer		DWORD	?
lpvOutBuffer	LPVOID	?
cbOutBuffer		DWORD	?
DIEFFESCAPE	ends

LPDIEFFESCAPE typedef ptr DIEFFESCAPE

DIDEVICEOBJECTDATA	struct
dwOfs		DWORD	?
dwData		DWORD	?
dwTimeStamp	DWORD	?
dwSequence	DWORD	?
if (DIRECTINPUT_VERSION ge 0800h)
uAppData	UINT_PTR	?
endif 
DIDEVICEOBJECTDATA	ends

LPDIDEVICEOBJECTDATA typedef ptr DIDEVICEOBJECTDATA
LPCDIDEVICEOBJECTDATA typedef ptr DIDEVICEOBJECTDATA

DIENUM_STOP		EQU	0
DIENUM_CONTINUE	EQU	1

DINPDEV2VFT struct
		DINPDEVVFT <>
pCreateEffect				dd ? ; :REFGUID, :LPCDIEFFECT, :ptr LPDIRECTINPUTEFFECT, :LPUNKNOWN
pEnumEffects				dd ? ; :LPDIENUMEFFECTSCALLBACKA, :LPVOID, :DWORD
pGetEffectInfo				dd ? ; :LPDIEFFECTINFOA, :REFGUID
pGetForceFeedbackState		dd ? ; :LPDWORD
pSendForceFeedbackCommand	dd ? ; :DWORD
pEnumCreatedEffectObjects	dd ? ; :LPDIENUMCREATEDEFFECTOBJECTSCALLBACK, :LPVOID, :DWORD
pEscape 					dd ? ; :LPDIEFFESCAPE
pPoll						dd ? ; 
pSendDeviceData				dd ? ; :DWORD, :LPCDIDEVICEOBJECTDATA, :LPDWORD, :DWORD
DINPDEV2VFT ends


MAKE_HRESULT	macro sev,fac,code
	exitm <sev * 80000000h + fac * 10000h + code>
	endm

DIDEVCAPS	struct
dwSize		DWORD	?
dwFlags		DWORD	?
dwDevType	DWORD	?
dwAxes		DWORD	?
dwButtons	DWORD	?
dwPOVs		DWORD	?
if 0; (DIRECTINPUT_VERSION ge 0500h)
dwFFSamplePeriod		DWORD	?
dwFFMinTimeResolution	DWORD	?
dwFirmwareRevision		DWORD	?
dwHardwareRevision		DWORD	?
dwFFDriverVersion		DWORD	?
endif 
DIDEVCAPS	ends

LPDIDEVCAPS typedef ptr DIDEVCAPS

DIPROPHEADER	struct
dwSize			DWORD	?
dwHeaderSize	DWORD	?
dwObj			DWORD	?
dwHow			DWORD	?
DIPROPHEADER	ends

LPDIPROPHEADER typedef ptr DIPROPHEADER
LPCDIPROPHEADER typedef ptr DIPROPHEADER

DIPROPDWORD	struct
diph	DIPROPHEADER	<>
dwData	DWORD	?
DIPROPDWORD	ends

LPDIPROPDWORD typedef ptr DIPROPDWORD

DIDEVICEOBJECTDATA	struct
dwOfs		DWORD	?
dwData		DWORD	?
dwTimeStamp	DWORD	?
dwSequence	DWORD	?
if (DIRECTINPUT_VERSION ge 0800h)
uAppData	UINT_PTR	?
endif 
DIDEVICEOBJECTDATA	ends

LPDIDEVICEOBJECTDATA typedef ptr DIDEVICEOBJECTDATA

DIOBJECTDATAFORMAT	struct
pguid	DWORD	?
dwOfs	DWORD	?
dwType	DWORD	?
dwFlags	DWORD	?
DIOBJECTDATAFORMAT	ends

LPDIOBJECTDATAFORMAT typedef ptr DIOBJECTDATAFORMAT

DIDATAFORMAT	struct
dwSize		DWORD	?
dwObjSize	DWORD	?
dwFlags		DWORD	?
dwDataSize	DWORD	?
dwNumObjs	DWORD	?
rgodf		LPDIOBJECTDATAFORMAT	?
DIDATAFORMAT	ends

LPDIDATAFORMAT typedef ptr DIDATAFORMAT
LPCDIDATAFORMAT typedef ptr DIDATAFORMAT

DIDEVICEOBJECTINSTANCEA	struct
dwSize		DWORD	?
guidType	GUID	<>
dwOfs		DWORD	?
dwType		DWORD	?
dwFlags		DWORD	?
tszName		SBYTE MAX_PATH dup (?)
if (DIRECTINPUT_VERSION ge 0500h)
dwFFMaxForce		DWORD	?
dwFFForceResolution	DWORD	?
wCollectionNumber	WORD	?
wDesignatorIndex	WORD	?
wUsagePage			WORD	?
wUsage				WORD	?
dwDimension			DWORD	?
wExponent			WORD	?
wReportId			WORD	?
endif 
DIDEVICEOBJECTINSTANCEA	ends

LPDIDEVICEOBJECTINSTANCEA typedef ptr DIDEVICEOBJECTINSTANCEA
LPCDIDEVICEOBJECTINSTANCEA typedef ptr DIDEVICEOBJECTINSTANCEA

DIDEVICEINSTANCEA	struct
dwSize			DWORD	?
guidInstance	GUID	<>
guidProduct		GUID	<>
dwDevType		DWORD	?
tszInstanceName	SBYTE MAX_PATH dup (?)
tszProductName	SBYTE MAX_PATH dup (?)
if (DIRECTINPUT_VERSION ge 0500h)
guidFFDriver	GUID	<>
wUsagePage		WORD	?
wUsage			WORD	?
endif 
DIDEVICEINSTANCEA	ends

LPDIDEVICEINSTANCEA typedef ptr DIDEVICEINSTANCEA

proto_LPDIENUMDEVICEOBJECTSCALLBACKA typedef proto stdcall :LPCDIDEVICEOBJECTINSTANCEA,:LPVOID
LPDIENUMDEVICEOBJECTSCALLBACKA typedef ptr proto_LPDIENUMDEVICEOBJECTSCALLBACKA

DIEFFECTINFOA	struct
dwSize			DWORD	?
guid			GUID	<>
dwEffType		DWORD	?
dwStaticParams	DWORD	?
dwDynamicParams	DWORD	?
tszName			SBYTE MAX_PATH dup (?)
DIEFFECTINFOA	ends

LPDIEFFECTINFOA typedef ptr DIEFFECTINFOA
LPCDIEFFECTINFOA typedef ptr DIEFFECTINFOA

proto_LPDIENUMEFFECTSCALLBACKA typedef proto stdcall :LPCDIEFFECTINFOA,:LPVOID
LPDIENUMEFFECTSCALLBACKA typedef ptr proto_LPDIENUMEFFECTSCALLBACKA

DIENVELOPE	struct
dwSize			DWORD	?
dwAttackLevel	DWORD	?
dwAttackTime	DWORD	?
dwFadeLevel		DWORD	?
dwFadeTime		DWORD	?
DIENVELOPE	ends

LPDIENVELOPE typedef ptr DIENVELOPE
LPCDIENVELOPE typedef ptr DIENVELOPE

LPDWORD typedef ptr DWORD
LPLONG	typedef ptr SDWORD

DIEFFECT	struct
dwSize			DWORD	?
dwFlags			DWORD	?
dwDuration		DWORD	?
dwSamplePeriod	DWORD	?
dwGain			DWORD	?
dwTriggerButton	DWORD	?
dwTriggerRepeatInterval	DWORD	?
cAxes			DWORD	?
rgdwAxes		LPDWORD	?
rglDirection	LPLONG	?
lpEnvelope		LPDIENVELOPE	?
cbTypeSpecificParams	DWORD	?
lpvTypeSpecificParams	LPVOID	?
if 0;(DIRECTINPUT_VERSION ge 0600h)
dwStartDelay	DWORD	?
endif 
DIEFFECT	ends

LPDIEFFECT typedef ptr DIEFFECT
LPCDIEFFECT typedef ptr DIEFFECT

;--- flags in dwType of DIOBJECTDATAFORMAT (low byte)
;--- byte 1+2 contain the object instance (key number for kbd)

DIDFT_ALL		EQU	00000000h
DIDFT_RELAXIS	EQU	00000001h
DIDFT_ABSAXIS	EQU	00000002h
DIDFT_AXIS		EQU	00000003h
DIDFT_PSHBUTTON	EQU	00000004h
DIDFT_TGLBUTTON	EQU	00000008h
DIDFT_BUTTON	EQU	0000000Ch

DIMOUSESTATE	struct
lX	SDWORD	?
lY	SDWORD	?
lZ	SDWORD	?
rgbButtons	BYTE 4 dup (?)
DIMOUSESTATE	ends

DIMOFS_X	EQU	<DIMOUSESTATE.lX>
DIMOFS_Y	EQU	<DIMOUSESTATE.lY>
DIMOFS_Z	EQU	<DIMOUSESTATE.lZ>
DIMOFS_BUTTON0	EQU	(DIMOUSESTATE.rgbButtons + 0)
DIMOFS_BUTTON1	EQU	(DIMOUSESTATE.rgbButtons + 1)
DIMOFS_BUTTON2	EQU	(DIMOUSESTATE.rgbButtons + 2)
DIMOFS_BUTTON3	EQU	(DIMOUSESTATE.rgbButtons + 3)



;--- flags SetCooperativeLevel

DISCL_EXCLUSIVE		EQU	00000001h
DISCL_NONEXCLUSIVE	EQU	00000002h
DISCL_FOREGROUND	EQU	00000004h
DISCL_BACKGROUND	EQU	00000008h
DISCL_NOWINKEY		EQU	00000010h

MAKEDIPROP macro prop
	exitm <( prop ) >
	endm

DIPROP_BUFFERSIZE	EQU	<MAKEDIPROP ( 1 )>
DIPROP_AXISMODE		EQU	<MAKEDIPROP ( 2 )>
DIPROP_GRANULARITY	EQU	<MAKEDIPROP ( 3 )>
DIPROP_RANGE		EQU	<MAKEDIPROP ( 4 )>
DIPROP_DEADZONE		EQU	<MAKEDIPROP ( 5 )>
DIPROP_SATURATION	EQU	<MAKEDIPROP ( 6 )>
DIPROP_FFGAIN		EQU	<MAKEDIPROP ( 7 )>
DIPROP_FFLOAD		EQU	<MAKEDIPROP ( 8 )>
DIPROP_AUTOCENTER	EQU	<MAKEDIPROP ( 9 )>

DIPROPAXISMODE_ABS	EQU	0
DIPROPAXISMODE_REL	EQU	1

DIDF_ABSAXIS	EQU	00000001h
DIDF_RELAXIS	EQU	00000002h

DIDEVTYPE_DEVICE	EQU	1
DIDEVTYPE_MOUSE		EQU	2
DIDEVTYPE_KEYBOARD	EQU	3
DIDEVTYPE_JOYSTICK	EQU	4

if DIRECTINPUT_VERSION le 700h
DIDEVTYPEMOUSE_UNKNOWN		EQU	1
DIDEVTYPEMOUSE_TRADITIONAL	EQU	2
DIDEVTYPEMOUSE_FINGERSTICK	EQU	3
DIDEVTYPEMOUSE_TOUCHPAD		EQU	4
DIDEVTYPEMOUSE_TRACKBALL	EQU	5
DIDEVTYPEKEYBOARD_UNKNOWN	EQU	0
DIDEVTYPEKEYBOARD_PCXT		EQU	1
DIDEVTYPEKEYBOARD_OLIVETTI	EQU	2
DIDEVTYPEKEYBOARD_PCAT		EQU	3
DIDEVTYPEKEYBOARD_PCENH		EQU	4
DIDEVTYPEKEYBOARD_NOKIA1050	EQU	5
DIDEVTYPEKEYBOARD_NOKIA9140	EQU	6
DIDEVTYPEKEYBOARD_NEC98		EQU	7
DIDEVTYPEKEYBOARD_NEC98LAPTOP	EQU	8
DIDEVTYPEKEYBOARD_NEC98106	EQU	9
DIDEVTYPEKEYBOARD_JAPAN106	EQU	10
DIDEVTYPEKEYBOARD_JAPANAX	EQU	11
DIDEVTYPEKEYBOARD_J3100		EQU	12
DIDEVTYPEJOYSTICK_UNKNOWN	EQU	1
DIDEVTYPEJOYSTICK_TRADITIONAL	EQU	2
DIDEVTYPEJOYSTICK_FLIGHTSTICK	EQU	3
DIDEVTYPEJOYSTICK_GAMEPAD	EQU	4
DIDEVTYPEJOYSTICK_RUDDER	EQU	5
DIDEVTYPEJOYSTICK_WHEEL		EQU	6
DIDEVTYPEJOYSTICK_HEADTRACKER	EQU	7
endif

DIDC_ATTACHED			EQU	00000001h
DIDC_POLLEDDEVICE		EQU	00000002h
DIDC_EMULATED			EQU	00000004h
DIDC_POLLEDDATAFORMAT	EQU	00000008h
if 1;(DIRECTINPUT_VERSION ge 0500h)
DIDC_FORCEFEEDBACK		EQU	00000100h
DIDC_FFATTACK			EQU	00000200h
DIDC_FFFADE				EQU	00000400h
DIDC_SATURATION			EQU	00000800h
DIDC_POSNEGCOEFFICIENTS	EQU	00001000h
DIDC_POSNEGSATURATION	EQU	00002000h
DIDC_DEADBAND			EQU	00004000h
endif 
DIDC_STARTDELAY			EQU	00008000h
if 0;(DIRECTINPUT_VERSION ge 050ah)
DIDC_ALIAS				EQU	00010000h
DIDC_PHANTOM			EQU	00020000h
endif 
if 0;(DIRECTINPUT_VERSION ge 0800h)
DIDC_HIDDEN				EQU	00040000h
endif 

DI_OK				EQU	<S_OK>
DI_NOTATTACHED		EQU	<S_FALSE>
DI_BUFFEROVERFLOW	EQU	<S_FALSE>
DI_PROPNOEFFECT		EQU	<S_FALSE>
DI_NOEFFECT			EQU	<S_FALSE>

DIERR_OLDDIRECTINPUTVERSION	EQU	<MAKE_HRESULT ( SEVERITY_ERROR , FACILITY_WIN32 , ERROR_OLD_WIN_VERSION )>
DIERR_BETADIRECTINPUTVERSION	EQU	<MAKE_HRESULT ( SEVERITY_ERROR , FACILITY_WIN32 , ERROR_RMODE_APP )>
DIERR_BADDRIVERVER		EQU	<MAKE_HRESULT ( SEVERITY_ERROR , FACILITY_WIN32 , ERROR_BAD_DRIVER_LEVEL )>
DIERR_DEVICENOTREG		EQU	<REGDB_E_CLASSNOTREG>
DIERR_NOTFOUND			EQU	<MAKE_HRESULT ( SEVERITY_ERROR , FACILITY_WIN32 , ERROR_FILE_NOT_FOUND )>
DIERR_OBJECTNOTFOUND	EQU	<MAKE_HRESULT ( SEVERITY_ERROR , FACILITY_WIN32 , ERROR_FILE_NOT_FOUND )>
DIERR_INVALIDPARAM		EQU	<E_INVALIDARG>
DIERR_NOINTERFACE		EQU	80004002h
DIERR_GENERIC			EQU	<E_FAIL>
DIERR_OUTOFMEMORY		EQU	<E_OUTOFMEMORY>
DIERR_UNSUPPORTED		EQU	<E_NOTIMPL>
DIERR_NOTINITIALIZED	EQU	<MAKE_HRESULT ( SEVERITY_ERROR , FACILITY_WIN32 , ERROR_NOT_READY )>
DIERR_ALREADYINITIALIZED	EQU	<MAKE_HRESULT ( SEVERITY_ERROR , FACILITY_WIN32 , ERROR_ALREADY_INITIALIZED )>
DIERR_NOAGGREGATION		EQU	<CLASS_E_NOAGGREGATION>
DIERR_OTHERAPPHASPRIO	EQU	<E_ACCESSDENIED>
DIERR_INPUTLOST			EQU	<MAKE_HRESULT ( SEVERITY_ERROR , FACILITY_WIN32 , ERROR_READ_FAULT )>
DIERR_ACQUIRED			EQU	<MAKE_HRESULT ( SEVERITY_ERROR , FACILITY_WIN32 , ERROR_BUSY )>
DIERR_NOTACQUIRED		EQU	<MAKE_HRESULT ( SEVERITY_ERROR , FACILITY_WIN32 , ERROR_INVALID_ACCESS )>
DIERR_READONLY			EQU	<E_ACCESSDENIED>
DIERR_HANDLEEXISTS		EQU	<E_ACCESSDENIED>
ifndef E_PENDING
E_PENDING	EQU	8000000Ah
endif 
DIERR_INSUFFICIENTPRIVS		EQU	80040200h
DIERR_DEVICEFULL			EQU	80040201h
DIERR_MOREDATA				EQU	80040202h
DIERR_NOTDOWNLOADED			EQU	80040203h
DIERR_HASEFFECTS			EQU	80040204h
DIERR_NOTEXCLUSIVEACQUIRED	EQU	80040205h
DIERR_INCOMPLETEEFFECT		EQU	80040206h
DIERR_NOTBUFFERED			EQU	80040207h
DIERR_EFFECTPLAYING			EQU	80040208h
DIERR_UNPLUGGED				EQU	80040209h
DIERR_REPORTFULL			EQU	8004020Ah
DIERR_MAPFILEFAIL			EQU	8004020Bh

DirectInputCreateA proto :ptr, :dword, :ptr DWORD, :ptr

