
		include objbase.inc

ifndef DIRECTSOUND_VERSION
DIRECTSOUND_VERSION	EQU	0700h
endif 

ifndef LPDWORD
LPDWORD typedef ptr DWORD
endif
ifndef LPLONG
LPLONG typedef ptr SDWORD
endif

externdef IID_IDirectSound:GUID

DirectSoundCreate proto :ptr, :ptr DWORD, :ptr

LPVOID typedef ptr

LPDIRECTSOUND typedef ptr IDirectSound
LPDIRECTSOUNDBUFFER typedef ptr IDirectSoundBuffer

DSCAPS	struct 
dwSize							DWORD	?
dwFlags							DWORD	?
dwMinSecondarySampleRate		DWORD	?
dwMaxSecondarySampleRate		DWORD	?
dwPrimaryBuffers				DWORD	?
dwMaxHwMixingAllBuffers			DWORD	?
dwMaxHwMixingStaticBuffers		DWORD	?
dwMaxHwMixingStreamingBuffers	DWORD	?
dwFreeHwMixingAllBuffers		DWORD	?
dwFreeHwMixingStaticBuffers		DWORD	?
dwFreeHwMixingStreamingBuffers	DWORD	?
dwMaxHw3DAllBuffers				DWORD	?
dwMaxHw3DStaticBuffers			DWORD	?
dwMaxHw3DStreamingBuffers		DWORD	?
dwFreeHw3DAllBuffers			DWORD	?
dwFreeHw3DStaticBuffers			DWORD	?
dwFreeHw3DStreamingBuffers		DWORD	?
dwTotalHwMemBytes				DWORD	?
dwFreeHwMemBytes				DWORD	?
dwMaxContigFreeHwMemBytes		DWORD	?
dwUnlockTransferRateHwBuffers	DWORD	?
dwPlayCpuOverheadSwBuffers		DWORD	?
dwReserved1						DWORD	?
dwReserved2						DWORD	?
DSCAPS	ends

LPDSCAPS typedef ptr DSCAPS

DSBCAPS	struct 
dwSize					DWORD	?
dwFlags					DWORD	?
dwBufferBytes			DWORD	?
dwUnlockTransferRate	DWORD	?
dwPlayCpuOverhead		DWORD	?
DSBCAPS	ends

LPDSBCAPS typedef ptr DSBCAPS

ifndef LPWAVEFORMATEX
LPWAVEFORMATEX typedef ptr WAVEFORMATEX
endif

DSBUFFERDESC	struct 
dwSize			DWORD	?
dwFlags			DWORD	?
dwBufferBytes	DWORD	?
dwReserved		DWORD	?
lpwfxFormat		LPWAVEFORMATEX	?
if DIRECTSOUND_VERSION ge 0700h
guid3DAlgorithm	GUID	<>
endif 
DSBUFFERDESC	ends

LPDSBUFFERDESC typedef ptr DSBUFFERDESC

DSBUFFERDESC1	struct 
dwSize			DWORD	?
dwFlags			DWORD	?
dwBufferBytes	DWORD	?
dwReserved		DWORD	?
lpwfxFormat		LPWAVEFORMATEX	?
DSBUFFERDESC1	ends

LPDSBUFFERDESC1 typedef ptr DSBUFFERDESC1

D3DVALUE typedef REAL4

ifndef D3DVECTOR_DEFINED
D3DVECTOR	struct 
x	REAL4	?
y	REAL4	?
z	REAL4	?
D3DVECTOR	ends
endif

DS3DBUFFER	struct
dwSize				DWORD		?
vPosition			D3DVECTOR	<>
vVelocity			D3DVECTOR	<>
dwInsideConeAngle	DWORD		?
dwOutsideConeAngle	DWORD		?
vConeOrientation	D3DVECTOR	<>
lConeOutsideVolume	SDWORD		?
flMinDistance		D3DVALUE	?
flMaxDistance		D3DVALUE	?
dwMode				DWORD		?
DS3DBUFFER	ends

LPDS3DBUFFER typedef ptr DS3DBUFFER

DSOBJVFT struct
pQueryInterface 		dd ?  ; REFIID riid, LPVOID FAR * ppvObj
pAddRef 				dd ?  ;
pRelease				dd ?  ;
pCreateSoundBuffer		dd ?  ; :LPCDSBUFFERDESC, :ptr LPDIRECTSOUNDBUFFER, :LPUNKNOWN
pGetCaps				dd ?  ; :LPDSCAPS
pDuplicateSoundBuffer	dd ?  ; :LPDIRECTSOUNDBUFFER, :ptr LPDIRECTSOUNDBUFFER
pSetCooperativeLevel	dd ?  ; :HWND, :DWORD
pCompact				dd ?  ;
pGetSpeakerConfig		dd ?  ; :LPDWORD
pSetSpeakerConfig		dd ?  ; :DWORD
pInitialize				dd ?  ; :LPCGUID
DSOBJVFT ends

DSBUFFERVFT struct
pQueryInterface 		dd ?  ; :REFIID, :LPVOID
pAddRef 				dd ?
pRelease				dd ?
pGetCaps				dd ?  ; :LPDSBCAPS
pGetCurrentPosition 	dd ?  ; :LPDWORD, :LPDWORD
pGetFormat  			dd ?  ; :LPWAVEFORMATEX, :DWORD, :LPDWORD
pGetVolume  			dd ?  ; :LPLONG
pGetPan 				dd ?  ; :LPLONG
pGetFrequency   		dd ?  ; :LPDWORD
pGetStatus				dd ?  ; :LPDWORD
pInitialize 			dd ?  ; :LPDIRECTSOUND, :LPCDSBUFFERDESC
pLock					dd ?  ; :DWORD, :DWORD, :ptr LPVOID, :LPDWORD, :ptr LPVOID, :LPDWORD, :DWORD
pPlay					dd ?  ; :DWORD, :DWORD, :DWORD
pSetCurrentPosition 	dd ?  ; :DWORD
pSetFormat				dd ?  ; :LPCWAVEFORMATEX
pSetVolume				dd ?  ; :SDWORD
pSetPan 				dd ?  ; :SDWORD
pSetFrequency			dd ?  ; :DWORD
pStop					dd ?  ;
pUnlock 				dd ?  ; :LPVOID, :DWORD, :LPVOID, :DWORD
pRestore				dd ?  ;
DSBUFFERVFT ends

DSNOTIFYVFT struct
pQueryInterface 		dd ?  ; :REFIID, :LPVOID
pAddRef 				dd ?
pRelease				dd ?
pSetNotificationPositions dd ?  ; :DWORD, :LPCDSBPOSITIONNOTIFY
DSNOTIFYVFT ends

_FACDS	EQU	878h

MAKE_HRESULT	macro sev,fac,code
	exitm <sev * 80000000h + fac * 10000h + code>
	endm

DS_OK	EQU	<S_OK>
DS_NO_VIRTUALIZATION	EQU	<MAKE_HRESULT ( 0 , _FACDS , 10 )>

MAKE_DSHRESULT macro code
	exitm <MAKE_HRESULT( 1 , _FACDS , code)>
	endm

DSERR_ALLOCATED			EQU	MAKE_DSHRESULT ( 10 )
DSERR_CONTROLUNAVAIL	EQU	MAKE_DSHRESULT ( 30 )
DSERR_INVALIDPARAM		EQU	<E_INVALIDARG>
DSERR_INVALIDCALL		EQU	MAKE_DSHRESULT ( 50 )
DSERR_GENERIC			EQU	<E_FAIL>
DSERR_PRIOLEVELNEEDED	EQU	MAKE_DSHRESULT ( 70 )
DSERR_OUTOFMEMORY		EQU	<E_OUTOFMEMORY>
DSERR_BADFORMAT			EQU	MAKE_DSHRESULT ( 100 )
DSERR_UNSUPPORTED		EQU	80004001h	;<E_NOTIMPL>
DSERR_NODRIVER			EQU	MAKE_DSHRESULT ( 120 )
DSERR_ALREADYINITIALIZED	EQU	MAKE_DSHRESULT ( 130 )
DSERR_NOAGGREGATION		EQU	<CLASS_E_NOAGGREGATION>
DSERR_BUFFERLOST		EQU	MAKE_DSHRESULT ( 150 )
DSERR_OTHERAPPHASPRIO	EQU	MAKE_DSHRESULT ( 160 )
DSERR_UNINITIALIZED		EQU	MAKE_DSHRESULT ( 170 )
DSERR_NOINTERFACE		EQU	<E_NOINTERFACE>
DSERR_ACCESSDENIED		EQU	<E_ACCESSDENIED>
DSERR_BUFFERTOOSMALL	EQU	MAKE_DSHRESULT ( 180 )
DSERR_DS8_REQUIRED		EQU	MAKE_DSHRESULT ( 190 )
DSERR_SENDLOOP			EQU	MAKE_DSHRESULT ( 200 )
DSERR_BADSENDBUFFERGUID	EQU	MAKE_DSHRESULT ( 210 )
DSERR_OBJECTNOTFOUND	EQU	MAKE_DSHRESULT ( 4449 )
DSERR_FXUNAVAILABLE		EQU	MAKE_DSHRESULT ( 220 )

DSCAPS_PRIMARYMONO		EQU	00000001h
DSCAPS_PRIMARYSTEREO	EQU	00000002h
DSCAPS_PRIMARY8BIT		EQU	00000004h
DSCAPS_PRIMARY16BIT		EQU	00000008h
DSCAPS_CONTINUOUSRATE	EQU	00000010h
DSCAPS_EMULDRIVER		EQU	00000020h
DSCAPS_CERTIFIED		EQU	00000040h
DSCAPS_SECONDARYMONO	EQU	00000100h
DSCAPS_SECONDARYSTEREO	EQU	00000200h
DSCAPS_SECONDARY8BIT	EQU	00000400h
DSCAPS_SECONDARY16BIT	EQU	00000800h

DSSCL_NORMAL		EQU	00000001h
DSSCL_PRIORITY		EQU	00000002h
DSSCL_EXCLUSIVE		EQU	00000003h
DSSCL_WRITEPRIMARY	EQU	00000004h

DSSPEAKER_DIRECTOUT	EQU	00000000h
DSSPEAKER_HEADPHONE	EQU	00000001h
DSSPEAKER_MONO		EQU	00000002h
DSSPEAKER_QUAD		EQU	00000003h
DSSPEAKER_STEREO	EQU	00000004h
DSSPEAKER_SURROUND	EQU	00000005h
DSSPEAKER_5POINT1	EQU	00000006h
DSSPEAKER_7POINT1	EQU	00000007h
DSSPEAKER_GEOMETRY_MIN	EQU	00000005h
DSSPEAKER_GEOMETRY_NARROW	EQU	0000000Ah
DSSPEAKER_GEOMETRY_WIDE	EQU	00000014h
DSSPEAKER_GEOMETRY_MAX	EQU	000000B4h

DSBCAPS_PRIMARYBUFFER	EQU	00000001h
DSBCAPS_STATIC			EQU	00000002h
DSBCAPS_LOCHARDWARE		EQU	00000004h
DSBCAPS_LOCSOFTWARE		EQU	00000008h
DSBCAPS_CTRL3D			EQU	00000010h
DSBCAPS_CTRLFREQUENCY	EQU	00000020h
DSBCAPS_CTRLPAN			EQU	00000040h
DSBCAPS_CTRLVOLUME		EQU	00000080h
DSBCAPS_CTRLPOSITIONNOTIFY	EQU	00000100h
DSBCAPS_CTRLFX			EQU	00000200h
DSBCAPS_STICKYFOCUS		EQU	00004000h
DSBCAPS_GLOBALFOCUS		EQU	00008000h
DSBCAPS_GETCURRENTPOSITION2	EQU	00010000h
DSBCAPS_MUTE3DATMAXDISTANCE	EQU	00020000h
DSBCAPS_LOCDEFER		EQU	00040000h

DSBPLAY_LOOPING					EQU	00000001h
DSBPLAY_LOCHARDWARE				EQU	00000002h
DSBPLAY_LOCSOFTWARE				EQU	00000004h
DSBPLAY_TERMINATEBY_TIME		EQU	00000008h
DSBPLAY_TERMINATEBY_DISTANCE	EQU	00000010h
DSBPLAY_TERMINATEBY_PRIORITY	EQU	00000020h

DSBLOCK_FROMWRITECURSOR	EQU	00000001h
DSBLOCK_ENTIREBUFFER	EQU	00000002h

DSBSTATUS_PLAYING		EQU	00000001h
DSBSTATUS_BUFFERLOST	EQU	00000002h
DSBSTATUS_LOOPING		EQU	00000004h
DSBSTATUS_LOCHARDWARE	EQU	00000008h
DSBSTATUS_LOCSOFTWARE	EQU	00000010h
DSBSTATUS_TERMINATED	EQU	00000020h
