/*
   Defines.h

   Windows32 API definitions

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Scott Christley <scottc@net-community.com>

   This file is part of the Windows32 API Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   If you are interested in a warranty or support for this source code,
   contact Scott Christley <scottc@net-community.com> for more information.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   -----------
   DAL 2003 - this file modified extensively for my compiler.  New
   definitionswnwn added as well.
*/
/* WARNING:  This file is automatically generated. */

#ifndef _GNU_H_WINDOWS32_DEFINES
#define _GNU_H_WINDOWS32_DEFINES

#ifndef WINVER
#define WINVER  (0x0400)
#endif
#ifndef _WIN32_WINDOWS
#define _WIN32_WINDOWS WINVER
#endif
#ifndef _WIN32_WINNT
#define _WIN32_WINNT WINVER
#endif
#ifndef _WIN32_IE
#define _WIN32_IE WINVER
#endif

#define TLS_OUT_OF_INDEXES ((DWORD)0xFFFFFFFF)
#define MAX_PATH        (260)
#define UNICODE_NULL ((WCHAR)0)
#define LF_FACESIZE     (32)
#define LF_FULLFACESIZE (64)
#define ELF_VENDOR_SIZE (4)
#define SECURITY_STATIC_TRACKING        (0)
#define SECURITY_DYNAMIC_TRACKING       (1)
#define MAX_DEFAULTCHAR (2)
#define MAX_LEADBYTES   (12)
#define EXCEPTION_MAXIMUM_PARAMETERS    (15)
#define CCHDEVICENAME   (32)
#define CCHFORMNAME     (32)
#define MENU_TEXT_LEN   (40)
#define MAX_LANA        (254)
#define NCBNAMSZ        (16)
#define NETBIOS_NAME_LEN        16
#define OFS_MAXPATHNAME (128)
#define MAX_TAB_STOPS   (32)
#define ANYSIZE_ARRAY   (1)
#define RAS_MaxCallbackNumber   (128)
#define RAS_MaxDeviceName       (128)
#define RAS_MaxDeviceType       (16)
#define RAS_MaxEntryName        (256)
#define RAS_MaxIpAddress        (15)
#define RAS_MaxIpxAddress       (21)
#define RAS_MaxPhoneNumber      (128)
#define UNLEN   256
#define PWLEN   256
#define CNLEN   15
#define DNLEN   CNLEN
/* Unsigned types max */
#define MAXDWORD         (0xFFFFFFFF)
#define MAXWORD          (0xFFFF)
#define MAXBYTE          (0xFF)
/* Signed types max/min */
#define MINCHAR          (0x80)
#define MAXCHAR          (0x7F)
#define MINSHORT         (0x8000)
#define MAXSHORT         (0x7FFF)
#define MINLONG          (0x80000000)
#define MAXLONG          (0x7FFFFFFF)

/* _llseek */
#define FILE_BEGIN      (0)
#define FILE_CURRENT    (1)
#define FILE_END        (2)

/* _lopen, LZOpenFile, OpenFile */
#define OF_READ (0)
#define OF_READWRITE    (2)
#define OF_WRITE        (1)
#define OF_SHARE_COMPAT (0)
#define OF_SHARE_DENY_NONE      (64)
#define OF_SHARE_DENY_READ      (48)
#define OF_SHARE_DENY_WRITE     (32)
#define OF_SHARE_EXCLUSIVE      (16)
#define OF_CANCEL       (2048)
#define OF_CREATE       (4096)
#define OF_DELETE       (512)
#define OF_EXIST        (16384)
#define OF_PARSE        (256)
#define OF_PROMPT       (8192)
#define OF_REOPEN       (32768)
#define OF_VERIFY       (1024)

/* ActivateKeyboardLayout, LoadKeyboardLayout */
#define HKL_NEXT        (1)
#define HKL_PREV        (0)
#define KLF_REORDER     (8)
#define KLF_UNLOADPREVIOUS      (4)
#define KLF_ACTIVATE    (1)
#define KLF_NOTELLSHELL (128)
#define KLF_REPLACELANG (16)
#define KLF_SUBSTITUTE_OK       (2)

/* AppendMenu */
#define MF_BITMAP       (0x4L)
#define MF_DISABLED     (0x2L)
#define MF_ENABLED      (0L)
#define MF_GRAYED       (0x1L)
#define MF_HELP         (0x4000L)
#define MF_MENUBARBREAK (0x20L)
#define MF_MENUBREAK    (0x40L)
#define MF_MOUSESELECT  (0x8000L)
#define MF_OWNERDRAW    (0x100L)
#define MF_POPUP        (0x10L)
#define MF_SEPARATOR    (0x800L)
#define MF_STRING       (0L)
#define MF_SYSMENU      (0x2000L)
#define MF_USECHECKBITMAPS      (0x200L)

/* Ternary Raster Operations - BitBlt */
#define BLACKNESS       0x00000042
#define NOTSRCERASE     0x001100A6
#define NOTSRCCOPY      0x00330008
#define SRCERASE        0x00440328
#define DSTINVERT       0x00550009
#define PATINVERT       0x005A0049
#define SRCINVERT       0x00660046
#define SRCAND  0x008800C6
#define MERGEPAINT      0x00BB0226
#define MERGECOPY       0x00C000CA
#define SRCCOPY 0x00CC0020
#define SRCPAINT        0x00EE0086
#define PATCOPY 0x00F00021
#define PATPAINT        0x00FB0A09
#define WHITENESS       0x00FF0062

/* Binary Raster Operations */
#define R2_BLACK        (1)
#define R2_COPYPEN      (13)
#define R2_MASKNOTPEN   (3)
#define R2_MASKPEN      (9)
#define R2_MASKPENNOT   (5)
#define R2_MERGENOTPEN  (12)
#define R2_MERGEPEN     (15)
#define R2_MERGEPENNOT  (14)
#define R2_NOP  (11)
#define R2_NOT  (6)
#define R2_NOTCOPYPEN   (4)
#define R2_NOTMASKPEN   (8)
#define R2_NOTMERGEPEN  (2)
#define R2_NOTXORPEN    (10)
#define R2_WHITE        (16)
#define R2_XORPEN       (7)

/* BroadcastSystemMessage */
#define BSF_FLUSHDISK   (4)
#define BSF_FORCEIFHUNG (32)
#define BSF_IGNORECURRENTTASK   (2)
#define BSF_NOHANG      (8)
#define BSF_POSTMESSAGE (16)
#define BSF_QUERY       (1)
#define BSM_ALLCOMPONENTS       (0)
#define BSM_APPLICATIONS        (8)
#define BSM_INSTALLABLEDRIVERS  (4)
#define BSM_NETDRIVER   (2)
#define BSM_VXDS        (1)
#define BROADCAST_QUERY_DENY    (1112363332)

/* BrowseCallbackProc */

/* CallNamedPipe */
#define NMPWAIT_NOWAIT  (1)
#define NMPWAIT_WAIT_FOREVER    (-1)
#define NMPWAIT_USE_DEFAULT_WAIT        (0)

/* CascadeWindows, TileWindows */
#define MDITILE_SKIPDISABLED    (2)
#define MDITILE_HORIZONTAL      (1)
#define MDITILE_VERTICAL        (0)

/* CBTProc */
#define HCBT_ACTIVATE   (5)
#define HCBT_CLICKSKIPPED       (6)
#define HCBT_CREATEWND  (3)
#define HCBT_DESTROYWND (4)
#define HCBT_KEYSKIPPED (7)
#define HCBT_MINMAX     (1)
#define HCBT_MOVESIZE   (0)
#define HCBT_QS (2)
#define HCBT_SETFOCUS   (9)
#define HCBT_SYSCOMMAND (8)

/* ChangeDisplaySettings */
#define ENUM_CURRENT_SETTINGS   ((DWORD)-1)
#define DM_BITSPERPEL   (0x40000L)
#define DM_PELSWIDTH    (0x80000L)
#define DM_PELSHEIGHT   (0x100000L)
#define DM_DISPLAYFLAGS (0x200000L)
#define DM_DISPLAYFREQUENCY     (0x400000L)
#define CDS_UPDATEREGISTRY      (1)
#define CDS_TEST        (2)
#define CDS_FULLSCREEN  4
#define DISP_CHANGE_SUCCESSFUL  (0)
#define DISP_CHANGE_RESTART     (1)
#define DISP_CHANGE_BADFLAGS    (-4)
#define DISP_CHANGE_FAILED      (-1)
#define DISP_CHANGE_BADMODE     (-2)
#define DISP_CHANGE_NOTUPDATED  (-3)

/* ChangeServiceConfig */
#define SERVICE_NO_CHANGE       (-1)
#define SERVICE_WIN32_OWN_PROCESS       (16)
#define SERVICE_WIN32_SHARE_PROCESS     (32)
#define SERVICE_KERNEL_DRIVER   (1)
#define SERVICE_FILE_SYSTEM_DRIVER      (2)
#define SERVICE_INTERACTIVE_PROCESS     (256)
#define SERVICE_BOOT_START      (0)
#define SERVICE_SYSTEM_START    (1)
#define SERVICE_AUTO_START      (2)
#define SERVICE_DEMAND_START    (3)
#define SERVICE_DISABLED        (4)

/* SERVICE_STATUS structure */
#define SERVICE_STOPPED (1)
#define SERVICE_START_PENDING   (2)
#define SERVICE_STOP_PENDING    (3)
#define SERVICE_RUNNING (4)
#define SERVICE_CONTINUE_PENDING        (5)
#define SERVICE_PAUSE_PENDING   (6)
#define SERVICE_PAUSED  (7)
#define SERVICE_ACCEPT_STOP     (1)
#define SERVICE_ACCEPT_PAUSE_CONTINUE   (2)
#define SERVICE_ACCEPT_SHUTDOWN (4)

/* CheckDlgButton */
#define BST_CHECKED     (1)
#define BST_INDETERMINATE       (2)
#define BST_UNCHECKED   (0)
#define BST_FOCUS       (8)
#define BST_PUSHED      (4)

/* CheckMenuItem, HiliteMenuItem */
#define MF_BYCOMMAND    (0L)
#define MF_BYPOSITION   (0x400L)
#define MF_CHECKED      (0x8L)
#define MF_UNCHECKED    (0L)
#define MF_HILITE       (0x80L)
#define MF_UNHILITE     (0L)

/* ChildWindowFromPointEx */
#define CWP_ALL (0)
#define CWP_SKIPINVISIBLE       (1)
#define CWP_SKIPDISABLED        (2)
#define CWP_SKIPTRANSPARENT     (4)

/* ClearCommError */
#define CE_BREAK        (16)
#define CE_DNS  (2048)
#define CE_FRAME        (8)
#define CE_IOE  (1024)
#define CE_MODE (32768)
#define CE_OOP  (4096)
#define CE_OVERRUN      (2)
#define CE_PTO  (512)
#define CE_RXOVER       (1)
#define CE_RXPARITY     (4)
#define CE_TXFULL       (256)

/* ChooseMatchToTarget */

/* CombineRgn */
#define RGN_AND (1)
#define RGN_COPY        (5)
#define RGN_DIFF        (4)
#define RGN_OR  (2)
#define RGN_XOR (3)
#define NULLREGION      (1)
#define SIMPLEREGION    (2)
#define COMPLEXREGION   (3)
#define ERROR   (0)

/* CommonDlgExtendedError */

/* CompareString, LCMapString */
#define LOCALE_SYSTEM_DEFAULT   (0x800L)
#define LOCALE_USER_DEFAULT     (0x400L)
#define NORM_IGNORECASE (1)
#define NORM_IGNOREKANATYPE     (65536)
#define NORM_IGNORENONSPACE     (2)
#define NORM_IGNORESYMBOLS      (4)
#define NORM_IGNOREWIDTH        (131072)
#define SORT_STRINGSORT (4096)
#define LCMAP_BYTEREV   (2048)
#define LCMAP_FULLWIDTH (8388608)
#define LCMAP_HALFWIDTH (4194304)
#define LCMAP_HIRAGANA  (1048576)
#define LCMAP_KATAKANA  (2097152)
#define LCMAP_LOWERCASE (256)
#define LCMAP_SORTKEY   (1024)
#define LCMAP_UPPERCASE (512)
#define LCMAP_LINGUISTIC_CASING   (16777216)

/* ContinueDebugEvent */
#define DBG_CONTINUE    (0x10002L)
#define DBG_CONTROL_BREAK       (0x40010008L)
#define DBG_CONTROL_C   (0x40010005L)
#define DBG_EXCEPTION_NOT_HANDLED       (0x80010001L)
#define DBG_TERMINATE_THREAD            (0x40010003L)
#define DBG_TERMINATE_PROCESS           (0x40010004L)

/* ControlService */
#define SERVICE_CONTROL_STOP    (1)
#define SERVICE_CONTROL_PAUSE   (2)
#define SERVICE_CONTROL_CONTINUE        (3)
#define SERVICE_CONTROL_INTERROGATE     (4)
#define SERVICE_CONTROL_SHUTDOWN        (5)

/* CopyImage, LoadImage */
#define IMAGE_BITMAP    (0)
#define IMAGE_CURSOR    (2)
#define IMAGE_ENHMETAFILE       (1)
#define IMAGE_ICON      (1)
#define LR_COPYDELETEORG        (8)
#define LR_COPYRETURNORG        (4)
#define LR_MONOCHROME   (1)
#define LR_CREATEDIBSECTION     (8192)
#define LR_DEFAULTSIZE  (64)

/* CreateDesktop */
#define DF_ALLOWOTHERACCOUNTHOOK        (0x1L)
#define DESKTOP_CREATEMENU      (0x4L)
#define DESKTOP_CREATEWINDOW    (0x2L)
#define DESKTOP_ENUMERATE       (0x40L)
#define DESKTOP_HOOKCONTROL     (0x8L)
#define DESKTOP_JOURNALPLAYBACK (0x20L)
#define DESKTOP_JOURNALRECORD   (0x10L)
#define DESKTOP_READOBJECTS     (0x1L)
#define DESKTOP_SWITCHDESKTOP   (0x100L)
#define DESKTOP_WRITEOBJECTS    (0x80L)
#define WSF_VISIBLE     (0x1L)

/* CreateDIBitmap */
#define CBM_INIT        (0x4L)
#define DIB_PAL_INDICES (2)
#define DIB_PAL_COLORS  (1)
#define DIB_RGB_COLORS  (0)

/* CreateFile, GetFileAttributes, SetFileAttributes */
#define GENERIC_READ    (0x80000000L)
#define GENERIC_WRITE   (0x40000000L)
#define FILE_SHARE_DELETE       (4)
#define FILE_SHARE_READ (1)
#define FILE_SHARE_WRITE        (2)
#define CONSOLE_TEXTMODE_BUFFER (1)
#define CREATE_NEW      (1)
#define CREATE_ALWAYS   (2)
#define OPEN_EXISTING   (3)
#define OPEN_ALWAYS     (4)
#define TRUNCATE_EXISTING       (5)
#define FILE_ATTRIBUTE_ARCHIVE  (32)
#define FILE_ATTRIBUTE_COMPRESSED       (2048)
#define FILE_ATTRIBUTE_NORMAL   (128)
#define FILE_ATTRIBUTE_DIRECTORY        (16)
#define FILE_ATTRIBUTE_HIDDEN   (2)
#define FILE_ATTRIBUTE_READONLY (1)
#define FILE_ATTRIBUTE_SYSTEM   (4)
#define FILE_ATTRIBUTE_TEMPORARY        (256)
#define FILE_FLAG_WRITE_THROUGH (2147483648)
#define FILE_FLAG_OVERLAPPED    (1073741824)
#define FILE_FLAG_NO_BUFFERING  (536870912)
#define FILE_FLAG_RANDOM_ACCESS (268435456)
#define FILE_FLAG_SEQUENTIAL_SCAN       (134217728)
#define FILE_FLAG_DELETE_ON_CLOSE       (67108864)
#define FILE_FLAG_BACKUP_SEMANTICS      (33554432)
#define FILE_FLAG_POSIX_SEMANTICS       (16777216)
#define SECURITY_ANONYMOUS      (0)
#define SECURITY_IDENTIFICATION (65536)
#define SECURITY_IMPERSONATION  (131072)
#define SECURITY_DELEGATION     (196608)
#define SECURITY_CONTEXT_TRACKING       (262144)
#define SECURITY_EFFECTIVE_ONLY (524288)
#define SECURITY_SQOS_PRESENT   (1048576)

#define FILE_APPEND_DATA        0x00000004
#define FILE_READ_ATTRIBUTES    0x00000080
#define FILE_WRITE_ATTRIBUTES   0x00000100

/* CreateFileMapping, VirtualAlloc, VirtualFree, VirtualProtect */
#define SEC_COMMIT      (134217728)
#define SEC_IMAGE       (16777216)
#define SEC_NOCACHE     (268435456)
#define SEC_RESERVE     (67108864)
#define PAGE_READONLY   (2)
#define PAGE_READWRITE  (4)
#define PAGE_WRITECOPY  (8)
#define PAGE_EXECUTE    (16)
#define PAGE_EXECUTE_READ       (32)
#define PAGE_EXECUTE_READWRITE  (64)
#define PAGE_EXECUTE_WRITECOPY  (128)
#define PAGE_GUARD      (256)
#define PAGE_NOACCESS   (1)
#define PAGE_NOCACHE    (512)
#define MEM_COMMIT      (4096)
#define MEM_FREE        (65536)
#define MEM_RESERVE     (8192)
#define MEM_IMAGE       (16777216)
#define MEM_MAPPED      (262144)
#define MEM_PRIVATE     (131072)
#define MEM_DECOMMIT    (16384)
#define MEM_RELEASE     (32768)
#define MEM_TOP_DOWN    (1048576)
#define EXCEPTION_GUARD_PAGE    (0x80000001L)
#define SECTION_EXTEND_SIZE     (0x10)
#define SECTION_MAP_READ        (0x4)
#define SECTION_MAP_WRITE       (0x2)
#define SECTION_QUERY   (0x1)
#define SECTION_ALL_ACCESS      (0xf001fL)

/* CreateFont */
#define FW_DONTCARE     (0)
#define FW_THIN (100)
#define FW_EXTRALIGHT   (200)
#define FW_LIGHT        (300)
#define FW_NORMAL       (400)
#define FW_REGULAR FW_NORMAL
#define FW_MEDIUM       (500)
#define FW_SEMIBOLD     (600)
#define FW_BOLD (700)
#define FW_EXTRABOLD    (800)
#define FW_HEAVY        (900)
#define ANSI_CHARSET    (0)
#define DEFAULT_CHARSET (1)
#define SYMBOL_CHARSET  (2)
#define SHIFTJIS_CHARSET        (128)
#define HANGEUL_CHARSET (129)
#define GB2312_CHARSET  (134)
#define CHINESEBIG5_CHARSET     (136)
#define GREEK_CHARSET   (161)
#define TURKISH_CHARSET (162)
#define HEBREW_CHARSET  (177)
#define ARABIC_CHARSET  (178)
#define BALTIC_CHARSET  (186)
#define RUSSIAN_CHARSET (204)
#define THAI_CHARSET    (222)
#define EASTEUROPE_CHARSET      (238)
#define OEM_CHARSET     (255)
#define OUT_DEFAULT_PRECIS      (0)
#define OUT_STRING_PRECIS       (1)
#define OUT_CHARACTER_PRECIS    (2)
#define OUT_STROKE_PRECIS       (3)
#define OUT_TT_PRECIS   (4)
#define OUT_DEVICE_PRECIS       (5)
#define OUT_RASTER_PRECIS       (6)
#define OUT_TT_ONLY_PRECIS      (7)
#define OUT_OUTLINE_PRECIS      (8)
#define CLIP_DEFAULT_PRECIS     (0)
#define CLIP_CHARACTER_PRECIS   (1)
#define CLIP_STROKE_PRECIS      (2)
#define CLIP_MASK       (15)
#define CLIP_LH_ANGLES  (16)
#define CLIP_TT_ALWAYS  (32)
#define CLIP_EMBEDDED   (128)
#define DEFAULT_QUALITY (0)
#define DRAFT_QUALITY   (1)
#define PROOF_QUALITY   (2)
#define NONANTIALIASED_QUALITY 3
#define ANTIALIASED_QUALITY 4
#define DEFAULT_PITCH   (0)
#define FIXED_PITCH     (1)
#define VARIABLE_PITCH  (2)
#define FF_DECORATIVE   (80)
#define FF_DONTCARE     (0)
#define FF_MODERN       (48)
#define FF_ROMAN        (16)
#define FF_SCRIPT       (64)
#define FF_SWISS        (32)

#define TMPF_FIXED_PITCH 1
#define TMPF_VECTOR 2
#define TMPF_TRUETYPE 4
#define TMPF_DEVICE 8

#define FR_PRIVATE     (16)
#define FR_NOT_ENUM    (32)

/* CreateHatchBrush */
#define HS_BDIAGONAL    (3)
#define HS_CROSS        (4)
#define HS_DIAGCROSS    (5)
#define HS_FDIAGONAL    (2)
#define HS_HORIZONTAL   (0)
#define HS_VERTICAL     (1)

/* CreateIconFromResourceEx */
#define LR_DEFAULTCOLOR (0)
#define LR_LOADREALSIZE (128)
#define LR_MONOCHROME   (1)

/* CreateMailslot, GetMailslotInfo */
#define MAILSLOT_WAIT_FOREVER   (0xffffffffL)
#define MAILSLOT_NO_MESSAGE     (0xffffffffL)

/* CreateMappedBitmap */
#define CMB_MASKED      (2)

/* CreateNamedPipe */
#define PIPE_ACCESS_DUPLEX      (3)
#define PIPE_ACCESS_INBOUND     (1)
#define PIPE_ACCESS_OUTBOUND    (2)
#define PIPE_UNLIMITED_INSTANCES (255)
#define WRITE_DAC       (0x40000L)
#define WRITE_OWNER     (0x80000L)
#define ACCESS_SYSTEM_SECURITY  (0x1000000L)
#define PIPE_TYPE_BYTE  (0)
#define PIPE_TYPE_MESSAGE       (4)
#define PIPE_READMODE_BYTE      (0)
#define PIPE_READMODE_MESSAGE   (2)
#define PIPE_REJECT_REMOTE_CLIENTS (8)
#define PIPE_WAIT       (0)
#define PIPE_NOWAIT     (1)

/* CreatePen, ExtCreatePen */
#define PS_GEOMETRIC    (65536)
#define PS_COSMETIC     (0)
#define PS_ALTERNATE    (8)
#define PS_SOLID        (0)
#define PS_DASH (1)
#define PS_DOT  (2)
#define PS_DASHDOT      (3)
#define PS_DASHDOTDOT   (4)
#define PS_NULL (5)
#define PS_USERSTYLE    (7)
#define PS_INSIDEFRAME  (6)
#define PS_ENDCAP_ROUND (0)
#define PS_ENDCAP_SQUARE        (256)
#define PS_ENDCAP_FLAT  (512)
#define PS_JOIN_BEVEL   (4096)
#define PS_JOIN_MITER   (8192)
#define PS_JOIN_ROUND   (0)
#define PS_STYLE_MASK   (15)
#define PS_ENDCAP_MASK  (3840)
#define PS_TYPE_MASK    (983040)

/* CreatePolygonRgn */
#define ALTERNATE       (1)
#define WINDING (2)

/* CreateProcess */
#define CREATE_DEFAULT_ERROR_MODE       (67108864)
#define CREATE_NEW_CONSOLE      (16)
#define CREATE_NEW_PROCESS_GROUP        (512)
#define CREATE_SEPARATE_WOW_VDM (2048)
#define CREATE_SUSPENDED        (4)
#define CREATE_UNICODE_ENVIRONMENT      (1024)
#define DEBUG_PROCESS   (1)
#define DEBUG_ONLY_THIS_PROCESS (2)
#define DETACHED_PROCESS        (8)
#define HIGH_PRIORITY_CLASS     (128)
#define IDLE_PRIORITY_CLASS     (64)
#define NORMAL_PRIORITY_CLASS   (32)
#define REALTIME_PRIORITY_CLASS (256)
#define CREATE_NO_WINDOW                0x08000000

/* CreateService */
#define SERVICE_ALL_ACCESS      (0xf01ffL)
#define SERVICE_CHANGE_CONFIG   (2)
#define SERVICE_ENUMERATE_DEPENDENTS    (8)
#define SERVICE_INTERROGATE     (128)
#define SERVICE_PAUSE_CONTINUE  (64)
#define SERVICE_QUERY_CONFIG    (1)
#define SERVICE_QUERY_STATUS    (4)
#define SERVICE_START   (16)
#define SERVICE_STOP    (32)
#define SERVICE_USER_DEFINED_CONTROL    (256)
#define DELETE  (0x10000L)
#define READ_CONTROL    (0x20000L)
#define GENERIC_EXECUTE (0x20000000L)
#define SERVICE_WIN32_OWN_PROCESS       (16)
#define SERVICE_WIN32_SHARE_PROCESS     (32)
#define SERVICE_KERNEL_DRIVER   (1)
#define SERVICE_FILE_SYSTEM_DRIVER      (2)
#define SERVICE_INTERACTIVE_PROCESS     (256)
#define SERVICE_BOOT_START      (0)
#define SERVICE_SYSTEM_START    (1)
#define SERVICE_AUTO_START      (2)
#define SERVICE_DEMAND_START    (3)
#define SERVICE_DISABLED        (4)
#define SERVICE_ERROR_IGNORE    (0)
#define SERVICE_ERROR_NORMAL    (1)
#define SERVICE_ERROR_SEVERE    (2)
#define SERVICE_ERROR_CRITICAL  (3)

/* CreateTapePartition, WriteTapemark */
#define TAPE_FIXED_PARTITIONS   (0L)
#define TAPE_INITIATOR_PARTITIONS       (0x2L)
#define TAPE_SELECT_PARTITIONS  (0x1L)
#define TAPE_FILEMARKS  (0x1L)
#define TAPE_LONG_FILEMARKS     (0x3L)
#define TAPE_SETMARKS   (0L)
#define TAPE_SHORT_FILEMARKS    (0x2L)

/* CreateWindow */
#define CW_USEDEFAULT   (0x80000000)
#define WS_BORDER       (0x800000L)
#define WS_CAPTION      (0xc00000L)
#define WS_CHILD        (0x40000000L)
#define WS_CHILDWINDOW  (0x40000000L)
#define WS_CLIPCHILDREN (0x2000000L)
#define WS_CLIPSIBLINGS (0x4000000L)
#define WS_DISABLED     (0x8000000L)
#define WS_DLGFRAME     (0x400000L)
#define WS_GROUP        (0x20000L)
#define WS_HSCROLL      (0x100000L)
#define WS_ICONIC       (0x20000000L)
#define WS_MAXIMIZE     (0x1000000L)
#define WS_MAXIMIZEBOX  (0x10000L)
#define WS_MINIMIZE     (0x20000000L)
#define WS_MINIMIZEBOX  (0x20000L)
#define WS_OVERLAPPED   (0L)
#define WS_OVERLAPPEDWINDOW     (0xcf0000L)
#define WS_POPUP        (0x80000000L)
#define WS_POPUPWINDOW  (0x80880000L)
#define WS_SIZEBOX      (0x40000L)
#define WS_SYSMENU      (0x80000L)
#define WS_TABSTOP      (0x10000L)
#define WS_THICKFRAME   (0x40000L)
#define WS_TILED        (0L)
#define WS_TILEDWINDOW  (0xcf0000L)
#define WS_VISIBLE      (0x10000000L)
#define WS_VSCROLL      (0x200000L)
#define MDIS_ALLCHILDSTYLES     (0x1)
#define BS_3STATE       (0x5L)
#define BS_AUTO3STATE   (0x6L)
#define BS_AUTOCHECKBOX (0x3L)
#define BS_AUTORADIOBUTTON      (0x9L)
#define BS_BITMAP       (0x80L)
#define BS_BOTTOM       (0x800L)
#define BS_CENTER       (0x300L)
#define BS_CHECKBOX     (0x2L)
#define BS_DEFPUSHBUTTON        (0x1L)
#define BS_GROUPBOX     (0x7L)
#define BS_ICON (0x40L)
#define BS_LEFT (0x100L)
#define BS_LEFTTEXT     (0x20L)
#define BS_MULTILINE    (0x2000L)
#define BS_NOTIFY       (0x4000L)
#define BS_FLAT (0x8000L)
#define BS_OWNERDRAW    (0xbL)
#define BS_PUSHBUTTON   (0L)
#define BS_PUSHLIKE     (0x1000L)
#define BS_RADIOBUTTON  (0x4L)
#define BS_RIGHT        (0x200L)
#define BS_RIGHTBUTTON  (0x20L)
#define BS_TEXT (0L)
#define BS_TOP  (0x400L)
#define BS_USERBUTTON   (0x8L)
#define BS_VCENTER      (0xc00L)
#define CBS_AUTOHSCROLL (0x40L)
#define CBS_DISABLENOSCROLL     (0x800L)
#define CBS_DROPDOWN    (0x2L)
#define CBS_DROPDOWNLIST        (0x3L)
#define CBS_HASSTRINGS  (0x200L)
#define CBS_LOWERCASE   (0x4000L)
#define CBS_NOINTEGRALHEIGHT    (0x400L)
#define CBS_OEMCONVERT  (0x80L)
#define CBS_OWNERDRAWFIXED      (0x10L)
#define CBS_OWNERDRAWVARIABLE   (0x20L)
#define CBS_SIMPLE      (0x1L)
#define CBS_SORT        (0x100L)
#define CBS_UPPERCASE   (0x2000L)
#define ES_AUTOHSCROLL  (0x80L)
#define ES_AUTOVSCROLL  (0x40L)
#define ES_CENTER       (0x1L)
#define ES_LEFT (0L)
#define ES_LOWERCASE    (0x10L)
#define ES_MULTILINE    (0x4L)
#define ES_NOHIDESEL    (0x100L)
#define ES_NUMBER       (0x2000L)
#define ES_OEMCONVERT   (0x400L)
#define ES_PASSWORD     (0x20L)
#define ES_READONLY     (0x800L)
#define ES_RIGHT        (0x2L)
#define ES_UPPERCASE    (0x8L)
#define ES_WANTRETURN   (0x1000L)
#define LBS_DISABLENOSCROLL     (0x1000L)
#define LBS_EXTENDEDSEL (0x800L)
#define LBS_HASSTRINGS  (0x40L)
#define LBS_MULTICOLUMN (0x200L)
#define LBS_MULTIPLESEL (0x8L)
#define LBS_NODATA      (0x2000L)
#define LBS_NOINTEGRALHEIGHT    (0x100L)
#define LBS_NOREDRAW    (0x4L)
#define LBS_NOSEL       (0x4000L)
#define LBS_NOTIFY      (0x1L)
#define LBS_OWNERDRAWFIXED      (0x10L)
#define LBS_OWNERDRAWVARIABLE   (0x20L)
#define LBS_SORT        (0x2L)
#define LBS_STANDARD    (0xa00003L)
#define LBS_USETABSTOPS (0x80L)
#define LBS_WANTKEYBOARDINPUT   (0x400L)
#define SBS_BOTTOMALIGN (0x4L)
#define SBS_HORZ        (0L)
#define SBS_LEFTALIGN   (0x2L)
#define SBS_RIGHTALIGN  (0x4L)
#define SBS_SIZEBOX     (0x8L)
#define SBS_SIZEBOXBOTTOMRIGHTALIGN     (0x4L)
#define SBS_SIZEBOXTOPLEFTALIGN (0x2L)
#define SBS_SIZEGRIP    (0x10L)
#define SBS_TOPALIGN    (0x2L)
#define SBS_VERT        (0x1L)
#define SS_BITMAP       (0xeL)
#define SS_BLACKFRAME   (0x7L)
#define SS_BLACKRECT    (0x4L)
#define SS_CENTER       (0x1L)
#define SS_CENTERIMAGE  (0x200L)
#define SS_ELLIPSISMASK     (0xC000L)
#define SS_ENDELLIPSIS      (0x4000L)
#define SS_ENHMETAFILE  (0xfL)
#define SS_ETCHEDFRAME  (0x12L)
#define SS_ETCHEDHORZ   (0x10L)
#define SS_ETCHEDVERT   (0x11L)
#define SS_GRAYFRAME    (0x8L)
#define SS_GRAYRECT     (0x5L)
#define SS_ICON (0x3L)
#define SS_LEFT (0L)
#define SS_LEFTNOWORDWRAP       (0xcL)
#define SS_NOPREFIX     (0x80L)
#define SS_NOTIFY       (0x100L)
#define SS_OWNERDRAW    (0xdL)
#define SS_PATHELLIPSIS     (0x8000L)
#define SS_REALSIZEIMAGE        (0x800L)
#define SS_RIGHT        (0x2L)
#define SS_RIGHTJUST    (0x400L)
#define SS_SIMPLE       (0xbL)
#define SS_SUNKEN       (0x1000L)
#define SS_TYPEMASK (0x1FL)
#define SS_USERITEM     (0xaL)
#define SS_WHITEFRAME   (0x9L)
#define SS_WHITERECT    (0x6L)
#define SS_WORDELLIPSIS     (0xC000L)
#define DS_3DLOOK       (0x4L)
#define DS_ABSALIGN     (0x1L)
#define DS_CENTER       (0x800L)
#define DS_CENTERMOUSE  (0x1000L)
#define DS_CONTEXTHELP  (0x2000L)
#define DS_CONTROL      (0x400L)
#define DS_FIXEDSYS     (0x8L)
#define DS_LOCALEDIT    (0x20L)
#define DS_MODALFRAME   (0x80L)
#define DS_NOFAILCREATE (0x10L)
#define DS_NOIDLEMSG    (0x100L)
#define DS_SETFONT      (0x40L)
#define DS_SETFOREGROUND        (0x200L)
#define DS_SHELLFONT (0x48L)
#define DS_SYSMODAL     (0x2L)

/* CreateWindowEx */
#define WS_EX_ACCEPTFILES       (0x10L)
#define WS_EX_APPWINDOW (0x40000L)
#define WS_EX_CLIENTEDGE        (0x200L)
#define WS_EX_CONTEXTHELP       (0x400L)
#define WS_EX_CONTROLPARENT     (0x10000L)
#define WS_EX_DLGMODALFRAME     (0x1L)
#define WS_EX_LAYERED           (0x80000)
#define WS_EX_LAYOUTRTL         (0x400000L)
#define WS_EX_LEFT      (0L)
#define WS_EX_LEFTSCROLLBAR     (0x4000L)
#define WS_EX_LTRREADING        (0L)
#define WS_EX_MDICHILD  (0x40L)
#define WS_EX_NOACTIVATE        (0x8000000L)
#define WS_EX_NOINHERITLAYOUT   (0x100000L)
#define WS_EX_NOPARENTNOTIFY    (0x4L)
#define WS_EX_OVERLAPPEDWINDOW  (0x300L)
#define WS_EX_PALETTEWINDOW     (0x188L)
#define WS_EX_RIGHT     (0x1000L)
#define WS_EX_RIGHTSCROLLBAR    (0L)
#define WS_EX_RTLREADING        (0x2000L)
#define WS_EX_STATICEDGE        (0x20000L)
#define WS_EX_TOOLWINDOW        (0x80L)
#define WS_EX_TOPMOST   (0x8L)
#define WS_EX_TRANSPARENT       (0x20L)
#define WS_EX_WINDOWEDGE        (0x100L)

#define LWA_ALPHA               (0x2)
#define LWA_COLORKEY            (0x1)

#define ULW_ALPHA               (0x2)
#define ULW_COLORKEY            (0x1)
#define ULW_OPAQUE              (0x4)

#define WC_DIALOG               (MAKEINTATOM(0x8002))

/* CreateWindowStation */
#define WINSTA_ACCESSCLIPBOARD  (0x4L)
#define WINSTA_ACCESSGLOBALATOMS        (0x20L)
#define WINSTA_CREATEDESKTOP    (0x8L)
#define WINSTA_ENUMDESKTOPS     (0x1L)
#define WINSTA_ENUMERATE        (0x100L)
#define WINSTA_EXITWINDOWS      (0x40L)
#define WINSTA_READATTRIBUTES   (0x2L)
#define WINSTA_READSCREEN       (0x200L)
#define WINSTA_WRITEATTRIBUTES  (0x10L)

/* DdeCallback */

/* DdeClientTransaction */

/* DdeEnableCallback */

/* DdeGetLastError */

/* DdeInitialize */

/* DdeNameService */

/* DebugProc */
#define WH_CALLWNDPROC  (4)
#define WH_CALLWNDPROCRET       (12)
#define WH_CBT  (5)
#define WH_DEBUG        (9)
#define WH_GETMESSAGE   (3)
#define WH_JOURNALPLAYBACK      (1)
#define WH_JOURNALRECORD        (0)
#define WH_KEYBOARD     (2)
#define WH_MOUSE        (7)
#define WH_MSGFILTER    (-1)
#define WH_SHELL        (10)
#define WH_SYSMSGFILTER (6)
#define WH_MSGFILTER    (-1)
#define WH_FOREGROUNDIDLE       (11)

/* DefineDosDevice */
#define DDD_RAW_TARGET_PATH     (1)
#define DDD_REMOVE_DEFINITION   (2)
#define DDD_EXACT_MATCH_ON_REMOVE       (4)

/* DeviceCapbilities */
#define DC_BINNAMES     (12)
#define DC_BINS (6)
#define DC_COPIES       (18)
#define DC_DRIVER       (11)
#define DC_DATATYPE_PRODUCED    (21)
#define DC_DUPLEX       (7)
#define DC_EMF_COMPLIANT        (20)
#define DC_ENUMRESOLUTIONS      (13)
#define DC_EXTRA        (9)
#define DC_FIELDS       (1)
#define DC_FILEDEPENDENCIES     (14)
#define DC_MAXEXTENT    (5)
#define DC_MINEXTENT    (4)
#define DC_ORIENTATION  (17)
#define DC_PAPERNAMES   (16)
#define DC_PAPERS       (2)
#define DC_PAPERSIZE    (3)
#define DC_SIZE (8)
#define DC_TRUETYPE     (15)
#define DCTT_BITMAP     (0x1L)
#define DCTT_DOWNLOAD   (0x2L)
#define DCTT_SUBDEV     (0x4L)
#define DC_VERSION      (10)
#define DC_BINADJUST    (19)
#define DC_DATATYPE_PRODUCED    (21)

/* DeviceIoControl */

/* DlgDirList */
#define DDL_ARCHIVE     (32)
#define DDL_DIRECTORY   (16)
#define DDL_DRIVES      (16384)
#define DDL_EXCLUSIVE   (32768)
#define DDL_HIDDEN      (2)
#define DDL_READONLY    (1)
#define DDL_READWRITE   (0)
#define DDL_SYSTEM      (4)
#define DDL_POSTMSGS    (8192)

/* DllEntryPoint */
#define DLL_PROCESS_ATTACH      (1)
#define DLL_THREAD_ATTACH       (2)
#define DLL_PROCESS_DETACH      (0)
#define DLL_THREAD_DETACH       (3)

/* DocumentProperties */
#define DM_IN_BUFFER    (8)
#define DM_MODIFY       (8)
#define DM_IN_PROMPT    (4)
#define DM_PROMPT       (4)
#define DM_OUT_BUFFER   (2)
#define DM_COPY (2)
#define DM_UPDATE       (1)

/* DrawAnimatedRects */
#define IDANI_OPEN      (1)
#define IDANI_CLOSE     (2)

/* DrawCaption */
#define DC_ACTIVE       (1)
#define DC_SMALLCAP (2)
#define DC_ICON (4)
#define DC_TEXT (8)
#define DC_INBUTTON (16)
#define DC_GRADIENT (32)

/* DrawEdge */
#define BDR_INNER       (12)
#define BDR_OUTER       (3)
#define BDR_RAISED      (5)
#define BDR_RAISEDINNER (4)
#define BDR_RAISEDOUTER (1)
#define BDR_SUNKEN      (10)
#define BDR_SUNKENINNER (8)
#define BDR_SUNKENOUTER (2)
#define EDGE_BUMP       (9)
#define EDGE_ETCHED     (6)
#define EDGE_RAISED     (5)
#define EDGE_SUNKEN     (10)

#define BF_ADJUST       (8192)
#define BF_BOTTOM       (8)
#define BF_BOTTOMLEFT   (9)
#define BF_BOTTOMRIGHT  (12)
#define BF_DIAGONAL     (16)
#define BF_DIAGONAL_ENDBOTTOMLEFT       (25)
#define BF_DIAGONAL_ENDBOTTOMRIGHT      (28)
#define BF_DIAGONAL_ENDTOPLEFT  (19)
#define BF_DIAGONAL_ENDTOPRIGHT (22)
#define BF_FLAT (16384)
#define BF_LEFT (1)
#define BF_MIDDLE       (2048)
#define BF_MONO (32768)
#define BF_RECT (15)
#define BF_RIGHT        (4)
#define BF_SOFT (4096)
#define BF_TOP  (2)
#define BF_TOPLEFT      (3)
#define BF_TOPRIGHT     (6)

/* DrawFrameControl */
#define DFC_BUTTON      (4)
#define DFC_CAPTION     (1)
#define DFC_MENU        (2)
#define DFC_SCROLL      (3)
#define DFCS_BUTTON3STATE       (8)
#define DFCS_BUTTONCHECK        (0)
#define DFCS_BUTTONPUSH (16)
#define DFCS_BUTTONRADIO        (4)
#define DFCS_BUTTONRADIOIMAGE   (1)
#define DFCS_BUTTONRADIOMASK    (2)
#define DFCS_CAPTIONCLOSE       (0)
#define DFCS_CAPTIONHELP        (4)
#define DFCS_CAPTIONMAX (2)
#define DFCS_CAPTIONMIN (1)
#define DFCS_CAPTIONRESTORE     (3)
#define DFCS_MENUARROW  (0)
#define DFCS_MENUBULLET (2)
#define DFCS_MENUCHECK  (1)
#define DFCS_SCROLLCOMBOBOX     (5)
#define DFCS_SCROLLDOWN (1)
#define DFCS_SCROLLLEFT (2)
#define DFCS_SCROLLRIGHT        (3)
#define DFCS_SCROLLSIZEGRIP     (8)
#define DFCS_SCROLLUP   (0)
#define DFCS_ADJUSTRECT (8192)
#define DFCS_CHECKED    (1024)
#define DFCS_FLAT       (16384)
#define DFCS_INACTIVE   (256)
#define DFCS_MONO       (32768)
#define DFCS_PUSHED     (512)

/* DrawIconEx */
#define DI_COMPAT       (4)
#define DI_DEFAULTSIZE  (8)
#define DI_IMAGE        (2)
#define DI_MASK (1)
#define DI_NORMAL       (3)

/* DrawState */
#define DST_BITMAP      (4)
#define DST_COMPLEX     (0)
#define DST_ICON        (3)
#define DST_PREFIXTEXT  (2)
#define DST_TEXT        (1)
#define DSS_NORMAL      (0)
#define DSS_UNION       (16)
#define DSS_DISABLED    (32)
#define DSS_MONO        (128)

/* DrawStatusText */
#define SBT_NOBORDERS   (256)
#define SBT_OWNERDRAW   (4096)
#define SBT_POPOUT      (512)
#define SBT_RTLREADING  (1024)

/* DrawText, DrawTextEx */
#define DT_BOTTOM       (8)
#define DT_CALCRECT     (1024)
#define DT_CENTER       (1)
#define DT_EDITCONTROL  (8192)
#define DT_END_ELLIPSIS (32768)
#define DT_PATH_ELLIPSIS        (16384)
#define DT_EXPANDTABS   (64)
#define DT_EXTERNALLEADING      (512)
#define DT_LEFT (0)
#define DT_MODIFYSTRING (65536)
#define DT_NOCLIP       (256)
#define DT_NOPREFIX     (2048)
#define DT_RIGHT        (2)
#define DT_RTLREADING   (131072)
#define DT_SINGLELINE   (32)
#define DT_TABSTOP      (128)
#define DT_TOP  (0)
#define DT_VCENTER      (4)
#define DT_WORDBREAK    (16)
#define DT_INTERNAL     (4096)

/* DuplicateHandle, MapViewOfFile */
#define DUPLICATE_CLOSE_SOURCE  (1)
#define DUPLICATE_SAME_ACCESS   (2)
#define FILE_MAP_ALL_ACCESS     (0xf001fL)
#define FILE_MAP_READ   (4)
#define FILE_MAP_WRITE  (2)
#define FILE_MAP_COPY   (1)
#define MUTEX_ALL_ACCESS        (0x1f0001L)
#define MUTEX_MODIFY_STATE      (1)
#define SYNCHRONIZE     (0x100000L)
#define SEMAPHORE_ALL_ACCESS    (0x1f0003L)
#define SEMAPHORE_MODIFY_STATE  (2)
#define EVENT_ALL_ACCESS        (0x1f0003L)
#define EVENT_MODIFY_STATE      (2)
#define KEY_ALL_ACCESS  (0xf003fL)
#define KEY_CREATE_LINK (32)
#define KEY_CREATE_SUB_KEY      (4)
#define KEY_ENUMERATE_SUB_KEYS  (8)
#define KEY_EXECUTE     (0x20019L)
#define KEY_NOTIFY      (16)
#define KEY_QUERY_VALUE (1)
#define KEY_READ        (0x20019L)
#define KEY_SET_VALUE   (2)
#define KEY_WRITE       (0x20006L)
#define PROCESS_ALL_ACCESS      (0x1f0fffL)
#define PROCESS_CREATE_PROCESS  (128)
#define PROCESS_CREATE_THREAD   (2)
#define PROCESS_DUP_HANDLE      (64)
#define PROCESS_QUERY_INFORMATION       (1024)
#define PROCESS_QUERY_LIMITED_INFORMATION (4096)
#define PROCESS_SET_INFORMATION (512)
#define PROCESS_TERMINATE       (1)
#define PROCESS_VM_OPERATION    (8)
#define PROCESS_VM_READ (16)
#define PROCESS_VM_WRITE        (32)
#define THREAD_ALL_ACCESS       (0x1f03ffL)
#define THREAD_DIRECT_IMPERSONATION     (512)
#define THREAD_GET_CONTEXT      (8)
#define THREAD_IMPERSONATE      (256)
#define THREAD_QUERY_INFORMATION        (64)
#define THREAD_SET_CONTEXT      (16)
#define THREAD_SET_INFORMATION  (32)
#define THREAD_SET_THREAD_TOKEN (128)
#define THREAD_SUSPEND_RESUME   (2)
#define THREAD_TERMINATE        (1)

/* EditWordBreakProc */
#define WB_ISDELIMITER  (2)
#define WB_LEFT (0)
#define WB_RIGHT        (1)

/* EnableScrollBar */
#define SB_BOTH (3)
#define SB_CTL  (2)
#define SB_HORZ (0)
#define SB_VERT (1)
#define ESB_DISABLE_BOTH        (3)
#define ESB_DISABLE_DOWN        (2)
#define ESB_DISABLE_LEFT        (1)
#define ESB_DISABLE_LTUP        (1)
#define ESB_DISABLE_RIGHT       (2)
#define ESB_DISABLE_RTDN        (2)
#define ESB_DISABLE_UP  (1)
#define ESB_ENABLE_BOTH (0)

/* Scroll Bar notifications*/
#define SB_LINEUP       (0)
#define SB_LINEDOWN     (1)
#define SB_LINELEFT     (0)
#define SB_LINERIGHT    (1)
#define SB_PAGEUP       (2)
#define SB_PAGEDOWN     (3)
#define SB_PAGELEFT     (2)
#define SB_PAGERIGHT    (3)
#define SB_THUMBPOSITION        (4)
#define SB_THUMBTRACK   (5)
#define SB_ENDSCROLL    (8)
#define SB_LEFT (6)
#define SB_RIGHT        (7)
#define SB_BOTTOM       (7)
#define SB_TOP  (6)

/* EnumCalendarInfo */
#define ENUM_ALL_CALENDARS      (-1)

/* EnumDateFormats */
#define DATE_SHORTDATE  (1)
#define DATE_LONGDATE   (2)

/* EnumDependentServices */
#define SERVICE_ACTIVE  (1)
#define SERVICE_INACTIVE        (2)

/* EnumFontFamExProc */
#define DEVICE_FONTTYPE (2)
#define RASTER_FONTTYPE (1)
#define TRUETYPE_FONTTYPE       (4)

/* EnumObjects, GetCurrentObject, GetObjectType */
#define OBJ_BRUSH       (2)
#define OBJ_PEN (1)
#define OBJ_PAL (5)
#define OBJ_FONT        (6)
#define OBJ_BITMAP      (7)
#define OBJ_EXTPEN      (11)
#define OBJ_REGION      (8)
#define OBJ_DC  (3)
#define OBJ_MEMDC       (10)
#define OBJ_METAFILE    (9)
#define OBJ_METADC      (4)
#define OBJ_ENHMETAFILE (13)
#define OBJ_ENHMETADC   (12)

/* EnumPrinters */

/* EnumProtocols */

/* EnumResLangProc */
#define RT_CURSOR       (MAKEINTRESOURCE(1))
#define RT_BITMAP       (MAKEINTRESOURCE(2))
#define RT_ICON         (MAKEINTRESOURCE(3))
#define RT_MENU         (MAKEINTRESOURCE(4))
#define RT_DIALOG       (MAKEINTRESOURCE(5))
#define RT_STRING       (MAKEINTRESOURCE(6))
#define RT_FONTDIR      (MAKEINTRESOURCE(7))
#define RT_FONT         (MAKEINTRESOURCE(8))
#define RT_ACCELERATOR  (MAKEINTRESOURCE(9))
#define RT_RCDATA       (MAKEINTRESOURCE(10))
#define RT_MESSAGETABLE (MAKEINTRESOURCE(11))
#define RT_GROUP_CURSOR (MAKEINTRESOURCE(12))
#define RT_GROUP_ICON   (MAKEINTRESOURCE(14))
#define RT_VERSION      (MAKEINTRESOURCE(16))

/* EnumServicesStatus */
#define SERVICE_WIN32   (48)
#define SERVICE_DRIVER  (11)

/* EnumSystemCodePages */
#define CP_INSTALLED    (1)
#define CP_SUPPORTED    (2)

/* EnumSystemLocales */
#define LCID_INSTALLED  (1)
#define LCID_SUPPORTED  (2)

/* EraseTape */
#define TAPE_ERASE_LONG (0x1L)
#define TAPE_ERASE_SHORT        (0L)

/* Escape */
#define SP_ERROR        (-1)
#define SP_OUTOFDISK    (-4)
#define SP_OUTOFMEMORY  (-5)
#define SP_USERABORT    (-3)
#define PHYSICALWIDTH   (110)
#define PHYSICALHEIGHT  (111)
#define PHYSICALOFFSETX (112)
#define PHYSICALOFFSETY (113)
#define SCALINGFACTORX  (114)
#define SCALINGFACTORY  (115)
#define QUERYESCSUPPORT (8)
#define ABORTDOC        (2)
#define ENDDOC  (11)
#define GETPHYSPAGESIZE (12)
#define GETPRINTINGOFFSET       (13)
#define GETSCALINGFACTOR        (14)
#define NEWFRAME        (1)
#define NEXTBAND        (3)
#define PASSTHROUGH     (19)
#define SETABORTPROC    (9)
#define STARTDOC        (10)

/* EscapeCommFunction */
#define CLRDTR  (6)
#define CLRRTS  (4)
#define SETDTR  (5)
#define SETRTS  (3)
#define SETXOFF (1)
#define SETXON  (2)
#define SETBREAK        (8)
#define CLRBREAK        (9)

/* ExitWindowsEx */
#define EWX_FORCE       (4)
#define EWX_LOGOFF      (0)
#define EWX_POWEROFF    (8)
#define EWX_REBOOT      (2)
#define EWX_SHUTDOWN    (1)

/* ExtFloodFill */
#define FLOODFILLBORDER (0)
#define FLOODFILLSURFACE        (1)

/* ExtTextOut */
#define ETO_CLIPPED     (4)
#define ETO_GLYPH_INDEX (16)
#define ETO_OPAQUE      (2)
#define ETO_RTLREADING  (128)

/* FillConsoleOutputAttribute */
#define FOREGROUND_BLUE (1)
#define FOREGROUND_GREEN        (2)
#define FOREGROUND_RED  (4)
#define FOREGROUND_INTENSITY    (8)
#define BACKGROUND_BLUE (16)
#define BACKGROUND_GREEN        (32)
#define BACKGROUND_RED  (64)
#define BACKGROUND_INTENSITY    (128)

/* FindFirstChangeNotification */
#define FILE_NOTIFY_CHANGE_FILE_NAME    (1)
#define FILE_NOTIFY_CHANGE_DIR_NAME     (2)
#define FILE_NOTIFY_CHANGE_ATTRIBUTES   (4)
#define FILE_NOTIFY_CHANGE_SIZE (8)
#define FILE_NOTIFY_CHANGE_LAST_WRITE   (16)
#define FILE_NOTIFY_CHANGE_SECURITY     (256)

/* FindFirstPrinterChangeNotification */

/* FindNextPrinterNotification */

/* FMExtensionProc */

/* FoldString */
#define MAP_FOLDCZONE   (16)
#define MAP_FOLDDIGITS  (128)
#define MAP_PRECOMPOSED (32)
#define MAP_COMPOSITE   (64)

/* ForegroundIdleProc */
#define HC_ACTION       (0)

/* FormatMessage */
#define FORMAT_MESSAGE_ALLOCATE_BUFFER  (256)
#define FORMAT_MESSAGE_IGNORE_INSERTS   (512)
#define FORMAT_MESSAGE_FROM_STRING      (1024)
#define FORMAT_MESSAGE_FROM_HMODULE     (2048)
#define FORMAT_MESSAGE_FROM_SYSTEM      (4096)
#define FORMAT_MESSAGE_ARGUMENT_ARRAY   (8192)
#define FORMAT_MESSAGE_MAX_WIDTH_MASK   (255)

/* gradient fill modes */
#define GRADIENT_FILL_RECT_H    0x00000000
#define GRADIENT_FILL_RECT_V    0x00000001
#define GRADIENT_FILL_TRIANGLE  0x00000002
#define GRADIENT_FILL_OP_FLAG   0x000000ff

/* alphablend and blit flags */
#define AC_SRC_OVER                 0x00
#define AC_SRC_ALPHA                0x01

/* GdiComment */
#define GDICOMMENT_WINDOWS_METAFILE     (-2147483647)
#define GDICOMMENT_BEGINGROUP   (2)
#define GDICOMMENT_ENDGROUP     (3)
#define GDICOMMENT_MULTIFORMATS (1073741828)
#define GDICOMMENT_IDENTIFIER   (1128875079)

/* GenerateConsoleCtrlEvent, HandlerRoutine */
#define CTRL_C_EVENT    (0)
#define CTRL_BREAK_EVENT        (1)
#define CTRL_CLOSE_EVENT        (2)
#define CTRL_LOGOFF_EVENT       (5)
#define CTRL_SHUTDOWN_EVENT     (6)

/* GetAddressByName */

/* GetArcDirection */
#define AD_COUNTERCLOCKWISE     (1)
#define AD_CLOCKWISE    (2)

/* GetBinaryTypes */
#define SCS_32BIT_BINARY        (0)
#define SCS_DOS_BINARY  (1)
#define SCS_OS216_BINARY        (5)
#define SCS_PIF_BINARY  (3)
#define SCS_POSIX_BINARY        (4)
#define SCS_WOW_BINARY  (2)

/* GetBoundsRect, SetBoundsRect */
#define DCB_DISABLE     (8)
#define DCB_ENABLE      (4)
#define DCB_RESET       (1)
#define DCB_SET (3)
#define DCB_ACCUMULATE  (2)

/* GetCharacterPlacement, GetFontLanguageInfo */
#define GCP_DBCS        (1)
#define GCP_ERROR       (0x8000)
#define GCP_CLASSIN     (0x80000L)
#define GCP_DIACRITIC   (256)
#define GCP_DISPLAYZWG  (0x400000L)
#define GCP_GLYPHSHAPE  (16)
#define GCP_JUSTIFY     (0x10000L)
#define GCP_JUSTIFYIN   (0x200000L)
#define GCP_KASHIDA     (1024)
#define GCP_LIGATE      (32)
#define GCP_MAXEXTENT   (0x100000L)
#define GCP_NEUTRALOVERRIDE     (0x2000000L)
#define GCP_NUMERICOVERRIDE     (0x1000000L)
#define GCP_NUMERICSLATIN       (0x4000000L)
#define GCP_NUMERICSLOCAL       (0x8000000L)
#define GCP_REORDER     (2)
#define GCP_SYMSWAPOFF  (0x800000L)
#define GCP_USEKERNING  (8)
#define FLI_GLYPHS      (0x40000L)
#define FLI_MASK        (0x103b)

/* GetClassLong, GetClassWord */
#define GCW_ATOM        (-32)
#define GCL_CBCLSEXTRA  (-20)
#define GCL_CBWNDEXTRA  (-18)
#define GCL_HBRBACKGROUND       (-10)
#define GCL_HCURSOR     (-12)
#define GCL_HICON       (-14)
#define GCL_HICONSM     (-34)
#define GCL_HMODULE     (-16)
#define GCL_MENUNAME    (-8)
#define GCL_STYLE       (-26)
#define GCL_WNDPROC     (-24)

/* GetClipboardFormat, SetClipboardData */
#define CF_BITMAP       (2)
#define CF_DIB  (8)
#define CF_PALETTE      (9)
#define CF_ENHMETAFILE  (14)
#define CF_METAFILEPICT (3)
#define CF_OEMTEXT      (7)
#define CF_TEXT (1)
#define CF_UNICODETEXT  (13)
#define CF_DIF  (5)
#define CF_DSPBITMAP    (130)
#define CF_DSPENHMETAFILE       (142)
#define CF_DSPMETAFILEPICT      (131)
#define CF_DSPTEXT      (129)
#define CF_GDIOBJFIRST  (768)
#define CF_GDIOBJLAST   (1023)
#define CF_HDROP        (15)
#define CF_LOCALE       (16)
#define CF_OWNERDISPLAY (128)
#define CF_PENDATA      (10)
#define CF_PRIVATEFIRST (512)
#define CF_PRIVATELAST  (767)
#define CF_RIFF (11)
#define CF_SYLK (4)
#define CF_WAVE (12)
#define CF_TIFF (6)

/* GetCommMask */
#define EV_BREAK        (64)
#define EV_CTS  (8)
#define EV_DSR  (16)
#define EV_ERR  (128)
#define EV_EVENT1       (2048)
#define EV_EVENT2       (4096)
#define EV_PERR (512)
#define EV_RING (256)
#define EV_RLSD (32)
#define EV_RX80FULL     (1024)
#define EV_RXCHAR       (1)
#define EV_RXFLAG       (2)
#define EV_TXEMPTY      (4)

/* GetCommModemStatus */
#define MS_CTS_ON       (0x10L)
#define MS_DSR_ON       (0x20L)
#define MS_RING_ON      (0x40L)
#define MS_RLSD_ON      (0x80L)

/* GetComputerName */
#define MAX_COMPUTERNAME_LENGTH (15)

/* GetConsoleMode */
#define ENABLE_LINE_INPUT       (2)
#define ENABLE_ECHO_INPUT       (4)
#define ENABLE_PROCESSED_INPUT  (1)
#define ENABLE_WINDOW_INPUT     (8)
#define ENABLE_MOUSE_INPUT      (16)
#define ENABLE_PROCESSED_OUTPUT (1)
#define ENABLE_WRAP_AT_EOL_OUTPUT       (2)

/* GetCPInfo */
#define CP_ACP  (0)
#define CP_MACCP        (2)
#define CP_OEMCP        (1)

/* GetDateFormat */
#define DATE_SHORTDATE  (1)
#define DATE_LONGDATE   (2)
#define DATE_USE_ALT_CALENDAR   (4)

/* GetDCEx */
#define DCX_WINDOW      (0x1L)
#define DCX_CACHE       (0x2L)
#define DCX_PARENTCLIP  (0x20L)
#define DCX_CLIPSIBLINGS        (0x10L)
#define DCX_CLIPCHILDREN        (0x8L)
#define DCX_NORESETATTRS        (0x4L)
#define DCX_LOCKWINDOWUPDATE    (0x400L)
#define DCX_EXCLUDERGN  (0x40L)
#define DCX_INTERSECTRGN        (0x80L)
#define DCX_VALIDATE    (0x200000L)

/* GetDeviceCaps */
#define DRIVERVERSION   (0)
#define TECHNOLOGY      (2)
#define DT_PLOTTER      (0)
#define DT_RASDISPLAY   (1)
#define DT_RASPRINTER   (2)
#define DT_RASCAMERA    (3)
#define DT_CHARSTREAM   (4)
#define DT_METAFILE     (5)
#define DT_DISPFILE     (6)
#define HORZSIZE        (4)
#define VERTSIZE        (6)
#define HORZRES (8)
#define VERTRES (10)
#define LOGPIXELSX      (88)
#define LOGPIXELSY      (90)
#define BITSPIXEL       (12)
#define PLANES  (14)
#define NUMBRUSHES      (16)
#define NUMPENS (18)
#define NUMMARKERS      (20)
#define NUMFONTS        (22)
#define NUMCOLORS       (24)
#define ASPECTX (40)
#define ASPECTY (42)
#define ASPECTXY        (44)
#define PDEVICESIZE     (26)
#define CLIPCAPS        (36)
#define SIZEPALETTE     (104)
#define NUMRESERVED     (106)
#define COLORRES        (108)
#define PHYSICALWIDTH   (110)
#define PHYSICALHEIGHT  (111)
#define PHYSICALOFFSETX (112)
#define PHYSICALOFFSETY (113)
#define SCALINGFACTORX  (114)
#define SCALINGFACTORY  (115)
#define VREFRESH        (116)
#define DESKTOPHORZRES  (118)
#define DESKTOPVERTRES  (117)
#define BLTALIGNMENT    (119)
#define RASTERCAPS      (38)
#define RC_BANDING      (2)
#define RC_BITBLT       (1)
#define RC_BITMAP64     (8)
#define RC_DI_BITMAP    (128)
#define RC_DIBTODEV     (512)
#define RC_FLOODFILL    (4096)
#define RC_GDI20_OUTPUT (16)
#define RC_PALETTE      (256)
#define RC_SCALING      (4)
#define RC_STRETCHBLT   (2048)
#define RC_STRETCHDIB   (8192)
#define CURVECAPS       (28)
#define CC_NONE (0)
#define CC_CIRCLES      (1)
#define CC_PIE  (2)
#define CC_CHORD        (4)
#define CC_ELLIPSES     (8)
#define CC_WIDE (16)
#define CC_STYLED       (32)
#define CC_WIDESTYLED   (64)
#define CC_INTERIORS    (128)
#define CC_ROUNDRECT    (256)
#define LINECAPS        (30)
#define LC_NONE (0)
#define LC_POLYLINE     (2)
#define LC_MARKER       (4)
#define LC_POLYMARKER   (8)
#define LC_WIDE (16)
#define LC_STYLED       (32)
#define LC_WIDESTYLED   (64)
#define LC_INTERIORS    (128)
#define POLYGONALCAPS   (32)
#define PC_NONE (0)
#define PC_POLYGON      (1)
#define PC_RECTANGLE    (2)
#define PC_WINDPOLYGON  (4)
#define PC_SCANLINE     (8)
#define PC_WIDE (16)
#define PC_STYLED       (32)
#define PC_WIDESTYLED   (64)
#define PC_INTERIORS    (128)
#define TEXTCAPS        (34)
#define TC_OP_CHARACTER (1)
#define TC_OP_STROKE    (2)
#define TC_CP_STROKE    (4)
#define TC_CR_90        (8)
#define TC_CR_ANY       (16)
#define TC_SF_X_YINDEP  (32)
#define TC_SA_DOUBLE    (64)
#define TC_SA_INTEGER   (128)
#define TC_SA_CONTIN    (256)
#define TC_EA_DOUBLE    (512)
#define TC_IA_ABLE      (1024)
#define TC_UA_ABLE      (2048)
#define TC_SO_ABLE      (4096)
#define TC_RA_ABLE      (8192)
#define TC_VA_ABLE      (16384)
#define TC_RESERVED     (32768)
#define TC_SCROLLBLT    (65536)
#define PC_PATHS        (512)

/* GetDriveType */
#define DRIVE_REMOVABLE (2)
#define DRIVE_FIXED     (3)
#define DRIVE_REMOTE    (4)
#define DRIVE_CDROM     (5)
#define DRIVE_RAMDISK   (6)
#define DRIVE_UNKNOWN   (0)
#define DRIVE_NO_ROOT_DIR       (1)

/* GetExceptionCode */
#define EXCEPTION_ACCESS_VIOLATION      (0xc0000005L)
#define EXCEPTION_BREAKPOINT    (0x80000003L)
#define EXCEPTION_CONTINUABLE   (0)
#define EXCEPTION_DATATYPE_MISALIGNMENT (0x80000002L)
#define EXCEPTION_SINGLE_STEP   (0x80000004L)
#define EXCEPTION_IN_PAGE_ERROR (0xc0000006L)
#define EXCEPTION_ILLEGAL_INSTRUCTION (0xc000001dL)
#define EXCEPTION_ARRAY_BOUNDS_EXCEEDED (0xc000008cL)
#define EXCEPTION_FLT_DENORMAL_OPERAND  (0xc000008dL)
#define EXCEPTION_FLT_DIVIDE_BY_ZERO    (0xc000008eL)
#define EXCEPTION_FLT_INEXACT_RESULT    (0xc000008fL)
#define EXCEPTION_FLT_INVALID_OPERATION (0xc0000090L)
#define EXCEPTION_FLT_OVERFLOW  (0xc0000091L)
#define EXCEPTION_FLT_STACK_CHECK       (0xc0000092L)
#define EXCEPTION_FLT_UNDERFLOW (0xc0000093L)
#define EXCEPTION_INT_DIVIDE_BY_ZERO    (0xc0000094L)
#define EXCEPTION_INT_OVERFLOW  (0xc0000095L)
#define EXCEPTION_PRIV_INSTRUCTION      (0xc0000096L)
#define EXCEPTION_NONCONTINUABLE_EXCEPTION      (0xc0000025L)
#define EXCEPTION_NONCONTINUABLE        (0x1)
#define EXCEPTION_STACK_OVERFLOW        (0xc00000fdL)
#define EXCEPTION_INVALID_DISPOSITION   (0xc0000026L)

/* GetFileType */
#define FILE_TYPE_UNKNOWN       (0)
#define FILE_TYPE_DISK  (1)
#define FILE_TYPE_CHAR  (2)
#define FILE_TYPE_PIPE  (3)

/* GetGlyphOutline */
#define GGO_BITMAP      (1)
#define GGO_NATIVE      (2)
#define GGO_METRICS     (0)
#define GGO_GRAY2_BITMAP        (4)
#define GGO_GRAY4_BITMAP        (5)
#define GGO_GRAY8_BITMAP        (6)
#define GDI_ERROR       (0xffffffffL)

/* GetGraphicsMode */
#define GM_COMPATIBLE   (1)
#define GM_ADVANCED     (2)

/* GetHandleInformation */
#define HANDLE_FLAG_INHERIT     (1)
#define HANDLE_FLAG_PROTECT_FROM_CLOSE  (2)

/* GetIconInfo */
#define IDC_ARROW       (MAKEINTRESOURCE(32512))
#define IDC_IBEAM       (MAKEINTRESOURCE(32513))
#define IDC_WAIT        (MAKEINTRESOURCE(32514))
#define IDC_CROSS       (MAKEINTRESOURCE(32515))
#define IDC_UPARROW     (MAKEINTRESOURCE(32516))
#define IDC_SIZENWSE    (MAKEINTRESOURCE(32642))
#define IDC_SIZENESW    (MAKEINTRESOURCE(32643))
#define IDC_SIZEWE      (MAKEINTRESOURCE(32644))
#define IDC_SIZENS      (MAKEINTRESOURCE(32645))
#define IDC_SIZEALL     (MAKEINTRESOURCE(32646))
#define IDC_NO  (MAKEINTRESOURCE(32648))
#define IDC_APPSTARTING (MAKEINTRESOURCE(32650))
#define IDC_HELP        (MAKEINTRESOURCE(32651))
#define IDI_APPLICATION (MAKEINTRESOURCE(32512))
#define IDI_HAND        (MAKEINTRESOURCE(32513))
#define IDI_QUESTION    (MAKEINTRESOURCE(32514))
#define IDI_EXCLAMATION (MAKEINTRESOURCE(32515))
#define IDI_ASTERISK    (MAKEINTRESOURCE(32516))
#define IDI_WINLOGO     (MAKEINTRESOURCE(32517))
#define IDC_SIZE        (MAKEINTRESOURCE(32640))
#define IDC_ICON        (MAKEINTRESOURCE(32641))

/* GetMapMode */
#define MM_ANISOTROPIC  (8)
#define MM_HIENGLISH    (5)
#define MM_HIMETRIC     (3)
#define MM_ISOTROPIC    (7)
#define MM_LOENGLISH    (4)
#define MM_LOMETRIC     (2)
#define MM_TEXT (1)
#define MM_TWIPS        (6)

/* GetMenuDefaultItem */
#define GMDI_GOINTOPOPUPS       (0x2L)
#define GMDI_USEDISABLED        (0x1L)

/* PeekMessage */
#define PM_NOREMOVE     (0)
#define PM_REMOVE       (1)
#define PM_NOYIELD      (2)

/* GetNamedPipeHandleState */
#define PIPE_NOWAIT     (1)
#define PIPE_READMODE_MESSAGE   (2)

/* GetNamedPipeInfo */
#define PIPE_CLIENT_END (0)
#define PIPE_SERVER_END (1)
#define PIPE_TYPE_MESSAGE       (4)

/* GetNextWindow, GetWindow */
#define GW_HWNDNEXT     (2)
#define GW_HWNDPREV     (3)
#define GW_CHILD        (5)
#define GW_HWNDFIRST    (0)
#define GW_HWNDLAST     (1)
#define GW_OWNER        (4)

/* GetPath */
#define PT_MOVETO       (6)
#define PT_LINETO       (2)
#define PT_BEZIERTO     (4)
#define PT_CLOSEFIGURE  (1)

/* GetProcessShutdownParameters */
#define SHUTDOWN_NORETRY        (1)

/* GetQueueStatus */
#define QS_ALLEVENTS    (191)
#define QS_ALLINPUT     (255)
#define QS_HOTKEY       (128)
#define QS_INPUT        (7)
#define QS_KEY  (1)
#define QS_MOUSE        (6)
#define QS_MOUSEBUTTON  (4)
#define QS_MOUSEMOVE    (2)
#define QS_PAINT        (32)
#define QS_POSTMESSAGE  (8)
#define QS_SENDMESSAGE  (64)
#define QS_TIMER        (16)

/* GetScrollInfo, SetScrollInfo */
#define SIF_PAGE                (2)
#define SIF_POS                 (4)
#define SIF_RANGE               (1)
#define SIF_DISABLENOSCROLL     (8)
#define SIF_TRACKPOS            (16)
#define SIF_ALL                 (SIF_PAGE | SIF_POS | SIF_RANGE | SIF_TRACKPOS)

/* GetStdHandle */
#define STD_INPUT_HANDLE        (DWORD)(-10)
#define STD_OUTPUT_HANDLE       (DWORD)(-11)
#define STD_ERROR_HANDLE        (DWORD)(-12)
#define INVALID_HANDLE_VALUE    ((HANDLE)-1)
#define HFILE_ERROR ((HANDLE) -1)

/* GetStockObject */
#define BLACK_BRUSH     (4)
#define DKGRAY_BRUSH    (3)
#define GRAY_BRUSH      (2)
#define HOLLOW_BRUSH    (5)
#define LTGRAY_BRUSH    (1)
#define NULL_BRUSH      (5)
#define WHITE_BRUSH     (0)
#define BLACK_PEN       (7)
#define NULL_PEN        (8)
#define WHITE_PEN       (6)
#define ANSI_FIXED_FONT (11)
#define ANSI_VAR_FONT   (12)
#define DEVICE_DEFAULT_FONT     (14)
#define DEFAULT_GUI_FONT        (17)
#define OEM_FIXED_FONT  (10)
#define SYSTEM_FONT     (13)
#define SYSTEM_FIXED_FONT       (16)
#define DEFAULT_PALETTE (15)

/* GetStringTypeA */
#define CT_CTYPE1       (1)
#define CT_CTYPE2       (2)
#define CT_CTYPE3       (4)
#define C1_UPPER        (1)
#define C1_LOWER        (2)
#define C1_DIGIT        (4)
#define C1_SPACE        (8)
#define C1_PUNCT        (16)
#define C1_CNTRL        (32)
#define C1_BLANK        (64)
#define C1_XDIGIT       (128)
#define C1_ALPHA        (256)
#define C2_LEFTTORIGHT  (1)
#define C2_RIGHTTOLEFT  (2)
#define C2_EUROPENUMBER (3)
#define C2_EUROPESEPARATOR      (4)
#define C2_EUROPETERMINATOR     (5)
#define C2_ARABICNUMBER (6)
#define C2_COMMONSEPARATOR      (7)
#define C2_BLOCKSEPARATOR       (8)
#define C2_SEGMENTSEPARATOR     (9)
#define C2_WHITESPACE   (10)
#define C2_OTHERNEUTRAL (11)
#define C2_NOTAPPLICABLE        (0)
#define C3_NONSPACING   (1)
#define C3_DIACRITIC    (2)
#define C3_VOWELMARK    (4)
#define C3_SYMBOL       (8)
#define C3_KATAKANA     (16)
#define C3_HIRAGANA     (32)
#define C3_HALFWIDTH    (64)
#define C3_FULLWIDTH    (128)
#define C3_IDEOGRAPH    (256)
#define C3_KASHIDA      (512)
#define C3_ALPHA        (32768)
#define C3_NOTAPPLICABLE        (0)

/* GetSysColor */
#define COLOR_3DDKSHADOW        (21)
#define COLOR_3DFACE    (15)
#define COLOR_3DHILIGHT (20)
#define COLOR_3DLIGHT   (22)
#define COLOR_BTNHILIGHT        (20)
#define COLOR_3DSHADOW  (16)
#define COLOR_ACTIVEBORDER      (10)
#define COLOR_ACTIVECAPTION     (2)
#define COLOR_APPWORKSPACE      (12)
#define COLOR_BACKGROUND        (1)
#define COLOR_DESKTOP   (1)
#define COLOR_BTNFACE   (15)
#define COLOR_BTNHIGHLIGHT      (20)
#define COLOR_BTNSHADOW (16)
#define COLOR_BTNTEXT   (18)
#define COLOR_CAPTIONTEXT       (9)
#define COLOR_GRADIENTACTIVECAPTION (27)
#define COLOR_GRADIENTINACTIVECAPTION (28)
#define COLOR_GRAYTEXT  (17)
#define COLOR_HIGHLIGHT (13)
#define COLOR_HIGHLIGHTTEXT     (14)
#define COLOR_HOTLIGHT (26)
#define COLOR_INACTIVEBORDER    (11)
#define COLOR_INACTIVECAPTION   (3)
#define COLOR_INACTIVECAPTIONTEXT       (19)
#define COLOR_INFOBK    (24)
#define COLOR_INFOTEXT  (23)
#define COLOR_MENU      (4)
#define COLOR_MENUTEXT  (7)
#define COLOR_SCROLLBAR (0)
#define COLOR_WINDOW    (5)
#define COLOR_WINDOWFRAME       (6)
#define COLOR_WINDOWTEXT        (8)

/* GetSystemMetrics */
#define SM_CYMIN        (29)
#define SM_CXMIN        (28)
#define SM_ARRANGE      (56)
#define SM_CLEANBOOT    (67)
#define SM_CMETRICS     (75)
#define SM_CMOUSEBUTTONS        (43)
#define SM_CXBORDER     (5)
#define SM_CYBORDER     (6)
#define SM_CXCURSOR     (13)
#define SM_CYCURSOR     (14)
#define SM_CXDLGFRAME   (7)
#define SM_CYDLGFRAME   (8)
#define SM_CXDOUBLECLK  (36)
#define SM_CYDOUBLECLK  (37)
#define SM_CXDRAG       (32)
#define SM_CYDRAG       (33)
#define SM_CXEDGE       (32)
#define SM_CYEDGE       (33)
#define SM_CXFIXEDFRAME (32)
#define SM_CYFIXEDFRAME (33)
#define SM_CXFRAME      (32)
#define SM_CYFRAME      (33)
#define SM_CXFULLSCREEN (16)
#define SM_CYFULLSCREEN (17)
#define SM_CXHSCROLL    (21)
#define SM_CYHSCROLL    (3)
#define SM_CXHTHUMB     (10)
#define SM_CXICON       (11)
#define SM_CYICON       (12)
#define SM_CXICONSPACING        (38)
#define SM_CYICONSPACING        (39)
#define SM_CXMAXIMIZED  (61)
#define SM_CYMAXIMIZED  (62)
#define SM_CXMAXTRACK   (59)
#define SM_CYMAXTRACK   (60)
#define SM_CXMENUCHECK  (71)
#define SM_CYMENUCHECK  (72)
#define SM_CXMENUSIZE   (54)
#define SM_CYMENUSIZE   (55)
#define SM_CXMINIMIZED  (57)
#define SM_CYMINIMIZED  (58)
#define SM_CXMINSPACING (47)
#define SM_CYMINSPACING (48)
#define SM_CXMINTRACK   (34)
#define SM_CYMINTRACK   (35)
#define SM_CXSCREEN     (0)
#define SM_CYSCREEN     (1)
#define SM_CXSIZE       (30)
#define SM_CYSIZE       (31)
#define SM_CXSIZEFRAME  (32)
#define SM_CYSIZEFRAME  (33)
#define SM_CXSMICON     (49)
#define SM_CYSMICON     (50)
#define SM_CXSMSIZE     (52)
#define SM_CYSMSIZE     (53)
#define SM_CXVSCROLL    (2)
#define SM_CYHSCROLL    (3)
#define SM_CXHSCROLL    (21)
#define SM_CYVSCROLL    (20)
#define SM_CYVTHUMB     (9)
#define SM_CYCAPTION    (4)
#define SM_CYKANJIWINDOW        (18)
#define SM_CYMENU       (15)
#define SM_CYSMCAPTION  (51)
#define SM_DBCSENABLED  (42)
#define SM_DEBUG        (22)
#define SM_MENUDROPALIGNMENT    (40)
#define SM_MIDEASTENABLED       (74)
#define SM_MOUSEPRESENT (19)
#define SM_NETWORK      (63)
#define SM_PENWINDOWS   (41)
#define SM_RESERVED1    (24)
#define SM_RESERVED2    (25)
#define SM_RESERVED3    (26)
#define SM_RESERVED4    (27)
#define SM_SECURE       (44)
#define SM_SHOWSOUNDS   (70)
#define SM_SLOWMACHINE  (73)
#define SM_SWAPBUTTON   (23)
#define ARW_BOTTOMLEFT  (0L)
#define ARW_BOTTOMRIGHT (0x1L)
#define ARW_HIDE        (0x8L)
#define ARW_TOPLEFT     (0x2L)
#define ARW_TOPRIGHT    (0x3L)
#define ARW_DOWN        (0x4L)
#define ARW_LEFT        (0L)
#define ARW_RIGHT       (0L)
#define ARW_UP  (0x4L)

/* GetSystemPaletteUse */
#define SYSPAL_NOSTATIC256 (3)
#define SYSPAL_NOSTATIC (2)
#define SYSPAL_STATIC   (1)
#define SYSPAL_ERROR    (0)

/* GetTapeParameters, SetTapeParameters */
#define GET_TAPE_MEDIA_INFORMATION      (0)
#define GET_TAPE_DRIVE_INFORMATION      (1)
#define SET_TAPE_MEDIA_INFORMATION      (0)
#define SET_TAPE_DRIVE_INFORMATION      (1)

/* GetTapePosition */
#define TAPE_ABSOLUTE_POSITION  (0L)
#define TAPE_LOGICAL_POSITION   (0x1L)

/* GetTextAlign */
#define TA_BASELINE     (24)
#define TA_BOTTOM       (8)
#define TA_TOP  (0)
#define TA_CENTER       (6)
#define TA_LEFT (0)
#define TA_RIGHT        (2)
#define TA_RTLREADING   (256)
#define TA_NOUPDATECP   (0)
#define TA_UPDATECP     (1)
#define VTA_BASELINE    (24)
#define VTA_CENTER      (6)

/* GetThreadPriority */
#define THREAD_PRIORITY_ABOVE_NORMAL    (1)
#define THREAD_PRIORITY_BELOW_NORMAL    (-1)
#define THREAD_PRIORITY_HIGHEST (2)
#define THREAD_PRIORITY_IDLE    (-15)
#define THREAD_PRIORITY_LOWEST  (-2)
#define THREAD_PRIORITY_NORMAL  (0)
#define THREAD_PRIORITY_TIME_CRITICAL   (15)
#define THREAD_PRIORITY_ERROR_RETURN    (2147483647)
#define TLS_MINIMUM_AVAILABLE   (64)

/* GetTimeFormat */
#define TIME_NOMINUTESORSECONDS (1)
#define TIME_NOSECONDS  (2)
#define TIME_NOTIMEMARKER       (4)
#define TIME_FORCE24HOURFORMAT  (8)

/* GetTimeZoneInformation */
#define TIME_ZONE_ID_UNKNOWN    (0)
#define TIME_ZONE_ID_STANDARD   (1)
#define TIME_ZONE_ID_DAYLIGHT   (2)
#define TIME_ZONE_ID_INVALID  (0xffffffff)

/* GetUserObjectInformation */
#define UOI_FLAGS       (1)
#define UOI_NAME        (2)
#define UOI_TYPE        (3)

/* GetVolumeInformation */
#define FS_CASE_IS_PRESERVED    (2)
#define FS_CASE_SENSITIVE       (1)
#define FS_UNICODE_STORED_ON_DISK       (4)
#define FS_PERSISTENT_ACLS      (8)
#define FS_FILE_COMPRESSION     (16)
#define FS_VOL_IS_COMPRESSED    (32768)

/* GetWindowLong */
#define GWL_EXSTYLE     (-20)
#define GWL_STYLE       (-16)
#define GWL_WNDPROC     (-4)
#define GWL_HINSTANCE   (-6)
#define GWL_HWNDPARENT  (-8)
#define GWL_ID  (-12)
#define GWL_USERDATA    (-21)
#define DWL_DLGPROC     (4)
#define DWL_MSGRESULT   (0)
#define DWL_USER        (8)

/* GlobalAlloc, GlobalFlags */
#define GMEM_FIXED      (0)
#define GMEM_MOVEABLE   (2)
#define GPTR    (64)
#define GHND    (66)
#define GMEM_DDESHARE   (8192)
#define GMEM_DISCARDABLE        (256)
#define GMEM_LOWER      (4096)
#define GMEM_NOCOMPACT  (16)
#define GMEM_NODISCARD  (32)
#define GMEM_NOT_BANKED (4096)
#define GMEM_NOTIFY     (16384)
#define GMEM_SHARE      (8192)
#define GMEM_ZEROINIT   (64)
#define GMEM_DISCARDED  (16384)
#define GMEM_INVALID_HANDLE     (32768)
#define GMEM_LOCKCOUNT  (255)

/* HeapAlloc, HeapReAlloc */
#define HEAP_GENERATE_EXCEPTIONS        (4)
#define HEAP_NO_SERIALIZE       (1)
#define HEAP_ZERO_MEMORY        (8)
#define STATUS_NO_MEMORY        (0xc0000017L)
#define STATUS_ACCESS_VIOLATION (0xc0000005L)
#define HEAP_REALLOC_IN_PLACE_ONLY      (16)

/* ImageList_Copy */
#define ILCF_MOVE   (0)
#define ILCF_SWAP   (1)

/* ImageList_Create */
#define ILC_COLOR       (0)
#define ILC_COLOR4      (4)
#define ILC_COLOR8      (8)
#define ILC_COLOR16     (16)
#define ILC_COLOR24     (24)
#define ILC_COLOR32     (32)
#define ILC_COLORDDB    (254)
#define ILC_MASK        (1)
#define ILC_PALETTE  (2048)


/* ImageList_Draw, ImageList_DrawEx */
#define ILD_BLEND25     (2)
#define ILD_BLEND50     (4)
#define ILD_BLEND       (4)
#define ILD_FOCUS       (2)
#define ILD_IMAGE (32)
#define ILD_MASK        (16)
#define ILD_NORMAL      (0)
#define ILD_OVERLAYMASK (0xf00)
#define ILD_ROP (64)
#define ILD_SELECTED    (4)
#define ILD_TRANSPARENT (1)
#define CLR_NONE        (0xffffffffL)
#define CLR_INVALID     (0xffffffffL)
#define CLR_DEFAULT     (0xff000000L)
#define CLR_HILIGHT (0xff000000L)

/* ImageList_LoadImage */
#define LR_DEFAULTCOLOR (0)
#define LR_LOADFROMFILE (16)
#define LR_LOADMAP3DCOLORS      (4096)
#define LR_LOADTRANSPARENT      (32)
#define LR_MONOCHROME   (1)

/* ImmConfigureIME */
#define IME_CONFIG_GENERAL      (1)
#define IME_CONFIG_REGISTERWORD (2)
#define IME_CONFIG_SELECTDICTIONARY     (3)

/* ImmGetConversionList */
#define GCL_CONVERSION  (1)
#define GCL_REVERSECONVERSION   (2)
#define GCL_REVERSE_LENGTH      (3)

/* ImmGetGuideLine */
#define GGL_LEVEL       (1)
#define GGL_INDEX       (2)
#define GGL_STRING      (3)
#define GGL_PRIVATE     (4)
#define GL_LEVEL_ERROR  (2)
#define GL_LEVEL_FATAL  (1)
#define GL_LEVEL_INFORMATION    (4)
#define GL_LEVEL_NOGUIDELINE    (0)
#define GL_LEVEL_WARNING        (3)
#define GL_ID_CANNOTSAVE        (17)
#define GL_ID_NOCONVERT (32)
#define GL_ID_NODICTIONARY      (16)
#define GL_ID_NOMODULE  (1)
#define GL_ID_READINGCONFLICT   (35)
#define GL_ID_TOOMANYSTROKE     (34)
#define GL_ID_TYPINGERROR       (33)
#define GL_ID_UNKNOWN   (0)
#define GL_ID_INPUTREADING      (36)
#define GL_ID_INPUTRADICAL      (37)
#define GL_ID_INPUTCODE (38)
#define GL_ID_CHOOSECANDIDATE   (40)
#define GL_ID_REVERSECONVERSION (41)

/* ImmGetProperty */
#define IGP_PROPERTY    (4)
#define IGP_CONVERSION  (8)
#define IGP_SENTENCE    (12)
#define IGP_UI  (16)
#define IGP_SETCOMPSTR  (20)
#define IGP_SELECT      (24)
#define IME_PROP_AT_CARET       (65536)
#define IME_PROP_SPECIAL_UI     (131072)
#define IME_PROP_CANDLIST_START_FROM_1  (262144)
#define IME_PROP_UNICODE        (524288)
#define UI_CAP_2700     (1)
#define UI_CAP_ROT90    (2)
#define UI_CAP_ROTANY   (4)
#define SCS_CAP_COMPSTR (1)
#define SCS_CAP_MAKEREAD        (2)
#define SELECT_CAP_CONVERSION   (1)
#define SELECT_CAP_SENTENCE     (2)

/* ImmNotifyIME */
#define NI_CHANGECANDIDATELIST  (19)
#define NI_CLOSECANDIDATE       (17)
#define NI_COMPOSITIONSTR       (21)
#define NI_OPENCANDIDATE        (16)
#define NI_SELECTCANDIDATESTR   (18)
#define NI_SETCANDIDATE_PAGESIZE        (23)
#define NI_SETCANDIDATE_PAGESTART       (22)
#define CPS_CANCEL      (4)
#define CPS_COMPLETE    (1)
#define CPS_CONVERT     (2)
#define CPS_REVERT      (3)

/* ImmGetCompositionString */
#define GCS_COMPREADSTR 1
#define GCS_COMPREADATTR 2
#define GCS_COMPREADCLAUSE 4
#define GCS_COMPSTR 8
#define GCS_COMPATTR 16
#define GCS_COMPCLAUSE 32
#define GCS_CURSORPOS 128
#define GCS_DELTASTART 256
#define GCS_RESULTREADSTR 512
#define GCS_RESULTREADCLAUSE 1024
#define GCS_RESULTSTR 2048
#define GCS_RESULTCLAUSE 4096

/* ImmSetCompositionString */
#define SCS_SETSTR      (9)
#define SCS_CHANGEATTR  (18)
#define SCS_CHANGECLAUSE        (36)

/* ImmSetCompositionWindow */
#define CFS_DEFAULT 0
#define CFS_RECT 1
#define CFS_POINT 2
#define CFS_SCREEN 4
#define CFS_FORCE_POSITION 32
#define CFS_CANDIDATEPOS 64
#define CFS_EXCLUDE 128

/* ImmUnregisterWord */
#define IME_REGWORD_STYLE_EUDC  (1)
#define IME_REGWORD_STYLE_USER_FIRST    0x80000000
#define IME_REGWORD_STYLE_USER_LAST     (-1)

/* InitializeSecurityDescriptor */
#define SECURITY_DESCRIPTOR_REVISION    (1)

/* IsTextUnicode */
#define IS_TEXT_UNICODE_ASCII16 (1)
#define IS_TEXT_UNICODE_REVERSE_ASCII16 (16)
#define IS_TEXT_UNICODE_STATISTICS      (2)
#define IS_TEXT_UNICODE_REVERSE_STATISTICS      (32)
#define IS_TEXT_UNICODE_CONTROLS        (4)
#define IS_TEXT_UNICODE_REVERSE_CONTROLS        (64)
#define IS_TEXT_UNICODE_SIGNATURE       (8)
#define IS_TEXT_UNICODE_REVERSE_SIGNATURE       (128)
#define IS_TEXT_UNICODE_ILLEGAL_CHARS   (256)
#define IS_TEXT_UNICODE_ODD_LENGTH      (512)
#define IS_TEXT_UNICODE_NULL_BYTES      (4096)
#define IS_TEXT_UNICODE_UNICODE_MASK    (15)
#define IS_TEXT_UNICODE_REVERSE_MASK    (240)
#define IS_TEXT_UNICODE_NOT_UNICODE_MASK        (3840)
#define IS_TEXT_UNICODE_NOT_ASCII_MASK  (61440)

/* JournalPlaybackProc, KeyboardProc */
#define HC_GETNEXT      (1)
#define HC_SKIP (2)
#define HC_SYSMODALOFF  (5)
#define HC_SYSMODALON   (4)
#define HC_NOREMOVE     (3)
#define HC_NOREM HC_NOREMOVE

/* keybd_event */
#define KEYEVENTF_EXTENDEDKEY   (1)
#define KEYEVENTF_KEYUP (2)

/* LoadBitmap */
#define OBM_BTNCORNERS  (32758)
#define OBM_BTSIZE      (32761)
#define OBM_CHECK       (32760)
#define OBM_CHECKBOXES  (32759)
#define OBM_CLOSE       (32754)
#define OBM_COMBO       (32738)
#define OBM_DNARROW     (32752)
#define OBM_DNARROWD    (32742)
#define OBM_DNARROWI    (32736)
#define OBM_LFARROW     (32750)
#define OBM_LFARROWI    (32734)
#define OBM_LFARROWD    (32740)
#define OBM_MNARROW     (32739)
#define OBM_OLD_CLOSE   (32767)
#define OBM_OLD_DNARROW (32764)
#define OBM_OLD_LFARROW (32762)
#define OBM_OLD_REDUCE  (32757)
#define OBM_OLD_RESTORE (32755)
#define OBM_OLD_RGARROW (32763)
#define OBM_OLD_UPARROW (32765)
#define OBM_OLD_ZOOM    (32756)
#define OBM_REDUCE      (32749)
#define OBM_REDUCED     (32746)
#define OBM_RESTORE     (32747)
#define OBM_RESTORED    (32744)
#define OBM_RGARROW     (32751)
#define OBM_RGARROWD    (32741)
#define OBM_RGARROWI    (32735)
#define OBM_SIZE        (32766)
#define OBM_UPARROW     (32753)
#define OBM_UPARROWD    (32743)
#define OBM_UPARROWI    (32737)
#define OBM_ZOOM        (32748)
#define OBM_ZOOMD       (32745)

/* LoadLibraryEx */
#define DONT_RESOLVE_DLL_REFERENCES     (1)
#define LOAD_LIBRARY_AS_DATAFILE        (2)
#define LOAD_WITH_ALTERED_SEARCH_PATH   (8)

/* LocalAlloc, LocalFlags */
#define LPTR    (64)
#define LHND    (66)
#define NONZEROLHND     (2)
#define NONZEROLPTR     (0)
#define LMEM_NONZEROLHND        (2)
#define LMEM_NONZEROLPTR        (0)
#define LMEM_FIXED      (0)
#define LMEM_MOVEABLE   (2)
#define LMEM_NOCOMPACT  (16)
#define LMEM_NODISCARD  (32)
#define LMEM_ZEROINIT   (64)
#define LMEM_MODIFY     (128)
#define LMEM_LOCKCOUNT  (255)
#define LMEM_DISCARDABLE        (3840)
#define LMEM_DISCARDED  (16384)
#define LMEM_INVALID_HANDLE     (32768)

/* LockFileEx */
#define LOCKFILE_FAIL_IMMEDIATELY       (1)
#define LOCKFILE_EXCLUSIVE_LOCK (2)

/* LogonUser */

/* LZCopy, LZInit, LZRead */

/* MessageBeep, MessageBox */
#define MB_USERICON     (0x80L)
#define MB_ICONASTERISK (0x40L)
#define MB_ICONEXCLAMATION      (0x30L)
#define MB_ICONWARNING  (0x30L)
#define MB_ICONERROR    (0x10L)
#define MB_ICONHAND     (0x10L)
#define MB_ICONQUESTION (0x20L)
#define MB_OK   (0L)
#define MB_ABORTRETRYIGNORE     (0x2L)
#define MB_APPLMODAL    (0L)
#define MB_DEFAULT_DESKTOP_ONLY (0x20000L)
#define MB_HELP (0x4000L)
#define MB_RIGHT        (0x80000L)
#define MB_RTLREADING   (0x100000L)
#define MB_TOPMOST      (0x40000L)
#define MB_DEFBUTTON1   (0L)
#define MB_DEFBUTTON2   (0x100L)
#define MB_DEFBUTTON3   (0x200L)
#define MB_DEFBUTTON4   (0x300L)
#define MB_ICONINFORMATION      (0x40L)
#define MB_ICONSTOP     (0x10L)
#define MB_OKCANCEL     (0x1L)
#define MB_RETRYCANCEL  (0x5L)
#define MB_SERVICE_NOTIFICATION (0x40000L)
#define MB_SETFOREGROUND        (0x10000L)
#define MB_SYSTEMMODAL  (0x1000L)
#define MB_TASKMODAL    (0x2000L)
#define MB_YESNO        (0x4L)
#define MB_YESNOCANCEL  (0x3L)
#define IDABORT (3)
#define IDCANCEL        (2)
#define IDCLOSE (8)
#define IDHELP  (9)
#define IDIGNORE        (5)
#define IDNO    (7)
#define IDOK    (1)
#define IDRETRY (4)
#define IDYES   (6)

/* MessageProc */
#define MSGF_DIALOGBOX  (0)
#define MSGF_MENU       (2)
#define MSGF_MOVE                (3)
#define MSGF_NEXTWINDOW (6)
#define MSGF_SCROLLBAR  (5)
#define MSGF_MAINLOOP   (8)
#define MSGF_SIZE                (4)
#define MSGF_USER       (4096)

/* ModifyWorldTransform */
#define MWT_IDENTITY    (1)
#define MWT_LEFTMULTIPLY        (2)
#define MWT_RIGHTMULTIPLY       (3)

/* mouse_event */
#define MOUSEEVENTF_ABSOLUTE    (32768)
#define MOUSEEVENTF_MOVE        (1)
#define MOUSEEVENTF_LEFTDOWN    (2)
#define MOUSEEVENTF_LEFTUP      (4)
#define MOUSEEVENTF_RIGHTDOWN   (8)
#define MOUSEEVENTF_RIGHTUP     (16)
#define MOUSEEVENTF_MIDDLEDOWN  (32)
#define MOUSEEVENTF_MIDDLEUP    (64)

/* MoveFileEx */
#define MOVEFILE_REPLACE_EXISTING       (1)
#define MOVEFILE_COPY_ALLOWED   (2)
#define MOVEFILE_DELAY_UNTIL_REBOOT     (4)

/* MsgWaitForMultipleObjects, WaitForMultipleObjectsEx */
#define WAIT_OBJECT_0   (0L)
#define WAIT_ABANDONED_0        (0x80L)
#ifndef WAIT_TIMEOUT
#define WAIT_TIMEOUT    (0x102L)
#endif
#define WAIT_IO_COMPLETION      (0xc0L)
#define WAIT_ABANDONED  (0x80L)
#define WAIT_FAILED     (0xffffffffL)
#define MAXIMUM_WAIT_OBJECTS    (0x40)
#define MAXIMUM_SUSPEND_COUNT   (0x7f)

/* MultiByteToWideChar */
#define MB_PRECOMPOSED  (1)
#define MB_COMPOSITE    (2)
#define MB_ERR_INVALID_CHARS    (8)
#define MB_USEGLYPHCHARS        (4)

/* NDdeSetTrustedShare */

/* NetAccessCheck */

/* NetServerEnum */

/* NetServiceControl */

/* NetUserEnum */

/* OpenProcessToken */
#define TOKEN_ADJUST_DEFAULT    (128)
#define TOKEN_ADJUST_GROUPS     (64)
#define TOKEN_ADJUST_PRIVILEGES (32)
#define TOKEN_ALL_ACCESS        (0xf00ffL)
#define TOKEN_ASSIGN_PRIMARY    (1)
#define TOKEN_DUPLICATE (2)
#define TOKEN_EXECUTE   (0x20000L)
#define TOKEN_IMPERSONATE       (4)
#define TOKEN_QUERY     (8)
#define TOKEN_QUERY_SOURCE      (16)
#define TOKEN_READ      (0x20008L)
#define TOKEN_WRITE     (0x200e0L)

/* OpenSCManager */
#define SC_MANAGER_ALL_ACCESS   (0xf003fL)
#define SC_MANAGER_CONNECT      (1)
#define SC_MANAGER_CREATE_SERVICE       (2)
#define SC_MANAGER_ENUMERATE_SERVICE    (4)
#define SC_MANAGER_LOCK (8)
#define SC_MANAGER_QUERY_LOCK_STATUS    (16)
#define SC_MANAGER_MODIFY_BOOT_CONFIG   (32)

/* PostMessage */
#define HWND_BROADCAST  ((HWND)0xFFFF)

/* PrepareTape */
#define TAPE_FORMAT     (0x5L)
#define TAPE_LOAD       (0L)
#define TAPE_LOCK       (0x3L)
#define TAPE_TENSION    (0x2L)
#define TAPE_UNLOAD     (0x1L)
#define TAPE_UNLOCK     (0x4L)

/* PropertySheet */
#define IS_PSREBOOTSYSTEM       (3)
#define IS_PSRESTARTWINDOWS     (2)

/* PropSheetPageProc */
#define PSPCB_CREATE    (2)
#define PSPCB_RELEASE   (1)

/* PurgeComm */
#define PURGE_TXABORT   (1)
#define PURGE_RXABORT   (2)
#define PURGE_TXCLEAR   (4)
#define PURGE_RXCLEAR   (8)

/* QueryServiceObjectSecurity */
#define OWNER_SECURITY_INFORMATION      (0x1L)
#define GROUP_SECURITY_INFORMATION      (0x2L)
#define DACL_SECURITY_INFORMATION       (0x4L)
#define SACL_SECURITY_INFORMATION       (0x8L)

/* ReadEventLog, ReportEvent */
#define EVENTLOG_FORWARDS_READ  (4)
#define EVENTLOG_BACKWARDS_READ (8)
#define EVENTLOG_SEEK_READ      (2)
#define EVENTLOG_SEQUENTIAL_READ        (1)
#define EVENTLOG_ERROR_TYPE     (1)
#define EVENTLOG_WARNING_TYPE   (2)
#define EVENTLOG_INFORMATION_TYPE       (4)
#define EVENTLOG_AUDIT_SUCCESS  (8)
#define EVENTLOG_AUDIT_FAILURE  (16)

/* RedrawWindow */
#define RDW_ERASE       (4)
#define RDW_FRAME       (1024)
#define RDW_INTERNALPAINT       (2)
#define RDW_INVALIDATE  (1)
#define RDW_NOERASE     (32)
#define RDW_NOFRAME     (2048)
#define RDW_NOINTERNALPAINT     (16)
#define RDW_VALIDATE    (8)
#define RDW_ERASENOW    (512)
#define RDW_UPDATENOW   (256)
#define RDW_ALLCHILDREN (128)
#define RDW_NOCHILDREN  (64)

/* RegCreateKey */
#define HKEY_CLASSES_ROOT       ((HKEY)0x80000000)
#define HKEY_CURRENT_USER       ((HKEY)0x80000001)
#define HKEY_LOCAL_MACHINE      ((HKEY)0x80000002)
#define HKEY_USERS              ((HKEY)0x80000003)
#define HKEY_PERFORMANCE_DATA   ((HKEY)0x80000004)
#define HKEY_CURRENT_CONFIG     ((HKEY)0x80000005)
#define HKEY_DYN_DATA           ((HKEY)0x80000006)

/* RegCreateKeyEx */
#define REG_OPTION_VOLATILE     (0x1L)
#define REG_OPTION_NON_VOLATILE (0L)
#define REG_CREATED_NEW_KEY     (0x1L)
#define REG_OPENED_EXISTING_KEY (0x2L)

/* RegEnumValue */
#define REG_BINARY      (3)
#define REG_DWORD       (4)
#define REG_DWORD_LITTLE_ENDIAN (4)
#define REG_DWORD_BIG_ENDIAN    (5)
#define REG_EXPAND_SZ   (2)
#define REG_LINK        (6)
#define REG_MULTI_SZ    (7)
#define REG_NONE        (0)
#define REG_RESOURCE_LIST       (8)
#define REG_SZ  (1)

/* RegisterHotKey */
#define MOD_ALT (1)
#define MOD_CONTROL     (2)
#define MOD_SHIFT       (4)
#define MOD_WIN (8)
#define IDHOT_SNAPDESKTOP       (-2)
#define IDHOT_SNAPWINDOW        (-1)

/* RegNotifyChangeKeyValue */
#define REG_NOTIFY_CHANGE_NAME  (0x1L)
#define REG_NOTIFY_CHANGE_ATTRIBUTES    (0x2L)
#define REG_NOTIFY_CHANGE_LAST_SET      (0x4L)
#define REG_NOTIFY_CHANGE_SECURITY      (0x8L)

/* ScrollWindowEx */
#define SW_ERASE        (4)
#define SW_INVALIDATE   (2)
#define SW_SCROLLCHILDREN       (1)

/* SendMessageTimeout */
#define SMTO_ABORTIFHUNG        (2)
#define SMTO_BLOCK      (1)
#define SMTO_NORMAL     (0)

/* SetBkMode */
#define OPAQUE  (2)
#define TRANSPARENT     (1)

/* SetDebugErrorLevel */
#define SLE_ERROR       (1)
#define SLE_MINORERROR  (2)
#define SLE_WARNING     (3)

/* SetErrorMode */
#define SEM_FAILCRITICALERRORS  (1)
#define SEM_NOALIGNMENTFAULTEXCEPT      (4)
#define SEM_NOGPFAULTERRORBOX   (2)
#define SEM_NOOPENFILEERRORBOX  (32768)

/* SetICMMode */
#define ICM_ON  (2)
#define ICM_OFF (1)
#define ICM_QUERY       (3)

/* SetJob */

/* Locale Information */
#define LOCALE_ILANGUAGE        (1)
#define LOCALE_SLANGUAGE        (2)
#define LOCALE_SENGLANGUAGE     (4097)
#define LOCALE_SABBREVLANGNAME  (3)
#define LOCALE_SNATIVELANGNAME  (4)
#define LOCALE_ICOUNTRY (5)
#define LOCALE_SCOUNTRY (6)
#define LOCALE_SENGCOUNTRY      (4098)
#define LOCALE_SABBREVCTRYNAME  (7)
#define LOCALE_SNATIVECTRYNAME  (8)
#define LOCALE_IDEFAULTLANGUAGE (9)
#define LOCALE_IDEFAULTCOUNTRY  (10)
#define LOCALE_IDEFAULTANSICODEPAGE     (4100)
#define LOCALE_IDEFAULTCODEPAGE (11)
#define LOCALE_SLIST    (12)
#define LOCALE_IMEASURE (13)
#define LOCALE_SDECIMAL (14)
#define LOCALE_STHOUSAND        (15)
#define LOCALE_SGROUPING        (16)
#define LOCALE_IDIGITS  (17)
#define LOCALE_ILZERO   (18)
#define LOCALE_INEGNUMBER       (4112)
#define LOCALE_SCURRENCY        (20)
#define LOCALE_SINTLSYMBOL      (21)
#define LOCALE_SMONDECIMALSEP   (22)
#define LOCALE_SMONTHOUSANDSEP  (23)
#define LOCALE_SMONGROUPING     (24)
#define LOCALE_ICURRDIGITS      (25)
#define LOCALE_IINTLCURRDIGITS  (26)
#define LOCALE_ICURRENCY        (27)
#define LOCALE_INEGCURR (28)
#define LOCALE_SDATE    (29)
#define LOCALE_STIME    (30)
#define LOCALE_STIMEFORMAT      (4099)
#define LOCALE_SSHORTDATE       (31)
#define LOCALE_SLONGDATE        (32)
#define LOCALE_IDATE    (33)
#define LOCALE_ILDATE   (34)
#define LOCALE_ITIME    (35)
#define LOCALE_ITLZERO  (37)
#define LOCALE_IDAYLZERO        (38)
#define LOCALE_IMONLZERO        (39)
#define LOCALE_S1159    (40)
#define LOCALE_S2359    (41)
#define LOCALE_ICALENDARTYPE    (4105)
#define LOCALE_IOPTIONALCALENDAR        (4107)
#define LOCALE_IFIRSTDAYOFWEEK  (4108)
#define LOCALE_IFIRSTWEEKOFYEAR (4109)
#define LOCALE_SDAYNAME1        (42)
#define LOCALE_SDAYNAME2        (43)
#define LOCALE_SDAYNAME3        (44)
#define LOCALE_SDAYNAME4        (45)
#define LOCALE_SDAYNAME5        (46)
#define LOCALE_SDAYNAME6        (47)
#define LOCALE_SDAYNAME7        (48)
#define LOCALE_SABBREVDAYNAME1  (49)
#define LOCALE_SABBREVDAYNAME2  (50)
#define LOCALE_SABBREVDAYNAME3  (51)
#define LOCALE_SABBREVDAYNAME4  (52)
#define LOCALE_SABBREVDAYNAME5  (53)
#define LOCALE_SABBREVDAYNAME6  (54)
#define LOCALE_SABBREVDAYNAME7  (55)
#define LOCALE_SMONTHNAME1      (56)
#define LOCALE_SMONTHNAME2      (57)
#define LOCALE_SMONTHNAME3      (58)
#define LOCALE_SMONTHNAME4      (59)
#define LOCALE_SMONTHNAME5      (60)
#define LOCALE_SMONTHNAME6      (61)
#define LOCALE_SMONTHNAME7      (62)
#define LOCALE_SMONTHNAME8      (63)
#define LOCALE_SMONTHNAME9      (64)
#define LOCALE_SMONTHNAME10     (65)
#define LOCALE_SMONTHNAME11     (66)
#define LOCALE_SMONTHNAME12     (67)
#define LOCALE_SMONTHNAME13     (4110)
#define LOCALE_SABBREVMONTHNAME1        (68)
#define LOCALE_SABBREVMONTHNAME2        (69)
#define LOCALE_SABBREVMONTHNAME3        (70)
#define LOCALE_SABBREVMONTHNAME4        (71)
#define LOCALE_SABBREVMONTHNAME5        (72)
#define LOCALE_SABBREVMONTHNAME6        (73)
#define LOCALE_SABBREVMONTHNAME7        (74)
#define LOCALE_SABBREVMONTHNAME8        (75)
#define LOCALE_SABBREVMONTHNAME9        (76)
#define LOCALE_SABBREVMONTHNAME10       (77)
#define LOCALE_SABBREVMONTHNAME11       (78)
#define LOCALE_SABBREVMONTHNAME12       (79)
#define LOCALE_SABBREVMONTHNAME13       (4111)
#define LOCALE_SPOSITIVESIGN    (80)
#define LOCALE_SNEGATIVESIGN    (81)
#define LOCALE_IPOSSIGNPOSN     (82)
#define LOCALE_INEGSIGNPOSN     (83)
#define LOCALE_IPOSSYMPRECEDES  (84)
#define LOCALE_IPOSSEPBYSPACE   (85)
#define LOCALE_INEGSYMPRECEDES  (86)
#define LOCALE_INEGSEPBYSPACE   (87)
#define LOCALE_FONTSIGNATURE    (88)
#define LOCALE_SISO639LANGNAME  (89)
#define LOCALE_SISO3166CTRYNAME (90)
#define LOCALE_NOUSEROVERRIDE   (0x80000000)

/* Calendar Type Information */
#define CAL_ICALINTVALUE        (1)
#define CAL_IYEAROFFSETRANGE    (3)
#define CAL_SABBREVDAYNAME1     (14)
#define CAL_SABBREVDAYNAME2     (15)
#define CAL_SABBREVDAYNAME3     (16)
#define CAL_SABBREVDAYNAME4     (17)
#define CAL_SABBREVDAYNAME5     (18)
#define CAL_SABBREVDAYNAME6     (19)
#define CAL_SABBREVDAYNAME7     (20)
#define CAL_SABBREVMONTHNAME1   (34)
#define CAL_SABBREVMONTHNAME2   (35)
#define CAL_SABBREVMONTHNAME3   (36)
#define CAL_SABBREVMONTHNAME4   (37)
#define CAL_SABBREVMONTHNAME5   (38)
#define CAL_SABBREVMONTHNAME6   (39)
#define CAL_SABBREVMONTHNAME7   (40)
#define CAL_SABBREVMONTHNAME8   (41)
#define CAL_SABBREVMONTHNAME9   (42)
#define CAL_SABBREVMONTHNAME10  (43)
#define CAL_SABBREVMONTHNAME11  (44)
#define CAL_SABBREVMONTHNAME12  (45)
#define CAL_SABBREVMONTHNAME13  (46)
#define CAL_SCALNAME    (2)
#define CAL_SDAYNAME1   (7)
#define CAL_SDAYNAME2   (8)
#define CAL_SDAYNAME3   (9)
#define CAL_SDAYNAME4   (10)
#define CAL_SDAYNAME5   (11)
#define CAL_SDAYNAME6   (12)
#define CAL_SDAYNAME7   (13)
#define CAL_SERASTRING  (4)
#define CAL_SLONGDATE   (6)
#define CAL_SMONTHNAME1 (21)
#define CAL_SMONTHNAME2 (22)
#define CAL_SMONTHNAME3 (23)
#define CAL_SMONTHNAME4 (24)
#define CAL_SMONTHNAME5 (25)
#define CAL_SMONTHNAME6 (26)
#define CAL_SMONTHNAME7 (27)
#define CAL_SMONTHNAME8 (28)
#define CAL_SMONTHNAME9 (29)
#define CAL_SMONTHNAME10        (30)
#define CAL_SMONTHNAME11        (31)
#define CAL_SMONTHNAME12        (32)
#define CAL_SMONTHNAME13        (33)
#define CAL_SSHORTDATE  (5)

/* SetProcessWorkingSetSize */
#define PROCESS_SET_QUOTA       (256)

/* SetPrinter */

/* SetService */

/* SetStretchBltMode */
#define BLACKONWHITE    (1)
#define COLORONCOLOR    (3)
#define HALFTONE        (4)
#define STRETCH_ANDSCANS        (1)
#define STRETCH_DELETESCANS     (3)
#define STRETCH_HALFTONE        (4)
#define STRETCH_ORSCANS (2)
#define WHITEONBLACK    (2)

/* SetSystemCursor */
#define OCR_NORMAL      (32512)
#define OCR_IBEAM       (32513)
#define OCR_WAIT        (32514)
#define OCR_CROSS       (32515)
#define OCR_UP  (32516)
#define OCR_SIZE        (32640)
#define OCR_ICON        (32641)
#define OCR_SIZENWSE    (32642)
#define OCR_SIZENESW    (32643)
#define OCR_SIZEWE      (32644)
#define OCR_SIZENS      (32645)
#define OCR_SIZEALL     (32646)
#define OCR_NO  (32648)
#define OCR_APPSTARTING (32650)

/* SetTapePosition */
#define TAPE_ABSOLUTE_BLOCK     (0x1L)
#define TAPE_LOGICAL_BLOCK      (0x2L)
#define TAPE_REWIND     (0L)
#define TAPE_SPACE_END_OF_DATA  (0x4L)
#define TAPE_SPACE_FILEMARKS    (0x6L)
#define TAPE_SPACE_RELATIVE_BLOCKS      (0x5L)
#define TAPE_SPACE_SEQUENTIAL_FMKS      (0x7L)
#define TAPE_SPACE_SEQUENTIAL_SMKS      (0x9L)
#define TAPE_SPACE_SETMARKS     (0x8L)

/* SetUnhandledExceptionFilter */
#define EXCEPTION_EXECUTE_HANDLER       (1)
#define EXCEPTION_CONTINUE_EXECUTION    (-1)
#define EXCEPTION_CONTINUE_SEARCH       (0)

/* SetWindowPos, DeferWindowPos */
#define HWND_BOTTOM     ((HWND)1)
#define HWND_NOTOPMOST  ((HWND)-2)
#define HWND_TOP        ((HWND)0)
#define HWND_TOPMOST    ((HWND)-1)
#define SWP_DRAWFRAME   (32)
#define SWP_FRAMECHANGED        (32)
#define SWP_HIDEWINDOW  (128)
#define SWP_NOACTIVATE  (16)
#define SWP_NOCOPYBITS  (256)
#define SWP_NOMOVE      (2)
#define SWP_NOSIZE      (1)
#define SWP_NOREDRAW    (8)
#define SWP_NOZORDER    (4)
#define SWP_SHOWWINDOW  (64)
#define SWP_NOOWNERZORDER       (512)
#define SWP_NOREPOSITION        (512)
#define SWP_NOSENDCHANGING      (1024)

/* ShowWindow */
#define SW_HIDE (0)
#define SW_MAXIMIZE     (3)
#define SW_MINIMIZE     (6)
#define SW_NORMAL       (1)
#define SW_RESTORE      (9)
#define SW_SHOW (5)
#define SW_SHOWDEFAULT  (10)
#define SW_SHOWMAXIMIZED        (3)
#define SW_SHOWMINIMIZED        (2)
#define SW_SHOWMINNOACTIVE      (7)
#define SW_SHOWNA       (8)
#define SW_SHOWNOACTIVATE       (4)
#define SW_SHOWNORMAL   (1)
#define WPF_RESTORETOMAXIMIZED  (2)
#define WPF_SETMINPOSITION      (1)

/* Sleep */
#define INFINITE        0xFFFFFFFF

/* SystemParametersInfo */
#define SPI_GETACCESSTIMEOUT    (60)
#define SPI_GETANIMATION        (72)
#define SPI_GETBEEP     (1)
#define SPI_GETBORDER   (5)
#define SPI_GETDEFAULTINPUTLANG (89)
#define SPI_GETDRAGFULLWINDOWS  (38)
#define SPI_GETFASTTASKSWITCH   (35)
#define SPI_GETFILTERKEYS       (50)
#define SPI_GETFONTSMOOTHING    (74)
#define SPI_GETGRIDGRANULARITY  (18)
#define SPI_GETHIGHCONTRAST     (66)
#define SPI_GETICONMETRICS      (45)
#define SPI_GETICONTITLELOGFONT (31)
#define SPI_GETICONTITLEWRAP    (25)
#define SPI_GETKEYBOARDDELAY    (22)
#define SPI_GETKEYBOARDPREF     (68)
#define SPI_GETKEYBOARDSPEED    (10)
#define SPI_GETLOWPOWERACTIVE   (83)
#define SPI_GETLOWPOWERTIMEOUT  (79)
#define SPI_GETMENUDROPALIGNMENT        (27)
#define SPI_GETMINIMIZEDMETRICS (43)
#define SPI_GETMOUSE    (3)
#define SPI_GETMOUSEKEYS        (54)
#define SPI_GETMOUSETRAILS      (94)
#define SPI_GETNONCLIENTMETRICS (41)
#define SPI_GETPOWEROFFACTIVE   (84)
#define SPI_GETPOWEROFFTIMEOUT  (80)
#define SPI_GETSCREENREADER     (70)
#define SPI_GETSCREENSAVEACTIVE (16)
#define SPI_GETSCREENSAVETIMEOUT        (14)
#define SPI_GETSERIALKEYS       (62)
#define SPI_GETSHOWSOUNDS       (56)
#define SPI_GETSOUNDSENTRY      (64)
#define SPI_GETSTICKYKEYS       (58)
#define SPI_GETTOGGLEKEYS       (52)
#define SPI_GETWINDOWSEXTENSION (92)
#define SPI_GETWORKAREA (48)
#define SPI_ICONHORIZONTALSPACING       (13)
#define SPI_ICONVERTICALSPACING (24)
#define SPI_LANGDRIVER  (12)
#define SPI_SCREENSAVERRUNNING  (97)
#define SPI_SETACCESSTIMEOUT    (61)
#define SPI_SETANIMATION        (73)
#define SPI_SETBEEP     (2)
#define SPI_SETBORDER   (6)
#define SPI_SETDEFAULTINPUTLANG (90)
#define SPI_SETDESKPATTERN      (21)
#define SPI_SETDESKWALLPAPER    (20)
#define SPI_SETDOUBLECLICKTIME  (32)
#define SPI_SETDOUBLECLKHEIGHT  (30)
#define SPI_SETDOUBLECLKWIDTH   (29)
#define SPI_SETDRAGFULLWINDOWS  (37)
#define SPI_SETDRAGHEIGHT       (77)
#define SPI_SETDRAGWIDTH        (76)
#define SPI_SETFASTTASKSWITCH   (36)
#define SPI_SETFILTERKEYS       (51)
#define SPI_SETFONTSMOOTHING    (75)
#define SPI_SETGRIDGRANULARITY  (19)
#define SPI_SETHANDHELD (78)
#define SPI_SETHIGHCONTRAST     (67)
#define SPI_SETICONMETRICS      (46)
#define SPI_SETICONTITLELOGFONT (34)
#define SPI_SETICONTITLEWRAP    (26)
#define SPI_SETKEYBOARDDELAY    (23)
#define SPI_SETKEYBOARDPREF     (69)
#define SPI_SETKEYBOARDSPEED    (11)
#define SPI_SETLANGTOGGLE       (91)
#define SPI_SETLOWPOWERACTIVE   (85)
#define SPI_SETLOWPOWERTIMEOUT  (81)
#define SPI_SETMENUDROPALIGNMENT        (28)
#define SPI_SETMINIMIZEDMETRICS (44)
#define SPI_SETMOUSE    (4)
#define SPI_SETMOUSEBUTTONSWAP  (33)
#define SPI_SETMOUSEKEYS        (55)
#define SPI_SETMOUSETRAILS      (93)
#define SPI_SETNONCLIENTMETRICS (42)
#define SPI_SETPENWINDOWS       (49)
#define SPI_SETPOWEROFFACTIVE   (86)
#define SPI_SETPOWEROFFTIMEOUT  (82)
#define SPI_SETSCREENREADER     (71)
#define SPI_SETSCREENSAVEACTIVE (17)
#define SPI_SETSCREENSAVETIMEOUT        (15)
#define SPI_SETSERIALKEYS       (63)
#define SPI_SETSHOWSOUNDS       (57)
#define SPI_SETSOUNDSENTRY      (65)
#define SPI_SETSTICKYKEYS       (59)
#define SPI_SETTOGGLEKEYS       (53)
#define SPI_SETWORKAREA (47)
#define SPIF_UPDATEINIFILE      (1)
#define SPIF_SENDWININICHANGE   (2)
#define SPIF_SENDCHANGE (2)

/* TrackPopupMenu, TrackPopMenuEx */
#define TPM_BOTTOMALIGN (0x20L)
#define TPM_CENTERALIGN (0x4L)
#define TPM_LEFTALIGN   (0L)
#define TPM_RIGHTALIGN  (0x8L)
#define TPM_TOPALIGN        (0L)
#define TPM_VCENTERALIGN    (0x10L)
#define TPM_LEFTBUTTON  (0L)
#define TPM_RIGHTBUTTON (0x2L)
#define TPM_HORIZONTAL  (0L)
#define TPM_VERTICAL    (0x40L)
#define TPM_NONOTIFY        (0x80L)
#define TPM_RETURNCMD       (0x100L)

/* TranslateCharsetInfo */
#define TCI_SRCCHARSET  (1)
#define TCI_SRCCODEPAGE (2)
#define TCI_SRCFONTSIG  (3)

/* VerFindFile */
#define VFFF_ISSHAREDFILE       (1)
#define VFF_CURNEDEST   (1)
#define VFF_FILEINUSE   (2)
#define VFF_BUFFTOOSMALL        (4)

/* VerInstallFile */
#define VIFF_FORCEINSTALL       (1)
#define VIFF_DONTDELETEOLD      (2)
#define VIF_TEMPFILE    (0x1L)
#define VIF_MISMATCH    (0x2L)
#define VIF_SRCOLD      (0x4L)
#define VIF_DIFFLANG    (0x8L)
#define VIF_DIFFCODEPG  (0x10L)
#define VIF_DIFFTYPE    (0x20L)
#define VIF_WRITEPROT   (0x40L)
#define VIF_FILEINUSE   (0x80L)
#define VIF_OUTOFSPACE  (0x100L)
#define VIF_ACCESSVIOLATION     (0x200L)
#define VIF_SHARINGVIOLATION    (0x400L)
#define VIF_CANNOTCREATE        (0x800L)
#define VIF_CANNOTDELETE        (0x1000L)
#define VIF_CANNOTDELETECUR     (0x4000L)
#define VIF_CANNOTRENAME        (0x2000L)
#define VIF_OUTOFMEMORY (0x8000L)
#define VIF_CANNOTREADSRC       (0x10000L)
#define VIF_CANNOTREADDST       (0x20000L)
#define VIF_BUFFTOOSMALL        (0x40000L)

/* WideCharToMultiByte */
#define WC_COMPOSITECHECK       (512)
#define WC_DISCARDNS    (16)
#define WC_SEPCHARS     (32)
#define WC_DEFAULTCHAR  (64)

/* WinHelp */
#define HELP_COMMAND    (0x102L)
#define HELP_CONTENTS   (0x3L)
#define HELP_CONTEXT    (0x1L)
#define HELP_CONTEXTPOPUP       (0x8L)
#define HELP_FORCEFILE  (0x9L)
#define HELP_HELPONHELP (0x4L)
#define HELP_INDEX      (0x3L)
#define HELP_KEY        (0x101L)
#define HELP_MULTIKEY   (0x201L)
#define HELP_PARTIALKEY (0x105L)
#define HELP_QUIT       (0x2L)
#define HELP_SETCONTENTS        (0x5L)
#define HELP_SETINDEX   (0x5L)
#define HELP_CONTEXTMENU        (0xa)
#define HELP_FINDER     (0xb)
#define HELP_WM_HELP    (0xc)
#define HELP_TCARD      (0x8000)
#define HELP_TCARD_DATA (0x10)
#define HELP_TCARD_OTHER_CALLER (0x11)

/* WNetAddConnectino2 */
#define CONNECT_UPDATE_PROFILE  (1)

/* WNetConnectionDialog, WNetDisconnectDialog, WNetOpenEnum */
#define RESOURCETYPE_DISK       (1)
#define RESOURCETYPE_PRINT      (2)
#define RESOURCETYPE_ANY        (0)
#define RESOURCE_CONNECTED      (1)
#define RESOURCE_GLOBALNET      (2)
#define RESOURCE_REMEMBERED     (3)
#define RESOURCE_RECENT     (4)
#define RESOURCE_CONTEXT    (5)
#define RESOURCEUSAGE_CONNECTABLE       (1)
#define RESOURCEUSAGE_CONTAINER (2)

#define SP_NOTREPORTED               (16384)
#define SP_ERROR                     (-1)
#define SP_APPABORT                  (-2)
#define SP_USERABORT                 (-3)
#define SP_OUTOFDISK                 (-4)
#define SP_OUTOFMEMORY               (-5)

#define PR_JOBSTATUS                 (0)

/* WNetGetResourceInformation, WNetGetResourceParent */
#define WN_BAD_NETNAME  (0x43L)
#define WN_EXTENDED_ERROR       (0x4b8L)
#define WN_MORE_DATA    (0xeaL)
#define WN_NO_NETWORK   (0x4c6L)
#define WN_SUCCESS      (0L)
#define WN_ACCESS_DENIED        (0x5L)
#define WN_BAD_PROVIDER (0x4b4L)
#define WN_NOT_AUTHENTICATED    (0x4dcL)

/* WNetGetUniversalName */
#define UNIVERSAL_NAME_INFO_LEVEL       (1)
#define REMOTE_NAME_INFO_LEVEL  (2)

/* GetExitCodeThread */
#define STILL_ACTIVE    (0x103L)

/* COMMPROP structure */
#define SP_SERIALCOMM   (0x1L)
#define BAUD_075        (0x1L)
#define BAUD_110        (0x2L)
#define BAUD_134_5      (0x4L)
#define BAUD_150        (0x8L)
#define BAUD_300        (0x10L)
#define BAUD_600        (0x20L)
#define BAUD_1200       (0x40L)
#define BAUD_1800       (0x80L)
#define BAUD_2400       (0x100L)
#define BAUD_4800       (0x200L)
#define BAUD_7200       (0x400L)
#define BAUD_9600       (0x800L)
#define BAUD_14400      (0x1000L)
#define BAUD_19200      (0x2000L)
#define BAUD_38400      (0x4000L)
#define BAUD_56K        (0x8000L)
#define BAUD_57600      (0x40000L)
#define BAUD_115200     (0x20000L)
#define BAUD_128K       (0x10000L)
#define BAUD_USER       (0x10000000L)
#define PST_FAX (0x21L)
#define PST_LAT (0x101L)
#define PST_MODEM       (0x6L)
#define PST_NETWORK_BRIDGE      (0x100L)
#define PST_PARALLELPORT        (0x2L)
#define PST_RS232       (0x1L)
#define PST_RS422       (0x3L)
#define PST_RS423       (0x4L)
#define PST_RS449       (0x5L)
#define PST_SCANNER     (0x22L)
#define PST_TCPIP_TELNET        (0x102L)
#define PST_UNSPECIFIED (0L)
#define PST_X25 (0x103L)
#define PCF_16BITMODE   (0x200L)
#define PCF_DTRDSR      (0x1L)
#define PCF_INTTIMEOUTS (0x80L)
#define PCF_PARITY_CHECK        (0x8L)
#define PCF_RLSD        (0x4L)
#define PCF_RTSCTS      (0x2L)
#define PCF_SETXCHAR    (0x20L)
#define PCF_SPECIALCHARS        (0x100L)
#define PCF_TOTALTIMEOUTS       (0x40L)
#define PCF_XONXOFF     (0x10L)
#define SP_BAUD (0x2L)
#define SP_DATABITS     (0x4L)
#define SP_HANDSHAKING  (0x10L)
#define SP_PARITY       (0x1L)
#define SP_PARITY_CHECK (0x20L)
#define SP_RLSD (0x40L)
#define SP_STOPBITS     (0x8L)
#define DATABITS_5      (1)
#define DATABITS_6      (2)
#define DATABITS_7      (4)
#define DATABITS_8      (8)
#define DATABITS_16     (16)
#define DATABITS_16X    (32)
#define STOPBITS_10     (1)
#define STOPBITS_15     (2)
#define STOPBITS_20     (4)
#define PARITY_NONE     (256)
#define PARITY_ODD      (512)
#define PARITY_EVEN     (1024)
#define PARITY_MARK     (2048)
#define PARITY_SPACE    (4096)
#define COMMPROP_INITIALIZED    (0xe73cf52eL)

/* DCB structure */
#define CBR_110 (110)
#define CBR_300 (300)
#define CBR_600 (600)
#define CBR_1200        (1200)
#define CBR_2400        (2400)
#define CBR_4800        (4800)
#define CBR_9600        (9600)
#define CBR_14400       (14400)
#define CBR_19200       (19200)
#define CBR_38400       (38400)
#define CBR_56000       (56000)
#define CBR_57600       (57600)
#define CBR_115200      (115200)
#define CBR_128000      (128000)
#define CBR_256000      (256000)
#define DTR_CONTROL_DISABLE     (0)
#define DTR_CONTROL_ENABLE      (1)
#define DTR_CONTROL_HANDSHAKE   (2)
#define RTS_CONTROL_DISABLE     (0)
#define RTS_CONTROL_ENABLE      (1)
#define RTS_CONTROL_HANDSHAKE   (2)
#define RTS_CONTROL_TOGGLE      (3)
#define EVENPARITY      (2)
#define MARKPARITY      (3)
#define NOPARITY        (0)
#define ODDPARITY       (1)
#define SPACEPARITY     (4)
#define ONESTOPBIT      (0)
#define ONE5STOPBITS    (1)
#define TWOSTOPBITS     (2)

/* Debugging events */
#define CREATE_PROCESS_DEBUG_EVENT      (3)
#define CREATE_THREAD_DEBUG_EVENT       (2)
#define EXCEPTION_DEBUG_EVENT   (1)
#define EXIT_PROCESS_DEBUG_EVENT        (5)
#define EXIT_THREAD_DEBUG_EVENT (4)
#define LOAD_DLL_DEBUG_EVENT    (6)
#define OUTPUT_DEBUG_STRING_EVENT       (8)
#define UNLOAD_DLL_DEBUG_EVENT  (7)
#define RIP_EVENT       (9)

/* PROCESS_HEAP_ENTRY structure */
#define PROCESS_HEAP_REGION     (1)
#define PROCESS_HEAP_UNCOMMITTED_RANGE  (2)
#define PROCESS_HEAP_ENTRY_BUSY (4)
#define PROCESS_HEAP_ENTRY_MOVEABLE     (16)
#define PROCESS_HEAP_ENTRY_DDESHARE     (32)

/* Win32s */
#define HINSTANCE_ERROR (32)

/* WIN32_STREAM_ID structure */
#define BACKUP_DATA     (1)
#define BACKUP_EA_DATA  (2)
#define BACKUP_SECURITY_DATA    (3)
#define BACKUP_ALTERNATE_DATA   (4)
#define BACKUP_LINK     (5)
#define STREAM_MODIFIED_WHEN_READ       (1)
#define STREAM_CONTAINS_SECURITY        (2)

/* STARTUPINFO structure */
#define STARTF_USESHOWWINDOW    (1)
#define STARTF_USEPOSITION      (4)
#define STARTF_USESIZE  (2)
#define STARTF_USECOUNTCHARS    (8)
#define STARTF_USEFILLATTRIBUTE (16)
#define STARTF_RUNFULLSCREEN    (32)
#define STARTF_FORCEONFEEDBACK  (64)
#define STARTF_FORCEOFFFEEDBACK (128)
#define STARTF_USESTDHANDLES    (256)
#define STARTF_USEHOTKEY        (512)

/* OSVERSIONINFO structure */
#define VER_PLATFORM_WIN32s             (0)
#define VER_PLATFORM_WIN32_WINDOWS      (1)
#define VER_PLATFORM_WIN32_NT           (2)

/* VX_FIXEDFILEINFO structure */
#define VS_FILE_INFO    (MAKEINTRESOURCE(16))
#define VS_VERSION_INFO 1

#define VS_FFI_SIGNATURE        (0xFEEF04BDL)
#define VS_FFI_STRUCVERSION     (0x10000L)
#define VS_FFI_FILEFLAGSMASK    (0x3FL)

#define VS_FF_DEBUG             (0x1L)
#define VS_FF_PRERELEASE        (0x2L)
#define VS_FF_PATCHED           (0x4L)
#define VS_FF_PRIVATEBUILD      (0x8L)
#define VS_FF_INFOINFERRED      (0x10L)
#define VS_FF_SPECIALBUILD      (0x20L)

#define VOS_UNKNOWN     (0L)
#define VOS_DOS (0x10000L)
#define VOS_OS216       (0x20000L)
#define VOS_OS232       (0x30000L)
#define VOS_NT  (0x40000L)
#define VOS_DOS_WINDOWS16       (0x10001L)
#define VOS_DOS_WINDOWS32       (0x10004L)
#define VOS_OS216_PM16  (0x20002L)
#define VOS_OS232_PM32  (0x30003L)
#define VOS_NT_WINDOWS32        (0x40004L)
#define VOS__BASE 0
#define VOS__WINDOWS16 1
#define VOS__PM16 2
#define VOS__PM32 3
#define VOS__WINDOWS32 4
#define VFT_UNKNOWN     (0L)
#define VFT_APP (0x1L)
#define VFT_DLL (0x2L)
#define VFT_DRV (0x3L)
#define VFT_FONT        (0x4L)
#define VFT_VXD (0x5L)
#define VFT_STATIC_LIB  (0x7L)
#define VFT2_UNKNOWN    (0L)
#define VFT2_DRV_PRINTER        (0x1L)
#define VFT2_DRV_KEYBOARD       (0x2L)
#define VFT2_DRV_LANGUAGE       (0x3L)
#define VFT2_DRV_DISPLAY        (0x4L)
#define VFT2_DRV_MOUSE  (0x5L)
#define VFT2_DRV_NETWORK        (0x6L)
#define VFT2_DRV_SYSTEM (0x7L)
#define VFT2_DRV_INSTALLABLE    (0x8L)
#define VFT2_DRV_SOUND  (0x9L)
#define VFT2_DRV_COMM 10
#define VFT2_DRV_INPUTMETHOD 11
#define VFT2_FONT_RASTER        (0x1L)
#define VFT2_FONT_VECTOR        (0x2L)
#define VFT2_FONT_TRUETYPE      (0x3L)

/* PANOSE structure */
#define PAN_ANY (0)
#define PAN_NO_FIT      (1)
#define PAN_FAMILY_TEXT_DISPLAY (2)
#define PAN_FAMILY_SCRIPT       (3)
#define PAN_FAMILY_DECORATIVE   (4)
#define PAN_FAMILY_PICTORIAL    (5)
#define PAN_SERIF_COVE  (2)
#define PAN_SERIF_OBTUSE_COVE   (3)
#define PAN_SERIF_SQUARE_COVE   (4)
#define PAN_SERIF_OBTUSE_SQUARE_COVE    (5)
#define PAN_SERIF_SQUARE        (6)
#define PAN_SERIF_THIN  (7)
#define PAN_SERIF_BONE  (8)
#define PAN_SERIF_EXAGGERATED   (9)
#define PAN_SERIF_TRIANGLE      (10)
#define PAN_SERIF_NORMAL_SANS   (11)
#define PAN_SERIF_OBTUSE_SANS   (12)
#define PAN_SERIF_PERP_SANS     (13)
#define PAN_SERIF_FLARED        (14)
#define PAN_SERIF_ROUNDED       (15)
#define PAN_WEIGHT_VERY_LIGHT   (2)
#define PAN_WEIGHT_LIGHT        (3)
#define PAN_WEIGHT_THIN (4)
#define PAN_WEIGHT_BOOK (5)
#define PAN_WEIGHT_MEDIUM       (6)
#define PAN_WEIGHT_DEMI (7)
#define PAN_WEIGHT_BOLD (8)
#define PAN_WEIGHT_HEAVY        (9)
#define PAN_WEIGHT_BLACK        (10)
#define PAN_WEIGHT_NORD (11)
#define PAN_PROP_OLD_STYLE      (2)
#define PAN_PROP_MODERN (3)
#define PAN_PROP_EVEN_WIDTH     (4)
#define PAN_PROP_EXPANDED       (5)
#define PAN_PROP_CONDENSED      (6)
#define PAN_PROP_VERY_EXPANDED  (7)
#define PAN_PROP_VERY_CONDENSED (8)
#define PAN_PROP_MONOSPACED     (9)
#define PAN_CONTRAST_NONE       (2)
#define PAN_CONTRAST_VERY_LOW   (3)
#define PAN_CONTRAST_LOW        (4)
#define PAN_CONTRAST_MEDIUM_LOW (5)
#define PAN_CONTRAST_MEDIUM     (6)
#define PAN_CONTRAST_MEDIUM_HIGH        (7)
#define PAN_CONTRAST_HIGH       (8)
#define PAN_CONTRAST_VERY_HIGH  (9)
#define PAN_STROKE_GRADUAL_DIAG (2)
#define PAN_STROKE_GRADUAL_TRAN (3)
#define PAN_STROKE_GRADUAL_VERT (4)
#define PAN_STROKE_GRADUAL_HORZ (5)
#define PAN_STROKE_RAPID_VERT   (6)
#define PAN_STROKE_RAPID_HORZ   (7)
#define PAN_STROKE_INSTANT_VERT (8)
#define PAN_STRAIGHT_ARMS_HORZ  (2)
#define PAN_STRAIGHT_ARMS_WEDGE (3)
#define PAN_STRAIGHT_ARMS_VERT  (4)
#define PAN_STRAIGHT_ARMS_SINGLE_SERIF  (5)
#define PAN_STRAIGHT_ARMS_DOUBLE_SERIF  (6)
#define PAN_BENT_ARMS_HORZ      (7)
#define PAN_BENT_ARMS_VERT      (9)
#define PAN_BENT_ARMS_WEDGE     (8)
#define PAN_BENT_ARMS_SINGLE_SERIF      (10)
#define PAN_BENT_ARMS_DOUBLE_SERIF      (11)
#define PAN_LETT_NORMAL_CONTACT (2)
#define PAN_LETT_NORMAL_WEIGHTED        (3)
#define PAN_LETT_NORMAL_BOXED   (4)
#define PAN_LETT_NORMAL_FLATTENED       (5)
#define PAN_LETT_NORMAL_ROUNDED (6)
#define PAN_LETT_NORMAL_OFF_CENTER      (7)
#define PAN_LETT_NORMAL_SQUARE  (8)
#define PAN_LETT_OBLIQUE_CONTACT        (9)
#define PAN_LETT_OBLIQUE_WEIGHTED       (10)
#define PAN_LETT_OBLIQUE_BOXED  (11)
#define PAN_LETT_OBLIQUE_FLATTENED      (12)
#define PAN_LETT_OBLIQUE_ROUNDED        (13)
#define PAN_LETT_OBLIQUE_OFF_CENTER     (14)
#define PAN_LETT_OBLIQUE_SQUARE (15)
#define PAN_MIDLINE_STANDARD_TRIMMED    (2)
#define PAN_MIDLINE_STANDARD_POINTED    (3)
#define PAN_MIDLINE_STANDARD_SERIFED    (4)
#define PAN_MIDLINE_HIGH_TRIMMED        (5)
#define PAN_MIDLINE_HIGH_POINTED        (6)
#define PAN_MIDLINE_HIGH_SERIFED        (7)
#define PAN_MIDLINE_CONSTANT_TRIMMED    (8)
#define PAN_MIDLINE_CONSTANT_POINTED    (9)
#define PAN_MIDLINE_CONSTANT_SERIFED    (10)
#define PAN_MIDLINE_LOW_TRIMMED (11)
#define PAN_MIDLINE_LOW_POINTED (12)
#define PAN_MIDLINE_LOW_SERIFED (13)
#define PAN_XHEIGHT_CONSTANT_SMALL      (2)
#define PAN_XHEIGHT_CONSTANT_STD        (3)
#define PAN_XHEIGHT_CONSTANT_LARGE      (4)
#define PAN_XHEIGHT_DUCKING_SMALL       (5)
#define PAN_XHEIGHT_DUCKING_STD (6)
#define PAN_XHEIGHT_DUCKING_LARGE       (7)

/* PALETTENTRY structure */
#define PC_EXPLICIT     (2)
#define PC_NOCOLLAPSE   (4)
#define PC_RESERVED     (1)

/* LOGBRUSH structure */
#define BS_DIBPATTERN   (5)
#define BS_DIBPATTERN8X8        (8)
#define BS_DIBPATTERNPT (6)
#define BS_HATCHED      (2)
#define BS_HOLLOW       (1)
#define BS_NULL (1)
#define BS_PATTERN      (3)
#define BS_PATTERN8X8   (7)
#define BS_SOLID        (0)

/* DEVMODE structure */
#define DM_ORIENTATION  (0x1L)
#define DM_PAPERSIZE    (0x2L)
#define DM_PAPERLENGTH  (0x4L)
#define DM_PAPERWIDTH   (0x8L)
#define DM_SCALE        (0x10L)
#define DM_COPIES       (0x100L)
#define DM_DEFAULTSOURCE        (0x200L)
#define DM_PRINTQUALITY (0x400L)
#define DM_COLOR        (0x800L)
#define DM_DUPLEX       (0x1000L)
#define DM_YRESOLUTION  (0x2000L)
#define DM_TTOPTION     (0x4000L)
#define DM_COLLATE      (0x8000L)
#define DM_FORMNAME     (0x10000L)
#define DM_LOGPIXELS    (0x20000L)
#define DM_BITSPERPEL   (0x40000L)
#define DM_PELSWIDTH    (0x80000L)
#define DM_PELSHEIGHT   (0x100000L)
#define DM_DISPLAYFLAGS (0x200000L)
#define DM_DISPLAYFREQUENCY     (0x400000L)
#define DM_ICMMETHOD    (0x800000L)
#define DM_ICMINTENT    (0x1000000L)
#define DM_MEDIATYPE    (0x2000000L)
#define DM_DITHERTYPE   (0x4000000L)
#define DMORIENT_LANDSCAPE      (2)
#define DMORIENT_PORTRAIT       (1)
#define DMPAPER_LETTER  (1)
#define DMPAPER_LEGAL   (5)
#define DMPAPER_A4      (9)
#define DMPAPER_CSHEET  (24)
#define DMPAPER_DSHEET  (25)
#define DMPAPER_ESHEET  (26)
#define DMPAPER_LETTERSMALL     (2)
#define DMPAPER_TABLOID (3)
#define DMPAPER_LEDGER  (4)
#define DMPAPER_STATEMENT       (6)
#define DMPAPER_EXECUTIVE       (7)
#define DMPAPER_A3      (8)
#define DMPAPER_A4SMALL (10)
#define DMPAPER_A5      (11)
#define DMPAPER_B4      (12)
#define DMPAPER_B5      (13)
#define DMPAPER_FOLIO   (14)
#define DMPAPER_QUARTO  (15)
#define DMPAPER_10X14   (16)
#define DMPAPER_11X17   (17)
#define DMPAPER_NOTE    (18)
#define DMPAPER_ENV_9   (19)
#define DMPAPER_ENV_10  (20)
#define DMPAPER_ENV_11  (21)
#define DMPAPER_ENV_12  (22)
#define DMPAPER_ENV_14  (23)
#define DMPAPER_ENV_DL  (27)
#define DMPAPER_ENV_C5  (28)
#define DMPAPER_ENV_C3  (29)
#define DMPAPER_ENV_C4  (30)
#define DMPAPER_ENV_C6  (31)
#define DMPAPER_ENV_C65 (32)
#define DMPAPER_ENV_B4  (33)
#define DMPAPER_ENV_B5  (34)
#define DMPAPER_ENV_B6  (35)
#define DMPAPER_ENV_ITALY       (36)
#define DMPAPER_ENV_MONARCH     (37)
#define DMPAPER_ENV_PERSONAL    (38)
#define DMPAPER_FANFOLD_US      (39)
#define DMPAPER_FANFOLD_STD_GERMAN      (40)
#define DMPAPER_FANFOLD_LGL_GERMAN      (41)
#define DMRES_HIGH      (-4)
#define DMRES_MEDIUM    (-3)
#define DMRES_LOW       (-2)
#define DMRES_DRAFT     (-1)
#define DMCOLOR_COLOR   (2)
#define DMCOLOR_MONOCHROME      (1)
#define DMDUP_SIMPLEX   (1)
#define DMDUP_HORIZONTAL        (3)
#define DMDUP_VERTICAL  (2)
#define DMTT_BITMAP     (1)
#define DMTT_DOWNLOAD   (2)
#define DMTT_SUBDEV     (3)
#define DMCOLLATE_TRUE  (1)
#define DMCOLLATE_FALSE (0)
#define DM_GRAYSCALE    (1)
#define DM_INTERLACED   (2)
#define DMICMMETHOD_NONE        (1)
#define DMICMMETHOD_SYSTEM      (2)
#define DMICMMETHOD_DRIVER      (3)
#define DMICMMETHOD_DEVICE      (4)
#define DMICMMETHOD_USER        (256)
#define DMICM_SATURATE  (1)
#define DMICM_CONTRAST  (2)
#define DMICM_COLORMETRIC       (3)
#define DMICM_USER      (256)
#define DMMEDIA_STANDARD        (1)
#define DMMEDIA_GLOSSY  (3)
#define DMMEDIA_TRANSPARENCY    (2)
#define DMMEDIA_USER    (256)
#define DMDITHER_NONE   (1)
#define DMDITHER_COARSE (2)
#define DMDITHER_FINE   (3)
#define DMDITHER_LINEART        (4)
#define DMDITHER_GRAYSCALE      (10)
#define DMDITHER_USER   (256)

/* RGNDATAHEADER structure */
#define RDH_RECTANGLES  (1)

/* TTPOLYGONHEADER structure */
#define TT_POLYGON_TYPE (24)

/* TTPOLYCURVE structure */
#define TT_PRIM_LINE    (1)
#define TT_PRIM_QSPLINE (2)

/* GCP_RESULTS structure */
#define GCPCLASS_ARABIC (2)
#define GCPCLASS_HEBREW (2)
#define GCPCLASS_LATIN  (1)
#define GCPCLASS_LATINNUMBER    (5)
#define GCPCLASS_LOCALNUMBER    (4)
#define GCPCLASS_LATINNUMERICSEPARATOR  (7)
#define GCPCLASS_LATINNUMERICTERMINATOR (6)
#define GCPCLASS_NEUTRAL        (3)
#define GCPCLASS_NUMERICSEPARATOR       (8)
#define GCPCLASS_PREBOUNDLTR    (128)
#define GCPCLASS_PREBOUNDRTL    (64)
#define GCPCLASS_POSTBOUNDLTR   (32)
#define GCPCLASS_POSTBOUNDRTL   (16)
#define GCPGLYPH_LINKBEFORE     (32768)
#define GCPGLYPH_LINKAFTER      (16384)

/* RASTERIZER_STATUS structure */
#define TT_AVAILABLE    (1)
#define TT_ENABLED      (2)

/* COLORADJUSTMENT structure */
#define CA_NEGATIVE     (1)
#define CA_LOG_FILTER   (2)
#define ILLUMINANT_DEVICE_DEFAULT       (0)
#define ILLUMINANT_A    (1)
#define ILLUMINANT_B    (2)
#define ILLUMINANT_C    (3)
#define ILLUMINANT_D50  (4)
#define ILLUMINANT_D55  (5)
#define ILLUMINANT_D65  (6)
#define ILLUMINANT_D75  (7)
#define ILLUMINANT_F2   (8)
#define ILLUMINANT_TUNGSTEN     (1)
#define ILLUMINANT_DAYLIGHT     (3)
#define ILLUMINANT_FLUORESCENT  (8)
#define ILLUMINANT_NTSC (3)

/* DOCINFO structure */
#define DI_APPBANDING   (1)

/* EMRMETAHEADER structure */
#define EMR_HEADER      (1)
#define ENHMETA_SIGNATURE       (1179469088)

/* DRAWITEMSTRUCT structure */
#define ODT_BUTTON      (4)
#define ODT_COMBOBOX    (3)
#define ODT_LISTBOX     (2)
#define ODT_LISTVIEW    (102)
#define ODT_MENU        (1)
#define ODT_STATIC      (5)
#define ODT_TAB         (101)
#define ODT_HEADER      (100)
#define ODA_DRAWENTIRE  (1)
#define ODA_FOCUS       (4)
#define ODA_SELECT      (2)
#define ODS_CHECKED     (8)
#define ODS_COMBOBOXEDIT        (4096)
#define ODS_DEFAULT     (32)
#define ODS_DISABLED    (4)
#define ODS_FOCUS       (16)
#define ODS_GRAYED      (2)
#define ODS_SELECTED    (1)

/* MODEMDEVCAPS structure */
#define DIALOPTION_BILLING      (64)
#define DIALOPTION_QUIET        (128)
#define DIALOPTION_DIALTONE     (256)
#define MDMVOLFLAG_LOW  (1)
#define MDMVOLFLAG_MEDIUM       (2)
#define MDMVOLFLAG_HIGH (4)
#define MDMVOL_LOW      (0)
#define MDMVOL_MEDIUM   (1)
#define MDMVOL_HIGH     (2)
#define MDMSPKRFLAG_OFF (1)
#define MDMSPKRFLAG_DIAL        (2)
#define MDMSPKRFLAG_ON  (4)
#define MDMSPKRFLAG_CALLSETUP   (8)
#define MDMSPKR_OFF     (0)
#define MDMSPKR_DIAL    (1)
#define MDMSPKR_ON      (2)
#define MDMSPKR_CALLSETUP       (3)
#define MDM_BLIND_DIAL  (512)
#define MDM_CCITT_OVERRIDE      (64)
#define MDM_CELLULAR    (8)
#define MDM_COMPRESSION (1)
#define MDM_ERROR_CONTROL       (2)
#define MDM_FLOWCONTROL_HARD    (16)
#define MDM_FLOWCONTROL_SOFT    (32)
#define MDM_FORCED_EC   (4)
#define MDM_SPEED_ADJUST        (128)
#define MDM_TONE_DIAL   (256)
#define MDM_V23_OVERRIDE        (1024)

/* Languages */
#define LANG_BULGARIAN  (2)
#define LANG_CHINESE    (4)
#define LANG_CROATIAN   (26)
#define LANG_CZECH      (5)
#define LANG_DANISH     (6)
#define LANG_DUTCH      (19)
#define LANG_ENGLISH    (9)
#define LANG_FINNISH    (11)
#define LANG_FRENCH     (12)
#define LANG_GERMAN     (7)
#define LANG_GREEK      (8)
#define LANG_HUNGARIAN  (14)
#define LANG_ICELANDIC  (15)
#define LANG_ITALIAN    (16)
#define LANG_JAPANESE   (17)
#define LANG_KOREAN     (18)
#define LANG_NEUTRAL    (0)
#define LANG_NORWEGIAN  (20)
#define LANG_POLISH     (21)
#define LANG_PORTUGUESE (22)
#define LANG_ROMANIAN   (24)
#define LANG_RUSSIAN    (25)
#define LANG_SLOVAK     (27)
#define LANG_SLOVENIAN  (36)
#define LANG_SPANISH    (10)
#define LANG_SWEDISH    (29)
#define LANG_TURKISH    (31)
#define SUBLANG_CHINESE_SIMPLIFIED      (2)
#define SUBLANG_CHINESE_TRADITIONAL     (1)
#define SUBLANG_CHINESE_HONGKONG        (3)
#define SUBLANG_CHINESE_SINGAPORE       (4)
#define SUBLANG_DEFAULT (1)
#define SUBLANG_DUTCH   (1)
#define SUBLANG_DUTCH_BELGIAN   (2)
#define SUBLANG_ENGLISH_AUS     (3)
#define SUBLANG_ENGLISH_CAN     (4)
#define SUBLANG_ENGLISH_EIRE    (6)
#define SUBLANG_ENGLISH_NZ      (5)
#define SUBLANG_ENGLISH_UK      (2)
#define SUBLANG_ENGLISH_US      (1)
#define SUBLANG_FRENCH  (1)
#define SUBLANG_FRENCH_BELGIAN  (2)
#define SUBLANG_FRENCH_CANADIAN (3)
#define SUBLANG_FRENCH_SWISS    (4)
#define SUBLANG_GERMAN  (1)
#define SUBLANG_GERMAN_AUSTRIAN (3)
#define SUBLANG_GERMAN_SWISS    (2)
#define SUBLANG_ITALIAN (1)
#define SUBLANG_ITALIAN_SWISS   (2)
#define SUBLANG_NEUTRAL (0)
#define SUBLANG_NORWEGIAN_BOKMAL        (1)
#define SUBLANG_NORWEGIAN_NYNORSK       (2)
#define SUBLANG_PORTUGUESE      (2)
#define SUBLANG_PORTUGUESE_BRAZILIAN    (1)
#define SUBLANG_SPANISH (1)
#define SUBLANG_SPANISH_MEXICAN (2)
#define SUBLANG_SPANISH_MODERN  (3)
#define SUBLANG_SYS_DEFAULT     (2)
#define NLS_VALID_LOCALE_MASK   (1048575)
#define SORT_DEFAULT    (0)
#define SORT_JAPANESE_XJIS      (0)
#define SORT_JAPANESE_UNICODE   (1)
#define SORT_CHINESE_BIG5       (0)
#define SORT_CHINESE_UNICODE    (1)
#define SORT_KOREAN_KSC (0)
#define SORT_KOREAN_UNICODE     (1)

/* SYSTEM_INFO structure */
#define PROCESSOR_INTEL_386     (386)
#define PROCESSOR_INTEL_486     (486)
#define PROCESSOR_INTEL_PENTIUM (586)
#define PROCESSOR_MIPS_R4000    (4000)
#define PROCESSOR_ALPHA_21064   (21064)

/* FSCTL_SET_COMPRESSION */
#define COMPRESSION_FORMAT_NONE (0)
#define COMPRESSION_FORMAT_DEFAULT      (1)
#define COMPRESSION_FORMAT_LZNT1        (2)

/* TAPE_GET_DRIVE_PARAMETERS structure */
#define TAPE_DRIVE_COMPRESSION  (131072)
#define TAPE_DRIVE_ECC  (65536)
#define TAPE_DRIVE_ERASE_BOP_ONLY       (64)
#define TAPE_DRIVE_ERASE_LONG   (32)
#define TAPE_DRIVE_ERASE_IMMEDIATE      (128)
#define TAPE_DRIVE_ERASE_SHORT  (16)
#define TAPE_DRIVE_FIXED        (1)
#define TAPE_DRIVE_FIXED_BLOCK  (1024)
#define TAPE_DRIVE_INITIATOR    (4)
#define TAPE_DRIVE_PADDING      (262144)
#define TAPE_DRIVE_GET_ABSOLUTE_BLK     (1048576)
#define TAPE_DRIVE_GET_LOGICAL_BLK      (2097152)
#define TAPE_DRIVE_REPORT_SMKS  (524288)
#define TAPE_DRIVE_SELECT       (2)
#define TAPE_DRIVE_SET_EOT_WZ_SIZE      (4194304)
#define TAPE_DRIVE_TAPE_CAPACITY        (256)
#define TAPE_DRIVE_TAPE_REMAINING       (512)
#define TAPE_DRIVE_VARIABLE_BLOCK       (2048)
#define TAPE_DRIVE_WRITE_PROTECT        (4096)
#define TAPE_DRIVE_ABS_BLK_IMMED        (-2147475456)
#define TAPE_DRIVE_ABSOLUTE_BLK (-2147479552)
#define TAPE_DRIVE_END_OF_DATA  (-2147418112)
#define TAPE_DRIVE_FILEMARKS    (-2147221504)
#define TAPE_DRIVE_LOAD_UNLOAD  (-2147483647)
#define TAPE_DRIVE_LOAD_UNLD_IMMED      (-2147483616)
#define TAPE_DRIVE_LOCK_UNLOCK  (-2147483644)
#define TAPE_DRIVE_LOCK_UNLK_IMMED      (-2147483520)
#define TAPE_DRIVE_LOG_BLK_IMMED        (-2147450880)
#define TAPE_DRIVE_LOGICAL_BLK  (-2147467264)
#define TAPE_DRIVE_RELATIVE_BLKS        (-2147352576)
#define TAPE_DRIVE_REVERSE_POSITION     (-2143289344)
#define TAPE_DRIVE_REWIND_IMMEDIATE     (-2147483640)
#define TAPE_DRIVE_SEQUENTIAL_FMKS      (-2146959360)
#define TAPE_DRIVE_SEQUENTIAL_SMKS      (-2145386496)
#define TAPE_DRIVE_SET_BLOCK_SIZE       (-2147483632)
#define TAPE_DRIVE_SET_COMPRESSION      (-2147483136)
#define TAPE_DRIVE_SET_ECC      (-2147483392)
#define TAPE_DRIVE_SET_PADDING  (-2147482624)
#define TAPE_DRIVE_SET_REPORT_SMKS      (-2147481600)
#define TAPE_DRIVE_SETMARKS     (-2146435072)
#define TAPE_DRIVE_SPACE_IMMEDIATE      (-2139095040)
#define TAPE_DRIVE_TENSION      (-2147483646)
#define TAPE_DRIVE_TENSION_IMMED        (-2147483584)
#define TAPE_DRIVE_WRITE_FILEMARKS      (-2113929216)
#define TAPE_DRIVE_WRITE_LONG_FMKS      (-2013265920)
#define TAPE_DRIVE_WRITE_MARK_IMMED     (-1879048192)
#define TAPE_DRIVE_WRITE_SETMARKS       (-2130706432)
#define TAPE_DRIVE_WRITE_SHORT_FMKS     (-2080374784)

/* Standard rights */
#define STANDARD_RIGHTS_REQUIRED        (0xf0000L)
#define STANDARD_RIGHTS_WRITE   (0x20000L)
#define STANDARD_RIGHTS_READ    (0x20000L)
#define STANDARD_RIGHTS_EXECUTE (0x20000L)
#define STANDARD_RIGHTS_ALL     (0x1f0000L)
#define SPECIFIC_RIGHTS_ALL     (0xffffL)

/* ACCESS_MASK */
#define MAXIMUM_ALLOWED (0x2000000L)
#define GENERIC_ALL     (0x10000000L)

/* SID */
#define SECURITY_NULL_RID       (0L)
#define SECURITY_WORLD_RID      (0L)
#define SECURITY_LOCAL_RID      (0L)
#define SECURITY_CREATOR_OWNER_RID      (0L)
#define SECURITY_CREATOR_GROUP_RID      (0x1L)
#define SECURITY_DIALUP_RID     (0x1L)
#define SECURITY_NETWORK_RID    (0x2L)
#define SECURITY_BATCH_RID      (0x3L)
#define SECURITY_INTERACTIVE_RID        (0x4L)
#define SECURITY_LOGON_IDS_RID  (0x5L)
#define SECURITY_LOGON_IDS_RID_COUNT    (0x3L)
#define SECURITY_SERVICE_RID    (0x6L)
#define SECURITY_LOCAL_SYSTEM_RID       (0x12L)
#define SECURITY_BUILTIN_DOMAIN_RID     (0x20L)
#define DOMAIN_USER_RID_ADMIN   (0x1f4L)
#define DOMAIN_USER_RID_GUEST   (0x1f5L)
#define DOMAIN_GROUP_RID_ADMINS (0x200L)
#define DOMAIN_GROUP_RID_USERS  (0x201L)
#define DOMAIN_ALIAS_RID_ADMINS (0x220L)
#define DOMAIN_ALIAS_RID_USERS  (0x221L)
#define DOMAIN_ALIAS_RID_GUESTS (0x222L)
#define DOMAIN_ALIAS_RID_POWER_USERS    (0x223L)
#define DOMAIN_ALIAS_RID_ACCOUNT_OPS    (0x224L)
#define DOMAIN_ALIAS_RID_SYSTEM_OPS     (0x225L)
#define DOMAIN_ALIAS_RID_PRINT_OPS      (0x226L)
#define DOMAIN_ALIAS_RID_BACKUP_OPS     (0x227L)
#define DOMAIN_ALIAS_RID_REPLICATOR     (0x228L)

/* TOKEN_GROUPS structure */
#define SE_GROUP_MANDATORY      (0x1L)
#define SE_GROUP_ENABLED_BY_DEFAULT     (0x2L)
#define SE_GROUP_ENABLED        (0x4L)
#define SE_GROUP_OWNER  (0x8L)
#define SE_GROUP_LOGON_ID       (0xc0000000L)

/* ACL Defines */
#define ACL_REVISION  (2)

/* ACE_HEADER structure */
#define ACCESS_ALLOWED_ACE_TYPE      (0x0)
#define ACCESS_DENIED_ACE_TYPE       (0x1)
#define SYSTEM_AUDIT_ACE_TYPE        (0x2)
#define SYSTEM_ALARM_ACE_TYPE        (0x3)

/* ACE flags in the ACE_HEADER structure */
#define OBJECT_INHERIT_ACE           (0x1)
#define CONTAINER_INHERIT_ACE        (0x2)
#define NO_PROPAGATE_INHERIT_ACE     (0x4)
#define INHERIT_ONLY_ACE             (0x8)
#define SUCCESSFUL_ACCESS_ACE_FLAG   (0x40)
#define FAILED_ACCESS_ACE_FLAG       (0x80)

/* SECURITY_DESCRIPTOR_CONTROL */
#define SECURITY_DESCRIPTOR_REVISION    (1)
#define SECURITY_DESCRIPTOR_MIN_LENGTH  (20)
#define SE_OWNER_DEFAULTED      (1)
#define SE_GROUP_DEFAULTED      (2)
#define SE_DACL_PRESENT (4)
#define SE_DACL_DEFAULTED       (8)
#define SE_SACL_PRESENT (16)
#define SE_SACL_DEFAULTED       (32)
#define SE_SELF_RELATIVE        (32768)

/* PRIVILEGE_SET */
#define SE_PRIVILEGE_ENABLED_BY_DEFAULT (0x1L)
#define SE_PRIVILEGE_ENABLED    (0x2L)
#define SE_PRIVILEGE_USED_FOR_ACCESS    (0x80000000L)
#define PRIVILEGE_SET_ALL_NECESSARY     (0x1)

/* LBSELCHSTRING message */
#define CD_LBSELCHANGE  (0)
#define CD_LBSELADD     (2)
#define CD_LBSELSUB     (1)
#define CD_LBSELNOITEMS (-1)

/* DEVNAMES structure */
#define DN_DEFAULTPRN   (1)

/* WM_SHOWWINDOW message */
#define SW_OTHERUNZOOM  (4)
#define SW_OTHERZOOM    (2)
#define SW_PARENTCLOSING        (1)
#define SW_PARENTOPENING        (3)

/* Virtual Key codes */
#define VK_LBUTTON      (1)
#define VK_RBUTTON      (2)
#define VK_CANCEL       (3)
#define VK_MBUTTON      (4)
#define VK_XBUTTON1     (5)
#define VK_XBUTTON2     (6)
#define VK_BACK (8)
#define VK_TAB  (9)
#define VK_CLEAR        (12)
#define VK_RETURN       (13)
#define VK_SHIFT        (16)
#define VK_CONTROL      (17)
#define VK_MENU (18)
#define VK_PAUSE        (19)
#define VK_CAPITAL      (20)
#define VK_KANA (21)
#define VK_HANGEUL      (21)
#define VK_HANGUL       (21)
#define VK_JUNJA        (23)
#define VK_FINAL        (24)
#define VK_HANJA        (25)
#define VK_KANJI        (25)
#define VK_ESCAPE       (27)
#define VK_CONVERT      (28)
#define VK_NONCONVERT   (29)
#define VK_ACCEPT       (30)
#define VK_MODECHANGE   (31)
#define VK_SPACE        (32)
#define VK_CAPITAL      (20)
#define VK_KANA (21)
#define VK_HANGEUL      (21)
#define VK_HANGUL       (21)
#define VK_JUNJA        (23)
#define VK_FINAL        (24)
#define VK_HANJA        (25)
#define VK_KANJI        (25)
#define VK_ESCAPE       (27)
#define VK_CONVERT      (28)
#define VK_NONCONVERT   (29)
#define VK_ACCEPT       (30)
#define VK_MODECHANGE   (31)
#define VK_SPACE        (32)
#define VK_PRIOR        (33)
#define VK_NEXT (34)
#define VK_END  (35)
#define VK_HOME (36)
#define VK_LEFT (37)
#define VK_UP   (38)
#define VK_RIGHT        (39)
#define VK_DOWN (40)
#define VK_SELECT       (41)
#define VK_PRINT        (42)
#define VK_EXECUTE      (43)
#define VK_SNAPSHOT     (44)
#define VK_INSERT       (45)
#define VK_DELETE       (46)
#define VK_HELP (47)
#define VK_0    (48)
#define VK_1    (49)
#define VK_2    (50)
#define VK_3    (51)
#define VK_4    (52)
#define VK_5    (53)
#define VK_6    (54)
#define VK_7    (55)
#define VK_8    (56)
#define VK_9    (57)
#define VK_A    (65)
#define VK_B    (66)
#define VK_C    (67)
#define VK_D    (68)
#define VK_E    (69)
#define VK_F    (70)
#define VK_G    (71)
#define VK_H    (72)
#define VK_I    (73)
#define VK_J    (74)
#define VK_K    (75)
#define VK_L    (76)
#define VK_M    (77)
#define VK_N    (78)
#define VK_O    (79)
#define VK_P    (80)
#define VK_Q    (81)
#define VK_R    (82)
#define VK_S    (83)
#define VK_T    (84)
#define VK_U    (85)
#define VK_V    (86)
#define VK_W    (87)
#define VK_X    (88)
#define VK_Y    (89)
#define VK_Z    (90)
#define VK_LWIN (91)
#define VK_RWIN (92)
#define VK_APPS (93)
#define VK_SLEEP        (95)
#define VK_NUMPAD0      (96)
#define VK_NUMPAD1      (97)
#define VK_NUMPAD2      (98)
#define VK_NUMPAD3      (99)
#define VK_NUMPAD4      (100)
#define VK_NUMPAD5      (101)
#define VK_NUMPAD6      (102)
#define VK_NUMPAD7      (103)
#define VK_NUMPAD8      (104)
#define VK_NUMPAD9      (105)
#define VK_MULTIPLY     (106)
#define VK_ADD  (107)
#define VK_SEPARATOR    (108)
#define VK_SUBTRACT     (109)
#define VK_DECIMAL      (110)
#define VK_DIVIDE       (111)
#define VK_F1   (112)
#define VK_F2   (113)
#define VK_F3   (114)
#define VK_F4   (115)
#define VK_F5   (116)
#define VK_F6   (117)
#define VK_F7   (118)
#define VK_F8   (119)
#define VK_F9   (120)
#define VK_F10  (121)
#define VK_F11  (122)
#define VK_F12  (123)
#define VK_F13  (124)
#define VK_F14  (125)
#define VK_F15  (126)
#define VK_F16  (127)
#define VK_F17  (128)
#define VK_F18  (129)
#define VK_F19  (130)
#define VK_F20  (131)
#define VK_F21  (132)
#define VK_F22  (133)
#define VK_F23  (134)
#define VK_F24  (135)

/* GetAsyncKeyState */
#define VK_NUMLOCK      (144)
#define VK_SCROLL       (145)
#define VK_OEM_NEC_EQUAL        (146)
#define VK_OEM_FJ_JISHO (146)
#define VK_OEM_FJ_MASSHOU       (147)
#define VK_OEM_FJ_TOUROKU       (148)
#define VK_OEM_FJ_LOYA  (149)
#define VK_OEM_FJ_ROYA  (150)
#define VK_LSHIFT       (160)
#define VK_RSHIFT       (161)
#define VK_LCONTROL     (162)
#define VK_RCONTROL     (163)
#define VK_LMENU        (164)
#define VK_RMENU        (165)
#define VK_BROWSER_BACK (166)
#define VK_BROWSER_FORWARD      (167)
#define VK_BROWSER_REFRESH      (168)
#define VK_BROWSER_STOP (169)
#define VK_BROWSER_SEARCH       (170)
#define VK_BROWSER_FAVORITES    (171)
#define VK_BROWSER_HOME (172)
#define VK_VOLUME_MUTE  (173)
#define VK_VOLUME_DOWN  (174)
#define VK_VOLUME_UP    (175)
#define VK_MEDIA_NEXT_TRACK     (176)
#define VK_MEDIA_PREV_TRACK     (177)
#define VK_MEDIA_STOP   (178)
#define VK_MEDIA_PLAY_PAUSE     (179)
#define VK_LAUNCH_MAIL  (180)
#define VK_LAUNCH_MEDIA_SELECT  (181)
#define VK_LAUNCH_APP1  (182)
#define VK_LAUNCH_APP2  (183)
#define VK_OEM_1        (186)
#define VK_OEM_PLUS     (187)
#define VK_OEM_COMMA    (188)
#define VK_OEM_MINUS    (189)
#define VK_OEM_PERIOD   (190)
#define VK_OEM_2        (191)
#define VK_OEM_3        (192)
#define VK_OEM_4        (219)
#define VK_OEM_5        (220)
#define VK_OEM_6        (221)
#define VK_OEM_7        (222)
#define VK_OEM_8        (223)
#define VK_OEM_AX       (225)
#define VK_OEM_102      (226)
#define VK_ICO_HELP     (227)
#define VK_ICO_00       (228)
#define VK_PROCESSKEY   (229)
#define VK_ICO_CLEAR    (230)
#define VK_PACKET       (231)
#define VK_OEM_RESET    (233)
#define VK_OEM_JUMP     (234)
#define VK_OEM_PA1      (235)
#define VK_OEM_PA2      (236)
#define VK_OEM_PA3      (237)
#define VK_OEM_WSCTRL   (238)
#define VK_OEM_CUSEL    (239)
#define VK_OEM_ATTN     (240)
#define VK_OEM_FINISH   (241)
#define VK_OEM_COPY     (242)
#define VK_OEM_AUTO     (243)
#define VK_OEM_ENLW     (244)
#define VK_OEM_BACKTAB  (245)
#define VK_ATTN (246)
#define VK_CRSEL        (247)
#define VK_EXSEL        (248)
#define VK_EREOF        (249)
#define VK_PLAY (250)
#define VK_ZOOM (251)
#define VK_NONAME       (252)
#define VK_PA1  (253)
#define VK_OEM_CLEAR    (254)

/* Keystroke Message Flags */
#define KF_ALTDOWN      (8192)
#define KF_DLGMODE      (2048)
#define KF_EXTENDED     (256)
#define KF_MENUMODE     (4096)
#define KF_REPEAT       (16384)
#define KF_UP   (32768)

/* GetKeyboardLayoutName */
#define KL_NAMELENGTH   (9)

/* WM_ACTIVATE message */
#define WA_ACTIVE       (1)
#define WA_CLICKACTIVE  (2)
#define WA_INACTIVE     (0)

/* WM_ACTIVATE message */
#define PWR_CRITICALRESUME      (3)
#define PWR_SUSPENDREQUEST      (1)
#define PWR_SUSPENDRESUME       (2)
#define PWR_FAIL        (-1)
#define PWR_OK  (1)

/* WM_NOTIFYFORMAT message */
#define NF_QUERY        (3)
#define NF_REQUERY      (4)
#define NFR_ANSI        (1)
#define NFR_UNICODE     (2)

/* WM_SIZING message */
#define WMSZ_BOTTOM     (6)
#define WMSZ_BOTTOMLEFT (7)
#define WMSZ_BOTTOMRIGHT        (8)
#define WMSZ_LEFT       (1)
#define WMSZ_RIGHT      (2)
#define WMSZ_TOP        (3)
#define WMSZ_TOPLEFT    (4)
#define WMSZ_TOPRIGHT   (5)

/* WM_MOUSEACTIVATE message */
#define MA_ACTIVATE     (1)
#define MA_ACTIVATEANDEAT       (2)
#define MA_NOACTIVATE   (3)
#define MA_NOACTIVATEANDEAT     (4)

/* WM_SIZE message */
#define SIZE_MAXHIDE    (4)
#define SIZE_MAXIMIZED  (2)
#define SIZE_MAXSHOW    (3)
#define SIZE_MINIMIZED  (1)
#define SIZE_RESTORED   (0)

/* WM_NCCALCSIZE message */
#define WVR_ALIGNTOP    (16)
#define WVR_ALIGNLEFT   (32)
#define WVR_ALIGNBOTTOM (64)
#define WVR_ALIGNRIGHT  (128)
#define WVR_HREDRAW     (256)
#define WVR_VREDRAW     (512)
#define WVR_REDRAW      (768)
#define WVR_VALIDRECTS  (1024)

/* WM_NCHITTEST message */
#define HTBOTTOM        (15)
#define HTBOTTOMLEFT    (16)
#define HTBOTTOMRIGHT   (17)
#define HTCAPTION       (2)
#define HTCLIENT        (1)
#define HTERROR (-2)
#define HTGROWBOX       (4)
#define HTHSCROLL       (6)
#define HTLEFT  (10)
#define HTMENU  (5)
#define HTNOWHERE       (0)
#define HTREDUCE        (8)
#define HTRIGHT (11)
#define HTSIZE  (4)
#define HTSYSMENU       (3)
#define HTTOP   (12)
#define HTTOPLEFT       (13)
#define HTTOPRIGHT      (14)
#define HTTRANSPARENT   (-1)
#define HTVSCROLL       (7)
#define HTZOOM  (9)

/* Mouse messages */
#define MK_CONTROL      (8)
#define MK_LBUTTON      (1)
#define MK_MBUTTON      (16)
#define MK_RBUTTON      (2)
#define MK_SHIFT        (4)

/* WNDCLASS structure */
#define CS_BYTEALIGNCLIENT      (4096)
#define CS_BYTEALIGNWINDOW      (8192)
#define CS_CLASSDC      (64)
#define CS_DBLCLKS      (8)
#define CS_GLOBALCLASS  (16384)
#define CS_HREDRAW      (2)
#define CS_KEYCVTWINDOW (4)
#define CS_NOCLOSE      (512)
#define CS_NOKEYCVT     (256)
#define CS_OWNDC        (32)
#define CS_PARENTDC     (128)
#define CS_SAVEBITS     (2048)
#define CS_VREDRAW      (1)
#define DLGWINDOWEXTRA  (30)

/* ACCEL structure */
#define FALT    (16)
#define FCONTROL        (8)
#define FNOINVERT       (2)
#define FSHIFT  (4)
#define FVIRTKEY        (1)

/* MENUITEMINFO structure */
#define MIIM_BITMAP  (128)
#define MIIM_CHECKMARKS (8)
#define MIIM_DATA       (32)
#define MIIM_FTYPE  (256)
#define MIIM_ID (2)
#define MIIM_STATE      (1)
#define MIIM_STRING    (64)
#define MIIM_SUBMENU    (4)
#define MIIM_TYPE       (16)
#define MFT_BITMAP      (0x4L)
#define MFT_MENUBARBREAK        (0x20L)
#define MFT_MENUBREAK   (0x40L)
#define MFT_OWNERDRAW   (0x100L)
#define MFT_RADIOCHECK  (0x200L)
#define MFT_RIGHTJUSTIFY        (0x4000L)
#define MFT_SEPARATOR   (0x800L)
#define MFT_STRING      (0L)
#define MFS_CHECKED     (0x8L)
#define MFS_DEFAULT     (0x1000L)
#define MFS_DISABLED    (0x3L)
#define MFS_ENABLED     (0L)
#define MFS_GRAYED      (0x3L)
#define MFS_HILITE      (0x80L)
#define MFS_UNCHECKED   (0L)
#define MFS_UNHILITE    (0L)

/* SERIALKEYS structure */
#define SERKF_AVAILABLE (2)
#define SERKF_INDICATOR (4)
#define SERKF_SERIALKEYSON      (1)

/* FILTERKEYS structure */
#define FKF_AVAILABLE   (2)
#define FKF_CLICKON     (64)
#define FKF_FILTERKEYSON        (1)
#define FKF_HOTKEYACTIVE        (4)
#define FKF_HOTKEYSOUND (16)
#define FKF_CONFIRMHOTKEY       (8)
#define FKF_INDICATOR   (32)

/* HELPINFO structure */
#define HELPINFO_MENUITEM       (2)
#define HELPINFO_WINDOW (1)

/* WM_PRINT message */
#define PRF_CHECKVISIBLE        (0x1L)
#define PRF_CHILDREN    (0x10L)
#define PRF_CLIENT      (0x4L)
#define PRF_ERASEBKGND  (0x8L)
#define PRF_NONCLIENT   (0x2L)
#define PRF_OWNED       (0x20L)

/* MapWindowPoints */
#define HWND_DESKTOP    ((HWND)0)

/* WM_SYSCOMMAND message */
#define SC_CLOSE        (61536)
#define SC_CONTEXTHELP  (61824)
#define SC_DEFAULT      (61792)
#define SC_HOTKEY       (61776)
#define SC_HSCROLL      (61568)
#define SC_KEYMENU      (61696)
#define SC_MAXIMIZE     (61488)
#define SC_ZOOM (61488)
#define SC_MINIMIZE     (61472)
#define SC_ICON (61472)
#define SC_MONITORPOWER (61808)
#define SC_MOUSEMENU    (61584)
#define SC_MOVE (61456)
#define SC_NEXTWINDOW   (61504)
#define SC_PREVWINDOW   (61520)
#define SC_RESTORE      (61728)
#define SC_SCREENSAVE   (61760)
#define SC_SIZE (61440)
#define SC_TASKLIST     (61744)
#define SC_VSCROLL      (61552)

#define ICON_SMALL 0
#define ICON_BIG   1

/* DM_GETDEFID message */
#define DC_HASDEFID     (21323)

/* WM_GETDLGCODE message */
#define DLGC_BUTTON     (8192)
#define DLGC_DEFPUSHBUTTON      (16)
#define DLGC_HASSETSEL  (8)
#define DLGC_RADIOBUTTON        (64)
#define DLGC_STATIC     (256)
#define DLGC_UNDEFPUSHBUTTON    (32)
#define DLGC_WANTALLKEYS        (4)
#define DLGC_WANTARROWS (1)
#define DLGC_WANTCHARS  (128)
#define DLGC_WANTMESSAGE        (4)
#define DLGC_WANTTAB    (2)

/* EM_SETMARGINS message */
#define EC_LEFTMARGIN   (1)
#define EC_RIGHTMARGIN  (2)
#define EC_USEFONTINFO  (65535)

/* LB_SETCOUNT message */
#define LB_ERR          (-1)
#define LB_ERRSPACE     (-2)
#define LB_OKAY         (0)

/* CB_DIR message */
#define CB_ERR  (-1)
#define CB_ERRSPACE     (-2)

/* WM_IME_CONTROL message */
#define IMC_GETCANDIDATEPOS     (7)
#define IMC_GETCOMPOSITIONFONT  (9)
#define IMC_GETCOMPOSITIONWINDOW        (11)
#define IMC_GETSTATUSWINDOWPOS  (15)
#define IMC_CLOSESTATUSWINDOW   (33)
#define IMC_OPENSTATUSWINDOW    (34)
#define IMC_SETCANDIDATEPOS     (8)
#define IMC_SETCOMPOSITIONFONT  (10)
#define IMC_SETCOMPOSITIONWINDOW        (12)
#define IMC_SETSTATUSWINDOWPOS  (16)

/* WM_IME_CONTROL message */
#define IMN_CHANGECANDIDATE     (3)
#define IMN_CLOSECANDIDATE      (4)
#define IMN_CLOSESTATUSWINDOW   (1)
#define IMN_GUIDELINE   (13)
#define IMN_OPENCANDIDATE       (5)
#define IMN_OPENSTATUSWINDOW    (2)
#define IMN_SETCANDIDATEPOS     (9)
#define IMN_SETCOMPOSITIONFONT  (10)
#define IMN_SETCOMPOSITIONWINDOW        (11)
#define IMN_SETCONVERSIONMODE   (6)
#define IMN_SETOPENSTATUS       (8)
#define IMN_SETSENTENCEMODE     (7)
#define IMN_SETSTATUSWINDOWPOS  (12)
#define IMN_PRIVATE     (14)

/* STICKYKEYS structure */
#define SKF_AUDIBLEFEEDBACK     (64)
#define SKF_AVAILABLE   (2)
#define SKF_CONFIRMHOTKEY       (8)
#define SKF_HOTKEYACTIVE        (4)
#define SKF_HOTKEYSOUND (16)
#define SKF_INDICATOR   (32)
#define SKF_STICKYKEYSON        (1)
#define SKF_TRISTATE    (128)
#define SKF_TWOKEYSOFF  (256)

/* MOUSEKEYS structure */
#define MKF_AVAILABLE   (2)
#define MKF_CONFIRMHOTKEY       (8)
#define MKF_HOTKEYACTIVE        (4)
#define MKF_HOTKEYSOUND (16)
#define MKF_INDICATOR   (32)
#define MKF_MOUSEKEYSON (1)
#define MKF_MODIFIERS   (64)
#define MKF_REPLACENUMBERS      (128)

/* SOUNDSENTRY structure */
#define SSF_AVAILABLE   (2)
#define SSF_SOUNDSENTRYON       (1)
#define SSTF_BORDER     (2)
#define SSTF_CHARS      (1)
#define SSTF_DISPLAY    (3)
#define SSTF_NONE       (0)
#define SSGF_DISPLAY    (3)
#define SSGF_NONE       (0)
#define SSWF_CUSTOM     (4)
#define SSWF_DISPLAY    (3)
#define SSWF_NONE       (0)
#define SSWF_TITLE      (1)
#define SSWF_WINDOW     (2)

/* ACCESSTIMEOUT structure */
#define ATF_ONOFFFEEDBACK       (2)
#define ATF_TIMEOUTON   (1)

/* HIGHCONTRAST structure */
#define HCF_AVAILABLE   (2)
#define HCF_CONFIRMHOTKEY       (8)
#define HCF_HIGHCONTRASTON      (1)
#define HCF_HOTKEYACTIVE        (4)
#define HCF_HOTKEYAVAILABLE     (64)
#define HCF_HOTKEYSOUND (16)
#define HCF_INDICATOR   (32)

/* TOGGLEKEYS structure */
#define TKF_AVAILABLE   (2)
#define TKF_CONFIRMHOTKEY       (8)
#define TKF_HOTKEYACTIVE        (4)
#define TKF_HOTKEYSOUND (16)
#define TKF_TOGGLEKEYSON        (1)

/* Installable Policy */
#define PP_DISPLAYERRORS        (1)

/* SERVICE_INFO structure */
#define RESOURCEDISPLAYTYPE_DOMAIN      (1)
#define RESOURCEDISPLAYTYPE_FILE        (4)
#define RESOURCEDISPLAYTYPE_GENERIC     (0)
#define RESOURCEDISPLAYTYPE_GROUP       (5)
#define RESOURCEDISPLAYTYPE_SERVER      (2)
#define RESOURCEDISPLAYTYPE_SHARE       (3)

/* KEY_EVENT_RECORD structure */
#define CAPSLOCK_ON     (128)
#define ENHANCED_KEY    (256)
#define LEFT_ALT_PRESSED        (2)
#define LEFT_CTRL_PRESSED       (8)
#define NUMLOCK_ON      (32)
#define RIGHT_ALT_PRESSED       (1)
#define RIGHT_CTRL_PRESSED      (4)
#define SCROLLLOCK_ON   (64)
#define SHIFT_PRESSED   (16)

/* MOUSE_EVENT_RECORD structure */
#define FROM_LEFT_1ST_BUTTON_PRESSED    (1)
#define RIGHTMOST_BUTTON_PRESSED        (2)
#define FROM_LEFT_2ND_BUTTON_PRESSED    (4)
#define FROM_LEFT_3RD_BUTTON_PRESSED    (8)
#define FROM_LEFT_4TH_BUTTON_PRESSED    (16)
#define DOUBLE_CLICK    (2)
#define MOUSE_MOVED     (1)

/* INPUT_RECORD structure */
#define KEY_EVENT       (1)
#define MOUSE_EVENT     (2)
#define WINDOW_BUFFER_SIZE_EVENT        (4)
#define MENU_EVENT      (8)
#define FOCUS_EVENT     (16)

/* BITMAPINFOHEADER structure */
#define BI_RGB  (0L)
#define BI_RLE8 (1L)
#define BI_RLE4 (2L)
#define BI_BITFIELDS    (3L)

/* Extensions to OpenGL */

/* ChoosePixelFormat */
#define PFD_DRAW_TO_WINDOW      (0x4)
#define PFD_DRAW_TO_BITMAP      (0x8)
#define PFD_SUPPORT_GDI (0x10)
#define PFD_SUPPORT_OPENGL      (0x20)
#define PFD_DOUBLEBUFFER        (0x1)
#define PFD_STEREO      (0x2)
#define PFD_DOUBLEBUFFER_DONTCARE       (0x40000000)
#define PFD_STEREO_DONTCARE     (0x80000000)
#define PFD_TYPE_RGBA   (0)
#define PFD_TYPE_COLORINDEX     (1)
#define PFD_MAIN_PLANE  (0)
#define PFD_OVERLAY_PLANE       (1)
#define PFD_UNDERLAY_PLANE      (-1)

/* wglUseFontOutlines */
#define WGL_FONT_LINES  (0)
#define WGL_FONT_POLYGONS       (1)

/* LAYERPLANEDESCRIPTOR structure */

/* PIXELFORMATDESCRIPTOR structure */
#define PFD_GENERIC_FORMAT      (0x40)
#define PFD_NEED_PALETTE        (0x80)
#define PFD_NEED_SYSTEM_PALETTE (0x100)
#define PFD_SWAP_COPY   (0x400)
#define PFD_SWAP_EXCHANGE       (0x200)

/* --------------------- old stuff, need to organize! --------------- */

/* From ddeml.h in old Cygnus headers */

#define XCLASS_BOOL             0x1000
#define XCLASS_DATA             0x2000
#define XCLASS_FLAGS            0x4000
#define XCLASS_MASK             0xfc00
#define XCLASS_NOTIFICATION     0x8000
#define XTYPF_NOBLOCK           0x0002
#define XTYP_ADVDATA            0x4010
#define XTYP_ADVREQ             0x2022
#define XTYP_ADVSTART           0x1030
#define XTYP_ADVSTOP            0x8040
#define XTYP_CONNECT            0x1062
#define XTYP_CONNECT_CONFIRM    0x8072
#define XTYP_DISCONNECT         0x80c2
#define XTYP_EXECUTE            0x4050
#define XTYP_POKE               0x4090
#define XTYP_REQUEST            0x20b0
#define XTYP_WILDCONNECT        0x20E2
#define XTYP_REGISTER           0x80A2
#define XTYP_ERROR              0x8002
#define XTYP_XACT_COMPLETE      0x8080
#define XTYP_UNREGISTER         0x80D2

#define DMLERR_DLL_USAGE        0x4004
#define DMLERR_INVALIDPARAMETER 0x4006
#define DMLERR_NOTPROCESSED     0x4009
#define DMLERR_POSTMSG_FAILED   0x400c
#define DMLERR_SERVER_DIED      0x400e
#define DMLERR_SYS_ERROR        0x400f
#define DMLERR_BUSY             0x4001
#define DMLERR_DATAACKTIMEOUT   0x4002
#define DMLERR_ADVACKTIMEOUT    0x4000
#define DMLERR_DLL_NOT_INITIALIZED  0x4003
#define DMLERR_LOW_MEMORY       0x4007
#define DMLERR_MEMORY_ERROR     0x4008
#define DMLERR_POKEACKTIMEOUT   0x400b
#define DMLERR_NO_CONV_ESTABLISHED  0x400a
#define DMLERR_REENTRANCY       0x400d
#define DMLERR_UNFOUND_QUEUE_ID 0x4011
#define DMLERR_UNADVACKTIMEOUT  0x4010
#define DMLERR_EXECACKTIMEOUT   0x4005
#define DDE_FACK                0x8000
#define DDE_FNOTPROCESSED       0x0000

#define DNS_REGISTER 0x0001
#define DNS_UNREGISTER 0x0002
#define CP_WINANSI 1004
#define CP_WINUNICODE 1200
#define EXPENTRY CALLBACK
#define APPCLASS_STANDARD  0x00000000

/* End of stuff from ddeml.h in old Cygnus headers */
/* ----------------------------------------------- */

#define BKMODE_LAST     (2)

#define CTLCOLOR_MSGBOX         (0)
#define CTLCOLOR_EDIT           (1)
#define CTLCOLOR_LISTBOX        (2)
#define CTLCOLOR_BTN            (3)
#define CTLCOLOR_DLG            (4)
#define CTLCOLOR_SCROLLBAR      (5)
#define CTLCOLOR_STATIC         (6)
#define CTLCOLOR_MAX            (7)

#define META_SETMAPMODE         (0x0103L)
#define META_SETWINDOWORG       (0x020BL)
#define META_SETWINDOWEXT       (0x020CL)

#define POLYFILL_LAST           (2)

#define STATUS_WAIT_0                   (0x00000000L)
#define STATUS_ABANDONED_WAIT_0         (0x00000080L)
#define STATUS_USER_APC                 (0x000000C0L)
#define STATUS_TIMEOUT                  (0x00000102L)
#define STATUS_PENDING                  (0x00000103L)
#define STATUS_SEGMENT_NOTIFICATION      (0x40000005L)
#define STATUS_GUARD_PAGE_VIOLATION     (0x80000001L)
#define STATUS_DATATYPE_MISALIGNMENT    (0x80000002L)
#define STATUS_BREAKPOINT               (0x80000003L)
#define STATUS_SINGLE_STEP              (0x80000004L)
#define STATUS_IN_PAGE_ERROR            (0xC0000006L)
#define STATUS_INVALID_HANDLE            (0xC0000008L)

#define STATUS_ILLEGAL_INSTRUCTION      (0xC000001DL)
#define STATUS_NONCONTINUABLE_EXCEPTION (0xC0000025L)
#define STATUS_INVALID_DISPOSITION      (0xC0000026L)
#define STATUS_ARRAY_BOUNDS_EXCEEDED    (0xC000008CL)
#define STATUS_FLOAT_DENORMAL_OPERAND   (0xC000008DL)
#define STATUS_FLOAT_DIVIDE_BY_ZERO     (0xC000008EL)
#define STATUS_FLOAT_INEXACT_RESULT     (0xC000008FL)
#define STATUS_FLOAT_INVALID_OPERATION  (0xC0000090L)
#define STATUS_FLOAT_OVERFLOW           (0xC0000091L)
#define STATUS_FLOAT_STACK_CHECK        (0xC0000092L)
#define STATUS_FLOAT_UNDERFLOW          (0xC0000093L)
#define STATUS_INTEGER_DIVIDE_BY_ZERO   (0xC0000094L)
#define STATUS_INTEGER_OVERFLOW         (0xC0000095L)
#define STATUS_PRIVILEGED_INSTRUCTION   (0xC0000096L)
#define STATUS_STACK_OVERFLOW           (0xC00000FDL)
#define STATUS_CONTROL_C_EXIT           (0xC000013AL)
#define STATUS_FLOAT_MULTIPLE_FAULTS     ((DWORD   )0xC00002B4L)
#define STATUS_FLOAT_MULTIPLE_TRAPS      ((DWORD   )0xC00002B5L)
#define STATUS_ILLEGAL_VLM_REFERENCE     ((DWORD   )0xC00002C0L)
#define STATUS_REG_NAT_CONSUMPTION       ((DWORD   )0xC00002C9L)

#define EXCEPTION_CTRL_C

#define PROCESSOR_ARCHITECTURE_INTEL 0
#define PROCESSOR_ARCHITECTURE_MIPS  1
#define PROCESSOR_ARCHITECTURE_ALPHA 2
#define PROCESSOR_ARCHITECTURE_PPC   3

#define FreeModule(h) FreeLibrary(h)
#define MakeProcInstance(p,i) (p)
#define FreeProcInstance(p) (p)

#define _fmemcpy memcpy

/* Used by wxwindows. */
#define SIZEFULLSCREEN  SIZE_MAXIMIZED
#define SIZENORMAL      SIZE_RESTORED
#define SIZEICONIC      SIZE_MINIMIZED
#define NPLOGPALETTE    PLOGPALETTE

/* In the old winnt.h */
#if 0
#ifdef __ANAL__
#define DECLARE_HANDLE(h) struct h##__ { int dummy; }; typedef struct h##__ *h
#else
#define DECLARE_HANDLE(h)  typedef void *h
#endif
DECLARE_HANDLE(HANDLE);
#endif

#ifdef __PPC__
#define CONTEXT_CONTROL         1L
#define CONTEXT_FLOATING_POINT  2L
#define CONTEXT_INTEGER         4L
#define CONTEXT_DEBUG_REGISTERS 8L

#define CONTEXT_FULL (CONTEXT_CONTROL | CONTEXT_FLOATING_POINT | CONTEXT_INTEGER)
#define CONTEXT_DEBUGGER (CONTEXT_FULL)

#else /* x86 */
/* The doc refered me to winnt.h, so I had to look... */
#define SIZE_OF_80387_REGISTERS      80

/* Values for contextflags */
#define CONTEXT_i386    0x10000
#define CONTEXT_CONTROL         (CONTEXT_i386 | 1)
#define CONTEXT_INTEGER         (CONTEXT_i386 | 2)
#define CONTEXT_SEGMENTS        (CONTEXT_i386 | 4)
#define CONTEXT_FLOATING_POINT  (CONTEXT_i386 | 8)
#define CONTEXT_DEBUG_REGISTERS (CONTEXT_i386 | 0x10)
#define CONTEXT_FULL (CONTEXT_CONTROL | CONTEXT_INTEGER | CONTEXT_SEGMENTS)

/* our own invention */
#define FLAG_TRACE_BIT 0x100
#define CONTEXT_DEBUGGER (CONTEXT_FULL | CONTEXT_FLOATING_POINT)

#endif

#define ASCIICHAR AsciiChar
#define NEAR
#ifndef FAR
#define FAR
#endif
#ifdef __GNUC__
#define PACKED __attribute__((packed))
#else
#define PACKED
#endif

#define FILTER_TEMP_DUPLICATE_ACCOUNT       (0x0001)
#define FILTER_NORMAL_ACCOUNT               (0x0002)
#define FILTER_INTERDOMAIN_TRUST_ACCOUNT    (0x0008)
#define FILTER_WORKSTATION_TRUST_ACCOUNT    (0x0010)
#define FILTER_SERVER_TRUST_ACCOUNT         (0x0020)

#define LOGON32_LOGON_INTERACTIVE           (0x02)
#define LOGON32_LOGON_BATCH                 (0x04)
#define LOGON32_LOGON_SERVICE               (0x05)
#define LOGON32_PROVIDER_DEFAULT            (0x00)
#define LOGON32_PROVIDER_WINNT35            (0x01)

#define QID_SYNC 0xFFFFFFFF

#define IMAGE_DOS_SIGNATURE     (0x5a4d)
#define IMAGE_OS2_SIGNATURE     (0x454e)
#define IMAGE_OS2_SIGNATURE_LE  (0x454c)
#define IMAGE_VXD_SIGNATURE     (0x454c)
#define IMAGE_NT_SIGNATURE      (0x4550)

#define IMAGE_NUMBEROF_DIRECTORY_ENTRIES 16
#define IMAGE_SIZEOF_SHORT_NAME 8
#define IMAGE_SIZEOF_FILE_HEADER        20
#define IMAGE_DIRECTORY_ENTRY_EXPORT          0   /* Export Directory */
#define IMAGE_DIRECTORY_ENTRY_IMPORT          1   /* Import Directory */
#define IMAGE_DIRECTORY_ENTRY_RESOURCE        2   /* Resource Directory */
#define IMAGE_DIRECTORY_ENTRY_EXCEPTION       3   /* Exception Directory */
#define IMAGE_DIRECTORY_ENTRY_SECURITY        4   /* Security Directory */
#define IMAGE_DIRECTORY_ENTRY_BASERELOC       5   /* Base Relocation Table */
#define IMAGE_DIRECTORY_ENTRY_DEBUG           6   /* Debug Directory */
/*      IMAGE_DIRECTORY_ENTRY_COPYRIGHT       7      (X86 usage) */
#define IMAGE_DIRECTORY_ENTRY_ARCHITECTURE    7   /* Architecture Specific Data */
#define IMAGE_DIRECTORY_ENTRY_GLOBALPTR       8   /* RVA of GP */
#define IMAGE_DIRECTORY_ENTRY_TLS             9   /* TLS Directory */
#define IMAGE_DIRECTORY_ENTRY_LOAD_CONFIG    10   /* Load Configuration Directory */
#define IMAGE_DIRECTORY_ENTRY_BOUND_IMPORT   11   /* Bound Import Directory in headers */
#define IMAGE_DIRECTORY_ENTRY_IAT            12   /* Import Address Table */
#define IMAGE_DIRECTORY_ENTRY_DELAY_IMPORT   13   /* Delay Load Import Descriptors */
#define IMAGE_DIRECTORY_ENTRY_COM_DESCRIPTOR 14   /* COM Runtime descriptor */
#define IMAGE_REL_BASED_HIGHLOW 3

#define IMAGE_SUBSYSTEM_UNKNOWN              0
#define IMAGE_SUBSYSTEM_NATIVE               1
#define IMAGE_SUBSYSTEM_WINDOWS_GUI          2
#define IMAGE_SUBSYSTEM_WINDOWS_CUI          3
#define IMAGE_SUBSYSTEM_OS2_CUI              5
#define IMAGE_SUBSYSTEM_POSIX_CUI            7
#define IMAGE_SUBSYSTEM_NATIVE_WINDOWS       8
#define IMAGE_SUBSYSTEM_WINDOWS_CE_GUI       9
#define IMAGE_SUBSYSTEM_EFI_APPLICATION     10   //
#define IMAGE_SUBSYSTEM_EFI_BOOT_SERVICE_DRIVER  11   //
#define IMAGE_SUBSYSTEM_EFI_RUNTIME_DRIVER  12   //

#define IMAGE_SCN_TYPE_NO_PAD                0x00000008
#define IMAGE_SCN_CNT_CODE                   0x00000020
#define IMAGE_SCN_CNT_INITIALIZED_DATA       0x00000040
#define IMAGE_SCN_CNT_UNINITIALIZED_DATA     0x00000080

#define IMAGE_SCN_LNK_OTHER                  0x00000100
#define IMAGE_SCN_LNK_INFO                   0x00000200
#define IMAGE_SCN_LNK_REMOVE                 0x00000800
#define IMAGE_SCN_LNK_COMDAT                 0x00001000
#define IMAGE_SCN_NO_DEFER_SPEC_EXC          0x00004000
#define IMAGE_SCN_GPREL                      0x00008000
#define IMAGE_SCN_MEM_FARDATA                0x00008000
#define IMAGE_SCN_MEM_PURGEABLE              0x00020000
#define IMAGE_SCN_MEM_16BIT                  0x00020000
#define IMAGE_SCN_MEM_LOCKED                 0x00040000
#define IMAGE_SCN_MEM_PRELOAD                0x00080000

#define IMAGE_SCN_ALIGN_1BYTES               0x00100000  //
#define IMAGE_SCN_ALIGN_2BYTES               0x00200000  //
#define IMAGE_SCN_ALIGN_4BYTES               0x00300000  //
#define IMAGE_SCN_ALIGN_8BYTES               0x00400000  //
#define IMAGE_SCN_ALIGN_16BYTES              0x00500000
#define IMAGE_SCN_ALIGN_32BYTES              0x00600000  //
#define IMAGE_SCN_ALIGN_64BYTES              0x00700000  //
#define IMAGE_SCN_ALIGN_128BYTES             0x00800000  //
#define IMAGE_SCN_ALIGN_256BYTES             0x00900000  //
#define IMAGE_SCN_ALIGN_512BYTES             0x00A00000  //
#define IMAGE_SCN_ALIGN_1024BYTES            0x00B00000  //
#define IMAGE_SCN_ALIGN_2048BYTES            0x00C00000  //
#define IMAGE_SCN_ALIGN_4096BYTES            0x00D00000  //
#define IMAGE_SCN_ALIGN_8192BYTES            0x00E00000  //
#define IMAGE_SCN_ALIGN_MASK                 0x00F00000

#define IMAGE_SCN_LNK_NRELOC_OVFL            0x01000000
#define IMAGE_SCN_MEM_DISCARDABLE            0x02000000
#define IMAGE_SCN_MEM_NOT_CACHED             0x04000000
#define IMAGE_SCN_MEM_NOT_PAGED              0x08000000
#define IMAGE_SCN_MEM_SHARED                 0x10000000
#define IMAGE_SCN_MEM_EXECUTE                0x20000000
#define IMAGE_SCN_MEM_READ                   0x40000000
#define IMAGE_SCN_MEM_WRITE                  0x80000000
#define IMAGE_SCN_SCALE_INDEX                0x00000001

#define CP_ACP                    (0)
#define CP_OEMCP                  (1)
#define CP_MACCP                  (2)
#define CP_THREAD_ACP             (3)
#define CP_SYMBOL                 (42)
#define CP_UTF7                   (65000)
#define CP_UTF8                   (65001)


#define WHEEL_DELTA                     120
#define GET_WHEEL_DELTA_WPARAM(wParam)  ((short)HIWORD(wParam))
#define WHEEL_PAGESCROLL                (UINT_MAX)
#define GET_KEYSTATE_WPARAM(wParam)     (LOWORD(wParam))

#define INVALID_FILE_SIZE ((DWORD)-1)
#define INVALID_FILE_ATTRIBUTES ((DWORD)-1)

#define RtlEqualMemory(Destination,Source,Length) (!memcmp((Destination),(Source),(Length)))
#define RtlMoveMemory(Destination,Source,Length) memmove((Destination),(Source),(Length))
#define RtlCopyMemory(Destination,Source,Length) memcpy((Destination),(Source),(Length))
#define RtlFillMemory(Destination,Length,Fill) memset((Destination),(Fill),(Length))
#define RtlZeroMemory(Destination,Length) memset((Destination),0,(Length))

#define ZeroMemory(pb,cb)           RtlZeroMemory((pb),(cb))
#define FillMemory(pb,cb,b)         RtlFillMemory((pb),(b),(cb))
#define CopyMemory(pbDst,pbSrc,cb)  RtlCopyMemory((pbDst),(pbSrc),(cb))
#define MoveMemory(pbDst,pbSrc,cb)  RtlMoveMemory((pbDst),(pbSrc),(cb))

#define ASFW_ANY ((DWORD) (-1))
#define UNREFERENCED_PARAMETER(a)

#define FLASHW_STOP 0
#define FLASHW_CAPTION 1
#define FLASHW_TRAY 2
#define FLASHW_ALL (FLASHW_CAPTION|FLASHW_TRAY)
#define FLASHW_TIMER 4
#define FLASHW_TIMERNOFG 12

/* winperf */
#define PERF_DATA_VERSION 1
#define PERF_DATA_REVISION 1
#define PERF_NO_INSTANCES -1
#define PERF_SIZE_DWORD 0
#define PERF_SIZE_LARGE 256
#define PERF_SIZE_ZERO 512
#define PERF_SIZE_VARIABLE_LEN 768
#define PERF_TYPE_NUMBER 0
#define PERF_TYPE_COUNTER 1024
#define PERF_TYPE_TEXT 2048
#define PERF_TYPE_ZERO 0xC00
#define PERF_NUMBER_HEX 0
#define PERF_NUMBER_DECIMAL 0x10000
#define PERF_NUMBER_DEC_1000 0x20000
#define PERF_COUNTER_VALUE 0
#define PERF_COUNTER_RATE 0x10000
#define PERF_COUNTER_FRACTION 0x20000
#define PERF_COUNTER_BASE 0x30000
#define PERF_COUNTER_ELAPSED 0x40000
#define PERF_COUNTER_QUEUELEN 0x50000
#define PERF_COUNTER_HISTOGRAM 0x60000
#define PERF_TEXT_UNICODE 0
#define PERF_TEXT_ASCII 0x10000
#define PERF_TIMER_TICK 0
#define PERF_TIMER_100NS 0x100000
#define PERF_OBJECT_TIMER 0x200000
#define PERF_DELTA_COUNTER 0x400000
#define PERF_DELTA_BASE 0x800000
#define PERF_INVERSE_COUNTER 0x1000000
#define PERF_MULTI_COUNTER 0x2000000
#define PERF_DISPLAY_NO_SUFFIX 0
#define PERF_DISPLAY_PER_SEC 0x10000000
#define PERF_DISPLAY_PERCENT 0x20000000
#define PERF_DISPLAY_SECONDS 0x30000000
#define PERF_DISPLAY_NOSHOW 0x40000000
#define PERF_COUNTER_HISTOGRAM_TYPE 0x80000000
#define PERF_NO_UNIQUE_ID (-1)
#define PERF_DETAIL_NOVICE 100
#define PERF_DETAIL_ADVANCED 200
#define PERF_DETAIL_EXPERT 300
#define PERF_DETAIL_WIZARD 400
#define PERF_COUNTER_COUNTER (PERF_SIZE_DWORD|PERF_TYPE_COUNTER|PERF_COUNTER_RATE|PERF_TIMER_TICK|PERF_DELTA_COUNTER|PERF_DISPLAY_PER_SEC)
#define PERF_COUNTER_TIMER (PERF_SIZE_LARGE|PERF_TYPE_COUNTER|PERF_COUNTER_RATE|PERF_TIMER_TICK|PERF_DELTA_COUNTER|PERF_DISPLAY_PERCENT)
#define PERF_COUNTER_QUEUELEN_TYPE (PERF_SIZE_DWORD|PERF_TYPE_COUNTER|PERF_COUNTER_QUEUELEN|PERF_TIMER_TICK|PERF_DELTA_COUNTER|PERF_DISPLAY_NO_SUFFIX)
#define PERF_COUNTER_BULK_COUNT (PERF_SIZE_LARGE|PERF_TYPE_COUNTER|PERF_COUNTER_RATE|PERF_TIMER_TICK|PERF_DELTA_COUNTER|PERF_DISPLAY_PER_SEC)
#define PERF_COUNTER_TEXT (PERF_SIZE_VARIABLE_LEN|PERF_TYPE_TEXT|PERF_TEXT_UNICODE|PERF_DISPLAY_NO_SUFFIX)
#define PERF_COUNTER_RAWCOUNT (PERF_SIZE_DWORD|PERF_TYPE_NUMBER|PERF_NUMBER_DECIMAL|PERF_DISPLAY_NO_SUFFIX)
#define PERF_COUNTER_LARGE_RAWCOUNT (PERF_SIZE_LARGE|PERF_TYPE_NUMBER|PERF_NUMBER_DECIMAL|PERF_DISPLAY_NO_SUFFIX)
#define PERF_COUNTER_RAWCOUNT_HEX (PERF_SIZE_DWORD|PERF_TYPE_NUMBER|PERF_NUMBER_HEX|PERF_DISPLAY_NO_SUFFIX)
#define PERF_COUNTER_LARGE_RAWCOUNT_HEX (PERF_SIZE_LARGE|PERF_TYPE_NUMBER|PERF_NUMBER_HEX|PERF_DISPLAY_NO_SUFFIX)
#define PERF_SAMPLE_FRACTION (PERF_SIZE_DWORD|PERF_TYPE_COUNTER|PERF_COUNTER_FRACTION|PERF_DELTA_COUNTER|PERF_DELTA_BASE|PERF_DISPLAY_PERCENT)
#define PERF_SAMPLE_COUNTER (PERF_SIZE_DWORD|PERF_TYPE_COUNTER|PERF_COUNTER_RATE|PERF_TIMER_TICK|PERF_DELTA_COUNTER|PERF_DISPLAY_NO_SUFFIX)
#define PERF_COUNTER_NODATA (PERF_SIZE_ZERO|PERF_DISPLAY_NOSHOW)
#define PERF_COUNTER_TIMER_INV (PERF_SIZE_LARGE|PERF_TYPE_COUNTER|PERF_COUNTER_RATE|PERF_TIMER_TICK|PERF_DELTA_COUNTER|PERF_INVERSE_COUNTER|PERF_DISPLAY_PERCENT)
#define PERF_SAMPLE_BASE (PERF_SIZE_DWORD|PERF_TYPE_COUNTER|PERF_COUNTER_BASE|PERF_DISPLAY_NOSHOW|1)
#define PERF_AVERAGE_TIMER (PERF_SIZE_DWORD|PERF_TYPE_COUNTER|PERF_COUNTER_FRACTION|PERF_DISPLAY_SECONDS)
#define PERF_AVERAGE_BASE (PERF_SIZE_DWORD|PERF_TYPE_COUNTER|PERF_COUNTER_BASE|PERF_DISPLAY_NOSHOW|2)
#define PERF_AVERAGE_BULK (PERF_SIZE_LARGE|PERF_TYPE_COUNTER|PERF_COUNTER_FRACTION|PERF_DISPLAY_NOSHOW)
#define PERF_100NSEC_TIMER (PERF_SIZE_LARGE|PERF_TYPE_COUNTER|PERF_COUNTER_RATE|PERF_TIMER_100NS|PERF_DELTA_COUNTER|PERF_DISPLAY_PERCENT)
#define PERF_100NSEC_TIMER_INV (PERF_SIZE_LARGE|PERF_TYPE_COUNTER|PERF_COUNTER_RATE|PERF_TIMER_100NS|PERF_DELTA_COUNTER|PERF_INVERSE_COUNTER|PERF_DISPLAY_PERCENT)
#define PERF_COUNTER_MULTI_TIMER (PERF_SIZE_LARGE|PERF_TYPE_COUNTER|PERF_COUNTER_RATE|PERF_DELTA_COUNTER|PERF_TIMER_TICK|PERF_MULTI_COUNTER|PERF_DISPLAY_PERCENT)
#define PERF_COUNTER_MULTI_TIMER_INV (PERF_SIZE_LARGE|PERF_TYPE_COUNTER|PERF_COUNTER_RATE|PERF_DELTA_COUNTER|PERF_MULTI_COUNTER|PERF_TIMER_TICK|PERF_INVERSE_COUNTER|PERF_DISPLAY_PERCENT)
#define PERF_COUNTER_MULTI_BASE (PERF_SIZE_LARGE|PERF_TYPE_COUNTER|PERF_COUNTER_BASE|PERF_MULTI_COUNTER|PERF_DISPLAY_NOSHOW)
#define PERF_100NSEC_MULTI_TIMER (PERF_SIZE_LARGE|PERF_TYPE_COUNTER|PERF_DELTA_COUNTER|PERF_COUNTER_RATE|PERF_TIMER_100NS|PERF_MULTI_COUNTER|PERF_DISPLAY_PERCENT)
#define PERF_100NSEC_MULTI_TIMER_INV (PERF_SIZE_LARGE|PERF_TYPE_COUNTER|PERF_DELTA_COUNTER|PERF_COUNTER_RATE|PERF_TIMER_100NS|PERF_MULTI_COUNTER|PERF_INVERSE_COUNTER|PERF_DISPLAY_PERCENT)
#define PERF_RAW_FRACTION (PERF_SIZE_DWORD|PERF_TYPE_COUNTER|PERF_COUNTER_FRACTION|PERF_DISPLAY_PERCENT)
#define PERF_RAW_BASE (PERF_SIZE_DWORD|PERF_TYPE_COUNTER|PERF_COUNTER_BASE|PERF_DISPLAY_NOSHOW|3)
#define PERF_ELAPSED_TIME (PERF_SIZE_LARGE|PERF_TYPE_COUNTER|PERF_COUNTER_ELAPSED|PERF_OBJECT_TIMER|PERF_DISPLAY_SECONDS)

#define STATE_SYSTEM_UNAVAILABLE        (0x1)
#define STATE_SYSTEM_SELECTED           (0x2)
#define STATE_SYSTEM_FOCUSED            (0x4)
#define STATE_SYSTEM_PRESSED            (0x8)
#define STATE_SYSTEM_CHECKED            (0x10)
#define STATE_SYSTEM_MIXED              (0x20)
#define STATE_SYSTEM_INDETERMINATE      STATE_SYSTEM_MIXED
#define STATE_SYSTEM_READONLY           (0x40)
#define STATE_SYSTEM_HOTTRACKED         (0x80)
#define STATE_SYSTEM_DEFAULT            (0x100)
#define STATE_SYSTEM_EXPANDED           (0x200)
#define STATE_SYSTEM_COLLAPSED          (0x400)
#define STATE_SYSTEM_BUSY               (0x800)
#define STATE_SYSTEM_FLOATING           (0x1000)
#define STATE_SYSTEM_MARQUEED           (0x2000)
#define STATE_SYSTEM_ANIMATED           (0x4000)
#define STATE_SYSTEM_INVISIBLE          (0x8000)
#define STATE_SYSTEM_OFFSCREEN          (0x10000)
#define STATE_SYSTEM_SIZEABLE           (0x20000)
#define STATE_SYSTEM_MOVEABLE           (0x40000)
#define STATE_SYSTEM_SELFVOICING        (0x80000)
#define STATE_SYSTEM_FOCUSABLE          (0x100000)
#define STATE_SYSTEM_SELECTABLE         (0x200000)
#define STATE_SYSTEM_LINKED             (0x400000)
#define STATE_SYSTEM_TRAVERSED          (0x800000)
#define STATE_SYSTEM_MULTISELECTABLE    (0x1000000)
#define STATE_SYSTEM_EXTSELECTABLE      (0x2000000)
#define STATE_SYSTEM_ALERT_LOW          (0x4000000)
#define STATE_SYSTEM_ALERT_MEDIUM       (0x8000000)
#define STATE_SYSTEM_ALERT_HIGH         (0x10000000)
#define STATE_SYSTEM_PROTECTED          (0x20000000)
#define STATE_SYSTEM_VALID              (0x3FFFFFFF)

#define CCHILDREN_TITLEBAR              (5)
#define CCHILDREN_SCROLLBAR             (5)

#define TH32CS_SNAPHEAPLIST (1)
#define TH32CS_SNAPPROCESS  (2)
#define TH32CS_SNAPTHREAD   (4)
#define TH32CS_SNAPMODULE   (8)
#define TH32CS_SNAPALL      (TH32CS_SNAPHEAPLIST | TH32CS_SNAPPROCESS | TH32CS_SNAPTHREAD | TH32CS_SNAPMODULE)
#define TH32CS_INHERIT      (0x80000000U)


#endif /* _GNU_H_WINDOWS32_DEFINES */
