/* Software License Agreement
 *
 *     Copyright(C) 1994-2020 David Lindauer, (LADSoft)
 *
 *     This file is part of the Orange C Compiler package.
 *
 *     The Orange C Compiler package is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     The Orange C Compiler package is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with Orange C.  If not, see <http://www.gnu.org/licenses/>.
 *
 *     contact information:
 *         email: TouchStone222@runbox.com <David Lindauer>
 *
 */

#include "UTF8.h"
#include <ctype.h>

int UTF8::alpha[] = {
    0x000041, 0x000042, 0x000043, 0x000044, 0x000045, 0x000046, 0x000047, 0x000048, 0x000049, 0x00004a, 0x00004b, 0x00004c,
    0x00004d, 0x00004e, 0x00004f, 0x000050, 0x000051, 0x000052, 0x000053, 0x000054, 0x000055, 0x000056, 0x000057, 0x000058,
    0x000059, 0x00005a, 0x000061, 0x000062, 0x000063, 0x000064, 0x000065, 0x000066, 0x000067, 0x000068, 0x000069, 0x00006a,
    0x00006b, 0x00006c, 0x00006d, 0x00006e, 0x00006f, 0x000070, 0x000071, 0x000072, 0x000073, 0x000074, 0x000075, 0x000076,
    0x000077, 0x000078, 0x000079, 0x00007a, 0x0000c0, 0x0000c1, 0x0000c2, 0x0000c3, 0x0000c4, 0x0000c5, 0x0000c6, 0x0000c7,
    0x0000c8, 0x0000c9, 0x0000ca, 0x0000cb, 0x0000cc, 0x0000cd, 0x0000ce, 0x0000cf, 0x0000d0, 0x0000d1, 0x0000d2, 0x0000d3,
    0x0000d4, 0x0000d5, 0x0000d6, 0x0000d8, 0x0000d9, 0x0000da, 0x0000db, 0x0000dc, 0x0000dd, 0x0000de, 0x0000df, 0x0000e0,
    0x0000e1, 0x0000e2, 0x0000e3, 0x0000e4, 0x0000e5, 0x0000e6, 0x0000e7, 0x0000e8, 0x0000e9, 0x0000ea, 0x0000eb, 0x0000ec,
    0x0000ed, 0x0000ee, 0x0000ef, 0x0000f0, 0x0000f1, 0x0000f2, 0x0000f3, 0x0000f4, 0x0000f5, 0x0000f6, 0x0000f8, 0x0000f9,
    0x0000fa, 0x0000fb, 0x0000fc, 0x0000fd, 0x0000fe, 0x0000ff, 0x000100, 0x000101, 0x000102, 0x000103, 0x000104, 0x000105,
    0x000106, 0x000107, 0x000108, 0x000109, 0x00010a, 0x00010b, 0x00010c, 0x00010d, 0x00010e, 0x00010f, 0x000110, 0x000111,
    0x000112, 0x000113, 0x000114, 0x000115, 0x000116, 0x000117, 0x000118, 0x000119, 0x00011a, 0x00011b, 0x00011c, 0x00011d,
    0x00011e, 0x00011f, 0x000120, 0x000121, 0x000122, 0x000123, 0x000124, 0x000125, 0x000126, 0x000127, 0x000128, 0x000129,
    0x00012a, 0x00012b, 0x00012c, 0x00012d, 0x00012e, 0x00012f, 0x000130, 0x000131, 0x000132, 0x000133, 0x000134, 0x000135,
    0x000136, 0x000137, 0x000138, 0x000139, 0x00013a, 0x00013b, 0x00013c, 0x00013d, 0x00013e, 0x00013f, 0x000140, 0x000141,
    0x000142, 0x000143, 0x000144, 0x000145, 0x000146, 0x000147, 0x000148, 0x000149, 0x00014a, 0x00014b, 0x00014c, 0x00014d,
    0x00014e, 0x00014f, 0x000150, 0x000151, 0x000152, 0x000153, 0x000154, 0x000155, 0x000156, 0x000157, 0x000158, 0x000159,
    0x00015a, 0x00015b, 0x00015c, 0x00015d, 0x00015e, 0x00015f, 0x000160, 0x000161, 0x000162, 0x000163, 0x000164, 0x000165,
    0x000166, 0x000167, 0x000168, 0x000169, 0x00016a, 0x00016b, 0x00016c, 0x00016d, 0x00016e, 0x00016f, 0x000170, 0x000171,
    0x000172, 0x000173, 0x000174, 0x000175, 0x000176, 0x000177, 0x000178, 0x000179, 0x00017a, 0x00017b, 0x00017c, 0x00017d,
    0x00017e, 0x00017f, 0x000180, 0x000181, 0x000182, 0x000183, 0x000184, 0x000185, 0x000186, 0x000187, 0x000188, 0x000189,
    0x00018a, 0x00018b, 0x00018c, 0x00018d, 0x00018e, 0x00018f, 0x000190, 0x000191, 0x000192, 0x000193, 0x000194, 0x000195,
    0x000196, 0x000197, 0x000198, 0x000199, 0x00019a, 0x00019b, 0x00019c, 0x00019d, 0x00019e, 0x00019f, 0x0001a0, 0x0001a1,
    0x0001a2, 0x0001a3, 0x0001a4, 0x0001a5, 0x0001a6, 0x0001a7, 0x0001a8, 0x0001a9, 0x0001aa, 0x0001ab, 0x0001ac, 0x0001ad,
    0x0001ae, 0x0001af, 0x0001b0, 0x0001b1, 0x0001b2, 0x0001b3, 0x0001b4, 0x0001b5, 0x0001b6, 0x0001b7, 0x0001b8, 0x0001b9,
    0x0001ba, 0x0001bb, 0x0001bc, 0x0001bd, 0x0001be, 0x0001bf, 0x0001c0, 0x0001c1, 0x0001c2, 0x0001c3, 0x0001c4, 0x0001c5,
    0x0001c6, 0x0001c7, 0x0001c8, 0x0001c9, 0x0001ca, 0x0001cb, 0x0001cc, 0x0001cd, 0x0001ce, 0x0001cf, 0x0001d0, 0x0001d1,
    0x0001d2, 0x0001d3, 0x0001d4, 0x0001d5, 0x0001d6, 0x0001d7, 0x0001d8, 0x0001d9, 0x0001da, 0x0001db, 0x0001dc, 0x0001dd,
    0x0001de, 0x0001df, 0x0001e0, 0x0001e1, 0x0001e2, 0x0001e3, 0x0001e4, 0x0001e5, 0x0001e6, 0x0001e7, 0x0001e8, 0x0001e9,
    0x0001ea, 0x0001eb, 0x0001ec, 0x0001ed, 0x0001ee, 0x0001ef, 0x0001f0, 0x0001f1, 0x0001f2, 0x0001f3, 0x0001f4, 0x0001f5,
    0x0001f6, 0x0001f7, 0x0001f8, 0x0001f9, 0x0001fa, 0x0001fb, 0x0001fc, 0x0001fd, 0x0001fe, 0x0001ff, 0x000200, 0x000201,
    0x000202, 0x000203, 0x000204, 0x000205, 0x000206, 0x000207, 0x000208, 0x000209, 0x00020a, 0x00020b, 0x00020c, 0x00020d,
    0x00020e, 0x00020f, 0x000210, 0x000211, 0x000212, 0x000213, 0x000214, 0x000215, 0x000216, 0x000217, 0x000218, 0x000219,
    0x00021a, 0x00021b, 0x00021c, 0x00021d, 0x00021e, 0x00021f, 0x000220, 0x000221, 0x000222, 0x000223, 0x000224, 0x000225,
    0x000226, 0x000227, 0x000228, 0x000229, 0x00022a, 0x00022b, 0x00022c, 0x00022d, 0x00022e, 0x00022f, 0x000230, 0x000231,
    0x000232, 0x000233, 0x000234, 0x000235, 0x000236, 0x000250, 0x000251, 0x000252, 0x000253, 0x000254, 0x000255, 0x000256,
    0x000257, 0x000258, 0x000259, 0x00025a, 0x00025b, 0x00025c, 0x00025d, 0x00025e, 0x00025f, 0x000260, 0x000261, 0x000262,
    0x000263, 0x000264, 0x000265, 0x000266, 0x000267, 0x000268, 0x000269, 0x00026a, 0x00026b, 0x00026c, 0x00026d, 0x00026e,
    0x00026f, 0x000270, 0x000271, 0x000272, 0x000273, 0x000274, 0x000275, 0x000276, 0x000277, 0x000278, 0x000279, 0x00027a,
    0x00027b, 0x00027c, 0x00027d, 0x00027e, 0x00027f, 0x000280, 0x000281, 0x000282, 0x000283, 0x000284, 0x000285, 0x000286,
    0x000287, 0x000288, 0x000289, 0x00028a, 0x00028b, 0x00028c, 0x00028d, 0x00028e, 0x00028f, 0x000290, 0x000291, 0x000292,
    0x000293, 0x000294, 0x000295, 0x000296, 0x000297, 0x000298, 0x000299, 0x00029a, 0x00029b, 0x00029c, 0x00029d, 0x00029e,
    0x00029f, 0x0002a0, 0x0002a1, 0x0002a2, 0x0002a3, 0x0002a4, 0x0002a5, 0x0002a6, 0x0002a7, 0x0002a8, 0x0002a9, 0x0002aa,
    0x0002ab, 0x0002ac, 0x0002ad, 0x0002ae, 0x0002af, 0x0002b0, 0x0002b1, 0x0002b2, 0x0002b3, 0x0002b4, 0x0002b5, 0x0002b6,
    0x0002b7, 0x0002b8, 0x0002b9, 0x0002ba, 0x0002bb, 0x0002bc, 0x0002bd, 0x0002be, 0x0002bf, 0x0002c0, 0x0002c1, 0x0002c2,
    0x0002c3, 0x0002c4, 0x0002c5, 0x0002c6, 0x0002c7, 0x0002c8, 0x0002c9, 0x0002ca, 0x0002cb, 0x0002cc, 0x0002cd, 0x0002ce,
    0x0002cf, 0x0002d0, 0x0002d1, 0x0002d2, 0x0002d3, 0x0002d4, 0x0002d5, 0x0002d6, 0x0002d7, 0x0002de, 0x0002df, 0x0002e0,
    0x0002e1, 0x0002e2, 0x0002e3, 0x0002e4, 0x0002e5, 0x0002e6, 0x0002e7, 0x0002e8, 0x0002e9, 0x0002ea, 0x0002eb, 0x0002ec,
    0x0002ed, 0x0002ee, 0x0002ef, 0x0002f0, 0x0002f1, 0x0002f2, 0x0002f3, 0x0002f4, 0x0002f5, 0x0002f6, 0x0002f7, 0x0002f8,
    0x0002f9, 0x0002fa, 0x0002fb, 0x0002fc, 0x0002fd, 0x0002fe, 0x0002ff, 0x000363, 0x000364, 0x000365, 0x000366, 0x000367,
    0x000368, 0x000369, 0x00036a, 0x00036b, 0x00036c, 0x00036d, 0x00036e, 0x00036f, 0x000386, 0x000388, 0x000389, 0x00038a,
    0x00038c, 0x00038e, 0x00038f, 0x000390, 0x000391, 0x000392, 0x000393, 0x000394, 0x000395, 0x000396, 0x000397, 0x000398,
    0x000399, 0x00039a, 0x00039b, 0x00039c, 0x00039d, 0x00039e, 0x00039f, 0x0003a0, 0x0003a1, 0x0003a3, 0x0003a4, 0x0003a5,
    0x0003a6, 0x0003a7, 0x0003a8, 0x0003a9, 0x0003aa, 0x0003ab, 0x0003ac, 0x0003ad, 0x0003ae, 0x0003af, 0x0003b0, 0x0003b1,
    0x0003b2, 0x0003b3, 0x0003b4, 0x0003b5, 0x0003b6, 0x0003b7, 0x0003b8, 0x0003b9, 0x0003ba, 0x0003bb, 0x0003bc, 0x0003bd,
    0x0003be, 0x0003bf, 0x0003c0, 0x0003c1, 0x0003c2, 0x0003c3, 0x0003c4, 0x0003c5, 0x0003c6, 0x0003c7, 0x0003c8, 0x0003c9,
    0x0003ca, 0x0003cb, 0x0003cc, 0x0003cd, 0x0003ce, 0x0003d0, 0x0003d1, 0x0003d2, 0x0003d3, 0x0003d4, 0x0003d5, 0x0003d6,
    0x0003d8, 0x0003d9, 0x0003da, 0x0003db, 0x0003dc, 0x0003dd, 0x0003de, 0x0003df, 0x0003e0, 0x0003e1, 0x0003e2, 0x0003e3,
    0x0003e4, 0x0003e5, 0x0003e6, 0x0003e7, 0x0003e8, 0x0003e9, 0x0003ea, 0x0003eb, 0x0003ec, 0x0003ed, 0x0003ee, 0x0003ef,
    0x0003f0, 0x0003f1, 0x0003f2, 0x0003f3, 0x0003f7, 0x0003f8, 0x0003fa, 0x0003fb, 0x000400, 0x000401, 0x000402, 0x000403,
    0x000404, 0x000405, 0x000406, 0x000407, 0x000408, 0x000409, 0x00040a, 0x00040b, 0x00040c, 0x00040d, 0x00040e, 0x00040f,
    0x000410, 0x000411, 0x000412, 0x000413, 0x000414, 0x000415, 0x000416, 0x000417, 0x000418, 0x000419, 0x00041a, 0x00041b,
    0x00041c, 0x00041d, 0x00041e, 0x00041f, 0x000420, 0x000421, 0x000422, 0x000423, 0x000424, 0x000425, 0x000426, 0x000427,
    0x000428, 0x000429, 0x00042a, 0x00042b, 0x00042c, 0x00042d, 0x00042e, 0x00042f, 0x000430, 0x000431, 0x000432, 0x000433,
    0x000434, 0x000435, 0x000436, 0x000437, 0x000438, 0x000439, 0x00043a, 0x00043b, 0x00043c, 0x00043d, 0x00043e, 0x00043f,
    0x000440, 0x000441, 0x000442, 0x000443, 0x000444, 0x000445, 0x000446, 0x000447, 0x000448, 0x000449, 0x00044a, 0x00044b,
    0x00044c, 0x00044d, 0x00044e, 0x00044f, 0x000450, 0x000451, 0x000452, 0x000453, 0x000454, 0x000455, 0x000456, 0x000457,
    0x000458, 0x000459, 0x00045a, 0x00045b, 0x00045c, 0x00045d, 0x00045e, 0x00045f, 0x000460, 0x000461, 0x000462, 0x000463,
    0x000464, 0x000465, 0x000466, 0x000467, 0x000468, 0x000469, 0x00046a, 0x00046b, 0x00046c, 0x00046d, 0x00046e, 0x00046f,
    0x000470, 0x000471, 0x000472, 0x000473, 0x000474, 0x000475, 0x000476, 0x000477, 0x000478, 0x000479, 0x00047a, 0x00047b,
    0x00047c, 0x00047d, 0x00047e, 0x00047f, 0x000480, 0x000481, 0x00048a, 0x00048b, 0x00048c, 0x00048d, 0x00048e, 0x00048f,
    0x000490, 0x000491, 0x000492, 0x000493, 0x000494, 0x000495, 0x000496, 0x000497, 0x000498, 0x000499, 0x00049a, 0x00049b,
    0x00049c, 0x00049d, 0x00049e, 0x00049f, 0x0004a0, 0x0004a1, 0x0004a2, 0x0004a3, 0x0004a4, 0x0004a5, 0x0004a6, 0x0004a7,
    0x0004a8, 0x0004a9, 0x0004aa, 0x0004ab, 0x0004ac, 0x0004ad, 0x0004ae, 0x0004af, 0x0004b0, 0x0004b1, 0x0004b2, 0x0004b3,
    0x0004b4, 0x0004b5, 0x0004b6, 0x0004b7, 0x0004b8, 0x0004b9, 0x0004ba, 0x0004bb, 0x0004bc, 0x0004bd, 0x0004be, 0x0004bf,
    0x0004c0, 0x0004c1, 0x0004c2, 0x0004c3, 0x0004c4, 0x0004c5, 0x0004c6, 0x0004c7, 0x0004c8, 0x0004c9, 0x0004ca, 0x0004cb,
    0x0004cc, 0x0004cd, 0x0004ce, 0x0004d0, 0x0004d1, 0x0004d2, 0x0004d3, 0x0004d6, 0x0004d7, 0x0004d8, 0x0004d9, 0x0004da,
    0x0004db, 0x0004dc, 0x0004dd, 0x0004de, 0x0004df, 0x0004e0, 0x0004e1, 0x0004e2, 0x0004e3, 0x0004e4, 0x0004e5, 0x0004e6,
    0x0004e7, 0x0004e8, 0x0004e9, 0x0004ea, 0x0004eb, 0x0004ec, 0x0004ed, 0x0004ee, 0x0004ef, 0x0004f0, 0x0004f1, 0x0004f2,
    0x0004f3, 0x0004f4, 0x0004f5, 0x0004f8, 0x0004f9, 0x000500, 0x000501, 0x000502, 0x000503, 0x000504, 0x000505, 0x000506,
    0x000507, 0x000508, 0x000509, 0x00050a, 0x00050b, 0x00050c, 0x00050d, 0x00050e, 0x00050f, 0x000531, 0x000532, 0x000533,
    0x000534, 0x000535, 0x000536, 0x000537, 0x000538, 0x000539, 0x00053a, 0x00053b, 0x00053c, 0x00053d, 0x00053e, 0x00053f,
    0x000540, 0x000541, 0x000542, 0x000543, 0x000544, 0x000545, 0x000546, 0x000547, 0x000548, 0x000549, 0x00054a, 0x00054b,
    0x00054c, 0x00054d, 0x00054e, 0x00054f, 0x000550, 0x000551, 0x000552, 0x000553, 0x000554, 0x000555, 0x000556, 0x000559,
    0x00055a, 0x000561, 0x000562, 0x000563, 0x000564, 0x000565, 0x000566, 0x000567, 0x000568, 0x000569, 0x00056a, 0x00056b,
    0x00056c, 0x00056d, 0x00056e, 0x00056f, 0x000570, 0x000571, 0x000572, 0x000573, 0x000574, 0x000575, 0x000576, 0x000577,
    0x000578, 0x000579, 0x00057a, 0x00057b, 0x00057c, 0x00057d, 0x00057e, 0x00057f, 0x000580, 0x000581, 0x000582, 0x000583,
    0x000584, 0x000585, 0x000586, 0x0005d0, 0x0005d1, 0x0005d2, 0x0005d3, 0x0005d4, 0x0005d5, 0x0005d6, 0x0005d7, 0x0005d8,
    0x0005d9, 0x0005da, 0x0005db, 0x0005dc, 0x0005dd, 0x0005de, 0x0005df, 0x0005e0, 0x0005e1, 0x0005e2, 0x0005e3, 0x0005e4,
    0x0005e5, 0x0005e6, 0x0005e7, 0x0005e8, 0x0005e9, 0x0005ea, 0x0005f0, 0x0005f1, 0x0005f2, 0x000621, 0x000622, 0x000623,
    0x000624, 0x000625, 0x000626, 0x000627, 0x000628, 0x000629, 0x00062a, 0x00062b, 0x00062c, 0x00062d, 0x00062e, 0x00062f,
    0x000630, 0x000631, 0x000632, 0x000633, 0x000634, 0x000635, 0x000636, 0x000637, 0x000638, 0x000639, 0x00063a, 0x000641,
    0x000642, 0x000643, 0x000644, 0x000645, 0x000646, 0x000647, 0x000648, 0x000649, 0x00064a, 0x00066e, 0x00066f, 0x000670,
    0x000671, 0x000672, 0x000673, 0x000674, 0x000675, 0x000676, 0x000677, 0x000678, 0x000679, 0x00067a, 0x00067b, 0x00067c,
    0x00067d, 0x00067e, 0x00067f, 0x000680, 0x000681, 0x000682, 0x000683, 0x000684, 0x000685, 0x000686, 0x000687, 0x000688,
    0x000689, 0x00068a, 0x00068b, 0x00068c, 0x00068d, 0x00068e, 0x00068f, 0x000690, 0x000691, 0x000692, 0x000693, 0x000694,
    0x000695, 0x000696, 0x000697, 0x000698, 0x000699, 0x00069a, 0x00069b, 0x00069c, 0x00069d, 0x00069e, 0x00069f, 0x0006a0,
    0x0006a1, 0x0006a2, 0x0006a3, 0x0006a4, 0x0006a5, 0x0006a6, 0x0006a7, 0x0006a8, 0x0006a9, 0x0006aa, 0x0006ab, 0x0006ac,
    0x0006ad, 0x0006ae, 0x0006af, 0x0006b0, 0x0006b1, 0x0006b2, 0x0006b3, 0x0006b4, 0x0006b5, 0x0006b6, 0x0006b7, 0x0006b8,
    0x0006b9, 0x0006ba, 0x0006bb, 0x0006bc, 0x0006bd, 0x0006be, 0x0006bf, 0x0006c0, 0x0006c1, 0x0006c2, 0x0006c3, 0x0006c4,
    0x0006c5, 0x0006c6, 0x0006c7, 0x0006c8, 0x0006c9, 0x0006ca, 0x0006cb, 0x0006cc, 0x0006cd, 0x0006ce, 0x0006cf, 0x0006d0,
    0x0006d1, 0x0006d2, 0x0006d3, 0x0006d5, 0x0006ee, 0x0006ef, 0x0006fa, 0x0006fb, 0x0006fc, 0x0006ff, 0x000710, 0x000711,
    0x000712, 0x000713, 0x000714, 0x000715, 0x000716, 0x000717, 0x000718, 0x000719, 0x00071a, 0x00071b, 0x00071c, 0x00071d,
    0x00071e, 0x00071f, 0x000720, 0x000721, 0x000722, 0x000723, 0x000724, 0x000725, 0x000726, 0x000727, 0x000728, 0x000729,
    0x00072a, 0x00072b, 0x00072c, 0x00072d, 0x00072e, 0x00072f, 0x00074d, 0x00074e, 0x00074f, 0x000780, 0x000781, 0x000782,
    0x000783, 0x000784, 0x000785, 0x000786, 0x000787, 0x000788, 0x000789, 0x00078a, 0x00078b, 0x00078c, 0x00078d, 0x00078e,
    0x00078f, 0x000790, 0x000791, 0x000792, 0x000793, 0x000794, 0x000795, 0x000796, 0x000797, 0x000798, 0x000799, 0x00079a,
    0x00079b, 0x00079c, 0x00079d, 0x00079e, 0x00079f, 0x0007a0, 0x0007a1, 0x0007a2, 0x0007a3, 0x0007a4, 0x0007a5, 0x0007b1,
    0x000904, 0x000905, 0x000906, 0x000907, 0x000908, 0x000909, 0x00090a, 0x00090b, 0x00090c, 0x00090d, 0x00090e, 0x00090f,
    0x000910, 0x000911, 0x000912, 0x000913, 0x000914, 0x000915, 0x000916, 0x000917, 0x000918, 0x000919, 0x00091a, 0x00091b,
    0x00091c, 0x00091d, 0x00091e, 0x00091f, 0x000920, 0x000921, 0x000922, 0x000923, 0x000924, 0x000925, 0x000926, 0x000927,
    0x000928, 0x000929, 0x00092a, 0x00092b, 0x00092c, 0x00092d, 0x00092e, 0x00092f, 0x000930, 0x000931, 0x000932, 0x000933,
    0x000934, 0x000935, 0x000936, 0x000937, 0x000938, 0x000939, 0x000958, 0x000959, 0x00095a, 0x00095b, 0x00095c, 0x00095d,
    0x00095e, 0x00095f, 0x000960, 0x000961, 0x000985, 0x000986, 0x000987, 0x000988, 0x000989, 0x00098a, 0x00098b, 0x00098c,
    0x00098f, 0x000990, 0x000993, 0x000994, 0x000995, 0x000996, 0x000997, 0x000998, 0x000999, 0x00099a, 0x00099b, 0x00099c,
    0x00099d, 0x00099e, 0x00099f, 0x0009a0, 0x0009a1, 0x0009a2, 0x0009a3, 0x0009a4, 0x0009a5, 0x0009a6, 0x0009a7, 0x0009a8,
    0x0009aa, 0x0009ab, 0x0009ac, 0x0009ad, 0x0009ae, 0x0009af, 0x0009b0, 0x0009b2, 0x0009b6, 0x0009b7, 0x0009b8, 0x0009b9,
    0x0009dc, 0x0009dd, 0x0009df, 0x0009e0, 0x0009e1, 0x0009f0, 0x0009f1, 0x000a05, 0x000a06, 0x000a07, 0x000a08, 0x000a09,
    0x000a0a, 0x000a0f, 0x000a10, 0x000a13, 0x000a14, 0x000a15, 0x000a16, 0x000a17, 0x000a18, 0x000a19, 0x000a1a, 0x000a1b,
    0x000a1c, 0x000a1d, 0x000a1e, 0x000a1f, 0x000a20, 0x000a21, 0x000a22, 0x000a23, 0x000a24, 0x000a25, 0x000a26, 0x000a27,
    0x000a28, 0x000a2a, 0x000a2b, 0x000a2c, 0x000a2d, 0x000a2e, 0x000a2f, 0x000a30, 0x000a32, 0x000a33, 0x000a35, 0x000a36,
    0x000a38, 0x000a39, 0x000a59, 0x000a5a, 0x000a5b, 0x000a5c, 0x000a5e, 0x000a85, 0x000a86, 0x000a87, 0x000a88, 0x000a89,
    0x000a8a, 0x000a8b, 0x000a8c, 0x000a8f, 0x000a90, 0x000a93, 0x000a94, 0x000a95, 0x000a96, 0x000a97, 0x000a98, 0x000a99,
    0x000a9a, 0x000a9b, 0x000a9c, 0x000a9d, 0x000a9e, 0x000a9f, 0x000aa0, 0x000aa1, 0x000aa2, 0x000aa3, 0x000aa4, 0x000aa5,
    0x000aa6, 0x000aa7, 0x000aa8, 0x000aaa, 0x000aab, 0x000aac, 0x000aad, 0x000aae, 0x000aaf, 0x000ab0, 0x000ab2, 0x000ab3,
    0x000ab5, 0x000ab6, 0x000ab7, 0x000ab8, 0x000ab9, 0x000ae0, 0x000ae1, 0x000b05, 0x000b06, 0x000b07, 0x000b08, 0x000b09,
    0x000b0a, 0x000b0b, 0x000b0c, 0x000b0f, 0x000b10, 0x000b13, 0x000b14, 0x000b15, 0x000b16, 0x000b17, 0x000b18, 0x000b19,
    0x000b1a, 0x000b1b, 0x000b1c, 0x000b1d, 0x000b1e, 0x000b1f, 0x000b20, 0x000b21, 0x000b22, 0x000b23, 0x000b24, 0x000b25,
    0x000b26, 0x000b27, 0x000b28, 0x000b2a, 0x000b2b, 0x000b2c, 0x000b2d, 0x000b2e, 0x000b2f, 0x000b30, 0x000b32, 0x000b33,
    0x000b35, 0x000b36, 0x000b37, 0x000b38, 0x000b39, 0x000b5c, 0x000b5d, 0x000b5f, 0x000b60, 0x000b61, 0x000b71, 0x000b85,
    0x000b86, 0x000b87, 0x000b88, 0x000b89, 0x000b8a, 0x000b8e, 0x000b8f, 0x000b90, 0x000b92, 0x000b93, 0x000b94, 0x000b95,
    0x000b99, 0x000b9a, 0x000b9c, 0x000b9e, 0x000b9f, 0x000ba3, 0x000ba4, 0x000ba8, 0x000ba9, 0x000baa, 0x000bae, 0x000baf,
    0x000bb0, 0x000bb1, 0x000bb2, 0x000bb3, 0x000bb4, 0x000bb5, 0x000bb7, 0x000bb8, 0x000bb9, 0x000c05, 0x000c06, 0x000c07,
    0x000c08, 0x000c09, 0x000c0a, 0x000c0b, 0x000c0c, 0x000c0e, 0x000c0f, 0x000c10, 0x000c12, 0x000c13, 0x000c14, 0x000c15,
    0x000c16, 0x000c17, 0x000c18, 0x000c19, 0x000c1a, 0x000c1b, 0x000c1c, 0x000c1d, 0x000c1e, 0x000c1f, 0x000c20, 0x000c21,
    0x000c22, 0x000c23, 0x000c24, 0x000c25, 0x000c26, 0x000c27, 0x000c28, 0x000c2a, 0x000c2b, 0x000c2c, 0x000c2d, 0x000c2e,
    0x000c2f, 0x000c30, 0x000c31, 0x000c32, 0x000c33, 0x000c35, 0x000c36, 0x000c37, 0x000c38, 0x000c39, 0x000c60, 0x000c61,
    0x000c85, 0x000c86, 0x000c87, 0x000c88, 0x000c89, 0x000c8a, 0x000c8b, 0x000c8c, 0x000c8e, 0x000c8f, 0x000c90, 0x000c92,
    0x000c93, 0x000c94, 0x000c95, 0x000c96, 0x000c97, 0x000c98, 0x000c99, 0x000c9a, 0x000c9b, 0x000c9c, 0x000c9d, 0x000c9e,
    0x000c9f, 0x000ca0, 0x000ca1, 0x000ca2, 0x000ca3, 0x000ca4, 0x000ca5, 0x000ca6, 0x000ca7, 0x000ca8, 0x000caa, 0x000cab,
    0x000cac, 0x000cad, 0x000cae, 0x000caf, 0x000cb0, 0x000cb1, 0x000cb2, 0x000cb3, 0x000cb5, 0x000cb6, 0x000cb7, 0x000cb8,
    0x000cb9, 0x000cde, 0x000ce0, 0x000ce1, 0x000d05, 0x000d06, 0x000d07, 0x000d08, 0x000d09, 0x000d0a, 0x000d0b, 0x000d0c,
    0x000d0e, 0x000d0f, 0x000d10, 0x000d12, 0x000d13, 0x000d14, 0x000d15, 0x000d16, 0x000d17, 0x000d18, 0x000d19, 0x000d1a,
    0x000d1b, 0x000d1c, 0x000d1d, 0x000d1e, 0x000d1f, 0x000d20, 0x000d21, 0x000d22, 0x000d23, 0x000d24, 0x000d25, 0x000d26,
    0x000d27, 0x000d28, 0x000d2a, 0x000d2b, 0x000d2c, 0x000d2d, 0x000d2e, 0x000d2f, 0x000d30, 0x000d31, 0x000d32, 0x000d33,
    0x000d34, 0x000d35, 0x000d36, 0x000d37, 0x000d38, 0x000d39, 0x000d60, 0x000d61, 0x000d85, 0x000d86, 0x000d87, 0x000d88,
    0x000d89, 0x000d8a, 0x000d8b, 0x000d8c, 0x000d8d, 0x000d8e, 0x000d8f, 0x000d90, 0x000d91, 0x000d92, 0x000d93, 0x000d94,
    0x000d95, 0x000d96, 0x000d9a, 0x000d9b, 0x000d9c, 0x000d9d, 0x000d9e, 0x000d9f, 0x000da0, 0x000da1, 0x000da2, 0x000da3,
    0x000da4, 0x000da5, 0x000da6, 0x000da7, 0x000da8, 0x000da9, 0x000daa, 0x000dab, 0x000dac, 0x000dad, 0x000dae, 0x000daf,
    0x000db0, 0x000db1, 0x000db3, 0x000db4, 0x000db5, 0x000db6, 0x000db7, 0x000db8, 0x000db9, 0x000dba, 0x000dbb, 0x000dbd,
    0x000dc0, 0x000dc1, 0x000dc2, 0x000dc3, 0x000dc4, 0x000dc5, 0x000dc6, 0x000e01, 0x000e02, 0x000e03, 0x000e04, 0x000e05,
    0x000e06, 0x000e07, 0x000e08, 0x000e09, 0x000e0a, 0x000e0b, 0x000e0c, 0x000e0d, 0x000e0e, 0x000e0f, 0x000e10, 0x000e11,
    0x000e12, 0x000e13, 0x000e14, 0x000e15, 0x000e16, 0x000e17, 0x000e18, 0x000e19, 0x000e1a, 0x000e1b, 0x000e1c, 0x000e1d,
    0x000e1e, 0x000e1f, 0x000e20, 0x000e21, 0x000e22, 0x000e23, 0x000e24, 0x000e25, 0x000e26, 0x000e27, 0x000e28, 0x000e29,
    0x000e2a, 0x000e2b, 0x000e2c, 0x000e2d, 0x000e2e, 0x000e81, 0x000e82, 0x000e84, 0x000e87, 0x000e88, 0x000e8a, 0x000e8d,
    0x000e94, 0x000e95, 0x000e96, 0x000e97, 0x000e99, 0x000e9a, 0x000e9b, 0x000e9c, 0x000e9d, 0x000e9e, 0x000e9f, 0x000ea1,
    0x000ea2, 0x000ea3, 0x000ea5, 0x000ea7, 0x000eaa, 0x000eab, 0x000ead, 0x000eae, 0x000f40, 0x000f41, 0x000f42, 0x000f43,
    0x000f44, 0x000f45, 0x000f46, 0x000f47, 0x000f49, 0x000f4a, 0x000f4b, 0x000f4c, 0x000f4d, 0x000f4e, 0x000f4f, 0x000f50,
    0x000f51, 0x000f52, 0x000f53, 0x000f54, 0x000f55, 0x000f56, 0x000f57, 0x000f58, 0x000f59, 0x000f5a, 0x000f5b, 0x000f5c,
    0x000f5d, 0x000f5e, 0x000f5f, 0x000f60, 0x000f61, 0x000f62, 0x000f63, 0x000f64, 0x000f65, 0x000f66, 0x000f67, 0x000f68,
    0x000f69, 0x000f6a, 0x000f90, 0x000f91, 0x000f92, 0x000f93, 0x000f94, 0x000f95, 0x000f96, 0x000f97, 0x000f99, 0x000f9a,
    0x000f9b, 0x000f9c, 0x000f9d, 0x000f9e, 0x000f9f, 0x000fa0, 0x000fa1, 0x000fa2, 0x000fa3, 0x000fa4, 0x000fa5, 0x000fa6,
    0x000fa7, 0x000fa8, 0x000fa9, 0x000faa, 0x000fab, 0x000fac, 0x000fad, 0x000fae, 0x000faf, 0x000fb0, 0x000fb1, 0x000fb2,
    0x000fb3, 0x000fb4, 0x000fb5, 0x000fb6, 0x000fb7, 0x000fb8, 0x000fb9, 0x000fba, 0x000fbb, 0x000fbc, 0x001000, 0x001001,
    0x001002, 0x001003, 0x001004, 0x001005, 0x001006, 0x001007, 0x001008, 0x001009, 0x00100a, 0x00100b, 0x00100c, 0x00100d,
    0x00100e, 0x00100f, 0x001010, 0x001011, 0x001012, 0x001013, 0x001014, 0x001015, 0x001016, 0x001017, 0x001018, 0x001019,
    0x00101a, 0x00101b, 0x00101c, 0x00101d, 0x00101e, 0x00101f, 0x001020, 0x001021, 0x001023, 0x001024, 0x001025, 0x001026,
    0x001027, 0x001029, 0x00102a, 0x001050, 0x001051, 0x001052, 0x001053, 0x001054, 0x001055, 0x0010a0, 0x0010a1, 0x0010a2,
    0x0010a3, 0x0010a4, 0x0010a5, 0x0010a6, 0x0010a7, 0x0010a8, 0x0010a9, 0x0010aa, 0x0010ab, 0x0010ac, 0x0010ad, 0x0010ae,
    0x0010af, 0x0010b0, 0x0010b1, 0x0010b2, 0x0010b3, 0x0010b4, 0x0010b5, 0x0010b6, 0x0010b7, 0x0010b8, 0x0010b9, 0x0010ba,
    0x0010bb, 0x0010bc, 0x0010bd, 0x0010be, 0x0010bf, 0x0010c0, 0x0010c1, 0x0010c2, 0x0010c3, 0x0010c4, 0x0010c5, 0x0010d0,
    0x0010d1, 0x0010d2, 0x0010d3, 0x0010d4, 0x0010d5, 0x0010d6, 0x0010d7, 0x0010d8, 0x0010d9, 0x0010da, 0x0010db, 0x0010dc,
    0x0010dd, 0x0010de, 0x0010df, 0x0010e0, 0x0010e1, 0x0010e2, 0x0010e3, 0x0010e4, 0x0010e5, 0x0010e6, 0x0010e7, 0x0010e8,
    0x0010e9, 0x0010ea, 0x0010eb, 0x0010ec, 0x0010ed, 0x0010ee, 0x0010ef, 0x0010f0, 0x0010f1, 0x0010f2, 0x0010f3, 0x0010f4,
    0x0010f5, 0x0010f6, 0x0010f7, 0x0010f8, 0x0013a0, 0x0013a1, 0x0013a2, 0x0013a3, 0x0013a4, 0x0013a5, 0x0013a6, 0x0013a7,
    0x0013a8, 0x0013a9, 0x0013aa, 0x0013ab, 0x0013ac, 0x0013ad, 0x0013ae, 0x0013af, 0x0013b0, 0x0013b1, 0x0013b2, 0x0013b3,
    0x0013b4, 0x0013b5, 0x0013b6, 0x0013b7, 0x0013b8, 0x0013b9, 0x0013ba, 0x0013bb, 0x0013bc, 0x0013bd, 0x0013be, 0x0013bf,
    0x0013c0, 0x0013c1, 0x0013c2, 0x0013c3, 0x0013c4, 0x0013c5, 0x0013c6, 0x0013c7, 0x0013c8, 0x0013c9, 0x0013ca, 0x0013cb,
    0x0013cc, 0x0013cd, 0x0013ce, 0x0013cf, 0x0013d0, 0x0013d1, 0x0013d2, 0x0013d3, 0x0013d4, 0x0013d5, 0x0013d6, 0x0013d7,
    0x0013d8, 0x0013d9, 0x0013da, 0x0013db, 0x0013dc, 0x0013dd, 0x0013de, 0x0013df, 0x0013e0, 0x0013e1, 0x0013e2, 0x0013e3,
    0x0013e4, 0x0013e5, 0x0013e6, 0x0013e7, 0x0013e8, 0x0013e9, 0x0013ea, 0x0013eb, 0x0013ec, 0x0013ed, 0x0013ee, 0x0013ef,
    0x0013f0, 0x0013f1, 0x0013f2, 0x0013f3, 0x0013f4, 0x001681, 0x001682, 0x001683, 0x001684, 0x001685, 0x001686, 0x001687,
    0x001688, 0x001689, 0x00168a, 0x00168b, 0x00168c, 0x00168d, 0x00168e, 0x00168f, 0x001690, 0x001691, 0x001692, 0x001693,
    0x001694, 0x001695, 0x001696, 0x001697, 0x001698, 0x001699, 0x00169a, 0x0016a0, 0x0016a1, 0x0016a2, 0x0016a3, 0x0016a4,
    0x0016a5, 0x0016a6, 0x0016a7, 0x0016a8, 0x0016a9, 0x0016aa, 0x0016ab, 0x0016ac, 0x0016ad, 0x0016ae, 0x0016af, 0x0016b0,
    0x0016b1, 0x0016b2, 0x0016b3, 0x0016b4, 0x0016b5, 0x0016b6, 0x0016b7, 0x0016b8, 0x0016b9, 0x0016ba, 0x0016bb, 0x0016bc,
    0x0016bd, 0x0016be, 0x0016bf, 0x0016c0, 0x0016c1, 0x0016c2, 0x0016c3, 0x0016c4, 0x0016c5, 0x0016c6, 0x0016c7, 0x0016c8,
    0x0016c9, 0x0016ca, 0x0016cb, 0x0016cc, 0x0016cd, 0x0016ce, 0x0016cf, 0x0016d0, 0x0016d1, 0x0016d2, 0x0016d3, 0x0016d4,
    0x0016d5, 0x0016d6, 0x0016d7, 0x0016d8, 0x0016d9, 0x0016da, 0x0016db, 0x0016dc, 0x0016dd, 0x0016de, 0x0016df, 0x0016e0,
    0x0016e1, 0x0016e2, 0x0016e3, 0x0016e4, 0x0016e5, 0x0016e6, 0x0016e7, 0x0016e8, 0x0016e9, 0x0016ea, 0x001700, 0x001701,
    0x001702, 0x001703, 0x001704, 0x001705, 0x001706, 0x001707, 0x001708, 0x001709, 0x00170a, 0x00170b, 0x00170c, 0x00170e,
    0x00170f, 0x001710, 0x001711, 0x001720, 0x001721, 0x001722, 0x001723, 0x001724, 0x001725, 0x001726, 0x001727, 0x001728,
    0x001729, 0x00172a, 0x00172b, 0x00172c, 0x00172d, 0x00172e, 0x00172f, 0x001730, 0x001731, 0x001740, 0x001741, 0x001742,
    0x001743, 0x001744, 0x001745, 0x001746, 0x001747, 0x001748, 0x001749, 0x00174a, 0x00174b, 0x00174c, 0x00174d, 0x00174e,
    0x00174f, 0x001750, 0x001751, 0x001760, 0x001761, 0x001762, 0x001763, 0x001764, 0x001765, 0x001766, 0x001767, 0x001768,
    0x001769, 0x00176a, 0x00176b, 0x00176c, 0x00176e, 0x00176f, 0x001770, 0x001780, 0x001781, 0x001782, 0x001783, 0x001784,
    0x001785, 0x001786, 0x001787, 0x001788, 0x001789, 0x00178a, 0x00178b, 0x00178c, 0x00178d, 0x00178e, 0x00178f, 0x001790,
    0x001791, 0x001792, 0x001793, 0x001794, 0x001795, 0x001796, 0x001797, 0x001798, 0x001799, 0x00179a, 0x00179b, 0x00179c,
    0x00179d, 0x00179e, 0x00179f, 0x0017a0, 0x0017a1, 0x0017a2, 0x001820, 0x001821, 0x001822, 0x001823, 0x001824, 0x001825,
    0x001826, 0x001827, 0x001828, 0x001829, 0x00182a, 0x00182b, 0x00182c, 0x00182d, 0x00182e, 0x00182f, 0x001830, 0x001831,
    0x001832, 0x001833, 0x001834, 0x001835, 0x001836, 0x001837, 0x001838, 0x001839, 0x00183a, 0x00183b, 0x00183c, 0x00183d,
    0x00183e, 0x00183f, 0x001840, 0x001841, 0x001842, 0x001843, 0x001844, 0x001845, 0x001846, 0x001847, 0x001848, 0x001849,
    0x00184a, 0x00184b, 0x00184c, 0x00184d, 0x00184e, 0x00184f, 0x001850, 0x001851, 0x001852, 0x001853, 0x001854, 0x001855,
    0x001856, 0x001857, 0x001858, 0x001859, 0x00185a, 0x00185b, 0x00185c, 0x00185d, 0x00185e, 0x00185f, 0x001860, 0x001861,
    0x001862, 0x001863, 0x001864, 0x001865, 0x001866, 0x001867, 0x001868, 0x001869, 0x00186a, 0x00186b, 0x00186c, 0x00186d,
    0x00186e, 0x00186f, 0x001870, 0x001871, 0x001872, 0x001873, 0x001874, 0x001875, 0x001876, 0x001877, 0x001880, 0x001881,
    0x001882, 0x001883, 0x001884, 0x001885, 0x001886, 0x001887, 0x001888, 0x001889, 0x00188a, 0x00188b, 0x00188c, 0x00188d,
    0x00188e, 0x00188f, 0x001890, 0x001891, 0x001892, 0x001893, 0x001894, 0x001895, 0x001896, 0x001897, 0x001898, 0x001899,
    0x00189a, 0x00189b, 0x00189c, 0x00189d, 0x00189e, 0x00189f, 0x0018a0, 0x0018a1, 0x0018a2, 0x0018a3, 0x0018a4, 0x0018a5,
    0x0018a6, 0x0018a7, 0x0018a8, 0x0018a9, 0x001900, 0x001901, 0x001902, 0x001903, 0x001904, 0x001905, 0x001906, 0x001907,
    0x001908, 0x001909, 0x00190a, 0x00190b, 0x00190c, 0x00190d, 0x00190e, 0x00190f, 0x001910, 0x001911, 0x001912, 0x001913,
    0x001914, 0x001915, 0x001916, 0x001917, 0x001918, 0x001919, 0x00191a, 0x00191b, 0x00191c, 0x001929, 0x00192a, 0x00192b,
    0x001930, 0x001931, 0x001932, 0x001933, 0x001934, 0x001935, 0x001936, 0x001937, 0x001938, 0x001950, 0x001951, 0x001952,
    0x001953, 0x001954, 0x001955, 0x001956, 0x001957, 0x001958, 0x001959, 0x00195a, 0x00195b, 0x00195c, 0x00195d, 0x00195e,
    0x00195f, 0x001960, 0x001961, 0x001962, 0x001963, 0x001964, 0x001965, 0x001966, 0x001967, 0x001968, 0x001969, 0x00196a,
    0x00196b, 0x00196c, 0x00196d, 0x001970, 0x001971, 0x001972, 0x001973, 0x001974, 0x001d00, 0x001d01, 0x001d02, 0x001d03,
    0x001d04, 0x001d05, 0x001d06, 0x001d07, 0x001d08, 0x001d09, 0x001d0a, 0x001d0b, 0x001d0c, 0x001d0d, 0x001d0e, 0x001d0f,
    0x001d10, 0x001d11, 0x001d12, 0x001d13, 0x001d14, 0x001d15, 0x001d16, 0x001d17, 0x001d18, 0x001d19, 0x001d1a, 0x001d1b,
    0x001d1c, 0x001d1d, 0x001d1e, 0x001d1f, 0x001d20, 0x001d21, 0x001d22, 0x001d23, 0x001d24, 0x001d25, 0x001d26, 0x001d27,
    0x001d28, 0x001d29, 0x001d2a, 0x001d2b, 0x001d2c, 0x001d2d, 0x001d2e, 0x001d2f, 0x001d30, 0x001d31, 0x001d32, 0x001d33,
    0x001d34, 0x001d35, 0x001d36, 0x001d37, 0x001d38, 0x001d39, 0x001d3a, 0x001d3b, 0x001d3c, 0x001d3d, 0x001d3e, 0x001d3f,
    0x001d40, 0x001d41, 0x001d42, 0x001d43, 0x001d44, 0x001d45, 0x001d46, 0x001d47, 0x001d48, 0x001d49, 0x001d4a, 0x001d4b,
    0x001d4c, 0x001d4d, 0x001d4e, 0x001d4f, 0x001d50, 0x001d51, 0x001d52, 0x001d53, 0x001d54, 0x001d55, 0x001d56, 0x001d57,
    0x001d58, 0x001d59, 0x001d5a, 0x001d5b, 0x001d5c, 0x001d5d, 0x001d5e, 0x001d5f, 0x001d60, 0x001d61, 0x001d62, 0x001d63,
    0x001d64, 0x001d65, 0x001d66, 0x001d67, 0x001d68, 0x001d69, 0x001d6a, 0x001d6b, 0x001e00, 0x001e01, 0x001e02, 0x001e03,
    0x001e04, 0x001e05, 0x001e06, 0x001e07, 0x001e08, 0x001e09, 0x001e0a, 0x001e0b, 0x001e0c, 0x001e0d, 0x001e0e, 0x001e0f,
    0x001e10, 0x001e11, 0x001e12, 0x001e13, 0x001e14, 0x001e15, 0x001e16, 0x001e17, 0x001e18, 0x001e19, 0x001e1a, 0x001e1b,
    0x001e1c, 0x001e1d, 0x001e1e, 0x001e1f, 0x001e20, 0x001e21, 0x001e22, 0x001e23, 0x001e24, 0x001e25, 0x001e26, 0x001e27,
    0x001e28, 0x001e29, 0x001e2a, 0x001e2b, 0x001e2c, 0x001e2d, 0x001e2e, 0x001e2f, 0x001e30, 0x001e31, 0x001e32, 0x001e33,
    0x001e34, 0x001e35, 0x001e36, 0x001e37, 0x001e38, 0x001e39, 0x001e3a, 0x001e3b, 0x001e3c, 0x001e3d, 0x001e3e, 0x001e3f,
    0x001e40, 0x001e41, 0x001e42, 0x001e43, 0x001e44, 0x001e45, 0x001e46, 0x001e47, 0x001e48, 0x001e49, 0x001e4a, 0x001e4b,
    0x001e4c, 0x001e4d, 0x001e4e, 0x001e4f, 0x001e50, 0x001e51, 0x001e52, 0x001e53, 0x001e54, 0x001e55, 0x001e56, 0x001e57,
    0x001e58, 0x001e59, 0x001e5a, 0x001e5b, 0x001e5c, 0x001e5d, 0x001e5e, 0x001e5f, 0x001e60, 0x001e61, 0x001e62, 0x001e63,
    0x001e64, 0x001e65, 0x001e66, 0x001e67, 0x001e68, 0x001e69, 0x001e6a, 0x001e6b, 0x001e6c, 0x001e6d, 0x001e6e, 0x001e6f,
    0x001e70, 0x001e71, 0x001e72, 0x001e73, 0x001e74, 0x001e75, 0x001e76, 0x001e77, 0x001e78, 0x001e79, 0x001e7a, 0x001e7b,
    0x001e7c, 0x001e7d, 0x001e7e, 0x001e7f, 0x001e80, 0x001e81, 0x001e82, 0x001e83, 0x001e84, 0x001e85, 0x001e86, 0x001e87,
    0x001e88, 0x001e89, 0x001e8a, 0x001e8b, 0x001e8c, 0x001e8d, 0x001e8e, 0x001e8f, 0x001e90, 0x001e91, 0x001e92, 0x001e93,
    0x001e94, 0x001e95, 0x001e96, 0x001e97, 0x001e98, 0x001e99, 0x001e9a, 0x001e9b, 0x001ea0, 0x001ea1, 0x001ea2, 0x001ea3,
    0x001ea4, 0x001ea5, 0x001ea6, 0x001ea7, 0x001ea8, 0x001ea9, 0x001eaa, 0x001eab, 0x001eac, 0x001ead, 0x001eae, 0x001eaf,
    0x001eb0, 0x001eb1, 0x001eb2, 0x001eb3, 0x001eb4, 0x001eb5, 0x001eb6, 0x001eb7, 0x001eb8, 0x001eb9, 0x001eba, 0x001ebb,
    0x001ebc, 0x001ebd, 0x001ebe, 0x001ebf, 0x001ec0, 0x001ec1, 0x001ec2, 0x001ec3, 0x001ec4, 0x001ec5, 0x001ec6, 0x001ec7,
    0x001ec8, 0x001ec9, 0x001eca, 0x001ecb, 0x001ecc, 0x001ecd, 0x001ece, 0x001ecf, 0x001ed0, 0x001ed1, 0x001ed2, 0x001ed3,
    0x001ed4, 0x001ed5, 0x001ed6, 0x001ed7, 0x001ed8, 0x001ed9, 0x001eda, 0x001edb, 0x001edc, 0x001edd, 0x001ede, 0x001edf,
    0x001ee0, 0x001ee1, 0x001ee2, 0x001ee3, 0x001ee4, 0x001ee5, 0x001ee6, 0x001ee7, 0x001ee8, 0x001ee9, 0x001eea, 0x001eeb,
    0x001eec, 0x001eed, 0x001eee, 0x001eef, 0x001ef0, 0x001ef1, 0x001ef2, 0x001ef3, 0x001ef4, 0x001ef5, 0x001ef6, 0x001ef7,
    0x001ef8, 0x001ef9, 0x001f00, 0x001f01, 0x001f02, 0x001f03, 0x001f04, 0x001f05, 0x001f06, 0x001f07, 0x001f08, 0x001f09,
    0x001f0a, 0x001f0b, 0x001f0c, 0x001f0d, 0x001f0e, 0x001f0f, 0x001f10, 0x001f11, 0x001f12, 0x001f13, 0x001f14, 0x001f15,
    0x001f18, 0x001f19, 0x001f1a, 0x001f1b, 0x001f1c, 0x001f1d, 0x001f20, 0x001f21, 0x001f22, 0x001f23, 0x001f24, 0x001f25,
    0x001f26, 0x001f27, 0x001f28, 0x001f29, 0x001f2a, 0x001f2b, 0x001f2c, 0x001f2d, 0x001f2e, 0x001f2f, 0x001f30, 0x001f31,
    0x001f32, 0x001f33, 0x001f34, 0x001f35, 0x001f36, 0x001f37, 0x001f38, 0x001f39, 0x001f3a, 0x001f3b, 0x001f3c, 0x001f3d,
    0x001f3e, 0x001f3f, 0x001f40, 0x001f41, 0x001f42, 0x001f43, 0x001f44, 0x001f45, 0x001f48, 0x001f49, 0x001f4a, 0x001f4b,
    0x001f4c, 0x001f4d, 0x001f50, 0x001f51, 0x001f52, 0x001f53, 0x001f54, 0x001f55, 0x001f56, 0x001f57, 0x001f59, 0x001f5b,
    0x001f5d, 0x001f5f, 0x001f60, 0x001f61, 0x001f62, 0x001f63, 0x001f64, 0x001f65, 0x001f66, 0x001f67, 0x001f68, 0x001f69,
    0x001f6a, 0x001f6b, 0x001f6c, 0x001f6d, 0x001f6e, 0x001f6f, 0x001f70, 0x001f71, 0x001f72, 0x001f73, 0x001f74, 0x001f75,
    0x001f76, 0x001f77, 0x001f78, 0x001f79, 0x001f7a, 0x001f7b, 0x001f7c, 0x001f7d, 0x001f80, 0x001f81, 0x001f82, 0x001f83,
    0x001f84, 0x001f85, 0x001f86, 0x001f87, 0x001f88, 0x001f89, 0x001f8a, 0x001f8b, 0x001f8c, 0x001f8d, 0x001f8e, 0x001f8f,
    0x001f90, 0x001f91, 0x001f92, 0x001f93, 0x001f94, 0x001f95, 0x001f96, 0x001f97, 0x001f98, 0x001f99, 0x001f9a, 0x001f9b,
    0x001f9c, 0x001f9d, 0x001f9e, 0x001f9f, 0x001fa0, 0x001fa1, 0x001fa2, 0x001fa3, 0x001fa4, 0x001fa5, 0x001fa6, 0x001fa7,
    0x001fa8, 0x001fa9, 0x001faa, 0x001fab, 0x001fac, 0x001fad, 0x001fae, 0x001faf, 0x001fb0, 0x001fb1, 0x001fb2, 0x001fb3,
    0x001fb4, 0x001fb6, 0x001fb7, 0x001fb8, 0x001fb9, 0x001fba, 0x001fbb, 0x001fbc, 0x001fc2, 0x001fc3, 0x001fc4, 0x001fc6,
    0x001fc7, 0x001fc8, 0x001fc9, 0x001fca, 0x001fcb, 0x001fcc, 0x001fd0, 0x001fd1, 0x001fd2, 0x001fd3, 0x001fd6, 0x001fd7,
    0x001fd8, 0x001fd9, 0x001fda, 0x001fdb, 0x001fe0, 0x001fe1, 0x001fe2, 0x001fe3, 0x001fe4, 0x001fe5, 0x001fe6, 0x001fe7,
    0x001fe8, 0x001fe9, 0x001fea, 0x001feb, 0x001fec, 0x001ff2, 0x001ff3, 0x001ff4, 0x001ff6, 0x001ff7, 0x001ff8, 0x001ff9,
    0x001ffa, 0x001ffb, 0x001ffc, 0x002071, 0x00207f, 0x00210c, 0x002111, 0x00211c, 0x002128, 0x002129, 0x00212d, 0x00249c,
    0x00249d, 0x00249e, 0x00249f, 0x0024a0, 0x0024a1, 0x0024a2, 0x0024a3, 0x0024a4, 0x0024a5, 0x0024a6, 0x0024a7, 0x0024a8,
    0x0024a9, 0x0024aa, 0x0024ab, 0x0024ac, 0x0024ad, 0x0024ae, 0x0024af, 0x0024b0, 0x0024b1, 0x0024b2, 0x0024b3, 0x0024b4,
    0x0024b5, 0x0024b6, 0x0024b7, 0x0024b8, 0x0024b9, 0x0024ba, 0x0024bb, 0x0024bc, 0x0024bd, 0x0024be, 0x0024bf, 0x0024c0,
    0x0024c1, 0x0024c2, 0x0024c3, 0x0024c4, 0x0024c5, 0x0024c6, 0x0024c7, 0x0024c8, 0x0024c9, 0x0024ca, 0x0024cb, 0x0024cc,
    0x0024cd, 0x0024ce, 0x0024cf, 0x0024d0, 0x0024d1, 0x0024d2, 0x0024d3, 0x0024d4, 0x0024d5, 0x0024d6, 0x0024d7, 0x0024d8,
    0x0024d9, 0x0024da, 0x0024db, 0x0024dc, 0x0024dd, 0x0024de, 0x0024df, 0x0024e0, 0x0024e1, 0x0024e2, 0x0024e3, 0x0024e4,
    0x0024e5, 0x0024e6, 0x0024e7, 0x0024e8, 0x0024e9, 0x003041, 0x003042, 0x003043, 0x003044, 0x003045, 0x003046, 0x003047,
    0x003048, 0x003049, 0x00304a, 0x00304b, 0x00304c, 0x00304d, 0x00304e, 0x00304f, 0x003050, 0x003051, 0x003052, 0x003053,
    0x003054, 0x003055, 0x003056, 0x003057, 0x003058, 0x003059, 0x00305a, 0x00305b, 0x00305c, 0x00305d, 0x00305e, 0x00305f,
    0x003060, 0x003061, 0x003062, 0x003063, 0x003064, 0x003065, 0x003066, 0x003067, 0x003068, 0x003069, 0x00306a, 0x00306b,
    0x00306c, 0x00306d, 0x00306e, 0x00306f, 0x003070, 0x003071, 0x003072, 0x003073, 0x003074, 0x003075, 0x003076, 0x003077,
    0x003078, 0x003079, 0x00307a, 0x00307b, 0x00307c, 0x00307d, 0x00307e, 0x00307f, 0x003080, 0x003081, 0x003082, 0x003083,
    0x003084, 0x003085, 0x003086, 0x003087, 0x003088, 0x003089, 0x00308a, 0x00308b, 0x00308c, 0x00308d, 0x00308e, 0x00308f,
    0x003090, 0x003091, 0x003092, 0x003093, 0x003094, 0x003095, 0x003096, 0x0030a1, 0x0030a2, 0x0030a3, 0x0030a4, 0x0030a5,
    0x0030a6, 0x0030a7, 0x0030a8, 0x0030a9, 0x0030aa, 0x0030ab, 0x0030ac, 0x0030ad, 0x0030ae, 0x0030af, 0x0030b0, 0x0030b1,
    0x0030b2, 0x0030b3, 0x0030b4, 0x0030b5, 0x0030b6, 0x0030b7, 0x0030b8, 0x0030b9, 0x0030ba, 0x0030bb, 0x0030bc, 0x0030bd,
    0x0030be, 0x0030bf, 0x0030c0, 0x0030c1, 0x0030c2, 0x0030c3, 0x0030c4, 0x0030c5, 0x0030c6, 0x0030c7, 0x0030c8, 0x0030c9,
    0x0030ca, 0x0030cb, 0x0030cc, 0x0030cd, 0x0030ce, 0x0030cf, 0x0030d0, 0x0030d1, 0x0030d2, 0x0030d3, 0x0030d4, 0x0030d5,
    0x0030d6, 0x0030d7, 0x0030d8, 0x0030d9, 0x0030da, 0x0030db, 0x0030dc, 0x0030dd, 0x0030de, 0x0030df, 0x0030e0, 0x0030e1,
    0x0030e2, 0x0030e3, 0x0030e4, 0x0030e5, 0x0030e6, 0x0030e7, 0x0030e8, 0x0030e9, 0x0030ea, 0x0030eb, 0x0030ec, 0x0030ed,
    0x0030ee, 0x0030ef, 0x0030f0, 0x0030f1, 0x0030f2, 0x0030f3, 0x0030f4, 0x0030f5, 0x0030f6, 0x0030f7, 0x0030f8, 0x0030f9,
    0x0030fa, 0x003105, 0x003106, 0x003107, 0x003108, 0x003109, 0x00310a, 0x00310b, 0x00310c, 0x00310d, 0x00310e, 0x00310f,
    0x003110, 0x003111, 0x003112, 0x003113, 0x003114, 0x003115, 0x003116, 0x003117, 0x003118, 0x003119, 0x00311a, 0x00311b,
    0x00311c, 0x00311d, 0x00311e, 0x00311f, 0x003120, 0x003121, 0x003122, 0x003123, 0x003124, 0x003125, 0x003126, 0x003127,
    0x003128, 0x003129, 0x00312a, 0x00312b, 0x00312c, 0x003131, 0x003132, 0x003133, 0x003134, 0x003135, 0x003136, 0x003137,
    0x003138, 0x003139, 0x00313a, 0x00313b, 0x00313c, 0x00313d, 0x00313e, 0x00313f, 0x003140, 0x003141, 0x003142, 0x003143,
    0x003144, 0x003145, 0x003146, 0x003147, 0x003148, 0x003149, 0x00314a, 0x00314b, 0x00314c, 0x00314d, 0x00314e, 0x00314f,
    0x003150, 0x003151, 0x003152, 0x003153, 0x003154, 0x003155, 0x003156, 0x003157, 0x003158, 0x003159, 0x00315a, 0x00315b,
    0x00315c, 0x00315d, 0x00315e, 0x00315f, 0x003160, 0x003161, 0x003162, 0x003163, 0x003165, 0x003166, 0x003167, 0x003168,
    0x003169, 0x00316a, 0x00316b, 0x00316c, 0x00316d, 0x00316e, 0x00316f, 0x003170, 0x003171, 0x003172, 0x003173, 0x003174,
    0x003175, 0x003176, 0x003177, 0x003178, 0x003179, 0x00317a, 0x00317b, 0x00317c, 0x00317d, 0x00317e, 0x00317f, 0x003180,
    0x003181, 0x003182, 0x003183, 0x003184, 0x003185, 0x003186, 0x003187, 0x003188, 0x003189, 0x00318a, 0x00318b, 0x00318c,
    0x00318d, 0x00318e, 0x0031a0, 0x0031a1, 0x0031a2, 0x0031a3, 0x0031a4, 0x0031a5, 0x0031a6, 0x0031a7, 0x0031a8, 0x0031a9,
    0x0031aa, 0x0031ab, 0x0031ac, 0x0031ad, 0x0031ae, 0x0031af, 0x0031b0, 0x0031b1, 0x0031b2, 0x0031b3, 0x0031b4, 0x0031b5,
    0x0031b6, 0x0031b7, 0x0031f0, 0x0031f1, 0x0031f2, 0x0031f3, 0x0031f4, 0x0031f5, 0x0031f6, 0x0031f7, 0x0031f8, 0x0031f9,
    0x0031fa, 0x0031fb, 0x0031fc, 0x0031fd, 0x0031fe, 0x0031ff, 0x00fb1d, 0x00fb20, 0x00fb21, 0x00fb22, 0x00fb23, 0x00fb24,
    0x00fb25, 0x00fb26, 0x00fb27, 0x00fb28, 0x00fb29, 0x00fb2a, 0x00fb2b, 0x00fb2c, 0x00fb2d, 0x00fb2e, 0x00fb2f, 0x00fb30,
    0x00fb31, 0x00fb32, 0x00fb33, 0x00fb34, 0x00fb35, 0x00fb36, 0x00fb38, 0x00fb39, 0x00fb3a, 0x00fb3b, 0x00fb3c, 0x00fb3e,
    0x00fb40, 0x00fb41, 0x00fb43, 0x00fb44, 0x00fb46, 0x00fb47, 0x00fb48, 0x00fb49, 0x00fb4a, 0x00fb4b, 0x00fb4c, 0x00fb4d,
    0x00fb4e, 0x00fb50, 0x00fb51, 0x00fb52, 0x00fb53, 0x00fb54, 0x00fb55, 0x00fb56, 0x00fb57, 0x00fb58, 0x00fb59, 0x00fb5a,
    0x00fb5b, 0x00fb5c, 0x00fb5d, 0x00fb5e, 0x00fb5f, 0x00fb60, 0x00fb61, 0x00fb62, 0x00fb63, 0x00fb64, 0x00fb65, 0x00fb66,
    0x00fb67, 0x00fb68, 0x00fb69, 0x00fb6a, 0x00fb6b, 0x00fb6c, 0x00fb6d, 0x00fb6e, 0x00fb6f, 0x00fb70, 0x00fb71, 0x00fb72,
    0x00fb73, 0x00fb74, 0x00fb75, 0x00fb76, 0x00fb77, 0x00fb78, 0x00fb79, 0x00fb7a, 0x00fb7b, 0x00fb7c, 0x00fb7d, 0x00fb7e,
    0x00fb7f, 0x00fb80, 0x00fb81, 0x00fb82, 0x00fb83, 0x00fb84, 0x00fb85, 0x00fb86, 0x00fb87, 0x00fb88, 0x00fb89, 0x00fb8a,
    0x00fb8b, 0x00fb8c, 0x00fb8d, 0x00fb8e, 0x00fb8f, 0x00fb90, 0x00fb91, 0x00fb92, 0x00fb93, 0x00fb94, 0x00fb95, 0x00fb96,
    0x00fb97, 0x00fb98, 0x00fb99, 0x00fb9a, 0x00fb9b, 0x00fb9c, 0x00fb9d, 0x00fb9e, 0x00fb9f, 0x00fba0, 0x00fba1, 0x00fba2,
    0x00fba3, 0x00fba4, 0x00fba5, 0x00fba6, 0x00fba7, 0x00fba8, 0x00fba9, 0x00fbaa, 0x00fbab, 0x00fbac, 0x00fbad, 0x00fbae,
    0x00fbaf, 0x00fbb0, 0x00fbb1, 0x00fbd3, 0x00fbd4, 0x00fbd5, 0x00fbd6, 0x00fbd7, 0x00fbd8, 0x00fbd9, 0x00fbda, 0x00fbdb,
    0x00fbdc, 0x00fbdd, 0x00fbde, 0x00fbdf, 0x00fbe0, 0x00fbe1, 0x00fbe2, 0x00fbe3, 0x00fbe4, 0x00fbe5, 0x00fbe6, 0x00fbe7,
    0x00fbe8, 0x00fbe9, 0x00fbfc, 0x00fbfd, 0x00fbfe, 0x00fbff, 0x00fdfa, 0x00fdfb, 0x00fe80, 0x00fe81, 0x00fe82, 0x00fe83,
    0x00fe84, 0x00fe85, 0x00fe86, 0x00fe87, 0x00fe88, 0x00fe89, 0x00fe8a, 0x00fe8b, 0x00fe8c, 0x00fe8d, 0x00fe8e, 0x00fe8f,
    0x00fe90, 0x00fe91, 0x00fe92, 0x00fe93, 0x00fe94, 0x00fe95, 0x00fe96, 0x00fe97, 0x00fe98, 0x00fe99, 0x00fe9a, 0x00fe9b,
    0x00fe9c, 0x00fe9d, 0x00fe9e, 0x00fe9f, 0x00fea0, 0x00fea1, 0x00fea2, 0x00fea3, 0x00fea4, 0x00fea5, 0x00fea6, 0x00fea7,
    0x00fea8, 0x00fea9, 0x00feaa, 0x00feab, 0x00feac, 0x00fead, 0x00feae, 0x00feaf, 0x00feb0, 0x00feb1, 0x00feb2, 0x00feb3,
    0x00feb4, 0x00feb5, 0x00feb6, 0x00feb7, 0x00feb8, 0x00feb9, 0x00feba, 0x00febb, 0x00febc, 0x00febd, 0x00febe, 0x00febf,
    0x00fec0, 0x00fec1, 0x00fec2, 0x00fec3, 0x00fec4, 0x00fec5, 0x00fec6, 0x00fec7, 0x00fec8, 0x00fec9, 0x00feca, 0x00fecb,
    0x00fecc, 0x00fecd, 0x00fece, 0x00fecf, 0x00fed0, 0x00fed1, 0x00fed2, 0x00fed3, 0x00fed4, 0x00fed5, 0x00fed6, 0x00fed7,
    0x00fed8, 0x00fed9, 0x00feda, 0x00fedb, 0x00fedc, 0x00fedd, 0x00fede, 0x00fedf, 0x00fee0, 0x00fee1, 0x00fee2, 0x00fee3,
    0x00fee4, 0x00fee5, 0x00fee6, 0x00fee7, 0x00fee8, 0x00fee9, 0x00feea, 0x00feeb, 0x00feec, 0x00feed, 0x00feee, 0x00feef,
    0x00fef0, 0x00fef1, 0x00fef2, 0x00fef3, 0x00fef4, 0x00ff21, 0x00ff22, 0x00ff23, 0x00ff24, 0x00ff25, 0x00ff26, 0x00ff27,
    0x00ff28, 0x00ff29, 0x00ff2a, 0x00ff2b, 0x00ff2c, 0x00ff2d, 0x00ff2e, 0x00ff2f, 0x00ff30, 0x00ff31, 0x00ff32, 0x00ff33,
    0x00ff34, 0x00ff35, 0x00ff36, 0x00ff37, 0x00ff38, 0x00ff39, 0x00ff3a, 0x00ff41, 0x00ff42, 0x00ff43, 0x00ff44, 0x00ff45,
    0x00ff46, 0x00ff47, 0x00ff48, 0x00ff49, 0x00ff4a, 0x00ff4b, 0x00ff4c, 0x00ff4d, 0x00ff4e, 0x00ff4f, 0x00ff50, 0x00ff51,
    0x00ff52, 0x00ff53, 0x00ff54, 0x00ff55, 0x00ff56, 0x00ff57, 0x00ff58, 0x00ff59, 0x00ff5a, 0x00ff66, 0x00ff67, 0x00ff68,
    0x00ff69, 0x00ff6a, 0x00ff6b, 0x00ff6c, 0x00ff6d, 0x00ff6e, 0x00ff6f, 0x00ff71, 0x00ff72, 0x00ff73, 0x00ff74, 0x00ff75,
    0x00ff76, 0x00ff77, 0x00ff78, 0x00ff79, 0x00ff7a, 0x00ff7b, 0x00ff7c, 0x00ff7d, 0x00ff7e, 0x00ff7f, 0x00ff80, 0x00ff81,
    0x00ff82, 0x00ff83, 0x00ff84, 0x00ff85, 0x00ff86, 0x00ff87, 0x00ff88, 0x00ff89, 0x00ff8a, 0x00ff8b, 0x00ff8c, 0x00ff8d,
    0x00ff8e, 0x00ff8f, 0x00ff90, 0x00ff91, 0x00ff92, 0x00ff93, 0x00ff94, 0x00ff95, 0x00ff96, 0x00ff97, 0x00ff98, 0x00ff99,
    0x00ff9a, 0x00ff9b, 0x00ff9c, 0x00ff9d, 0x00ffa1, 0x00ffa2, 0x00ffa3, 0x00ffa4, 0x00ffa5, 0x00ffa6, 0x00ffa7, 0x00ffa8,
    0x00ffa9, 0x00ffaa, 0x00ffab, 0x00ffac, 0x00ffad, 0x00ffae, 0x00ffaf, 0x00ffb0, 0x00ffb1, 0x00ffb2, 0x00ffb3, 0x00ffb4,
    0x00ffb5, 0x00ffb6, 0x00ffb7, 0x00ffb8, 0x00ffb9, 0x00ffba, 0x00ffbb, 0x00ffbc, 0x00ffbd, 0x00ffbe, 0x00ffc2, 0x00ffc3,
    0x00ffc4, 0x00ffc5, 0x00ffc6, 0x00ffc7, 0x00ffca, 0x00ffcb, 0x00ffcc, 0x00ffcd, 0x00ffce, 0x00ffcf, 0x00ffd2, 0x00ffd3,
    0x00ffd4, 0x00ffd5, 0x00ffd6, 0x00ffd7, 0x00ffda, 0x00ffdb, 0x00ffdc, 0x010300, 0x010301, 0x010302, 0x010303, 0x010304,
    0x010305, 0x010306, 0x010307, 0x010308, 0x010309, 0x01030a, 0x01030b, 0x01030c, 0x01030d, 0x01030e, 0x01030f, 0x010310,
    0x010311, 0x010312, 0x010313, 0x010314, 0x010315, 0x010316, 0x010317, 0x010318, 0x010319, 0x01031a, 0x01031b, 0x01031c,
    0x01031d, 0x01031e, 0x010330, 0x010331, 0x010332, 0x010333, 0x010334, 0x010335, 0x010336, 0x010337, 0x010338, 0x010339,
    0x01033a, 0x01033b, 0x01033c, 0x01033d, 0x01033e, 0x01033f, 0x010340, 0x010341, 0x010342, 0x010343, 0x010344, 0x010345,
    0x010346, 0x010347, 0x010348, 0x010349, 0x01034a, 0x010380, 0x010381, 0x010382, 0x010383, 0x010384, 0x010385, 0x010386,
    0x010387, 0x010388, 0x010389, 0x01038a, 0x01038b, 0x01038c, 0x01038d, 0x01038e, 0x01038f, 0x010390, 0x010391, 0x010392,
    0x010393, 0x010394, 0x010395, 0x010396, 0x010397, 0x010398, 0x010399, 0x01039a, 0x01039b, 0x01039c, 0x01039d, 0x010400,
    0x010401, 0x010402, 0x010403, 0x010404, 0x010405, 0x010406, 0x010407, 0x010408, 0x010409, 0x01040a, 0x01040b, 0x01040c,
    0x01040d, 0x01040e, 0x01040f, 0x010410, 0x010411, 0x010412, 0x010413, 0x010414, 0x010415, 0x010416, 0x010417, 0x010418,
    0x010419, 0x01041a, 0x01041b, 0x01041c, 0x01041d, 0x01041e, 0x01041f, 0x010420, 0x010421, 0x010422, 0x010423, 0x010424,
    0x010425, 0x010426, 0x010427, 0x010428, 0x010429, 0x01042a, 0x01042b, 0x01042c, 0x01042d, 0x01042e, 0x01042f, 0x010430,
    0x010431, 0x010432, 0x010433, 0x010434, 0x010435, 0x010436, 0x010437, 0x010438, 0x010439, 0x01043a, 0x01043b, 0x01043c,
    0x01043d, 0x01043e, 0x01043f, 0x010440, 0x010441, 0x010442, 0x010443, 0x010444, 0x010445, 0x010446, 0x010447, 0x010448,
    0x010449, 0x01044a, 0x01044b, 0x01044c, 0x01044d, 0x01044e, 0x01044f, 0x010450, 0x010451, 0x010452, 0x010453, 0x010454,
    0x010455, 0x010456, 0x010457, 0x010458, 0x010459, 0x01045a, 0x01045b, 0x01045c, 0x01045d, 0x01045e, 0x01045f, 0x010460,
    0x010461, 0x010462, 0x010463, 0x010464, 0x010465, 0x010466, 0x010467, 0x010468, 0x010469, 0x01046a, 0x01046b, 0x01046c,
    0x01046d, 0x01046e, 0x01046f, 0x010470, 0x010471, 0x010472, 0x010473, 0x010474, 0x010475, 0x010476, 0x010477, 0x010478,
    0x010479, 0x01047a, 0x01047b, 0x01047c, 0x01047d, 0x01047e, 0x01047f, 0x010480, 0x010481, 0x010482, 0x010483, 0x010484,
    0x010485, 0x010486, 0x010487, 0x010488, 0x010489, 0x01048a, 0x01048b, 0x01048c, 0x01048d, 0x01048e, 0x01048f, 0x010490,
    0x010491, 0x010492, 0x010493, 0x010494, 0x010495, 0x010496, 0x010497, 0x010498, 0x010499, 0x01049a, 0x01049b, 0x01049c,
    0x01049d, 0x0e0041, 0x0e0042, 0x0e0043, 0x0e0044, 0x0e0045, 0x0e0046, 0x0e0047, 0x0e0048, 0x0e0049, 0x0e004a, 0x0e004b,
    0x0e004c, 0x0e004d, 0x0e004e, 0x0e004f, 0x0e0050, 0x0e0051, 0x0e0052, 0x0e0053, 0x0e0054, 0x0e0055, 0x0e0056, 0x0e0057,
    0x0e0058, 0x0e0059, 0x0e005a, 0x0e0061, 0x0e0062, 0x0e0063, 0x0e0064, 0x0e0065, 0x0e0066, 0x0e0067, 0x0e0068, 0x0e0069,
    0x0e006a, 0x0e006b, 0x0e006c, 0x0e006d, 0x0e006e, 0x0e006f, 0x0e0070, 0x0e0071, 0x0e0072, 0x0e0073, 0x0e0074, 0x0e0075,
    0x0e0076, 0x0e0077, 0x0e0078, 0x0e0079, 0x0e007a,
};
int UTF8::alnum[] = {
    0x000030, 0x000031, 0x000032, 0x000033, 0x000034, 0x000035, 0x000036, 0x000037, 0x000038, 0x000039, 0x000041, 0x000042,
    0x000043, 0x000044, 0x000045, 0x000046, 0x000047, 0x000048, 0x000049, 0x00004a, 0x00004b, 0x00004c, 0x00004d, 0x00004e,
    0x00004f, 0x000050, 0x000051, 0x000052, 0x000053, 0x000054, 0x000055, 0x000056, 0x000057, 0x000058, 0x000059, 0x00005a,
    0x000061, 0x000062, 0x000063, 0x000064, 0x000065, 0x000066, 0x000067, 0x000068, 0x000069, 0x00006a, 0x00006b, 0x00006c,
    0x00006d, 0x00006e, 0x00006f, 0x000070, 0x000071, 0x000072, 0x000073, 0x000074, 0x000075, 0x000076, 0x000077, 0x000078,
    0x000079, 0x00007a, 0x0000b2, 0x0000b3, 0x0000b9, 0x0000c0, 0x0000c1, 0x0000c2, 0x0000c3, 0x0000c4, 0x0000c5, 0x0000c6,
    0x0000c7, 0x0000c8, 0x0000c9, 0x0000ca, 0x0000cb, 0x0000cc, 0x0000cd, 0x0000ce, 0x0000cf, 0x0000d0, 0x0000d1, 0x0000d2,
    0x0000d3, 0x0000d4, 0x0000d5, 0x0000d6, 0x0000d8, 0x0000d9, 0x0000da, 0x0000db, 0x0000dc, 0x0000dd, 0x0000de, 0x0000df,
    0x0000e0, 0x0000e1, 0x0000e2, 0x0000e3, 0x0000e4, 0x0000e5, 0x0000e6, 0x0000e7, 0x0000e8, 0x0000e9, 0x0000ea, 0x0000eb,
    0x0000ec, 0x0000ed, 0x0000ee, 0x0000ef, 0x0000f0, 0x0000f1, 0x0000f2, 0x0000f3, 0x0000f4, 0x0000f5, 0x0000f6, 0x0000f8,
    0x0000f9, 0x0000fa, 0x0000fb, 0x0000fc, 0x0000fd, 0x0000fe, 0x0000ff, 0x000100, 0x000101, 0x000102, 0x000103, 0x000104,
    0x000105, 0x000106, 0x000107, 0x000108, 0x000109, 0x00010a, 0x00010b, 0x00010c, 0x00010d, 0x00010e, 0x00010f, 0x000110,
    0x000111, 0x000112, 0x000113, 0x000114, 0x000115, 0x000116, 0x000117, 0x000118, 0x000119, 0x00011a, 0x00011b, 0x00011c,
    0x00011d, 0x00011e, 0x00011f, 0x000120, 0x000121, 0x000122, 0x000123, 0x000124, 0x000125, 0x000126, 0x000127, 0x000128,
    0x000129, 0x00012a, 0x00012b, 0x00012c, 0x00012d, 0x00012e, 0x00012f, 0x000130, 0x000131, 0x000132, 0x000133, 0x000134,
    0x000135, 0x000136, 0x000137, 0x000138, 0x000139, 0x00013a, 0x00013b, 0x00013c, 0x00013d, 0x00013e, 0x00013f, 0x000140,
    0x000141, 0x000142, 0x000143, 0x000144, 0x000145, 0x000146, 0x000147, 0x000148, 0x000149, 0x00014a, 0x00014b, 0x00014c,
    0x00014d, 0x00014e, 0x00014f, 0x000150, 0x000151, 0x000152, 0x000153, 0x000154, 0x000155, 0x000156, 0x000157, 0x000158,
    0x000159, 0x00015a, 0x00015b, 0x00015c, 0x00015d, 0x00015e, 0x00015f, 0x000160, 0x000161, 0x000162, 0x000163, 0x000164,
    0x000165, 0x000166, 0x000167, 0x000168, 0x000169, 0x00016a, 0x00016b, 0x00016c, 0x00016d, 0x00016e, 0x00016f, 0x000170,
    0x000171, 0x000172, 0x000173, 0x000174, 0x000175, 0x000176, 0x000177, 0x000178, 0x000179, 0x00017a, 0x00017b, 0x00017c,
    0x00017d, 0x00017e, 0x00017f, 0x000180, 0x000181, 0x000182, 0x000183, 0x000184, 0x000185, 0x000186, 0x000187, 0x000188,
    0x000189, 0x00018a, 0x00018b, 0x00018c, 0x00018d, 0x00018e, 0x00018f, 0x000190, 0x000191, 0x000192, 0x000193, 0x000194,
    0x000195, 0x000196, 0x000197, 0x000198, 0x000199, 0x00019a, 0x00019b, 0x00019c, 0x00019d, 0x00019e, 0x00019f, 0x0001a0,
    0x0001a1, 0x0001a2, 0x0001a3, 0x0001a4, 0x0001a5, 0x0001a6, 0x0001a7, 0x0001a8, 0x0001a9, 0x0001aa, 0x0001ab, 0x0001ac,
    0x0001ad, 0x0001ae, 0x0001af, 0x0001b0, 0x0001b1, 0x0001b2, 0x0001b3, 0x0001b4, 0x0001b5, 0x0001b6, 0x0001b7, 0x0001b8,
    0x0001b9, 0x0001ba, 0x0001bb, 0x0001bc, 0x0001bd, 0x0001be, 0x0001bf, 0x0001c0, 0x0001c1, 0x0001c2, 0x0001c3, 0x0001c4,
    0x0001c5, 0x0001c6, 0x0001c7, 0x0001c8, 0x0001c9, 0x0001ca, 0x0001cb, 0x0001cc, 0x0001cd, 0x0001ce, 0x0001cf, 0x0001d0,
    0x0001d1, 0x0001d2, 0x0001d3, 0x0001d4, 0x0001d5, 0x0001d6, 0x0001d7, 0x0001d8, 0x0001d9, 0x0001da, 0x0001db, 0x0001dc,
    0x0001dd, 0x0001de, 0x0001df, 0x0001e0, 0x0001e1, 0x0001e2, 0x0001e3, 0x0001e4, 0x0001e5, 0x0001e6, 0x0001e7, 0x0001e8,
    0x0001e9, 0x0001ea, 0x0001eb, 0x0001ec, 0x0001ed, 0x0001ee, 0x0001ef, 0x0001f0, 0x0001f1, 0x0001f2, 0x0001f3, 0x0001f4,
    0x0001f5, 0x0001f6, 0x0001f7, 0x0001f8, 0x0001f9, 0x0001fa, 0x0001fb, 0x0001fc, 0x0001fd, 0x0001fe, 0x0001ff, 0x000200,
    0x000201, 0x000202, 0x000203, 0x000204, 0x000205, 0x000206, 0x000207, 0x000208, 0x000209, 0x00020a, 0x00020b, 0x00020c,
    0x00020d, 0x00020e, 0x00020f, 0x000210, 0x000211, 0x000212, 0x000213, 0x000214, 0x000215, 0x000216, 0x000217, 0x000218,
    0x000219, 0x00021a, 0x00021b, 0x00021c, 0x00021d, 0x00021e, 0x00021f, 0x000220, 0x000221, 0x000222, 0x000223, 0x000224,
    0x000225, 0x000226, 0x000227, 0x000228, 0x000229, 0x00022a, 0x00022b, 0x00022c, 0x00022d, 0x00022e, 0x00022f, 0x000230,
    0x000231, 0x000232, 0x000233, 0x000234, 0x000235, 0x000236, 0x000250, 0x000251, 0x000252, 0x000253, 0x000254, 0x000255,
    0x000256, 0x000257, 0x000258, 0x000259, 0x00025a, 0x00025b, 0x00025c, 0x00025d, 0x00025e, 0x00025f, 0x000260, 0x000261,
    0x000262, 0x000263, 0x000264, 0x000265, 0x000266, 0x000267, 0x000268, 0x000269, 0x00026a, 0x00026b, 0x00026c, 0x00026d,
    0x00026e, 0x00026f, 0x000270, 0x000271, 0x000272, 0x000273, 0x000274, 0x000275, 0x000276, 0x000277, 0x000278, 0x000279,
    0x00027a, 0x00027b, 0x00027c, 0x00027d, 0x00027e, 0x00027f, 0x000280, 0x000281, 0x000282, 0x000283, 0x000284, 0x000285,
    0x000286, 0x000287, 0x000288, 0x000289, 0x00028a, 0x00028b, 0x00028c, 0x00028d, 0x00028e, 0x00028f, 0x000290, 0x000291,
    0x000292, 0x000293, 0x000294, 0x000295, 0x000296, 0x000297, 0x000298, 0x000299, 0x00029a, 0x00029b, 0x00029c, 0x00029d,
    0x00029e, 0x00029f, 0x0002a0, 0x0002a1, 0x0002a2, 0x0002a3, 0x0002a4, 0x0002a5, 0x0002a6, 0x0002a7, 0x0002a8, 0x0002a9,
    0x0002aa, 0x0002ab, 0x0002ac, 0x0002ad, 0x0002ae, 0x0002af, 0x0002b0, 0x0002b1, 0x0002b2, 0x0002b3, 0x0002b4, 0x0002b5,
    0x0002b6, 0x0002b7, 0x0002b8, 0x0002b9, 0x0002ba, 0x0002bb, 0x0002bc, 0x0002bd, 0x0002be, 0x0002bf, 0x0002c0, 0x0002c1,
    0x0002c2, 0x0002c3, 0x0002c4, 0x0002c5, 0x0002c6, 0x0002c7, 0x0002c8, 0x0002c9, 0x0002ca, 0x0002cb, 0x0002cc, 0x0002cd,
    0x0002ce, 0x0002cf, 0x0002d0, 0x0002d1, 0x0002d2, 0x0002d3, 0x0002d4, 0x0002d5, 0x0002d6, 0x0002d7, 0x0002de, 0x0002df,
    0x0002e0, 0x0002e1, 0x0002e2, 0x0002e3, 0x0002e4, 0x0002e5, 0x0002e6, 0x0002e7, 0x0002e8, 0x0002e9, 0x0002ea, 0x0002eb,
    0x0002ec, 0x0002ed, 0x0002ee, 0x0002ef, 0x0002f0, 0x0002f1, 0x0002f2, 0x0002f3, 0x0002f4, 0x0002f5, 0x0002f6, 0x0002f7,
    0x0002f8, 0x0002f9, 0x0002fa, 0x0002fb, 0x0002fc, 0x0002fd, 0x0002fe, 0x0002ff, 0x000363, 0x000364, 0x000365, 0x000366,
    0x000367, 0x000368, 0x000369, 0x00036a, 0x00036b, 0x00036c, 0x00036d, 0x00036e, 0x00036f, 0x000386, 0x000388, 0x000389,
    0x00038a, 0x00038c, 0x00038e, 0x00038f, 0x000390, 0x000391, 0x000392, 0x000393, 0x000394, 0x000395, 0x000396, 0x000397,
    0x000398, 0x000399, 0x00039a, 0x00039b, 0x00039c, 0x00039d, 0x00039e, 0x00039f, 0x0003a0, 0x0003a1, 0x0003a3, 0x0003a4,
    0x0003a5, 0x0003a6, 0x0003a7, 0x0003a8, 0x0003a9, 0x0003aa, 0x0003ab, 0x0003ac, 0x0003ad, 0x0003ae, 0x0003af, 0x0003b0,
    0x0003b1, 0x0003b2, 0x0003b3, 0x0003b4, 0x0003b5, 0x0003b6, 0x0003b7, 0x0003b8, 0x0003b9, 0x0003ba, 0x0003bb, 0x0003bc,
    0x0003bd, 0x0003be, 0x0003bf, 0x0003c0, 0x0003c1, 0x0003c2, 0x0003c3, 0x0003c4, 0x0003c5, 0x0003c6, 0x0003c7, 0x0003c8,
    0x0003c9, 0x0003ca, 0x0003cb, 0x0003cc, 0x0003cd, 0x0003ce, 0x0003d0, 0x0003d1, 0x0003d2, 0x0003d3, 0x0003d4, 0x0003d5,
    0x0003d6, 0x0003d8, 0x0003d9, 0x0003da, 0x0003db, 0x0003dc, 0x0003dd, 0x0003de, 0x0003df, 0x0003e0, 0x0003e1, 0x0003e2,
    0x0003e3, 0x0003e4, 0x0003e5, 0x0003e6, 0x0003e7, 0x0003e8, 0x0003e9, 0x0003ea, 0x0003eb, 0x0003ec, 0x0003ed, 0x0003ee,
    0x0003ef, 0x0003f0, 0x0003f1, 0x0003f2, 0x0003f3, 0x0003f7, 0x0003f8, 0x0003fa, 0x0003fb, 0x000400, 0x000401, 0x000402,
    0x000403, 0x000404, 0x000405, 0x000406, 0x000407, 0x000408, 0x000409, 0x00040a, 0x00040b, 0x00040c, 0x00040d, 0x00040e,
    0x00040f, 0x000410, 0x000411, 0x000412, 0x000413, 0x000414, 0x000415, 0x000416, 0x000417, 0x000418, 0x000419, 0x00041a,
    0x00041b, 0x00041c, 0x00041d, 0x00041e, 0x00041f, 0x000420, 0x000421, 0x000422, 0x000423, 0x000424, 0x000425, 0x000426,
    0x000427, 0x000428, 0x000429, 0x00042a, 0x00042b, 0x00042c, 0x00042d, 0x00042e, 0x00042f, 0x000430, 0x000431, 0x000432,
    0x000433, 0x000434, 0x000435, 0x000436, 0x000437, 0x000438, 0x000439, 0x00043a, 0x00043b, 0x00043c, 0x00043d, 0x00043e,
    0x00043f, 0x000440, 0x000441, 0x000442, 0x000443, 0x000444, 0x000445, 0x000446, 0x000447, 0x000448, 0x000449, 0x00044a,
    0x00044b, 0x00044c, 0x00044d, 0x00044e, 0x00044f, 0x000450, 0x000451, 0x000452, 0x000453, 0x000454, 0x000455, 0x000456,
    0x000457, 0x000458, 0x000459, 0x00045a, 0x00045b, 0x00045c, 0x00045d, 0x00045e, 0x00045f, 0x000460, 0x000461, 0x000462,
    0x000463, 0x000464, 0x000465, 0x000466, 0x000467, 0x000468, 0x000469, 0x00046a, 0x00046b, 0x00046c, 0x00046d, 0x00046e,
    0x00046f, 0x000470, 0x000471, 0x000472, 0x000473, 0x000474, 0x000475, 0x000476, 0x000477, 0x000478, 0x000479, 0x00047a,
    0x00047b, 0x00047c, 0x00047d, 0x00047e, 0x00047f, 0x000480, 0x000481, 0x00048a, 0x00048b, 0x00048c, 0x00048d, 0x00048e,
    0x00048f, 0x000490, 0x000491, 0x000492, 0x000493, 0x000494, 0x000495, 0x000496, 0x000497, 0x000498, 0x000499, 0x00049a,
    0x00049b, 0x00049c, 0x00049d, 0x00049e, 0x00049f, 0x0004a0, 0x0004a1, 0x0004a2, 0x0004a3, 0x0004a4, 0x0004a5, 0x0004a6,
    0x0004a7, 0x0004a8, 0x0004a9, 0x0004aa, 0x0004ab, 0x0004ac, 0x0004ad, 0x0004ae, 0x0004af, 0x0004b0, 0x0004b1, 0x0004b2,
    0x0004b3, 0x0004b4, 0x0004b5, 0x0004b6, 0x0004b7, 0x0004b8, 0x0004b9, 0x0004ba, 0x0004bb, 0x0004bc, 0x0004bd, 0x0004be,
    0x0004bf, 0x0004c0, 0x0004c1, 0x0004c2, 0x0004c3, 0x0004c4, 0x0004c5, 0x0004c6, 0x0004c7, 0x0004c8, 0x0004c9, 0x0004ca,
    0x0004cb, 0x0004cc, 0x0004cd, 0x0004ce, 0x0004d0, 0x0004d1, 0x0004d2, 0x0004d3, 0x0004d6, 0x0004d7, 0x0004d8, 0x0004d9,
    0x0004da, 0x0004db, 0x0004dc, 0x0004dd, 0x0004de, 0x0004df, 0x0004e0, 0x0004e1, 0x0004e2, 0x0004e3, 0x0004e4, 0x0004e5,
    0x0004e6, 0x0004e7, 0x0004e8, 0x0004e9, 0x0004ea, 0x0004eb, 0x0004ec, 0x0004ed, 0x0004ee, 0x0004ef, 0x0004f0, 0x0004f1,
    0x0004f2, 0x0004f3, 0x0004f4, 0x0004f5, 0x0004f8, 0x0004f9, 0x000500, 0x000501, 0x000502, 0x000503, 0x000504, 0x000505,
    0x000506, 0x000507, 0x000508, 0x000509, 0x00050a, 0x00050b, 0x00050c, 0x00050d, 0x00050e, 0x00050f, 0x000531, 0x000532,
    0x000533, 0x000534, 0x000535, 0x000536, 0x000537, 0x000538, 0x000539, 0x00053a, 0x00053b, 0x00053c, 0x00053d, 0x00053e,
    0x00053f, 0x000540, 0x000541, 0x000542, 0x000543, 0x000544, 0x000545, 0x000546, 0x000547, 0x000548, 0x000549, 0x00054a,
    0x00054b, 0x00054c, 0x00054d, 0x00054e, 0x00054f, 0x000550, 0x000551, 0x000552, 0x000553, 0x000554, 0x000555, 0x000556,
    0x000559, 0x00055a, 0x000561, 0x000562, 0x000563, 0x000564, 0x000565, 0x000566, 0x000567, 0x000568, 0x000569, 0x00056a,
    0x00056b, 0x00056c, 0x00056d, 0x00056e, 0x00056f, 0x000570, 0x000571, 0x000572, 0x000573, 0x000574, 0x000575, 0x000576,
    0x000577, 0x000578, 0x000579, 0x00057a, 0x00057b, 0x00057c, 0x00057d, 0x00057e, 0x00057f, 0x000580, 0x000581, 0x000582,
    0x000583, 0x000584, 0x000585, 0x000586, 0x0005d0, 0x0005d1, 0x0005d2, 0x0005d3, 0x0005d4, 0x0005d5, 0x0005d6, 0x0005d7,
    0x0005d8, 0x0005d9, 0x0005da, 0x0005db, 0x0005dc, 0x0005dd, 0x0005de, 0x0005df, 0x0005e0, 0x0005e1, 0x0005e2, 0x0005e3,
    0x0005e4, 0x0005e5, 0x0005e6, 0x0005e7, 0x0005e8, 0x0005e9, 0x0005ea, 0x0005f0, 0x0005f1, 0x0005f2, 0x000621, 0x000622,
    0x000623, 0x000624, 0x000625, 0x000626, 0x000627, 0x000628, 0x000629, 0x00062a, 0x00062b, 0x00062c, 0x00062d, 0x00062e,
    0x00062f, 0x000630, 0x000631, 0x000632, 0x000633, 0x000634, 0x000635, 0x000636, 0x000637, 0x000638, 0x000639, 0x00063a,
    0x000641, 0x000642, 0x000643, 0x000644, 0x000645, 0x000646, 0x000647, 0x000648, 0x000649, 0x00064a, 0x000660, 0x000661,
    0x000662, 0x000663, 0x000664, 0x000665, 0x000666, 0x000667, 0x000668, 0x000669, 0x00066e, 0x00066f, 0x000670, 0x000671,
    0x000672, 0x000673, 0x000674, 0x000675, 0x000676, 0x000677, 0x000678, 0x000679, 0x00067a, 0x00067b, 0x00067c, 0x00067d,
    0x00067e, 0x00067f, 0x000680, 0x000681, 0x000682, 0x000683, 0x000684, 0x000685, 0x000686, 0x000687, 0x000688, 0x000689,
    0x00068a, 0x00068b, 0x00068c, 0x00068d, 0x00068e, 0x00068f, 0x000690, 0x000691, 0x000692, 0x000693, 0x000694, 0x000695,
    0x000696, 0x000697, 0x000698, 0x000699, 0x00069a, 0x00069b, 0x00069c, 0x00069d, 0x00069e, 0x00069f, 0x0006a0, 0x0006a1,
    0x0006a2, 0x0006a3, 0x0006a4, 0x0006a5, 0x0006a6, 0x0006a7, 0x0006a8, 0x0006a9, 0x0006aa, 0x0006ab, 0x0006ac, 0x0006ad,
    0x0006ae, 0x0006af, 0x0006b0, 0x0006b1, 0x0006b2, 0x0006b3, 0x0006b4, 0x0006b5, 0x0006b6, 0x0006b7, 0x0006b8, 0x0006b9,
    0x0006ba, 0x0006bb, 0x0006bc, 0x0006bd, 0x0006be, 0x0006bf, 0x0006c0, 0x0006c1, 0x0006c2, 0x0006c3, 0x0006c4, 0x0006c5,
    0x0006c6, 0x0006c7, 0x0006c8, 0x0006c9, 0x0006ca, 0x0006cb, 0x0006cc, 0x0006cd, 0x0006ce, 0x0006cf, 0x0006d0, 0x0006d1,
    0x0006d2, 0x0006d3, 0x0006d5, 0x0006ee, 0x0006ef, 0x0006f0, 0x0006f1, 0x0006f2, 0x0006f3, 0x0006f4, 0x0006f5, 0x0006f6,
    0x0006f7, 0x0006f8, 0x0006f9, 0x0006fa, 0x0006fb, 0x0006fc, 0x0006ff, 0x000710, 0x000711, 0x000712, 0x000713, 0x000714,
    0x000715, 0x000716, 0x000717, 0x000718, 0x000719, 0x00071a, 0x00071b, 0x00071c, 0x00071d, 0x00071e, 0x00071f, 0x000720,
    0x000721, 0x000722, 0x000723, 0x000724, 0x000725, 0x000726, 0x000727, 0x000728, 0x000729, 0x00072a, 0x00072b, 0x00072c,
    0x00072d, 0x00072e, 0x00072f, 0x00074d, 0x00074e, 0x00074f, 0x000780, 0x000781, 0x000782, 0x000783, 0x000784, 0x000785,
    0x000786, 0x000787, 0x000788, 0x000789, 0x00078a, 0x00078b, 0x00078c, 0x00078d, 0x00078e, 0x00078f, 0x000790, 0x000791,
    0x000792, 0x000793, 0x000794, 0x000795, 0x000796, 0x000797, 0x000798, 0x000799, 0x00079a, 0x00079b, 0x00079c, 0x00079d,
    0x00079e, 0x00079f, 0x0007a0, 0x0007a1, 0x0007a2, 0x0007a3, 0x0007a4, 0x0007a5, 0x0007b1, 0x000904, 0x000905, 0x000906,
    0x000907, 0x000908, 0x000909, 0x00090a, 0x00090b, 0x00090c, 0x00090d, 0x00090e, 0x00090f, 0x000910, 0x000911, 0x000912,
    0x000913, 0x000914, 0x000915, 0x000916, 0x000917, 0x000918, 0x000919, 0x00091a, 0x00091b, 0x00091c, 0x00091d, 0x00091e,
    0x00091f, 0x000920, 0x000921, 0x000922, 0x000923, 0x000924, 0x000925, 0x000926, 0x000927, 0x000928, 0x000929, 0x00092a,
    0x00092b, 0x00092c, 0x00092d, 0x00092e, 0x00092f, 0x000930, 0x000931, 0x000932, 0x000933, 0x000934, 0x000935, 0x000936,
    0x000937, 0x000938, 0x000939, 0x000958, 0x000959, 0x00095a, 0x00095b, 0x00095c, 0x00095d, 0x00095e, 0x00095f, 0x000960,
    0x000961, 0x000966, 0x000967, 0x000968, 0x000969, 0x00096a, 0x00096b, 0x00096c, 0x00096d, 0x00096e, 0x00096f, 0x000985,
    0x000986, 0x000987, 0x000988, 0x000989, 0x00098a, 0x00098b, 0x00098c, 0x00098f, 0x000990, 0x000993, 0x000994, 0x000995,
    0x000996, 0x000997, 0x000998, 0x000999, 0x00099a, 0x00099b, 0x00099c, 0x00099d, 0x00099e, 0x00099f, 0x0009a0, 0x0009a1,
    0x0009a2, 0x0009a3, 0x0009a4, 0x0009a5, 0x0009a6, 0x0009a7, 0x0009a8, 0x0009aa, 0x0009ab, 0x0009ac, 0x0009ad, 0x0009ae,
    0x0009af, 0x0009b0, 0x0009b2, 0x0009b6, 0x0009b7, 0x0009b8, 0x0009b9, 0x0009dc, 0x0009dd, 0x0009df, 0x0009e0, 0x0009e1,
    0x0009e6, 0x0009e7, 0x0009e8, 0x0009e9, 0x0009ea, 0x0009eb, 0x0009ec, 0x0009ed, 0x0009ee, 0x0009ef, 0x0009f0, 0x0009f1,
    0x000a05, 0x000a06, 0x000a07, 0x000a08, 0x000a09, 0x000a0a, 0x000a0f, 0x000a10, 0x000a13, 0x000a14, 0x000a15, 0x000a16,
    0x000a17, 0x000a18, 0x000a19, 0x000a1a, 0x000a1b, 0x000a1c, 0x000a1d, 0x000a1e, 0x000a1f, 0x000a20, 0x000a21, 0x000a22,
    0x000a23, 0x000a24, 0x000a25, 0x000a26, 0x000a27, 0x000a28, 0x000a2a, 0x000a2b, 0x000a2c, 0x000a2d, 0x000a2e, 0x000a2f,
    0x000a30, 0x000a32, 0x000a33, 0x000a35, 0x000a36, 0x000a38, 0x000a39, 0x000a59, 0x000a5a, 0x000a5b, 0x000a5c, 0x000a5e,
    0x000a66, 0x000a67, 0x000a68, 0x000a69, 0x000a6a, 0x000a6b, 0x000a6c, 0x000a6d, 0x000a6e, 0x000a6f, 0x000a85, 0x000a86,
    0x000a87, 0x000a88, 0x000a89, 0x000a8a, 0x000a8b, 0x000a8c, 0x000a8f, 0x000a90, 0x000a93, 0x000a94, 0x000a95, 0x000a96,
    0x000a97, 0x000a98, 0x000a99, 0x000a9a, 0x000a9b, 0x000a9c, 0x000a9d, 0x000a9e, 0x000a9f, 0x000aa0, 0x000aa1, 0x000aa2,
    0x000aa3, 0x000aa4, 0x000aa5, 0x000aa6, 0x000aa7, 0x000aa8, 0x000aaa, 0x000aab, 0x000aac, 0x000aad, 0x000aae, 0x000aaf,
    0x000ab0, 0x000ab2, 0x000ab3, 0x000ab5, 0x000ab6, 0x000ab7, 0x000ab8, 0x000ab9, 0x000ae0, 0x000ae1, 0x000ae6, 0x000ae7,
    0x000ae8, 0x000ae9, 0x000aea, 0x000aeb, 0x000aec, 0x000aed, 0x000aee, 0x000aef, 0x000b05, 0x000b06, 0x000b07, 0x000b08,
    0x000b09, 0x000b0a, 0x000b0b, 0x000b0c, 0x000b0f, 0x000b10, 0x000b13, 0x000b14, 0x000b15, 0x000b16, 0x000b17, 0x000b18,
    0x000b19, 0x000b1a, 0x000b1b, 0x000b1c, 0x000b1d, 0x000b1e, 0x000b1f, 0x000b20, 0x000b21, 0x000b22, 0x000b23, 0x000b24,
    0x000b25, 0x000b26, 0x000b27, 0x000b28, 0x000b2a, 0x000b2b, 0x000b2c, 0x000b2d, 0x000b2e, 0x000b2f, 0x000b30, 0x000b32,
    0x000b33, 0x000b35, 0x000b36, 0x000b37, 0x000b38, 0x000b39, 0x000b5c, 0x000b5d, 0x000b5f, 0x000b60, 0x000b61, 0x000b66,
    0x000b67, 0x000b68, 0x000b69, 0x000b6a, 0x000b6b, 0x000b6c, 0x000b6d, 0x000b6e, 0x000b6f, 0x000b71, 0x000b85, 0x000b86,
    0x000b87, 0x000b88, 0x000b89, 0x000b8a, 0x000b8e, 0x000b8f, 0x000b90, 0x000b92, 0x000b93, 0x000b94, 0x000b95, 0x000b99,
    0x000b9a, 0x000b9c, 0x000b9e, 0x000b9f, 0x000ba3, 0x000ba4, 0x000ba8, 0x000ba9, 0x000baa, 0x000bae, 0x000baf, 0x000bb0,
    0x000bb1, 0x000bb2, 0x000bb3, 0x000bb4, 0x000bb5, 0x000bb7, 0x000bb8, 0x000bb9, 0x000be7, 0x000be8, 0x000be9, 0x000bea,
    0x000beb, 0x000bec, 0x000bed, 0x000bee, 0x000bef, 0x000c05, 0x000c06, 0x000c07, 0x000c08, 0x000c09, 0x000c0a, 0x000c0b,
    0x000c0c, 0x000c0e, 0x000c0f, 0x000c10, 0x000c12, 0x000c13, 0x000c14, 0x000c15, 0x000c16, 0x000c17, 0x000c18, 0x000c19,
    0x000c1a, 0x000c1b, 0x000c1c, 0x000c1d, 0x000c1e, 0x000c1f, 0x000c20, 0x000c21, 0x000c22, 0x000c23, 0x000c24, 0x000c25,
    0x000c26, 0x000c27, 0x000c28, 0x000c2a, 0x000c2b, 0x000c2c, 0x000c2d, 0x000c2e, 0x000c2f, 0x000c30, 0x000c31, 0x000c32,
    0x000c33, 0x000c35, 0x000c36, 0x000c37, 0x000c38, 0x000c39, 0x000c60, 0x000c61, 0x000c66, 0x000c67, 0x000c68, 0x000c69,
    0x000c6a, 0x000c6b, 0x000c6c, 0x000c6d, 0x000c6e, 0x000c6f, 0x000c85, 0x000c86, 0x000c87, 0x000c88, 0x000c89, 0x000c8a,
    0x000c8b, 0x000c8c, 0x000c8e, 0x000c8f, 0x000c90, 0x000c92, 0x000c93, 0x000c94, 0x000c95, 0x000c96, 0x000c97, 0x000c98,
    0x000c99, 0x000c9a, 0x000c9b, 0x000c9c, 0x000c9d, 0x000c9e, 0x000c9f, 0x000ca0, 0x000ca1, 0x000ca2, 0x000ca3, 0x000ca4,
    0x000ca5, 0x000ca6, 0x000ca7, 0x000ca8, 0x000caa, 0x000cab, 0x000cac, 0x000cad, 0x000cae, 0x000caf, 0x000cb0, 0x000cb1,
    0x000cb2, 0x000cb3, 0x000cb5, 0x000cb6, 0x000cb7, 0x000cb8, 0x000cb9, 0x000cde, 0x000ce0, 0x000ce1, 0x000ce6, 0x000ce7,
    0x000ce8, 0x000ce9, 0x000cea, 0x000ceb, 0x000cec, 0x000ced, 0x000cee, 0x000cef, 0x000d05, 0x000d06, 0x000d07, 0x000d08,
    0x000d09, 0x000d0a, 0x000d0b, 0x000d0c, 0x000d0e, 0x000d0f, 0x000d10, 0x000d12, 0x000d13, 0x000d14, 0x000d15, 0x000d16,
    0x000d17, 0x000d18, 0x000d19, 0x000d1a, 0x000d1b, 0x000d1c, 0x000d1d, 0x000d1e, 0x000d1f, 0x000d20, 0x000d21, 0x000d22,
    0x000d23, 0x000d24, 0x000d25, 0x000d26, 0x000d27, 0x000d28, 0x000d2a, 0x000d2b, 0x000d2c, 0x000d2d, 0x000d2e, 0x000d2f,
    0x000d30, 0x000d31, 0x000d32, 0x000d33, 0x000d34, 0x000d35, 0x000d36, 0x000d37, 0x000d38, 0x000d39, 0x000d60, 0x000d61,
    0x000d66, 0x000d67, 0x000d68, 0x000d69, 0x000d6a, 0x000d6b, 0x000d6c, 0x000d6d, 0x000d6e, 0x000d6f, 0x000d85, 0x000d86,
    0x000d87, 0x000d88, 0x000d89, 0x000d8a, 0x000d8b, 0x000d8c, 0x000d8d, 0x000d8e, 0x000d8f, 0x000d90, 0x000d91, 0x000d92,
    0x000d93, 0x000d94, 0x000d95, 0x000d96, 0x000d9a, 0x000d9b, 0x000d9c, 0x000d9d, 0x000d9e, 0x000d9f, 0x000da0, 0x000da1,
    0x000da2, 0x000da3, 0x000da4, 0x000da5, 0x000da6, 0x000da7, 0x000da8, 0x000da9, 0x000daa, 0x000dab, 0x000dac, 0x000dad,
    0x000dae, 0x000daf, 0x000db0, 0x000db1, 0x000db3, 0x000db4, 0x000db5, 0x000db6, 0x000db7, 0x000db8, 0x000db9, 0x000dba,
    0x000dbb, 0x000dbd, 0x000dc0, 0x000dc1, 0x000dc2, 0x000dc3, 0x000dc4, 0x000dc5, 0x000dc6, 0x000e01, 0x000e02, 0x000e03,
    0x000e04, 0x000e05, 0x000e06, 0x000e07, 0x000e08, 0x000e09, 0x000e0a, 0x000e0b, 0x000e0c, 0x000e0d, 0x000e0e, 0x000e0f,
    0x000e10, 0x000e11, 0x000e12, 0x000e13, 0x000e14, 0x000e15, 0x000e16, 0x000e17, 0x000e18, 0x000e19, 0x000e1a, 0x000e1b,
    0x000e1c, 0x000e1d, 0x000e1e, 0x000e1f, 0x000e20, 0x000e21, 0x000e22, 0x000e23, 0x000e24, 0x000e25, 0x000e26, 0x000e27,
    0x000e28, 0x000e29, 0x000e2a, 0x000e2b, 0x000e2c, 0x000e2d, 0x000e2e, 0x000e50, 0x000e51, 0x000e52, 0x000e53, 0x000e54,
    0x000e55, 0x000e56, 0x000e57, 0x000e58, 0x000e59, 0x000e81, 0x000e82, 0x000e84, 0x000e87, 0x000e88, 0x000e8a, 0x000e8d,
    0x000e94, 0x000e95, 0x000e96, 0x000e97, 0x000e99, 0x000e9a, 0x000e9b, 0x000e9c, 0x000e9d, 0x000e9e, 0x000e9f, 0x000ea1,
    0x000ea2, 0x000ea3, 0x000ea5, 0x000ea7, 0x000eaa, 0x000eab, 0x000ead, 0x000eae, 0x000ed0, 0x000ed1, 0x000ed2, 0x000ed3,
    0x000ed4, 0x000ed5, 0x000ed6, 0x000ed7, 0x000ed8, 0x000ed9, 0x000f20, 0x000f21, 0x000f22, 0x000f23, 0x000f24, 0x000f25,
    0x000f26, 0x000f27, 0x000f28, 0x000f29, 0x000f2a, 0x000f2b, 0x000f2c, 0x000f2d, 0x000f2e, 0x000f2f, 0x000f30, 0x000f31,
    0x000f32, 0x000f33, 0x000f40, 0x000f41, 0x000f42, 0x000f43, 0x000f44, 0x000f45, 0x000f46, 0x000f47, 0x000f49, 0x000f4a,
    0x000f4b, 0x000f4c, 0x000f4d, 0x000f4e, 0x000f4f, 0x000f50, 0x000f51, 0x000f52, 0x000f53, 0x000f54, 0x000f55, 0x000f56,
    0x000f57, 0x000f58, 0x000f59, 0x000f5a, 0x000f5b, 0x000f5c, 0x000f5d, 0x000f5e, 0x000f5f, 0x000f60, 0x000f61, 0x000f62,
    0x000f63, 0x000f64, 0x000f65, 0x000f66, 0x000f67, 0x000f68, 0x000f69, 0x000f6a, 0x000f90, 0x000f91, 0x000f92, 0x000f93,
    0x000f94, 0x000f95, 0x000f96, 0x000f97, 0x000f99, 0x000f9a, 0x000f9b, 0x000f9c, 0x000f9d, 0x000f9e, 0x000f9f, 0x000fa0,
    0x000fa1, 0x000fa2, 0x000fa3, 0x000fa4, 0x000fa5, 0x000fa6, 0x000fa7, 0x000fa8, 0x000fa9, 0x000faa, 0x000fab, 0x000fac,
    0x000fad, 0x000fae, 0x000faf, 0x000fb0, 0x000fb1, 0x000fb2, 0x000fb3, 0x000fb4, 0x000fb5, 0x000fb6, 0x000fb7, 0x000fb8,
    0x000fb9, 0x000fba, 0x000fbb, 0x000fbc, 0x001000, 0x001001, 0x001002, 0x001003, 0x001004, 0x001005, 0x001006, 0x001007,
    0x001008, 0x001009, 0x00100a, 0x00100b, 0x00100c, 0x00100d, 0x00100e, 0x00100f, 0x001010, 0x001011, 0x001012, 0x001013,
    0x001014, 0x001015, 0x001016, 0x001017, 0x001018, 0x001019, 0x00101a, 0x00101b, 0x00101c, 0x00101d, 0x00101e, 0x00101f,
    0x001020, 0x001021, 0x001023, 0x001024, 0x001025, 0x001026, 0x001027, 0x001029, 0x00102a, 0x001040, 0x001041, 0x001042,
    0x001043, 0x001044, 0x001045, 0x001046, 0x001047, 0x001048, 0x001049, 0x001050, 0x001051, 0x001052, 0x001053, 0x001054,
    0x001055, 0x0010a0, 0x0010a1, 0x0010a2, 0x0010a3, 0x0010a4, 0x0010a5, 0x0010a6, 0x0010a7, 0x0010a8, 0x0010a9, 0x0010aa,
    0x0010ab, 0x0010ac, 0x0010ad, 0x0010ae, 0x0010af, 0x0010b0, 0x0010b1, 0x0010b2, 0x0010b3, 0x0010b4, 0x0010b5, 0x0010b6,
    0x0010b7, 0x0010b8, 0x0010b9, 0x0010ba, 0x0010bb, 0x0010bc, 0x0010bd, 0x0010be, 0x0010bf, 0x0010c0, 0x0010c1, 0x0010c2,
    0x0010c3, 0x0010c4, 0x0010c5, 0x0010d0, 0x0010d1, 0x0010d2, 0x0010d3, 0x0010d4, 0x0010d5, 0x0010d6, 0x0010d7, 0x0010d8,
    0x0010d9, 0x0010da, 0x0010db, 0x0010dc, 0x0010dd, 0x0010de, 0x0010df, 0x0010e0, 0x0010e1, 0x0010e2, 0x0010e3, 0x0010e4,
    0x0010e5, 0x0010e6, 0x0010e7, 0x0010e8, 0x0010e9, 0x0010ea, 0x0010eb, 0x0010ec, 0x0010ed, 0x0010ee, 0x0010ef, 0x0010f0,
    0x0010f1, 0x0010f2, 0x0010f3, 0x0010f4, 0x0010f5, 0x0010f6, 0x0010f7, 0x0010f8, 0x001369, 0x00136a, 0x00136b, 0x00136c,
    0x00136d, 0x00136e, 0x00136f, 0x001370, 0x001371, 0x0013a0, 0x0013a1, 0x0013a2, 0x0013a3, 0x0013a4, 0x0013a5, 0x0013a6,
    0x0013a7, 0x0013a8, 0x0013a9, 0x0013aa, 0x0013ab, 0x0013ac, 0x0013ad, 0x0013ae, 0x0013af, 0x0013b0, 0x0013b1, 0x0013b2,
    0x0013b3, 0x0013b4, 0x0013b5, 0x0013b6, 0x0013b7, 0x0013b8, 0x0013b9, 0x0013ba, 0x0013bb, 0x0013bc, 0x0013bd, 0x0013be,
    0x0013bf, 0x0013c0, 0x0013c1, 0x0013c2, 0x0013c3, 0x0013c4, 0x0013c5, 0x0013c6, 0x0013c7, 0x0013c8, 0x0013c9, 0x0013ca,
    0x0013cb, 0x0013cc, 0x0013cd, 0x0013ce, 0x0013cf, 0x0013d0, 0x0013d1, 0x0013d2, 0x0013d3, 0x0013d4, 0x0013d5, 0x0013d6,
    0x0013d7, 0x0013d8, 0x0013d9, 0x0013da, 0x0013db, 0x0013dc, 0x0013dd, 0x0013de, 0x0013df, 0x0013e0, 0x0013e1, 0x0013e2,
    0x0013e3, 0x0013e4, 0x0013e5, 0x0013e6, 0x0013e7, 0x0013e8, 0x0013e9, 0x0013ea, 0x0013eb, 0x0013ec, 0x0013ed, 0x0013ee,
    0x0013ef, 0x0013f0, 0x0013f1, 0x0013f2, 0x0013f3, 0x0013f4, 0x001681, 0x001682, 0x001683, 0x001684, 0x001685, 0x001686,
    0x001687, 0x001688, 0x001689, 0x00168a, 0x00168b, 0x00168c, 0x00168d, 0x00168e, 0x00168f, 0x001690, 0x001691, 0x001692,
    0x001693, 0x001694, 0x001695, 0x001696, 0x001697, 0x001698, 0x001699, 0x00169a, 0x0016a0, 0x0016a1, 0x0016a2, 0x0016a3,
    0x0016a4, 0x0016a5, 0x0016a6, 0x0016a7, 0x0016a8, 0x0016a9, 0x0016aa, 0x0016ab, 0x0016ac, 0x0016ad, 0x0016ae, 0x0016af,
    0x0016b0, 0x0016b1, 0x0016b2, 0x0016b3, 0x0016b4, 0x0016b5, 0x0016b6, 0x0016b7, 0x0016b8, 0x0016b9, 0x0016ba, 0x0016bb,
    0x0016bc, 0x0016bd, 0x0016be, 0x0016bf, 0x0016c0, 0x0016c1, 0x0016c2, 0x0016c3, 0x0016c4, 0x0016c5, 0x0016c6, 0x0016c7,
    0x0016c8, 0x0016c9, 0x0016ca, 0x0016cb, 0x0016cc, 0x0016cd, 0x0016ce, 0x0016cf, 0x0016d0, 0x0016d1, 0x0016d2, 0x0016d3,
    0x0016d4, 0x0016d5, 0x0016d6, 0x0016d7, 0x0016d8, 0x0016d9, 0x0016da, 0x0016db, 0x0016dc, 0x0016dd, 0x0016de, 0x0016df,
    0x0016e0, 0x0016e1, 0x0016e2, 0x0016e3, 0x0016e4, 0x0016e5, 0x0016e6, 0x0016e7, 0x0016e8, 0x0016e9, 0x0016ea, 0x001700,
    0x001701, 0x001702, 0x001703, 0x001704, 0x001705, 0x001706, 0x001707, 0x001708, 0x001709, 0x00170a, 0x00170b, 0x00170c,
    0x00170e, 0x00170f, 0x001710, 0x001711, 0x001720, 0x001721, 0x001722, 0x001723, 0x001724, 0x001725, 0x001726, 0x001727,
    0x001728, 0x001729, 0x00172a, 0x00172b, 0x00172c, 0x00172d, 0x00172e, 0x00172f, 0x001730, 0x001731, 0x001740, 0x001741,
    0x001742, 0x001743, 0x001744, 0x001745, 0x001746, 0x001747, 0x001748, 0x001749, 0x00174a, 0x00174b, 0x00174c, 0x00174d,
    0x00174e, 0x00174f, 0x001750, 0x001751, 0x001760, 0x001761, 0x001762, 0x001763, 0x001764, 0x001765, 0x001766, 0x001767,
    0x001768, 0x001769, 0x00176a, 0x00176b, 0x00176c, 0x00176e, 0x00176f, 0x001770, 0x001780, 0x001781, 0x001782, 0x001783,
    0x001784, 0x001785, 0x001786, 0x001787, 0x001788, 0x001789, 0x00178a, 0x00178b, 0x00178c, 0x00178d, 0x00178e, 0x00178f,
    0x001790, 0x001791, 0x001792, 0x001793, 0x001794, 0x001795, 0x001796, 0x001797, 0x001798, 0x001799, 0x00179a, 0x00179b,
    0x00179c, 0x00179d, 0x00179e, 0x00179f, 0x0017a0, 0x0017a1, 0x0017a2, 0x0017e0, 0x0017e1, 0x0017e2, 0x0017e3, 0x0017e4,
    0x0017e5, 0x0017e6, 0x0017e7, 0x0017e8, 0x0017e9, 0x001810, 0x001811, 0x001812, 0x001813, 0x001814, 0x001815, 0x001816,
    0x001817, 0x001818, 0x001819, 0x001820, 0x001821, 0x001822, 0x001823, 0x001824, 0x001825, 0x001826, 0x001827, 0x001828,
    0x001829, 0x00182a, 0x00182b, 0x00182c, 0x00182d, 0x00182e, 0x00182f, 0x001830, 0x001831, 0x001832, 0x001833, 0x001834,
    0x001835, 0x001836, 0x001837, 0x001838, 0x001839, 0x00183a, 0x00183b, 0x00183c, 0x00183d, 0x00183e, 0x00183f, 0x001840,
    0x001841, 0x001842, 0x001843, 0x001844, 0x001845, 0x001846, 0x001847, 0x001848, 0x001849, 0x00184a, 0x00184b, 0x00184c,
    0x00184d, 0x00184e, 0x00184f, 0x001850, 0x001851, 0x001852, 0x001853, 0x001854, 0x001855, 0x001856, 0x001857, 0x001858,
    0x001859, 0x00185a, 0x00185b, 0x00185c, 0x00185d, 0x00185e, 0x00185f, 0x001860, 0x001861, 0x001862, 0x001863, 0x001864,
    0x001865, 0x001866, 0x001867, 0x001868, 0x001869, 0x00186a, 0x00186b, 0x00186c, 0x00186d, 0x00186e, 0x00186f, 0x001870,
    0x001871, 0x001872, 0x001873, 0x001874, 0x001875, 0x001876, 0x001877, 0x001880, 0x001881, 0x001882, 0x001883, 0x001884,
    0x001885, 0x001886, 0x001887, 0x001888, 0x001889, 0x00188a, 0x00188b, 0x00188c, 0x00188d, 0x00188e, 0x00188f, 0x001890,
    0x001891, 0x001892, 0x001893, 0x001894, 0x001895, 0x001896, 0x001897, 0x001898, 0x001899, 0x00189a, 0x00189b, 0x00189c,
    0x00189d, 0x00189e, 0x00189f, 0x0018a0, 0x0018a1, 0x0018a2, 0x0018a3, 0x0018a4, 0x0018a5, 0x0018a6, 0x0018a7, 0x0018a8,
    0x0018a9, 0x001900, 0x001901, 0x001902, 0x001903, 0x001904, 0x001905, 0x001906, 0x001907, 0x001908, 0x001909, 0x00190a,
    0x00190b, 0x00190c, 0x00190d, 0x00190e, 0x00190f, 0x001910, 0x001911, 0x001912, 0x001913, 0x001914, 0x001915, 0x001916,
    0x001917, 0x001918, 0x001919, 0x00191a, 0x00191b, 0x00191c, 0x001929, 0x00192a, 0x00192b, 0x001930, 0x001931, 0x001932,
    0x001933, 0x001934, 0x001935, 0x001936, 0x001937, 0x001938, 0x001946, 0x001947, 0x001948, 0x001949, 0x00194a, 0x00194b,
    0x00194c, 0x00194d, 0x00194e, 0x00194f, 0x001950, 0x001951, 0x001952, 0x001953, 0x001954, 0x001955, 0x001956, 0x001957,
    0x001958, 0x001959, 0x00195a, 0x00195b, 0x00195c, 0x00195d, 0x00195e, 0x00195f, 0x001960, 0x001961, 0x001962, 0x001963,
    0x001964, 0x001965, 0x001966, 0x001967, 0x001968, 0x001969, 0x00196a, 0x00196b, 0x00196c, 0x00196d, 0x001970, 0x001971,
    0x001972, 0x001973, 0x001974, 0x001d00, 0x001d01, 0x001d02, 0x001d03, 0x001d04, 0x001d05, 0x001d06, 0x001d07, 0x001d08,
    0x001d09, 0x001d0a, 0x001d0b, 0x001d0c, 0x001d0d, 0x001d0e, 0x001d0f, 0x001d10, 0x001d11, 0x001d12, 0x001d13, 0x001d14,
    0x001d15, 0x001d16, 0x001d17, 0x001d18, 0x001d19, 0x001d1a, 0x001d1b, 0x001d1c, 0x001d1d, 0x001d1e, 0x001d1f, 0x001d20,
    0x001d21, 0x001d22, 0x001d23, 0x001d24, 0x001d25, 0x001d26, 0x001d27, 0x001d28, 0x001d29, 0x001d2a, 0x001d2b, 0x001d2c,
    0x001d2d, 0x001d2e, 0x001d2f, 0x001d30, 0x001d31, 0x001d32, 0x001d33, 0x001d34, 0x001d35, 0x001d36, 0x001d37, 0x001d38,
    0x001d39, 0x001d3a, 0x001d3b, 0x001d3c, 0x001d3d, 0x001d3e, 0x001d3f, 0x001d40, 0x001d41, 0x001d42, 0x001d43, 0x001d44,
    0x001d45, 0x001d46, 0x001d47, 0x001d48, 0x001d49, 0x001d4a, 0x001d4b, 0x001d4c, 0x001d4d, 0x001d4e, 0x001d4f, 0x001d50,
    0x001d51, 0x001d52, 0x001d53, 0x001d54, 0x001d55, 0x001d56, 0x001d57, 0x001d58, 0x001d59, 0x001d5a, 0x001d5b, 0x001d5c,
    0x001d5d, 0x001d5e, 0x001d5f, 0x001d60, 0x001d61, 0x001d62, 0x001d63, 0x001d64, 0x001d65, 0x001d66, 0x001d67, 0x001d68,
    0x001d69, 0x001d6a, 0x001d6b, 0x001e00, 0x001e01, 0x001e02, 0x001e03, 0x001e04, 0x001e05, 0x001e06, 0x001e07, 0x001e08,
    0x001e09, 0x001e0a, 0x001e0b, 0x001e0c, 0x001e0d, 0x001e0e, 0x001e0f, 0x001e10, 0x001e11, 0x001e12, 0x001e13, 0x001e14,
    0x001e15, 0x001e16, 0x001e17, 0x001e18, 0x001e19, 0x001e1a, 0x001e1b, 0x001e1c, 0x001e1d, 0x001e1e, 0x001e1f, 0x001e20,
    0x001e21, 0x001e22, 0x001e23, 0x001e24, 0x001e25, 0x001e26, 0x001e27, 0x001e28, 0x001e29, 0x001e2a, 0x001e2b, 0x001e2c,
    0x001e2d, 0x001e2e, 0x001e2f, 0x001e30, 0x001e31, 0x001e32, 0x001e33, 0x001e34, 0x001e35, 0x001e36, 0x001e37, 0x001e38,
    0x001e39, 0x001e3a, 0x001e3b, 0x001e3c, 0x001e3d, 0x001e3e, 0x001e3f, 0x001e40, 0x001e41, 0x001e42, 0x001e43, 0x001e44,
    0x001e45, 0x001e46, 0x001e47, 0x001e48, 0x001e49, 0x001e4a, 0x001e4b, 0x001e4c, 0x001e4d, 0x001e4e, 0x001e4f, 0x001e50,
    0x001e51, 0x001e52, 0x001e53, 0x001e54, 0x001e55, 0x001e56, 0x001e57, 0x001e58, 0x001e59, 0x001e5a, 0x001e5b, 0x001e5c,
    0x001e5d, 0x001e5e, 0x001e5f, 0x001e60, 0x001e61, 0x001e62, 0x001e63, 0x001e64, 0x001e65, 0x001e66, 0x001e67, 0x001e68,
    0x001e69, 0x001e6a, 0x001e6b, 0x001e6c, 0x001e6d, 0x001e6e, 0x001e6f, 0x001e70, 0x001e71, 0x001e72, 0x001e73, 0x001e74,
    0x001e75, 0x001e76, 0x001e77, 0x001e78, 0x001e79, 0x001e7a, 0x001e7b, 0x001e7c, 0x001e7d, 0x001e7e, 0x001e7f, 0x001e80,
    0x001e81, 0x001e82, 0x001e83, 0x001e84, 0x001e85, 0x001e86, 0x001e87, 0x001e88, 0x001e89, 0x001e8a, 0x001e8b, 0x001e8c,
    0x001e8d, 0x001e8e, 0x001e8f, 0x001e90, 0x001e91, 0x001e92, 0x001e93, 0x001e94, 0x001e95, 0x001e96, 0x001e97, 0x001e98,
    0x001e99, 0x001e9a, 0x001e9b, 0x001ea0, 0x001ea1, 0x001ea2, 0x001ea3, 0x001ea4, 0x001ea5, 0x001ea6, 0x001ea7, 0x001ea8,
    0x001ea9, 0x001eaa, 0x001eab, 0x001eac, 0x001ead, 0x001eae, 0x001eaf, 0x001eb0, 0x001eb1, 0x001eb2, 0x001eb3, 0x001eb4,
    0x001eb5, 0x001eb6, 0x001eb7, 0x001eb8, 0x001eb9, 0x001eba, 0x001ebb, 0x001ebc, 0x001ebd, 0x001ebe, 0x001ebf, 0x001ec0,
    0x001ec1, 0x001ec2, 0x001ec3, 0x001ec4, 0x001ec5, 0x001ec6, 0x001ec7, 0x001ec8, 0x001ec9, 0x001eca, 0x001ecb, 0x001ecc,
    0x001ecd, 0x001ece, 0x001ecf, 0x001ed0, 0x001ed1, 0x001ed2, 0x001ed3, 0x001ed4, 0x001ed5, 0x001ed6, 0x001ed7, 0x001ed8,
    0x001ed9, 0x001eda, 0x001edb, 0x001edc, 0x001edd, 0x001ede, 0x001edf, 0x001ee0, 0x001ee1, 0x001ee2, 0x001ee3, 0x001ee4,
    0x001ee5, 0x001ee6, 0x001ee7, 0x001ee8, 0x001ee9, 0x001eea, 0x001eeb, 0x001eec, 0x001eed, 0x001eee, 0x001eef, 0x001ef0,
    0x001ef1, 0x001ef2, 0x001ef3, 0x001ef4, 0x001ef5, 0x001ef6, 0x001ef7, 0x001ef8, 0x001ef9, 0x001f00, 0x001f01, 0x001f02,
    0x001f03, 0x001f04, 0x001f05, 0x001f06, 0x001f07, 0x001f08, 0x001f09, 0x001f0a, 0x001f0b, 0x001f0c, 0x001f0d, 0x001f0e,
    0x001f0f, 0x001f10, 0x001f11, 0x001f12, 0x001f13, 0x001f14, 0x001f15, 0x001f18, 0x001f19, 0x001f1a, 0x001f1b, 0x001f1c,
    0x001f1d, 0x001f20, 0x001f21, 0x001f22, 0x001f23, 0x001f24, 0x001f25, 0x001f26, 0x001f27, 0x001f28, 0x001f29, 0x001f2a,
    0x001f2b, 0x001f2c, 0x001f2d, 0x001f2e, 0x001f2f, 0x001f30, 0x001f31, 0x001f32, 0x001f33, 0x001f34, 0x001f35, 0x001f36,
    0x001f37, 0x001f38, 0x001f39, 0x001f3a, 0x001f3b, 0x001f3c, 0x001f3d, 0x001f3e, 0x001f3f, 0x001f40, 0x001f41, 0x001f42,
    0x001f43, 0x001f44, 0x001f45, 0x001f48, 0x001f49, 0x001f4a, 0x001f4b, 0x001f4c, 0x001f4d, 0x001f50, 0x001f51, 0x001f52,
    0x001f53, 0x001f54, 0x001f55, 0x001f56, 0x001f57, 0x001f59, 0x001f5b, 0x001f5d, 0x001f5f, 0x001f60, 0x001f61, 0x001f62,
    0x001f63, 0x001f64, 0x001f65, 0x001f66, 0x001f67, 0x001f68, 0x001f69, 0x001f6a, 0x001f6b, 0x001f6c, 0x001f6d, 0x001f6e,
    0x001f6f, 0x001f70, 0x001f71, 0x001f72, 0x001f73, 0x001f74, 0x001f75, 0x001f76, 0x001f77, 0x001f78, 0x001f79, 0x001f7a,
    0x001f7b, 0x001f7c, 0x001f7d, 0x001f80, 0x001f81, 0x001f82, 0x001f83, 0x001f84, 0x001f85, 0x001f86, 0x001f87, 0x001f88,
    0x001f89, 0x001f8a, 0x001f8b, 0x001f8c, 0x001f8d, 0x001f8e, 0x001f8f, 0x001f90, 0x001f91, 0x001f92, 0x001f93, 0x001f94,
    0x001f95, 0x001f96, 0x001f97, 0x001f98, 0x001f99, 0x001f9a, 0x001f9b, 0x001f9c, 0x001f9d, 0x001f9e, 0x001f9f, 0x001fa0,
    0x001fa1, 0x001fa2, 0x001fa3, 0x001fa4, 0x001fa5, 0x001fa6, 0x001fa7, 0x001fa8, 0x001fa9, 0x001faa, 0x001fab, 0x001fac,
    0x001fad, 0x001fae, 0x001faf, 0x001fb0, 0x001fb1, 0x001fb2, 0x001fb3, 0x001fb4, 0x001fb6, 0x001fb7, 0x001fb8, 0x001fb9,
    0x001fba, 0x001fbb, 0x001fbc, 0x001fc2, 0x001fc3, 0x001fc4, 0x001fc6, 0x001fc7, 0x001fc8, 0x001fc9, 0x001fca, 0x001fcb,
    0x001fcc, 0x001fd0, 0x001fd1, 0x001fd2, 0x001fd3, 0x001fd6, 0x001fd7, 0x001fd8, 0x001fd9, 0x001fda, 0x001fdb, 0x001fe0,
    0x001fe1, 0x001fe2, 0x001fe3, 0x001fe4, 0x001fe5, 0x001fe6, 0x001fe7, 0x001fe8, 0x001fe9, 0x001fea, 0x001feb, 0x001fec,
    0x001ff2, 0x001ff3, 0x001ff4, 0x001ff6, 0x001ff7, 0x001ff8, 0x001ff9, 0x001ffa, 0x001ffb, 0x001ffc, 0x00206e, 0x00206f,
    0x002070, 0x002071, 0x002074, 0x002075, 0x002076, 0x002077, 0x002078, 0x002079, 0x00207f, 0x002080, 0x002081, 0x002082,
    0x002083, 0x002084, 0x002085, 0x002086, 0x002087, 0x002088, 0x002089, 0x00210c, 0x002111, 0x00211c, 0x002128, 0x002129,
    0x00212d, 0x002460, 0x002461, 0x002462, 0x002463, 0x002464, 0x002465, 0x002466, 0x002467, 0x002468, 0x002474, 0x002475,
    0x002476, 0x002477, 0x002478, 0x002479, 0x00247a, 0x00247b, 0x00247c, 0x002488, 0x002489, 0x00248a, 0x00248b, 0x00248c,
    0x00248d, 0x00248e, 0x00248f, 0x002490, 0x00249c, 0x00249d, 0x00249e, 0x00249f, 0x0024a0, 0x0024a1, 0x0024a2, 0x0024a3,
    0x0024a4, 0x0024a5, 0x0024a6, 0x0024a7, 0x0024a8, 0x0024a9, 0x0024aa, 0x0024ab, 0x0024ac, 0x0024ad, 0x0024ae, 0x0024af,
    0x0024b0, 0x0024b1, 0x0024b2, 0x0024b3, 0x0024b4, 0x0024b5, 0x0024b6, 0x0024b7, 0x0024b8, 0x0024b9, 0x0024ba, 0x0024bb,
    0x0024bc, 0x0024bd, 0x0024be, 0x0024bf, 0x0024c0, 0x0024c1, 0x0024c2, 0x0024c3, 0x0024c4, 0x0024c5, 0x0024c6, 0x0024c7,
    0x0024c8, 0x0024c9, 0x0024ca, 0x0024cb, 0x0024cc, 0x0024cd, 0x0024ce, 0x0024cf, 0x0024d0, 0x0024d1, 0x0024d2, 0x0024d3,
    0x0024d4, 0x0024d5, 0x0024d6, 0x0024d7, 0x0024d8, 0x0024d9, 0x0024da, 0x0024db, 0x0024dc, 0x0024dd, 0x0024de, 0x0024df,
    0x0024e0, 0x0024e1, 0x0024e2, 0x0024e3, 0x0024e4, 0x0024e5, 0x0024e6, 0x0024e7, 0x0024e8, 0x0024e9, 0x0024ea, 0x0024f5,
    0x0024f6, 0x0024f7, 0x0024f8, 0x0024f9, 0x0024fa, 0x0024fb, 0x0024fc, 0x0024fd, 0x0024ff, 0x002776, 0x002777, 0x002778,
    0x002779, 0x00277a, 0x00277b, 0x00277c, 0x00277d, 0x00277e, 0x002780, 0x002781, 0x002782, 0x002783, 0x002784, 0x002785,
    0x002786, 0x002787, 0x002788, 0x00278a, 0x00278b, 0x00278c, 0x00278d, 0x00278e, 0x00278f, 0x002790, 0x002791, 0x002792,
    0x003041, 0x003042, 0x003043, 0x003044, 0x003045, 0x003046, 0x003047, 0x003048, 0x003049, 0x00304a, 0x00304b, 0x00304c,
    0x00304d, 0x00304e, 0x00304f, 0x003050, 0x003051, 0x003052, 0x003053, 0x003054, 0x003055, 0x003056, 0x003057, 0x003058,
    0x003059, 0x00305a, 0x00305b, 0x00305c, 0x00305d, 0x00305e, 0x00305f, 0x003060, 0x003061, 0x003062, 0x003063, 0x003064,
    0x003065, 0x003066, 0x003067, 0x003068, 0x003069, 0x00306a, 0x00306b, 0x00306c, 0x00306d, 0x00306e, 0x00306f, 0x003070,
    0x003071, 0x003072, 0x003073, 0x003074, 0x003075, 0x003076, 0x003077, 0x003078, 0x003079, 0x00307a, 0x00307b, 0x00307c,
    0x00307d, 0x00307e, 0x00307f, 0x003080, 0x003081, 0x003082, 0x003083, 0x003084, 0x003085, 0x003086, 0x003087, 0x003088,
    0x003089, 0x00308a, 0x00308b, 0x00308c, 0x00308d, 0x00308e, 0x00308f, 0x003090, 0x003091, 0x003092, 0x003093, 0x003094,
    0x003095, 0x003096, 0x0030a1, 0x0030a2, 0x0030a3, 0x0030a4, 0x0030a5, 0x0030a6, 0x0030a7, 0x0030a8, 0x0030a9, 0x0030aa,
    0x0030ab, 0x0030ac, 0x0030ad, 0x0030ae, 0x0030af, 0x0030b0, 0x0030b1, 0x0030b2, 0x0030b3, 0x0030b4, 0x0030b5, 0x0030b6,
    0x0030b7, 0x0030b8, 0x0030b9, 0x0030ba, 0x0030bb, 0x0030bc, 0x0030bd, 0x0030be, 0x0030bf, 0x0030c0, 0x0030c1, 0x0030c2,
    0x0030c3, 0x0030c4, 0x0030c5, 0x0030c6, 0x0030c7, 0x0030c8, 0x0030c9, 0x0030ca, 0x0030cb, 0x0030cc, 0x0030cd, 0x0030ce,
    0x0030cf, 0x0030d0, 0x0030d1, 0x0030d2, 0x0030d3, 0x0030d4, 0x0030d5, 0x0030d6, 0x0030d7, 0x0030d8, 0x0030d9, 0x0030da,
    0x0030db, 0x0030dc, 0x0030dd, 0x0030de, 0x0030df, 0x0030e0, 0x0030e1, 0x0030e2, 0x0030e3, 0x0030e4, 0x0030e5, 0x0030e6,
    0x0030e7, 0x0030e8, 0x0030e9, 0x0030ea, 0x0030eb, 0x0030ec, 0x0030ed, 0x0030ee, 0x0030ef, 0x0030f0, 0x0030f1, 0x0030f2,
    0x0030f3, 0x0030f4, 0x0030f5, 0x0030f6, 0x0030f7, 0x0030f8, 0x0030f9, 0x0030fa, 0x003105, 0x003106, 0x003107, 0x003108,
    0x003109, 0x00310a, 0x00310b, 0x00310c, 0x00310d, 0x00310e, 0x00310f, 0x003110, 0x003111, 0x003112, 0x003113, 0x003114,
    0x003115, 0x003116, 0x003117, 0x003118, 0x003119, 0x00311a, 0x00311b, 0x00311c, 0x00311d, 0x00311e, 0x00311f, 0x003120,
    0x003121, 0x003122, 0x003123, 0x003124, 0x003125, 0x003126, 0x003127, 0x003128, 0x003129, 0x00312a, 0x00312b, 0x00312c,
    0x003131, 0x003132, 0x003133, 0x003134, 0x003135, 0x003136, 0x003137, 0x003138, 0x003139, 0x00313a, 0x00313b, 0x00313c,
    0x00313d, 0x00313e, 0x00313f, 0x003140, 0x003141, 0x003142, 0x003143, 0x003144, 0x003145, 0x003146, 0x003147, 0x003148,
    0x003149, 0x00314a, 0x00314b, 0x00314c, 0x00314d, 0x00314e, 0x00314f, 0x003150, 0x003151, 0x003152, 0x003153, 0x003154,
    0x003155, 0x003156, 0x003157, 0x003158, 0x003159, 0x00315a, 0x00315b, 0x00315c, 0x00315d, 0x00315e, 0x00315f, 0x003160,
    0x003161, 0x003162, 0x003163, 0x003165, 0x003166, 0x003167, 0x003168, 0x003169, 0x00316a, 0x00316b, 0x00316c, 0x00316d,
    0x00316e, 0x00316f, 0x003170, 0x003171, 0x003172, 0x003173, 0x003174, 0x003175, 0x003176, 0x003177, 0x003178, 0x003179,
    0x00317a, 0x00317b, 0x00317c, 0x00317d, 0x00317e, 0x00317f, 0x003180, 0x003181, 0x003182, 0x003183, 0x003184, 0x003185,
    0x003186, 0x003187, 0x003188, 0x003189, 0x00318a, 0x00318b, 0x00318c, 0x00318d, 0x00318e, 0x0031a0, 0x0031a1, 0x0031a2,
    0x0031a3, 0x0031a4, 0x0031a5, 0x0031a6, 0x0031a7, 0x0031a8, 0x0031a9, 0x0031aa, 0x0031ab, 0x0031ac, 0x0031ad, 0x0031ae,
    0x0031af, 0x0031b0, 0x0031b1, 0x0031b2, 0x0031b3, 0x0031b4, 0x0031b5, 0x0031b6, 0x0031b7, 0x0031f0, 0x0031f1, 0x0031f2,
    0x0031f3, 0x0031f4, 0x0031f5, 0x0031f6, 0x0031f7, 0x0031f8, 0x0031f9, 0x0031fa, 0x0031fb, 0x0031fc, 0x0031fd, 0x0031fe,
    0x0031ff, 0x00fb1d, 0x00fb20, 0x00fb21, 0x00fb22, 0x00fb23, 0x00fb24, 0x00fb25, 0x00fb26, 0x00fb27, 0x00fb28, 0x00fb29,
    0x00fb2a, 0x00fb2b, 0x00fb2c, 0x00fb2d, 0x00fb2e, 0x00fb2f, 0x00fb30, 0x00fb31, 0x00fb32, 0x00fb33, 0x00fb34, 0x00fb35,
    0x00fb36, 0x00fb38, 0x00fb39, 0x00fb3a, 0x00fb3b, 0x00fb3c, 0x00fb3e, 0x00fb40, 0x00fb41, 0x00fb43, 0x00fb44, 0x00fb46,
    0x00fb47, 0x00fb48, 0x00fb49, 0x00fb4a, 0x00fb4b, 0x00fb4c, 0x00fb4d, 0x00fb4e, 0x00fb50, 0x00fb51, 0x00fb52, 0x00fb53,
    0x00fb54, 0x00fb55, 0x00fb56, 0x00fb57, 0x00fb58, 0x00fb59, 0x00fb5a, 0x00fb5b, 0x00fb5c, 0x00fb5d, 0x00fb5e, 0x00fb5f,
    0x00fb60, 0x00fb61, 0x00fb62, 0x00fb63, 0x00fb64, 0x00fb65, 0x00fb66, 0x00fb67, 0x00fb68, 0x00fb69, 0x00fb6a, 0x00fb6b,
    0x00fb6c, 0x00fb6d, 0x00fb6e, 0x00fb6f, 0x00fb70, 0x00fb71, 0x00fb72, 0x00fb73, 0x00fb74, 0x00fb75, 0x00fb76, 0x00fb77,
    0x00fb78, 0x00fb79, 0x00fb7a, 0x00fb7b, 0x00fb7c, 0x00fb7d, 0x00fb7e, 0x00fb7f, 0x00fb80, 0x00fb81, 0x00fb82, 0x00fb83,
    0x00fb84, 0x00fb85, 0x00fb86, 0x00fb87, 0x00fb88, 0x00fb89, 0x00fb8a, 0x00fb8b, 0x00fb8c, 0x00fb8d, 0x00fb8e, 0x00fb8f,
    0x00fb90, 0x00fb91, 0x00fb92, 0x00fb93, 0x00fb94, 0x00fb95, 0x00fb96, 0x00fb97, 0x00fb98, 0x00fb99, 0x00fb9a, 0x00fb9b,
    0x00fb9c, 0x00fb9d, 0x00fb9e, 0x00fb9f, 0x00fba0, 0x00fba1, 0x00fba2, 0x00fba3, 0x00fba4, 0x00fba5, 0x00fba6, 0x00fba7,
    0x00fba8, 0x00fba9, 0x00fbaa, 0x00fbab, 0x00fbac, 0x00fbad, 0x00fbae, 0x00fbaf, 0x00fbb0, 0x00fbb1, 0x00fbd3, 0x00fbd4,
    0x00fbd5, 0x00fbd6, 0x00fbd7, 0x00fbd8, 0x00fbd9, 0x00fbda, 0x00fbdb, 0x00fbdc, 0x00fbdd, 0x00fbde, 0x00fbdf, 0x00fbe0,
    0x00fbe1, 0x00fbe2, 0x00fbe3, 0x00fbe4, 0x00fbe5, 0x00fbe6, 0x00fbe7, 0x00fbe8, 0x00fbe9, 0x00fbfc, 0x00fbfd, 0x00fbfe,
    0x00fbff, 0x00fdfa, 0x00fdfb, 0x00fe80, 0x00fe81, 0x00fe82, 0x00fe83, 0x00fe84, 0x00fe85, 0x00fe86, 0x00fe87, 0x00fe88,
    0x00fe89, 0x00fe8a, 0x00fe8b, 0x00fe8c, 0x00fe8d, 0x00fe8e, 0x00fe8f, 0x00fe90, 0x00fe91, 0x00fe92, 0x00fe93, 0x00fe94,
    0x00fe95, 0x00fe96, 0x00fe97, 0x00fe98, 0x00fe99, 0x00fe9a, 0x00fe9b, 0x00fe9c, 0x00fe9d, 0x00fe9e, 0x00fe9f, 0x00fea0,
    0x00fea1, 0x00fea2, 0x00fea3, 0x00fea4, 0x00fea5, 0x00fea6, 0x00fea7, 0x00fea8, 0x00fea9, 0x00feaa, 0x00feab, 0x00feac,
    0x00fead, 0x00feae, 0x00feaf, 0x00feb0, 0x00feb1, 0x00feb2, 0x00feb3, 0x00feb4, 0x00feb5, 0x00feb6, 0x00feb7, 0x00feb8,
    0x00feb9, 0x00feba, 0x00febb, 0x00febc, 0x00febd, 0x00febe, 0x00febf, 0x00fec0, 0x00fec1, 0x00fec2, 0x00fec3, 0x00fec4,
    0x00fec5, 0x00fec6, 0x00fec7, 0x00fec8, 0x00fec9, 0x00feca, 0x00fecb, 0x00fecc, 0x00fecd, 0x00fece, 0x00fecf, 0x00fed0,
    0x00fed1, 0x00fed2, 0x00fed3, 0x00fed4, 0x00fed5, 0x00fed6, 0x00fed7, 0x00fed8, 0x00fed9, 0x00feda, 0x00fedb, 0x00fedc,
    0x00fedd, 0x00fede, 0x00fedf, 0x00fee0, 0x00fee1, 0x00fee2, 0x00fee3, 0x00fee4, 0x00fee5, 0x00fee6, 0x00fee7, 0x00fee8,
    0x00fee9, 0x00feea, 0x00feeb, 0x00feec, 0x00feed, 0x00feee, 0x00feef, 0x00fef0, 0x00fef1, 0x00fef2, 0x00fef3, 0x00fef4,
    0x00ff10, 0x00ff11, 0x00ff12, 0x00ff13, 0x00ff14, 0x00ff15, 0x00ff16, 0x00ff17, 0x00ff18, 0x00ff19, 0x00ff21, 0x00ff22,
    0x00ff23, 0x00ff24, 0x00ff25, 0x00ff26, 0x00ff27, 0x00ff28, 0x00ff29, 0x00ff2a, 0x00ff2b, 0x00ff2c, 0x00ff2d, 0x00ff2e,
    0x00ff2f, 0x00ff30, 0x00ff31, 0x00ff32, 0x00ff33, 0x00ff34, 0x00ff35, 0x00ff36, 0x00ff37, 0x00ff38, 0x00ff39, 0x00ff3a,
    0x00ff41, 0x00ff42, 0x00ff43, 0x00ff44, 0x00ff45, 0x00ff46, 0x00ff47, 0x00ff48, 0x00ff49, 0x00ff4a, 0x00ff4b, 0x00ff4c,
    0x00ff4d, 0x00ff4e, 0x00ff4f, 0x00ff50, 0x00ff51, 0x00ff52, 0x00ff53, 0x00ff54, 0x00ff55, 0x00ff56, 0x00ff57, 0x00ff58,
    0x00ff59, 0x00ff5a, 0x00ff66, 0x00ff67, 0x00ff68, 0x00ff69, 0x00ff6a, 0x00ff6b, 0x00ff6c, 0x00ff6d, 0x00ff6e, 0x00ff6f,
    0x00ff71, 0x00ff72, 0x00ff73, 0x00ff74, 0x00ff75, 0x00ff76, 0x00ff77, 0x00ff78, 0x00ff79, 0x00ff7a, 0x00ff7b, 0x00ff7c,
    0x00ff7d, 0x00ff7e, 0x00ff7f, 0x00ff80, 0x00ff81, 0x00ff82, 0x00ff83, 0x00ff84, 0x00ff85, 0x00ff86, 0x00ff87, 0x00ff88,
    0x00ff89, 0x00ff8a, 0x00ff8b, 0x00ff8c, 0x00ff8d, 0x00ff8e, 0x00ff8f, 0x00ff90, 0x00ff91, 0x00ff92, 0x00ff93, 0x00ff94,
    0x00ff95, 0x00ff96, 0x00ff97, 0x00ff98, 0x00ff99, 0x00ff9a, 0x00ff9b, 0x00ff9c, 0x00ff9d, 0x00ffa1, 0x00ffa2, 0x00ffa3,
    0x00ffa4, 0x00ffa5, 0x00ffa6, 0x00ffa7, 0x00ffa8, 0x00ffa9, 0x00ffaa, 0x00ffab, 0x00ffac, 0x00ffad, 0x00ffae, 0x00ffaf,
    0x00ffb0, 0x00ffb1, 0x00ffb2, 0x00ffb3, 0x00ffb4, 0x00ffb5, 0x00ffb6, 0x00ffb7, 0x00ffb8, 0x00ffb9, 0x00ffba, 0x00ffbb,
    0x00ffbc, 0x00ffbd, 0x00ffbe, 0x00ffc2, 0x00ffc3, 0x00ffc4, 0x00ffc5, 0x00ffc6, 0x00ffc7, 0x00ffca, 0x00ffcb, 0x00ffcc,
    0x00ffcd, 0x00ffce, 0x00ffcf, 0x00ffd2, 0x00ffd3, 0x00ffd4, 0x00ffd5, 0x00ffd6, 0x00ffd7, 0x00ffda, 0x00ffdb, 0x00ffdc,
    0x010300, 0x010301, 0x010302, 0x010303, 0x010304, 0x010305, 0x010306, 0x010307, 0x010308, 0x010309, 0x01030a, 0x01030b,
    0x01030c, 0x01030d, 0x01030e, 0x01030f, 0x010310, 0x010311, 0x010312, 0x010313, 0x010314, 0x010315, 0x010316, 0x010317,
    0x010318, 0x010319, 0x01031a, 0x01031b, 0x01031c, 0x01031d, 0x01031e, 0x010330, 0x010331, 0x010332, 0x010333, 0x010334,
    0x010335, 0x010336, 0x010337, 0x010338, 0x010339, 0x01033a, 0x01033b, 0x01033c, 0x01033d, 0x01033e, 0x01033f, 0x010340,
    0x010341, 0x010342, 0x010343, 0x010344, 0x010345, 0x010346, 0x010347, 0x010348, 0x010349, 0x01034a, 0x010380, 0x010381,
    0x010382, 0x010383, 0x010384, 0x010385, 0x010386, 0x010387, 0x010388, 0x010389, 0x01038a, 0x01038b, 0x01038c, 0x01038d,
    0x01038e, 0x01038f, 0x010390, 0x010391, 0x010392, 0x010393, 0x010394, 0x010395, 0x010396, 0x010397, 0x010398, 0x010399,
    0x01039a, 0x01039b, 0x01039c, 0x01039d, 0x010400, 0x010401, 0x010402, 0x010403, 0x010404, 0x010405, 0x010406, 0x010407,
    0x010408, 0x010409, 0x01040a, 0x01040b, 0x01040c, 0x01040d, 0x01040e, 0x01040f, 0x010410, 0x010411, 0x010412, 0x010413,
    0x010414, 0x010415, 0x010416, 0x010417, 0x010418, 0x010419, 0x01041a, 0x01041b, 0x01041c, 0x01041d, 0x01041e, 0x01041f,
    0x010420, 0x010421, 0x010422, 0x010423, 0x010424, 0x010425, 0x010426, 0x010427, 0x010428, 0x010429, 0x01042a, 0x01042b,
    0x01042c, 0x01042d, 0x01042e, 0x01042f, 0x010430, 0x010431, 0x010432, 0x010433, 0x010434, 0x010435, 0x010436, 0x010437,
    0x010438, 0x010439, 0x01043a, 0x01043b, 0x01043c, 0x01043d, 0x01043e, 0x01043f, 0x010440, 0x010441, 0x010442, 0x010443,
    0x010444, 0x010445, 0x010446, 0x010447, 0x010448, 0x010449, 0x01044a, 0x01044b, 0x01044c, 0x01044d, 0x01044e, 0x01044f,
    0x010450, 0x010451, 0x010452, 0x010453, 0x010454, 0x010455, 0x010456, 0x010457, 0x010458, 0x010459, 0x01045a, 0x01045b,
    0x01045c, 0x01045d, 0x01045e, 0x01045f, 0x010460, 0x010461, 0x010462, 0x010463, 0x010464, 0x010465, 0x010466, 0x010467,
    0x010468, 0x010469, 0x01046a, 0x01046b, 0x01046c, 0x01046d, 0x01046e, 0x01046f, 0x010470, 0x010471, 0x010472, 0x010473,
    0x010474, 0x010475, 0x010476, 0x010477, 0x010478, 0x010479, 0x01047a, 0x01047b, 0x01047c, 0x01047d, 0x01047e, 0x01047f,
    0x010480, 0x010481, 0x010482, 0x010483, 0x010484, 0x010485, 0x010486, 0x010487, 0x010488, 0x010489, 0x01048a, 0x01048b,
    0x01048c, 0x01048d, 0x01048e, 0x01048f, 0x010490, 0x010491, 0x010492, 0x010493, 0x010494, 0x010495, 0x010496, 0x010497,
    0x010498, 0x010499, 0x01049a, 0x01049b, 0x01049c, 0x01049d, 0x0104a0, 0x0104a1, 0x0104a2, 0x0104a3, 0x0104a4, 0x0104a5,
    0x0104a6, 0x0104a7, 0x0104a8, 0x0104a9, 0x01d7ce, 0x01d7cf, 0x01d7d0, 0x01d7d1, 0x01d7d2, 0x01d7d3, 0x01d7d4, 0x01d7d5,
    0x01d7d6, 0x01d7d7, 0x01d7d8, 0x01d7d9, 0x01d7da, 0x01d7db, 0x01d7dc, 0x01d7dd, 0x01d7de, 0x01d7df, 0x01d7e0, 0x01d7e1,
    0x01d7e2, 0x01d7e3, 0x01d7e4, 0x01d7e5, 0x01d7e6, 0x01d7e7, 0x01d7e8, 0x01d7e9, 0x01d7ea, 0x01d7eb, 0x01d7ec, 0x01d7ed,
    0x01d7ee, 0x01d7ef, 0x01d7f0, 0x01d7f1, 0x01d7f2, 0x01d7f3, 0x01d7f4, 0x01d7f5, 0x01d7f6, 0x01d7f7, 0x01d7f8, 0x01d7f9,
    0x01d7fa, 0x01d7fb, 0x01d7fc, 0x01d7fd, 0x01d7fe, 0x01d7ff, 0x0e0030, 0x0e0031, 0x0e0032, 0x0e0033, 0x0e0034, 0x0e0035,
    0x0e0036, 0x0e0037, 0x0e0038, 0x0e0039, 0x0e0041, 0x0e0042, 0x0e0043, 0x0e0044, 0x0e0045, 0x0e0046, 0x0e0047, 0x0e0048,
    0x0e0049, 0x0e004a, 0x0e004b, 0x0e004c, 0x0e004d, 0x0e004e, 0x0e004f, 0x0e0050, 0x0e0051, 0x0e0052, 0x0e0053, 0x0e0054,
    0x0e0055, 0x0e0056, 0x0e0057, 0x0e0058, 0x0e0059, 0x0e005a, 0x0e0061, 0x0e0062, 0x0e0063, 0x0e0064, 0x0e0065, 0x0e0066,
    0x0e0067, 0x0e0068, 0x0e0069, 0x0e006a, 0x0e006b, 0x0e006c, 0x0e006d, 0x0e006e, 0x0e006f, 0x0e0070, 0x0e0071, 0x0e0072,
    0x0e0073, 0x0e0074, 0x0e0075, 0x0e0076, 0x0e0077, 0x0e0078, 0x0e0079, 0x0e007a,

};

static bool Match(int* table, int size, int val)
{
    int top = size;
    int bottom = -1;
    while (top - bottom > 1)
    {
        int mid = (top + bottom) / 2;
        if (val < table[mid])
        {
            top = mid;
        }
        else
        {
            bottom = mid;
        }
    }
    if (bottom < 0 || table[bottom] != val)
        return 0;
    return 1;
}
bool UTF8::IsAlpha(int n)
{
    if (n < 0x7f)
        return isalpha(n);
    return Match(alpha, sizeof(alpha) / sizeof(alpha[0]), n);
}
bool UTF8::IsAlnum(int n)
{
    if (n < 0x7f)
        return isalnum(n);
    return Match(alnum, sizeof(alnum) / sizeof(alnum[0]), n);
}
bool UTF8::IsAlpha(const char* str)
{
    int n = Decode(str);
    return IsAlpha(n);
}
bool UTF8::IsAlnum(const char* str)
{
    int n = Decode(str);
    return IsAlnum(n);
}
