SET(ALLEGRO_RASPBERRYPI 1)
SET(CMAKE_SYSTEM_NAME Linux)

IF("${TOOLCHAIN_ROOT}" STREQUAL "")
   SET(TOOLCHAIN_ROOT "/usr/bin")
ENDIF("${TOOLCHAIN_ROOT}" STREQUAL "")

IF("${TOOLCHAIN_PREFIX}" STREQUAL "")
   SET(TOOLCHAIN_PREFIX "")
ENDIF("${TOOLCHAIN_PREFIX}" STREQUAL "")

IF("${TOOLCHAIN_SUFFIX}" STREQUAL "")
   SET(TOOLCHAIN_SUFFIX "")
ENDIF("${TOOLCHAIN_SUFFIX}" STREQUAL "")

SET(CMAKE_C_FLAGS "-march=armv6 -mfpu=vfp -mfloat-abi=hard -Os")
SET(CMAKE_CXX_FLAGS "-march=armv6 -mfpu=vfp -mfloat-abi=hard -Os")

if(NOT DISTCC)
    set(CMAKE_C_COMPILER ${TOOLCHAIN_ROOT}/${TOOLCHAIN_PREFIX}gcc${TOOLCHAIN_SUFFIX})
    set(CMAKE_CXX_COMPILER ${TOOLCHAIN_ROOT}/${TOOLCHAIN_PREFIX}g++${TOOLCHAIN_SUFFIX})
endif()
set(CMAKE_LINKER ${TOOLCHAIN_ROOT}/${TOOLCHAIN_PREFIX}ld${TOOLCHAIN_SUFFIX})
set(CMAKE_NM ${TOOLCHAIN_ROOT}/${TOOLCHAIN_PREFIX}nm${TOOLCHAIN_SUFFIX})
set(CMAKE_OBJCOPY ${TOOLCHAIN_ROOT}/${TOOLCHAIN_PREFIX}objcopy${TOOLCHAIN_SUFFIX})
set(CMAKE_OBJDUMP ${TOOLCHAIN_ROOT}/${TOOLCHAIN_PREFIX}objdump${TOOLCHAIN_SUFFIX})
set(CMAKE_STRIP ${TOOLCHAIN_ROOT}/${TOOLCHAIN_PREFIX}strip${TOOLCHAIN_SUFFIX})
set(CMAKE_RANLIB ${TOOLCHAIN_ROOT}/${TOOLCHAIN_PREFIX}ranlib${TOOLCHAIN_SUFFIX})

SET(CMAKE_FIND_ROOT_PATH_MODE_PROGRAM NEVER)
SET(CMAKE_FIND_ROOT_PATH_MODE_LIBRARY ONLY)
SET(CMAKE_FIND_ROOT_PATH_MODE_INCLUDE ONLY)

include_directories(
   "/opt/vc/include"
   "/opt/vc/include/interface/vcos/pthreads"
   "/opt/vc/include/interface/vmcs_host/linux"
)

