/* This file has been put into the public domain by its author.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
   IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
   OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
   ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
   OTHER DEALINGS IN THE SOFTWARE.
*/

/* xmath.h - local #include file

   AUTHOR: Gregory Pietsch
   
*/

#ifndef _XMATH
#define _XMATH

#include <errno.h>
#include <fenv.h>
#include <float.h>
#include <limits.h>
#include <math.h>
#ifndef _YVALS
#include <yvals.h>
#endif

#ifndef M_E
#define M_E		\
(2.7182818284590452353602874713526624977572\
4709369995957496696762772407663035354759)
#define M_LOG2E		\
(1.4426950408889634073599246810018921374266\
4595415298593413544940693110921918118509)
#define M_LOG10E	\
(0.4342944819032518276511289189166050822943\
9700580366656611445378316586464920887077)
#define M_LN2           \
(0.6931471805599453094172321214581765680755\
0013436025525412068000949339362196969471)
#define M_LN10		\
(2.3025850929940456840179914546843642076011\
0148862877297603332790096757260967735248)
#define M_PI		\
(3.1415926535897932384626433832795028841971\
6939937510582097494459230781640628620896)
#define M_PI_2		\
(1.5707963267948966192313216916397514420985\
8469968755291048747229615390820314310448)
#define M_PI_4		\
(0.7853981633974483096156608458198757210492\
9234984377645524373614807695410157155224)
#define M_1_PI		\
(0.3183098861837906715377675267450287240689\
1929148091289749533468811779359526845307)
#define M_2_PI		\
(0.6366197723675813430755350534900574481378\
3858296182579499066937623558719053690614)
#define M_2_SQRTPI	\
(1.1283791670955125738961589031215451716881\
0125865799771368817144342128493688298683)
#define M_SQRT2		\
(1.4142135623730950488016887242096980785696\
7187537694807317667973799073247846210703)
#define M_SQRT1_2	\
(0.7071067811865475244008443621048490392848\
3593768847403658833986899536623923105351)
#endif
#define _M_EF		\
(2.7182818284590452353602874713526624977572\
4709369995957496696762772407663035354759F)
#define _M_LOG2EF	\
(1.4426950408889634073599246810018921374266\
4595415298593413544940693110921918118509F)
#define _M_LOG10EF	\
(0.4342944819032518276511289189166050822943\
9700580366656611445378316586464920887077F)
#define _M_LN2F		\
(0.6931471805599453094172321214581765680755\
0013436025525412068000949339362196969471F)
#define _M_LN10F	\
(2.3025850929940456840179914546843642076011\
0148862877297603332790096757260967735248F)
#define _M_PIF		\
(3.1415926535897932384626433832795028841971\
6939937510582097494459230781640628620896F)
#define _M_PI_2F	\
(1.5707963267948966192313216916397514420985\
8469968755291048747229615390820314310448F)
#define _M_PI_4F	\
(0.7853981633974483096156608458198757210492\
9234984377645524373614807695410157155224F)
#define _M_1_PIF	\
(0.3183098861837906715377675267450287240689\
1929148091289749533468811779359526845307F)
#define _M_2_PIF	\
(0.6366197723675813430755350534900574481378\
3858296182579499066937623558719053690614F)
#define _M_2_SQRTPIF	\
(1.1283791670955125738961589031215451716881\
0125865799771368817144342128493688298683F)
#define _M_SQRT2F	\
(1.4142135623730950488016887242096980785696\
7187537694807317667973799073247846210703F)
#define _M_SQRT1_2F	\
(0.7071067811865475244008443621048490392848\
3593768847403658833986899536623923105351F)
#define _M_EL		\
(2.7182818284590452353602874713526624977572\
4709369995957496696762772407663035354759L)
#define _M_LOG2EL	\
(1.4426950408889634073599246810018921374266\
4595415298593413544940693110921918118509L)
#define _M_LOG10EL	\
(0.4342944819032518276511289189166050822943\
9700580366656611445378316586464920887077L)
#define _M_LN2L		\
(0.6931471805599453094172321214581765680755\
0013436025525412068000949339362196969471L)
#define _M_LN10L	\
(2.3025850929940456840179914546843642076011\
0148862877297603332790096757260967735248L)
#define _M_PIL		\
(3.1415926535897932384626433832795028841971\
6939937510582097494459230781640628620896L)
#define _M_PI_2L	\
(1.5707963267948966192313216916397514420985\
8469968755291048747229615390820314310448L)
#define _M_PI_4L	\
(0.7853981633974483096156608458198757210492\
9234984377645524373614807695410157155224L)
#define _M_1_PIL	\
(0.3183098861837906715377675267450287240689\
1929148091289749533468811779359526845307L)
#define _M_2_PIL	\
(0.6366197723675813430755350534900574481378\
3858296182579499066937623558719053690614L)
#define _M_2_SQRTPIL	\
(1.1283791670955125738961589031215451716881\
0125865799771368817144342128493688298683L)
#define _M_SQRT2L	\
(1.4142135623730950488016887242096980785696\
7187537694807317667973799073247846210703L)
#define _M_SQRT1_2L	\
(0.7071067811865475244008443621048490392848\
3593768847403658833986899536623923105351L)

int _Fpclassify (double);
int _Fpclassifyf (float);
int _Fpclassifyl (long double);
int _Getsign (unsigned char *, const _FP_METRIC_T * const);
void _Matherr (int, int);
int _Setsign (unsigned char *, const _FP_METRIC_T * const, int);

#endif

/* END OF FILE */
