/* cii.c - convert signed to signed

   AUTHOR: Gregory Pietsch

   DESCRIPTION:
   
   The _Cii function converts a signed integer a with precision aprec into a
   signed integer c with precision cprec.
   
   This file has been put into the public domain by its author.
   
   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
   IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
   OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
   ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
   OTHER DEALINGS IN THE SOFTWARE.    
*/

#include "ordering.h"
#include "mpi.h"

_MPI_T
_Cii (_MPI_T c, int cprec, _MPI_T a, int aprec)
{
  int i, s;

  if (cprec == aprec)
    {
      if (c != a)
	_Cpy (c, a, aprec);
    }
  else if (cprec < aprec)
    {
      for (i = 0; i < cprec; ++i)
	c[_Byte (cprec - i - 1, cprec)] = a[_Byte (aprec - i - 1, aprec)];
    }
  else
    {
      s = _Sgn (a, aprec);
      for (i = 0; i < aprec; ++i)
	c[_Byte (cprec - i - 1, cprec)] = a[_Byte (aprec - i - 1, aprec)];
      for (; i < cprec; ++i)
	c[_Byte (cprec - i - 1, cprec)] = s ? ~0 : 0;
    }
  return c;
}

/* END OF FILE */
