/* cmp.c - do a comparison of two unsigned multiprecision integers

   AUTHOR: Gregory Pietsch

   DESCRIPTION:
   
   The _Cmp function compares two unsigned integers of precision prec and
   returns -1 if the left is less than the right, 0 if equal, and +1 if
   the left is greater than the right.
   
   This file has been placed into the public domain by its author.
   
   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
   IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
   OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
   ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
   OTHER DEALINGS IN THE SOFTWARE.
*/

#include "ordering.h"
#include "mpi.h"

int
_Cmp (_MPI_T a, _MPI_T b, int prec)
{
  int i;

  for (i = 0; i < prec; ++i)
    {
      if (a[_Byte (i, prec)] != b[_Byte (i, prec)])
	return (a[_Byte (i, prec)] < b[_Byte (i, prec)]) ? -1 : +1;
    }
  return 0;
}

/* END OF FILE */
