/* dec.c - decrement a, store in c

   AUTHOR: Gregory Pietsch

   DESCRIPTION:
   
   The _Dec function decrements a and stores the result in c, both having
   precision prec. It's okay if a and c are the same number.
   
   This file has been put into the public domain by its author.
   
   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
   IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
   OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
   ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
   OTHER DEALINGS IN THE SOFTWARE.
*/

#include "ordering.h"
#include "mpi.h"

_MPI_T
_Dec (_MPI_T c, _MPI_T a, int prec)
{
  int i, z = 1, n = 1;

  for (i = prec - 1; i >= 0; --i)
    {
      n &= (a[_Byte (i, prec)] == 0);
      c[_Byte (i, prec)] = a[_Byte (i, prec)] - z;
      z = z && n;
    }
  return c;
}

/* END OF FILE */
