/* dvu.c - divide unsigned multiprecision integers, return quotient

   Returns a null pointer iff b == 0.

   AUTHOR: Gregory Pietsch

   DESCRIPTION:
   
   The _Dvu function divides unsigned integers a/b and returns the
   result in c and as the return value.  If b was zero, c is unchanged
   and the function returns a null pointer.
   
   This file has been placed in the public domain by its author.
   
   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
   IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
   OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
   ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
   OTHER DEALINGS IN THE SOFTWARE.
*/

#include "mpi.h"

_MPI_T
_Dvu (_MPI_T c, _MPI_T a, _MPI_T b, int prec)
{
  unsigned char q[prec], r[prec];

  if (_Div (q, r, a, b, prec))
    return 0;
  _Cpy (c, q, prec);
  return c;
}

/* END OF FILE */
