; right-shift signed 32-bit numbers on an i86
;
; taken from an old public domain tape
;
; number to be shifted in DX:AX, number to shift in CL

_TEXT segment public byte 'CODE'
assume cs:_TEXT
public .rsi4

.rsi4:
	cmp	cl,16
	jae	.rsi4.L1
	mov	bx,dx	; save the high bits
	shr	ax,cl	; shift each half
	sar	dx,cl

; We now have a hole in AX where the lower bits of
; DX should have been shifted. So we must take our
; copy of DX and do a reverse shift to get the proper
; bits to be or'ed into AX.

	neg	cl
	add	cl,16
	shl	bx,cl
	or	ax,bx
	ret
.rsi4.L1:
; For shifts more than 15, do this short sequence.
	sub	cl,16
	xchg	ax,dx
	cwd
; We now have done a shift by 16; shift the remainder.
	sar	ax,cl
	ret
_TEXT ends
end
