/* mli.c - signed multiplication of multiprecision integers

   AUTHOR: Gregory Pietsch

   DESCRIPTION:
   
   c = a * b; a, b, and c are signed integers with precision prec.
   
   This file has been put into the public domain by its author.
   
   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
   IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
   OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
   ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
   OTHER DEALINGS IN THE SOFTWARE.
*/

#include "mpi.h"

_MPI_T
_Mli (_MPI_T c, _MPI_T a, _MPI_T b, int prec)
{
  int sc = 0;
  unsigned char x[prec], y[prec], z[prec];

  if (_Sgn (a, prec))
    {
      sc ^= 1;
      _Ngi (x, a, prec);
    }
  else
    _Cpy (x, a, prec);
  if (_Sgn (b, prec))
    {
      sc ^= 1;
      _Ngi (y, b, prec);
    }
  else
    _Cpy (y, b, prec);
  _Mlu (z, x, y, prec);
  if (sc)
    _Ngi (c, z, prec);
  else
    _Cpy (c, z, prec);
  return c;
}

/* END OF FILE */
