/* sbi.c - subtract unsigned multi-precision integers
   c = a - b

   AUTHOR: Gregory Pietsch

   DESCRIPTION:
   
   The unsigned integers a, b, and c all have precision prec.
   
   This file has been put into the public domain by its author.
   
   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
   IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
   OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
   ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
   OTHER DEALINGS IN THE SOFTWARE.
*/

#include "ordering.h"
#include "mpi.h"

_MPI_T
_Sbu (_MPI_T c, _MPI_T a, _MPI_T b, int prec)
{
  int i, borrow = 0;
  unsigned d;

  for (i = prec - 1; i >= 0; --i)
    {
      d = a[_Byte (i, prec)] + BASE - borrow - b[_Byte (i, prec)];
      c[_Byte (i, prec)] = MODBASE (d);
      borrow = 1 - DIVBASE (d);
    }
  return c;
}

/* END OF FILE */
