/* sgn.c - get sign bit of multi-precision integer

   AUTHOR: Gregory Pietsch

   DESCRIPTION:
   
   This function gets the sign bit of a signed integer; for an unsigned
   integer, it retrieves the most significant bit.
   
   This file has been placed in the public domain by its author.
   
   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
   IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
   OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
   ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
   OTHER DEALINGS IN THE SOFTWARE.
*/

#include "ordering.h"
#include "mpi.h"

int
_Sgn (_MPI_T x, int prec)
{
  return (x[_Byte (prec - 1, prec)] & (1 << (CHAR_BIT - 1))) != 0;
}

/* END OF FILE */
