/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: ADDU.C $
   $Locker:  $	$Name:  $	$State: Exp $

	addu(unsigned *u1, unsigned u2)

	Performs *u1 += u2;

	Return:	!0: arethmetic overflow
			 0: otherwise

   Target compilers: Micro-C, Borland C v2.0, v3.1, v4.52

*/

#include "initsupl.inc"

#ifndef __WATCOMC__

#include <portable.h>

#ifdef HI_TECH_C
int addu(unsigned * const u1, const unsigned u2)
{	
#ifdef SMALL_CODE
#define DISPL 2
#else	/* !SMALL_CODE */
#define DISPL 4
#endif	/* SMALL_CODE */
#asm
	mov ax, DISPL+2[bp]
#endasm

#ifdef FAR_DATA
#asm
	les bx, DISPL+6[bp]
	add es:[bx], ax
#endasm
#else	/* FAR_DATA */
#asm
	mov bx, DISPL+6[bp]
	add [bx], ax
#endasm
#endif	/* FAR_DATA */
#asm
	sbb ax, ax
#endasm
}
#else		/* HI_TECH_C */

int addu(nM(unsigned * const) u1, nM(const unsigned) u2)
{
asm {
		mov ax, asmName(u2, 4)
#ifdef FARDATA
		les bx, asmName(u1, 6)
		add es:[bx], ax
#else	/* FARDATA */
		mov bx, asmName(u1, 6)
		add [bx], ax
#endif	/* FARDATA */
		sbb ax, ax
	}
#ifdef __TURBOC__
	return _AX;			/* shut up warning */
#endif
}
#endif		/* HI_TECH_C */

#endif	/* WATCOM */
