/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: DFNMATC2.C $
   $Locker:  $	$Name:  $	$State: Exp $

	Match a filename against a pattern
	Supports DOS and >>Win32<< patterns.

	Assumptions:
		for DOS:
			+ A path component contains one dot at maximum, except in
				"..". However, the dot may head or trail a string.
			+ The supplied strings are not checked for invalid characters.
			+ The drive separator ':' is considered as a normal delimiter
				of path components, however it does not match a slash.

	DOS patterns:
		"?" any character except dot and space
		"*..." none or more characters up to the next dot or end of name;
			any following characters are ignored to the next dot or end of name
			--> only one asterisk within name and/or extension honored
		"." delimiter of filename and fileextension components
		"/" or "\\" path component delimiter (any non-empty sequence)

		"*" or "*.*" match any file
		"*." matches any file without an extension

	Win32 patterns:
		"?" any character
		"*" none or more characters
		"/" or "\\" delimiter of filename components
		"*"	matches any filename
		"*.*" matches any filename with at least one dot
		"*." matches a sequence of characters without a dot in it
			More than one asterisks are honored, even so dots.

	The path components "." and ".." are treated as real components.
	The pattern may contain wildcards within the path components.
	Wildcards within the fielname are not recognized.

*/


#include "initsupl.inc"
#include "dfn.h"

#define OS_WIN32
#ifdef dfnmatch
#undef dfnmatch
#endif
#ifdef SUPPORT_UNC_PATH
#define dfnmatch udfnmatch2
#else
#define dfnmatch dfnmatch2
#endif

#include "dfnmatch.c"
