/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: DFNSPLIT.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int dfnsplit(char fname[], char dr[][], char path[][]
	 , char name[][], char ext[][])

	Split a file name.
	If SUPPORT_UNC_PATH is defined, UNC paths are supported. Because UNC
	paths are not standardized, but most, if not all, UNC paths follow
	this scheme:
			\\major_device_id\minor_device_id
	this will be assumed.

	fname is the file name to split.

	dr, path, name, ext:	Pointers, which will receive the results.
							If one pointer is NULL, the particular filename
								portion is not saved.
							If one pointer receives NULL, the particular
								portion was not found in fname.
							dr does not has the ':', if it's not an UNC drive.
							dr starts with "\\\\", if it's an UNC drive.
							The trailing '\\' is stripped from path.
								==>  (**path=='\0') -> Root path!!
									(This is not a bug but a feature ;-)
							ext does not contain the leading '.'; ext itself
								contains no dot at all.
							Multiple backslashes are reduced to a single one.
							name may start with any number of dots.

	The returned pointers in dr, path, name,& ext are malloc()'ed;
	thus, they must be free()'ed by the programmer!

   Return:
   	0: Transformation failed, e.g. malloc() returned NULL
	1: dfnsplit() OK

   Example:
   		char *drive, *path, *name, *ext;

   		if(!dfnsplit("d:\\Path1*./Path2.dgf.575\\....mOrk.vOm.Ork"
   		 , &drive, &path, &name, &ext))
   		 	abort("memory full");
   	-results in:
   		drive = "d"
   		path = "\\Path1*.\\Path2.dgf.575"
   		name = "....mOrk.vOm"
   		ext = "Ork"

   		if(!dfnsplit("\\any.name", &drive, &path, &name, &ext))
   		 	abort("memory full");
   	-results in:
   		drive = NULL
   		path = ""				<-------!!!!!!
   		name = "any"
   		ext = "name"

   		if(!dfnsplit("d:\\Path1*./Path2.dgf.575\\....mOrk.vOm.Ork"
   		 , &drive, NULL, &name, NULL))
   		 	abort("memory full");
   	-results in:
   		drive = "d"
   		path = <unchanged>
   		name = "....mOrk.vOm"
   		ext = <unchanged>

	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

*/

#include "initsupl.inc"

#ifndef _MICROC_
#include <string.h>
#include <stdlib.h>
#include <dos.h>
#endif
#include <portable.h>
#include "dfn.h"
#include "dynstr.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: DFNSPLIT.C 1.6 1998/08/19 02:40:21 ska Exp $";
#endif

int dfnsplit(char fname[], char **dr, char **path, char **name, char **ext)
{	char *p, *h, *z;

#define iff(var,value) if(var) *(var) = (value)
	iff(dr, NULL);
	iff(path, NULL);
	iff(name, NULL);
	iff(ext, NULL);
	if((p = fname) == NULL) return !NUL;

#ifdef SUPPORT_UNC_PATH
	if(isUNCpath(p)) {					/* UNC drive */
		h = UNCpath(p);					/* h := end of UNC drive */
		if(dr) {
			if((*dr = *h? StrLeft(p, h - p): strdup(p)) == NULL)
				return NUL;
			if(!*h) {		/* no further portion, but UNC paths are always
								fully-qualified -> path := root_diectory */
				return (*path = strdup("")) != NULL;
			}
			p = h;			/* points to the '\\' marking the root direc */
		}
	}
	else			/* check for non-UNC drive spec */
#endif
	if(p[1] == ':') {	/* drive spec */
		if(dr) {
			if((*dr = StrChar(*p)) == NULL)
				return NUL;
		}
		p += 2;
	}

	if(*p) {	/* there are characters left */
	/* determine last path component */
		h = strchr(p, '\0');
		while(--h >= p && *h != '/' && *h != '\\');
	/* locate last '\\' */
		if(h >= p) { 	/* there is a backslash => a path */
			if(path) {
				if((*path = z = malloc(h - p + 1)) == NULL)
					return NUL;
				/* because malloc() before squeeze => if multiple '\\'s 
					some memory is wasted */
				/* while copying squeeze multiple '\\'s */
				do {
					if(*p == '\\' || *p == '/') {	/* squeeze */
						while(*++p == '\\' || *p == '/');
						--p;
					}
					if(p >= h) break;
					*z++ = *p++;
				} while(1);
				*z = NUL;
			}
			p = h + 1;	/* skip path */
		}
	/* check for special names strting with a dot '.' */
		if(*(h = p) == '.') do {} while(*++h == '.');
		if((h = strrchr(h, '.')) == NULL) 	/* no extension at all */
		 	return name? (*name = strdup(p)) != NULL: !NUL;
	/* copy the name */
		if(name) {
			if((*name = StrLeft(p, h - p)) == NULL)
				return NUL;
		}
	/* copy the extension */
		return ext? (*ext = strdup(h + 1)) != NULL: !NUL;
	}
	return !NUL;
}
