/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: DFNSQUEE.C $
   $Locker:  $	$Name:  $	$State: Exp $

	char *dfnsqueeze(const char fname[])

	Preprocess a filename:
		- Flip '/' -> '\\'
		- Squeeze '\\\\' -> '\\'
		- Squeeze '\\.\0' -> '\\'
		- Squeeze '\\.\\' -> '\\'
		- Upcase all characters (using DOS NLS API)

	The preprocessed filename is copied into a malloc'ed buffer.

   Return:
   	NULL: malloc failed or fname == NULL
	else: pointer to the malloc'ed buffer

	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

*/

#include "initsupl.inc"

#ifndef _MICROC_
#include <string.h>
#include <stdlib.h>
#include <dos.h>
#endif
#include <portable.h>
#include "dfn.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: DFNSQUEE.C 1.6 1998/08/19 02:40:21 ska Exp $";
#endif

char *dfnsqueeze(const char fname[])
{	char *p, *h, *q;

	if(!fname || (h = q = strdup(fname)) == NULL)
		return NULL;

	if(isUNCpath(q))		/* skip behind the UNC id */
		q = UNCpath(q);

/* First: Flip the slashes */
	while((q = strchr(q, '/')) != NULL)
		*q = '\\';

/* Second: Squeeze & upcase */
	
	if(isUNCpath(p = q = h)) {		/* if UNC drive -> upcase that portion */
		for(q = UNCpath(h); p < q; ++p)
			*p = toFUpper(*p);
	}

	do {
redo:
		if(*q == '\\') {	/* possibly to be squeezed */
			if(q[1] == '\\') {		/* Squeeze '\\\\' -> '\\' */
				++q;
				goto redo;
			}
			if(q[1] == '.') {
				if(q[2] == '\\') {		/* squeeze '\\.\\' -> '\\' */
					q += 2;
					goto redo;
				}
				if(q[2] == '\0') {		/* squeeze '\\.\0' -> '\\' */
					*p = '\\';
					*++p = NUL;
					break;
				}
			}
		}
	} while((*p++ = toFUpper(*q++)) != 0);

	return h;
}
