/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: DFNUNC.C $
   $Locker:  $	$Name:  $	$State: Exp $

	char *UNCpath(const char fname[]);

	Return a pointer to the first character of fname[], that is not a part
	of the UNC drive specification. That is either '\\', the root direc
	specificator, or '\0', if no path is following the UNC drive at all.

	Return:
		NULL: fname[] has no UNC drive spec
		else: pointer to a) '\\' the root direc mark; or b) '\0' if no path

	Target compilers: Micro-C, Borland C v2, v3.1, v4.52

*/

#include "initsupl.inc"

#ifndef _MICROC_
#include <string.h>
#endif
#include <portable.h>
#include "dfn.h"
#include "dynstr.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: DFNUNC.C 1.3 1998/08/19 02:40:21 ska Exp $";
#endif

char *UNCpath(const char fname[])
{	char *h;

	if(!isUNCpath(fname))
		return NULL;

	if((h = strchr(fname + 2, '\\')) != NULL
	 && (h = strchr(h + 1, '\\')) != NULL)
	 	return h;

	return strchr(fname, '\0');
}
