/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: DOSFREE.C $
   $Locker:  $	$Name:  $	$State: Exp $

	DOSfree(word segm)

	Free the memory segment.

   Target compilers: Micro-C, Borland C v2.0, v3.1, v4.52

*/

#include "initsupl.inc"

#ifndef _MICROC_
#include <dos.h>
#endif
#include <portable.h>
#include "suppl.h"

int DOSfree(nM(const word) segm)
#ifdef _MICROC_
asm {
	mov ax, asmName(segm, 4)
	or ax, ax				; /* no segment to free */
	jz DOSfree1	
	mov es, ax
	mov ah, 49h
	int 21h
DOSfree1:
}
#else
{	USEREGS

	_ES = segm;
	_AH = 0x49;		/* Free Memory Block */
	geninterrupt(0x21);
	return _AX;
}
#endif
