/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: DOSSIZE.C $
   $Locker:  $	$Name:  $	$State: Exp $

	DOSresize(word segm, unsigned length)

	Resizes, if possible, the memory segment segm to length paragraphes.
	If length == 0, the block is freed.
	If to resize the segment fails, the segment is not relocated to
	a different memory segment.
	If segm == 0, resizing fails.

	Return:
		0: resize OK
		!0: resize failed

   Target compilers: Micro-C, Borland C v2.0, v3.1, v4.52

*/

#include "initsupl.inc"

#ifndef _MICROC_
#include <dos.h>
#endif
#include <portable.h>
#include "suppl.h"
#include "mcb.h"

int DOSresize(word segm, unsigned newLen)
{	unsigned length;
	USEREGS

	if(!(length = mcb_length(segm)))
		return 1;		/* no segment */

	if(length != 0xFFFF && (length >> 4) == newLen)
		return 0;		/* number of paragraphes remains constant */
		
	/* resize the block, as the requested length is different */
#ifdef _MICROC_	/* Micro-C's int86() does not support ES */
	segm;			/* mov ax, segm */
	asm "mov es, ax";
	newLen;			/* mov ax, newLen */
	asm {
		mov bx, ax
		mov ah, 4ah
		int 21h
		sbb ax, ax
	}
	/* implizitly returning AX */
#else
	_ES = segm;		/* block to resize */
	_BX = newLen;	/* new size in paragraphs */
	_AH = 0x4a;		/* DOS call Modify Allocated Memory */
	geninterrupt(0x21);
	return _CFLAG;		/* return the Carry flag */
#endif
}

#ifdef _MICROC_
word resizeBlk(const word segm, const unsigned length) 
{	return DOSresize(segm, BLK_byte2para(length));
}
#endif
