/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: DSTRCONC.C $
   $Locker:  $	$Name:  $	$State: Exp $

	char *StrConcat(int argcnt, ...)

	Concats up to argcnt strings together and malloc() a buffer that will
	receive the result.

	If one of the string == NULL, this string is ignored.

	Return:
		NULL: if malloc() returned NULL
		else: the malloc'ed buffer

	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

*/

#include "initsupl.inc"

#ifndef _MICROC_
#include <string.h>
#include <stdarg.h>
#include <stdlib.h>
#endif
#include "dynstr.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: DSTRCONC.C 1.4 1998/08/19 02:40:21 ska Exp $";
#endif

#ifdef _MICROC_
register char *StrConcat(int argcnt)
{	unsigned cnt, *poi;
	unsigned Xcnt, *Xpoi;
	unsigned length;
	char *h, *p;

	cnt = nargs();
	Xpoi = poi = cnt * 2 - 2 + &argcnt;
	Xcnt = cnt = min(cnt, *poi);
	for(length = 1; cnt--;)
		if(*--poi) length += strlen(*poi);

	if((h = p = malloc(length)) == NULL)
		return NULL;

	while(Xcnt--)
		if(*--Xpoi)
			p = stpcpy(p, *Xpoi);

	return h;
}
#else		/* !_MICROC_ */

char *StrConcat(int argcnt, ...)
{	va_list strings;
	char *h, *p, *s;
	unsigned length;

	va_start(strings, argcnt);
	if((p = strdup("")) == NULL)
		return NULL;
	length = 1;
	while(argcnt--) {
		s = va_arg(strings, char *);
		if(s && *s) {
			if((h = realloc(p, length += strlen(s))) == NULL) {
				free(p);
				return NULL;
			}
			strcat(p = h, s);
		}
	}
	return p;
}
#endif		/* _MICROC_ */
