/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: DSTRSTRI.C $
   $Locker:  $	$Name:  $	$State: Exp $

	char *StrStrip(char s[], int ch);
	Remove any number of the character ch from the end of the string s.

	s[] may be NULL.
	ch may be 0.

	Return:	always s[].

	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

*/

#include "initsupl.inc"

#ifndef _MICROC_
#include <string.h>
#endif
#include <portable.h>
#include "dynstr.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: DSTRSTRI.C 1.4 1998/08/19 02:40:21 ska Exp $";
#endif

char *StrStrip(char s[], int ch)
{	unsigned char *p;

	if(ch &= 0xFF) {
		p = (unsigned char*)strchr(s, NUL);
		while(--p >= (unsigned char*)s && *p == ch);
		p[1] = NUL;
	}

	return s;
}
