/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: DSTRTOKE.C $
   $Locker:  $	$Name:  $	$State: Exp $

	char *StrTokenize(char *str, char *token)

	Tokenize str. str is unchanged, after StrTokenize() returned NULL.
	If str==NULL, the previous string is searched for the next token.
	If two tokens follow each other immediately, an empty string is returned.

	Return:
		NULL: no further token; the whole str is unchanged now
		else: pointer to token; this string's '\0' is the only modified part
				of the string.


	void StrSaveTokens(int mode, struct STR_SAVED_TOKENS *st)
	Save/restore the current context of the StrTokenize() function.

	If mode == 0, the context is placed into *st.
	If mode != 0, the context is restored from *st.

	If st==0, no action is performed.

	Target compilers: Micro-C v3.14; Borland C v2, v3.1, v4.52

*/

#include "initsupl.inc"

#ifndef _MICROC_
#include <string.h>
#endif
#include <portable.h>
#include "dynstr.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: DSTRTOKE.C 1.4 1998/08/19 02:40:21 ska Exp $";
#endif

static char *nxtToken = NULL;		/* pointer to previous scanned string */
static char ch;						/* previous token delimiter */

char *StrTokenize(char *str, const char token[])
{
	if(!str) {
		if((str = nxtToken) == NULL		/* nothing to do */
		 || (*str++ = ch) == NUL)		/* end of string reached */
			return nxtToken = NULL;
	}

	if(!token || !*token)			/* assume all the string */
		nxtToken = NULL;
	else {
		nxtToken = str - 1;
		while(!strchr(token, *++nxtToken));
		ch = *nxtToken;
		*nxtToken = NUL;
	}

	return str;
}

void StrTokSave(struct STR_SAVED_TOKENS *st)
{	if(st)
		st->str_next_saved_tokens = nxtToken;
		st->str_ch_saved_tokens = ch;
}

void StrTokRestore(struct STR_SAVED_TOKENS *st)
{	if(st)
		nxtToken = st->str_next_saved_tokens;
		ch = st->str_ch_saved_tokens;
}
