/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* 	$Header: D:/FREEDOS/SRC/LIB/SUPPL/RCS/ENV_CHG.C 2.3 1998/08/05 09:42:22 ska Exp $
 *
 *  ENV_CHG.C - part of the enviroment handling.
 *
 *	Functions: env_change()
 *
 *	int env_change(char *var, char *value);
 *	
 *	Insert/Replace/Delete the variable name with the value.
 *
 *	if value == NULL => delete variable
 *	if value == ""   => create a variable with no value
 *	if var  == NULL => Return -1 (error)
 *	if var  == ""   => create a variable without name
 *
 *	if segm == 0, the current used environment is processed.
 *
 *	Return value:
 *		0: Cannot insert variable.
 *		1: variable replaced or deleted.
 *		2: variable not found.
 *		3: variable newly inserted.
 *		4: no environment at all
 *		-1: var == NULL.
 *
 	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

 *  01/29/96 (Steffen Kaiser) -----------------------------------------------
 *    started.
 *
 */

#include "initsupl.inc"

#ifndef _MICROC_
#include <dos.h>
#include <string.h>
#endif
#include <portable.h>
#include "environ.h"

int env_change(unsigned segm, const char var[], const char value[])
{	unsigned offset;
	int err;

	if(var == NULL)
		return -1;

	if(!segm&& !(segm = env_glbSeg))
		return 4;

	/* Check if the variable is already in */
	if((offset = env_findVar(segm, var)) == 0xffff) {
		/* not in environment */
		if(!value)			/* nothing to delete */
			return 2;
		err = 3;			/* new variable */
	}
	else {
		/* Don't delete the variable if there is not enough room */
		if(env_noSpace(segm, var, value, env_varlen(segm, offset)))
			return 0;
		env_subVarOffset(segm, offset);	/* remove variable */
		if(!value)
			return 1;				/* OK, removed */
		err = 1;					/* prepare: replaced */
	}

	/* Try to insert the variable */
	return env_addVar(segm, var, value)? err: 0;
}
