/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/*  $Header: D:/FREEDOS/SRC/LIB/SUPPL/RCS/ENV_CPY.C 2.4 1998/08/05 09:42:22 ska Exp $
 *
 *  ENV_CE.C - part of the enviroment handling.
 *
 *	Functions: cpyenv(), env_get()
 *
 *  Comments:
 *
 *	int cpyenv(char *var, char *dst, int length);
 *	int env_get(word segm, char *var, char *dst, int length);
 *
 *	Copy length bytes from the beginning of variable var into dst.
 *
 *	If segm == 0, the current used environment is processed.
 *
 *	Return value:
 *		0: found & copied.
 *		1: found, but too long to copy completely. (length-1) bytes copied.
 *		2: not found
 *		3: no environment at all
 *		-1: var == NULL || dst == NULL || length == 0
 *
 	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

 *
 *  01/29/96 (Steffen Kaiser) -----------------------------------------------
 *    started.
 *
 */

#include "initsupl.inc"

#ifndef _MICROC_
#include <dos.h>
#include <string.h>
#endif
#include <portable.h>
#include "environ.h"
#include "fmemory.h"

int cpyenv(const char var[], char dst[], const unsigned length)
{	return env_get(0, var, dst, length);	}
int env_get(word segm, const char var[], char dst[], const unsigned length)
{	int ofs;
	int cpyLen;

	if(var == NULL || dst == NULL || length == 0)
		return -1;		/* nothing to do */

/* Locate the environment segment */
	if(!segm && !(segm = env_glbSeg))
		return 3;

/* Locate the variable */
	if((ofs = env_findVar(segm, var)) == -1)	/* not found */
		return 2;

	ofs += strlen(var) + 1;	/* skip the name & the equal sign */

/* Check, if the buffer overflows */
	if((cpyLen = _fstrlen(MK_FP(segm, ofs)) + 1) > length)
		cpyLen = length;

/* Copy the contents including the NUL terminator */
	_fmemcpy(TO_FP(dst), MK_FP(segm, ofs), cpyLen);
	if(cpyLen == length && dst[length - 1]) {		/* buffer overflow */
		dst[length - 1] = '\0';
		return 1;
	}

	return 0;
}
