/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/*  $Header: D:/FREEDOS/SRC/LIB/SUPPL/RCS/ENV_FREE.C 2.3 1998/08/05 09:42:22 ska Exp $
 *
 *  ENV_FREE.C - part of the enviroment handling.
 *
 *	Supplemental functions shared by several environment functions.
 *
 *	All of these functions requires that  segm points to a valid environment.
 *
 *	unsigned env_firstFree(unsigned segm);
 *	Return the offset of the first free byte in the environment segment.
 *
 *  unsigned env_endOfVars(const unsigned segm);
 *	Return the offset of the NUL terminator of the part of the environment
 *  segment for the variables.
 *
 *  unsigned env_freeCount(const unsigned segm);
 *	Return the number of bytes, which are unused in the environment segment.
 *
 	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

 *  01/29/96 (Steffen Kaiser) -----------------------------------------------
 *    started.
 *
 */

#include "initsupl.inc"

#ifndef _MICROC_
#include <dos.h>
#include <string.h>
#endif
#include <portable.h>
#include "environ.h"
#include "mcb.h"
#include "fmemory.h"

unsigned env_endOfVars(const unsigned segm)
{	unsigned offset;

	offset = 0;					/* env starts always at location 0 */

	while(peekb(segm, offset))	/* there is a variable */
		offset += env_varlen(segm, offset);

	return offset;				/* This is the terminator byte */
}

unsigned env_firstFree(const unsigned segm)
{	return env_string(segm, env_strings(segm));
}

unsigned env_freeCount(const unsigned segm)
{	return mcb_length(segm) - env_firstFree(segm);
}
