/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: ENV_SINS.C $
   $Locker:  $	$Name:  $	$State: Exp $

	env_strinsert(word segm, char *buf, int stringNr)

	Insert a string before the stringNr'th string. The number of all
	following strings increments by one.
	If stringNr == env_strings(), a new string is appended.

	If segm == 0, the current used environment is processed.

	Return:
		0: OK
		1: stringNr too high
		2: environment too small
		3: no environment at all
		4: buf == NULL

	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

*/

#include "initsupl.inc"

#ifndef _MICROC_
#include <string.h>
#include <dos.h>
#endif
#include "environ.h"
#include "fmemory.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: ENV_SINS.C 2.5 1998/08/19 02:40:21 ska Exp $";
#endif

int env_strinsert(word segm, const char buf[], const int stringNr)
{	word ofs, len;

	if(!buf) return 4;				/* no string to insert */

	if(!segm && !(segm = env_glbSeg))
		return 3;					/* no environment at all */
	
	if(env_freeCount(segm) <= (len = strlen(buf) + 1))
		return 2;					/* not enough room */

	if(!(ofs = env_string(segm, stringNr)))
		return 1;					/* string number too high */

	/* Move the following strings out of the way */
	_fmemmove(MK_FP(segm, ofs + len), MK_FP(segm, ofs)
	 , env_firstFree(segm) - ofs);

	/* Now, there is enough room at segm:ofs to put string there */
	_fmemcpy(MK_FP(segm, ofs), TO_FP(buf), len);

	/* Increment string counter */
	env_strcounter(segm, 1);

	return 0;
}
