/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: ENV_SPUT.C $
   $Locker:  $	$Name:  $	$State: Exp $

	env_strput(word segm, char *buf, int stringNr)

	Replaces the stringNr'th string (1st string is 0) of the environment
	segm by the ASCIZ string buf.

	If buf == NULL, the string is deleted, all following strings are
	shifted up one position.

	If stringNr == env_strings(segm), a new string is appended.

	If stringNr == env_strings(segm) && buf == NULL, NOP (ignored).

	If segm == 0, the current used environment is processed.

	Return:
		0:	OK
		1:	stringNr too high
		2:	environment too small
		3:	no environment at all

	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

*/

#include "initsupl.inc"

#ifndef _MICROC_
#include <string.h>
#include <dos.h>
#endif
#include "environ.h"
#include "fmemory.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: ENV_SPUT.C 2.5 1998/08/19 02:40:21 ska Exp $";
#endif

int env_strput(word segm, const char buf[], const int stringNr)
{	word ofs, len, lenX;
	int cnt;

	if(!segm && !(segm = env_glbSeg))
		return 3;						/* no environment at all */

	if(!(ofs = env_string(segm, stringNr)))
		return 1;						/* string number too high */

	if(stringNr == (cnt = env_strcounter(segm, 0))) {	/* append string */
			/* If buf == NULL, ignore */
		return buf? env_strinsert(segm, buf, stringNr): 0;
	}

/* at this place segm:ofs points to a valid string */

	len = buf? strlen(buf) + 1: 0;		/* length of string to put there */
	lenX = env_varlen(segm, ofs);		/* length of current string */
	if((len > lenX) && (env_freeCount(segm) <= len - lenX))
		return 2;	/* not enough memory */

	if(stringNr < cnt - 1) {	/* There are strings following the one
									to be replaced */

		/* Move them to the place directly where the new string will end */
		_fmemmove(MK_FP(segm, ofs + len), MK_FP(segm, ofs + lenX)
		 , env_firstFree(segm) - (ofs + lenX));
	}

/* Now, there is enough room at segm:ofs to put string there */

	if(buf) {		/* change the string value */
		_fmemcpy(MK_FP(segm, ofs), TO_FP(buf), len);
	}
	else 		/* The string has been deleted */
		env_strcounter(segm, -1);

	return 0;
}
