/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: ENV_STRG.C $
   $Locker:  $	$Name:  $	$State: Exp $

	word env_string(word segm, word stringNr)

	If stringNr == env_strings(), the first free byte is returned.

	If segm == 0, the current used environment is processed.

	Return:
		0: stringNr too high or no environment at all
		else: offset of the string

	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

*/

#include "initsupl.inc"

#ifndef _MICROC_
#include <dos.h>
#endif
#include "environ.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: ENV_STRG.C 2.4 1998/08/19 02:40:21 ska Exp $";
#endif

word env_string(word segm, int stringNr)
{	word ofs;

	if(!segm && !(segm = env_glbSeg))
		return 0;

	if(peekw(segm, ofs = 1 + env_endOfVars(segm)) < stringNr)
		return 0;		/* string number too high */

	ofs += 2;				/* 1st string */
	while(stringNr--)		/* skip current string */
		ofs += env_varlen(segm, ofs);

	return ofs;
}
