/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $Id: FMEMORY.H 2.2 1998/08/05 09:42:22 ska Exp $
   $Locker:  $	$Name:  $	$State: Exp $

	Far memory handling function.

	The implementation contains each string and memory function with
	a prepended "_f", e.g.: "strlen" -> "_fstrlen",& "memcmp" -> "_fmemcmp".

	The far pointers are given by two arguments instead of only one, e.g.:
		"strlen(str)" -> "_fstrlen(strSegment, strOffset)"
		"memcpy(d,s,l)" -> "_fmemcpy(dSeg, dOfs, sSeg, sOfs, l)"
	Because of this, the implementation does NOT completely covers far
	memory handling, because there is no way for real far variables.

	The implementation is a FAR implementation, not a HUGE one. That means,
	that no check is performed, if the segment will be wrapped.

	Two defines can help to increase the compatibly with other compilers:
		MK_FP(seg, ofs) simply replaces its arguments and the comma and,
			therefore, can be used in the argument list of "_f" functions
			quite easily, e.g.:
				"_fstrlen(MK_FP(seg, ofs))" expands to:
				"_fstrlen((seg), (ofs))".
			The macro fails, if far pointer arethmetics will be made.
		TO_FP(var) casts the variable to a far pointer and expands to:
			get_ds(), (var)
			So it can also be used in the argument list replacing the far
			pointer casting, eg.:
				char *dstr;
				_fstrcpy((char far*)dstr, sstr)
			->
				char *dstr;
				_fstrcpy(TO_FP(dstr), sstr)
			In non-Micro-C mode, this expands to:
				_fstrcpy(((void far*)(dstr)), sstr)
			In Micro-C mode, this expands to:
				_fstrcpy(get_ds(), (dstr), sstr)

*/

#ifndef __FMEMORY_H
#define __FMEMORY_H

#ifdef _MICROC_				/* for use for Micro-C only */

#define MK_FP(seg,ofs) (seg), (ofs)
#define TO_FP(var) get_ds(), (var)
#define _fnormalize(seg,ofs) _fnormalize_(&(seg), &(ofs))

#endif

#ifdef _PAC_NOCLIB_
#include <stdlib.h>
#define _fmemcpy farmemcpy
#define _fmemset farmemset

extern int _fstrlen(void far * const s);
extern void _fmemmove(void far * const dst, const void far * const src, unsigned length);
extern int _fmemcmp(const void far * const dst, const void far * const src, unsigned length);

#endif

#ifndef _MICROC_
#ifdef HI_TECH_C		/* no huge pointers */
void far *_fnormalize(void far *poi);
#else
#define _fnormalize(poi) ((void huge *)(poi))
#endif
#endif

#endif
